
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/TSTHELP.CPP   1.29   02 Apr 1996 09:30:08   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/TSTHELP.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:30:08   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:56:10   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:28   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:56   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:50   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:19:06   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:14:18   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:12   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:33:04   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:50   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:11:38   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:13:12   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:16   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:15:04   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:36   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:50   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:30   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:34:26   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:22   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:46   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:28   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:06   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:18   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:34   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:06   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:38   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:30   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:58:18   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:12   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:04   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: TSTHELP.CPP
//
//  Description: The implementation file for the class: CHelp.
//
//  Author: Chen Jun
//
//  Date: 06/22/95
//
//  Modification:
//      1. 06/22/95, Initial version of the class: CHelp.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"
                     
#include "shlcom.h"                     
#include "tsthelp.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.
/*extern struct {
    char* pszCommandName;
    int nMinKeyword;
}*/extern tagCmdTable CommandRecord[];

// Maximum number of command.
extern int nMaxCmdNo;


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void HelpCmd(int nArgc, char* pszArgv[]);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.



/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   HelpCmd().
//
//  Description: The main control routine of Help command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void HelpCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc || 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Execute Help command.
    CHelp* pHelp = new CHelp;
    if ( !pHelp ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pHelp->HelpAction(nArgc, pszArgv);
        delete pHelp;
    }
    
//    CHelp objHelp;
//    objHelp.HelpAction(nArgc, pszArgv);

}   // End of HelpCmd().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CHelp.

// Construction.
CHelp::CHelp()
{
    // Command list help file.
    extern char szAppPath[];
    m_strFileName = szAppPath;
    m_strFileName += "CMDLIST.BIN";
    m_nOpenFlag |= CFile::modeRead;
    
    // Allocate a space.
    m_pszOneLine = new char[maxChar+1];
    if ( !m_pszOneLine ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    
    // Initial.
    m_isSingleCmd = FALSE;
    m_strCommand.Empty();

}   // End of CHelp::CHelp().


// Destruction.
CHelp::~CHelp()
{
    // Release the allocated space.
    if ( m_pszOneLine ) {
        delete []m_pszOneLine;
    }

}   // End of CHelp::~CHelp().


// Help command.
void CHelp::HelpAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc || 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Parse the parameters.
    switch ( nArgc ) {
        case 1:
            break;
        case 2:
            m_isSingleCmd = TRUE;
            m_strCommand = strlwr((pszArgv[1]));
            break;
        default:
            ASSERT( FALSE );
            break;
    }
    
    // Call the Help kernel.
    HelpKernel();

}   // End of CHelp::HelpAction().


// Help kernel routine.
void CHelp::HelpKernel(void)
{
    // Assertion of the input parameters.
    ASSERT( NO_ERROR == m_nErrorID );
    ASSERT( m_pszOneLine );
    if ( !m_pszOneLine ) {
        return;
    }
    
    // Search the command keyword table.
    int nIndex;
    if ( m_isSingleCmd ) {
        for ( nIndex = 0; nIndex < ::nMaxCmdNo; nIndex++ ) {
            CString strTable = strlwr(CommandRecord[nIndex].pszCommandName);
            if ( m_strCommand == strTable ) {
                break;
            }
        }
        if ( ::nMaxCmdNo == nIndex ) {
            ShowLine("No such command.");
            return;
        }
    }
    
    // Open the help contents file: CMDLIST.HLP
    OpenFile();
    if ( NO_ERROR != m_nErrorID ) {
        ShowLine("CMDLIST.BIN cannot be opened.");
        return;
    }
    
    // Read one line help contents and display it.
    m_pszLineBuf = m_pszOneLine;
    int nCmdCount = -1;
    do {
        ReadFromFile();
        if ( NO_ERROR != m_nErrorID ) {
            if ( FILE_END != m_nErrorID ) {
                DisplayErrorMessage();
                return;
            }
            break;
        }
        else {
            if ( m_isSingleCmd ) {
                if ( ' ' != *m_pszOneLine ) {
                    nCmdCount++;
                }
                if ( nCmdCount == nIndex ) {
                    ShowLine(m_pszOneLine);
                }
            }
            else {
                ShowLine(m_pszOneLine);
            }
        }
    } while ( TRUE );
    
    // Close the help contents file: CMDLIST.HLP
    m_nErrorID = NO_ERROR;
    CloseFile();

}   // End of CHelp::HelpKernel().


//////////////////////////////// End of File ////////////////////////////////
