
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/TSTINC.H__   1.29   02 Apr 1996 09:28:08   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/TSTINC.H__  $
** 
**    Rev 1.29   02 Apr 1996 09:28:08   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:49:40   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:10   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:24   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:02   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:54   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:46   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:26   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:12   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:02   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:58   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:14   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:46   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:26   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:58   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:40   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:28:00   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:32   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:08   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:20   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:03:18   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:28   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:30   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.6   25 Oct 1995 14:29:04   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:50:20   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:58   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:34   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:36   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:14   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:04   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: TSTINC.H
//
//  Description: The header file for the class: CIncludeFile.
//
//  Author: Chen Jun
//
//  Date: 05/23/95
//
//  Modification:
//      1. 05/23/95, Initial version of the class: CIncludeFile.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _TSTINC_
#define _TSTINC_

#include "tstbase.h"


/////////////////////////////////////////////////////////////////////////////
// CIncludeFile class.
class CIncludeFile : public CFileBase
{
// Construction & Destruction.
public:
    CIncludeFile();
    ~CIncludeFile();
    
// Member variables.
private:
    char m_pszOneLine[maxChar+1];
    enum { TOKEN_KEY = 0x20 };

    // Parameter token.
    int m_nArgc;
    char* m_pszArgv[(maxChar+1)/2];

    // Inner error.
    int m_nCommandID;
    enum { minInner = 0,
           INC_BELL = minInner,
           INC_ERROR,
           INC_GOTO,
           INC_IF,
           INC_IFNOT,
           INC_ELSE,
           INC_BEGINMARK,
           INC_ENDMARK,
           INC_LOOP,
           INC_LOOPEND,
           INC_PAUSE,
           INC_REM,
           maxInner = INC_REM
    };
    
    // Error.
    BOOL m_isStop;

    // Goto Label.
    char m_pszLabel[maxChar-5+1];
    
    // Loop & Loopend.
    enum { maxLoop = 256 };
    long m_lLoopIndex;
    long m_lLoopCount[maxLoop];
    DWORD m_dwLoopPos[maxLoop];

    // If, If_not & Else.
    char m_pszCondition[maxChar+1];
    BOOL m_isMatchedIF;
    BOOL m_isMatchedELSE;
    BOOL m_isSkipELSE;

    // { & }.
    BOOL m_isMatchedBegin;

public:
    BOOL m_isEOF;
    enum { maxFileNo = 1000 };

// Implementations.
private:
    void CheckInnerCommand(char* pszIncLine);
    BOOL CommandParse(void);
    void CommandKernel(void);
    void ExecuteInnerCommand(void);

    void IncludeBell(void);
    void IncludeError(void);
    void IncludeGoto(void);
    void IncludeIf(void);
    void IncludeIfnot(void);
    void IncludeElse(void);
    void IncludeLoop(void);
    void IncludeLoopend(void);
    void IncludePause(void);
    void IncludeRem(void);
    void IncludeBeginMark(void);
    void IncludeEndMark(void);
    
    BOOL IsLabel(char* pszArgv) const;
    
    void GotoLabel(void);

    BOOL JudgeCondition(void);
    void PassBlockBranch(void);
    BOOL SearchELSE(void);
    void SkipELSE(void);

    int TestKey(WORD wKey);
    
public:
    BOOL IncludeAction(int nArgc, char* pszArgv[]);

    void ReadOneLine(char* pszBuf);
    BOOL IncludeFilter(char* pszIncLine);

};  // End of class: CIncludeFile.

#endif
//////////////////////////////// End of File ////////////////////////////////
