
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/UICOM.H__   1.29   02 Apr 1996 09:22:58   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/UICOM.H__  $
** 
**    Rev 1.29   02 Apr 1996 09:22:58   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:54:10   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:09:28   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:52   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:50:08   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:38   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.23   26 Jan 1996 09:20:32   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:20:26   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:42   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:23:12   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:12:38   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:15:36   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:09:24   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:10:56   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:04   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:40   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:22   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:56   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:24   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:20   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:14   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:51:08   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:52   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:16   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:47:10   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.4   13 Oct 1995 13:23:28   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:53:44   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:56:12   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:45:08   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:56:00   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  UICOM.H
//
//  Description:The header file of common declare for GUI
//
//  Author:     Roger Zhang
//
//  Date:       03/08/95
//
//  Modification:
//
//      1. 03/08/95, Initial version 0.1
//
//      2. 09/08/95  0.1a
//
//         2.1 Fixed bug No.18
//              Modify function prototype: DoJump
// 
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _UICOM_
#define _UICOM_
                      
// Step option
enum { STEP_INSTRUCTION = 0, STEP_STATEMENT, STEP_LINE };

// Source display mode
enum { MODE_SOURCE, MODE_MIXED, MODE_ASM };

// Indicate Insert key mode, TRUE for Insert, FALSE for Overwrite                      
extern BOOL isInsertOn;

const int   MAX_MEM_WND = 3;
// Indicate MDI child window state, TRUE for Open, FALSE for Close
extern BOOL    isPeriOn; 
extern BOOL    isShellOn;
extern BOOL    isSourceOn;
extern BOOL    isVariableOn;
extern BOOL    isStackOn;
extern BOOL    isCpuOn;
extern BOOL    isTraceOn;
extern BOOL    isBMemOn; // lane
extern BOOL    isMemOn[MAX_MEM_WND];

// Pointer to MDI child window
extern CMDIChildWnd    * pShellWnd;
extern CMDIChildWnd    * pSourceWnd;
extern CMDIChildWnd    * pVariableWnd;
extern CMDIChildWnd    * pStackWnd;
extern CMDIChildWnd    * pCpuWnd;
extern CMDIChildWnd    * pTraceWnd;
extern CMDIChildWnd    * pMemWnd[MAX_MEM_WND];
extern CMDIChildWnd    * pBMemWnd; // lane
extern CMDIChildWnd    * pPeriWnd;
extern CMultiDocTemplate* pMemDocTemplate;
extern CMultiDocTemplate* pBMemDocTemplate;
extern CMultiDocTemplate* pPeriDocTemplate;

// MDI Child Window ID
enum {
    WID_MAIN,
    WID_CPU, 
    WID_SHELL, 
    WID_TRACE, 
    WID_MEMORY, 
    WID_MEM2,
    WID_MEM3,
    WID_SOURCE,
    WID_STACK,
    WID_VARIABLE,
    WID_BMEM,
    WID_PERI,
    WID_COUNT
};

/////////////////////////////////////////////////////////////////////////////
//by Lane
extern int nTraceViewOption;

/////////////////////////////////////////////////////////////////////////////
extern CBitmap bmpMenuCheck;
extern CBitmap bmpMenuUncheck;

/////////////////////////////////////////////////////////////////////////////
//  Font to use in windows
const int   STANDARD_FONT = ANSI_FIXED_FONT; 

/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
//  User defined message
#define XM_MDIACTIVE    (WM_USER + 1801)
#define XM_SRCSRCH      (WM_USER + 1802)
#define XM_SRCSHOWPC    (WM_USER + 1803)
#define XM_REPAINT      (WM_USER + 1804)
                        
/////////////////////////////////////////////////////////////////////////////
//  User defined windows & controls                        
#define IDW_MSGBAR                  28000
#define IDC_SPIN                    28008

#define IDC_OPENLOGFILE_APPEND      28001
#define IDC_OPENLOGFILE_OVERWRITE   28002
#define IDC_OPENLOGFILE_COMMAND     28003
#define IDC_OPENLOGFILE_RESULT      28004
#define IDC_OPENLOGFILE_STATIC1     28005
#define IDC_OPENLOGFILE_STATIC2     28006

#define IDC_HISTORYSIZE_SPIN        28010

#define IDC_SAVECFG_MAP             28011
#define IDC_SAVECFG_EVENT           28012
#define IDC_SAVECFG_TRIGGER         28013
#define IDC_SAVECFG_STATIC          28014               

#define IDC_REGCONFIG_FIRSTREG      28020
#define IDC_REGCONFIG_LASTREG       28090

//#define IDC_SRCHCOMBO               28091//modify by carl

#define IDC_LOAD_OPTION             28092

#define IDC_MHTIP1					28093                                   
#define IDC_MHTIP2					28094

#define IDC_METER					28096                                   
/////////////////////////////////////////////////////////////////////////////
//  User defined commands                                   
#define IDM_STEP_STATEMENT          31501
#define IDM_STEP_INSTRUCTION        31502
#define IDM_SEARCH                  31503                                    
#define IDM_SETBP_FUNC				31504
#define IDM_CLRBP_FUNC				31505
#define IDM_WATCH_VAR				31506
#define IDM_INSPECT_FUNC			31507
#define IDM_LOAD_ADDR				31508
#define IDM_SETBP_VAR				31509
#define IDM_CLRBP_VAR				31510

#define ID_CPUTYPE                  31520

/////////////////////////////////////////////////////////////////////////////
// User defined help ID

// Help ID for windows and dialogs
#define IDD_LOAD                    27501
#define IDD_INCLUDE                 27502
#define IDD_SAVE_CONFIG             27503
#define IDD_RESTORE_CONFIG          27504
#define IDD_OPEN_LOGFILE            27505
#define IDD_SAVE_TRACE              27506

#define IDD_BROWSE_LINE             27507
#define IDD_SAVE_BP                 27508
#define IDD_RESTORE_BP              27509

#define IDD_SRCGRP_LOADOPTION       27511
#define IDD_SRCGRP_SOURCEOPTION     27512
#define IDD_SRCGRP_BROWSEMODULE     27513
#define IDD_SRCGRP_SOURCEPATH       27514
#define IDD_SRCGRP_EXTENSION        27515
#define IDD_SRCGRP_BREAKPOINT       27516

#define IDD_MEMGRP_CHECKSUM         27521
#define IDD_MEMGRP_COMPARE          27522
#define IDD_MEMGRP_COPY             27523
#define IDD_MEMGRP_FILL             27524
#define IDD_MEMGRP_SEARCH           27525
#define IDD_MEMGRP_TEST             27526

#define IDD_TRCGRP_EVENT            27531
#define IDD_TRCGRP_CONTROL          27532
#define IDD_TRCGRP_TRIGGER          27533
#define IDD_TRCGRP_FILTER           27534

#define IDD_ADD_EXT					27540
#define IDD_EDIT_EXT				27541

/////////////////////////////////////////////////////////////////////////////                       
void ShlOpenWindow(CMDIFrameWnd * pParent, BOOL isHide = FALSE);
void CpuOpenWindow(CMDIFrameWnd * pParent, BOOL isHide = FALSE);
void TrcOpenWindow(CMDIFrameWnd * pParent);
void SrcOpenWindow(BOOL isPCOn, CMDIFrameWnd * pParent, BOOL isHide = FALSE);
void OpenMemoryWindow(CMDIFrameWnd *);
void BMemOpenWindow(CMDIFrameWnd *); // lane
void NewMemoryOpenWindow(CMDIFrameWnd *, int); // lane
void PeriOpenWindow(CMDIFrameWnd *);
// For Variable window.
void VarOpenWindow(CMDIFrameWnd* pParent);
void VarCloseWindow(void);

// For Stack window.
void StkOpenWindow(CMDIFrameWnd* pParent);
void StkCloseWindow(void);
                    
/////////////////////////////////////////////////////////////////////////////                            
BOOL IsRunAccess(void);

void MarkPC(void);
void RepaintSource(void);
void RepaintCPU(void);
void RepaintMemory(void);
void RepaintBMemory(void);
void RepaintTrace(void);
void RepaintStack(void);
void RepaintVariable(void);         
void RepaintPeri(void);

void OnEmulation(void);
void RepaintWindows(void);
/////////////////////////////////////////////////////////////////////////////                            
enum { SRC_LOAD_OK, SRC_LOAD_ALREADY, SRC_LOAD_ERROR };                         
extern int LoadModule(const char * pszFileName);        
extern void SrcResetView(void);
/////////////////////////////////////////////////////////////////////////////                   
void ShlShowLine(char * pch, int nLen);
int TestKey(WORD wKey);
int TestAnyKey(void);
void DrawFrame(CDC * pDC, CRect &rect, int nConvex);
BOOL Str2Num(char * psz, DWORD & dwVal);
void DrawBitmap(CBitmap * bmp, CRect &rect, CDC * pDC);
BOOL CreateMenuCheckBMP(void);
void DeleteMenuCheckBMP(void);
void SetMainMenuCheck(CMenu & menu) ;
void DoFileLoad(void);
void DoBreakPoint(CWnd * pParent);
void DoReset(void);
BOOL DoJump(CWnd * pParent);
    
/////////////////////////////////////////////////////////////////////////////
// Read/Write .ini File
/////////////////////////////////////////////////////////////////////////////
BOOL ReadLoadOption(void);
BOOL WriteLoadOption(void);
void SaveWindowPlacement(void);
BOOL RestoreWindowPlacement(void);

/////////////////////////////////////////////////////////////////////////////
void TestMessage(void);
/////////////////////////////////////////////////////////////////////////////
extern CString strIncludeFile;

extern BOOL isSaveLayoutOnExit;

#endif
/////////////////////////////////(EOF)///////////////////////////////////////
