
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/VARTYPE.CPP   1.29   02 Apr 1996 09:30:00   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/VARTYPE.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:30:00   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:56:04   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:20   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:48   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:42   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:18:58   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:14:10   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:04   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:35:24   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:12   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:14:50   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:56   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:02   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:16   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:10   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:06   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:20   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:34:14   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:12   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:46:04   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:08   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:49:16   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:43:54   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:56   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:04   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:04   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:54   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:56:02   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:20   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:12   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: VARTYPE.CPP
//
//  Description: The implementation file for the class: CVarTypeDialog.
//
//  Author: Chen Jun
//
//  Date: 07/25/95
//
//  Modification:
//      1. 07/25/95, Initial version of the class: CVarTypeDialog.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "vartype.h"

#include "colors.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern CMDIChildWnd* pVariableWnd;


/////////////////////////////////////////////////////////////////////////////
// CVarTypeDialog dialog

// Construction & destruction.
CVarTypeDialog::CVarTypeDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CVarTypeDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CVarTypeDialog)
    //}}AFX_DATA_INIT

    // Initial.
    m_nErrorID = noError;

    // Load bitmap.
    if( !m_bmpOpen.LoadBitmap(IDB_VAR_OPEN_GRAY) ) {
        m_nErrorID = bmpOpen;
        DisplayErrorMessage();
        ::pVariableWnd->MDIDestroy();
        ASSERT( FALSE );
        return;
    }
    if( !m_bmpClose.LoadBitmap(IDB_VAR_CLOSE_GRAY) ) {
        m_nErrorID = bmpClose;
        DisplayErrorMessage();
        ::pVariableWnd->MDIDestroy();
        ASSERT( FALSE );
        return;
    }
}

CVarTypeDialog::~CVarTypeDialog()
{
    // Free bitmap.
    ASSERT( m_bmpOpen.m_hObject && m_bmpClose.m_hObject );
    if ( m_bmpOpen.m_hObject ) {
        m_bmpOpen.DeleteObject();
    }
    if ( m_bmpClose.m_hObject ) {
        m_bmpClose.DeleteObject();
    }
}

void CVarTypeDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CVarTypeDialog)
    DDX_Control(pDX, IDOK, m_btnOK);
    //}}AFX_DATA_MAP
}


/////////////////////////////////////////////////////////////////////////////
// Common function.

// Show the specific bitmap.
void CVarTypeDialog::DisplayBitmap(CDC* pDC, const int nRow, const int nCol)
{
    // Assertion of the input parameters.
    ASSERT( pDC );

    // Draw the bitmap.
    if ( openSign == m_nBmpStatus ) {
        CDC dc;
        dc.CreateCompatibleDC(pDC);
        CBitmap* bmpOld = dc.SelectObject(&m_bmpOpen);
        pDC->BitBlt(nCol, nRow, openWidth, openHeight, &dc, 0, 0, SRCCOPY);
        dc.SelectObject(bmpOld);
    }
    else if ( closeSign == m_nBmpStatus ) {
        CDC dc;
        dc.CreateCompatibleDC(pDC);
        CBitmap* bmpOld = dc.SelectObject(&m_bmpClose);
        pDC->BitBlt(nCol, nRow, closeWidth, closeHeight, &dc, 0, 0, SRCCOPY);
        dc.SelectObject(bmpOld);
    }
}

// Clear the bitmap.
void CVarTypeDialog::ClearBitmap(CDC* pDC, const int nRow, const int nCol)
{
    // Assertion of the input parameters.
    ASSERT( pDC );

    // Clear the bitmap.
    if ( openSign == m_nBmpStatus ) {
        CRect rect(nRow, nCol, nRow+openWidth, nCol+openHeight);
        InvalidateRect(rect);
    }
    else if ( closeSign == m_nBmpStatus ) {
        CRect rect(nRow, nCol, nRow+closeWidth, nCol+closeHeight);
        InvalidateRect(rect);
    }
}

// Display the error message.
void CVarTypeDialog::DisplayErrorMessage(void) const
{
    // Assertion of the input parameters.
    ASSERT( m_nErrorID > noError && m_nErrorID < maxError );
    
    // Create the error message table.
    char* pszErrorMessage[] = {
        "",
        "Insufficient memory.",
        "Cannot load VAR_OPEN bitmap.",
        "Cannot load VAR_CLOSE bitmap."
    };
    
    // Show the error message.
    AfxMessageBox(pszErrorMessage[m_nErrorID]);
}


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CVarTypeDialog, CDialog)
    //{{AFX_MSG_MAP(CVarTypeDialog)
    ON_WM_CREATE()
    ON_WM_PAINT()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVarTypeDialog message handlers

void CVarTypeDialog::OnOK()
{
    // TODO: Add extra validation here
    
    CDialog::OnOK();
}

int CVarTypeDialog::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CDialog::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    // TODO: Add your specialized creation code here
    
    // Set standard font.
    CDC* pDC = GetDC();
    pDC->SelectStockObject(ANSI_FIXED_FONT);

    // Get the font size.
    TEXTMETRIC tm;
    pDC->GetTextMetrics(&tm);
    m_nFontWidth = tm.tmAveCharWidth;
    m_nFontHeight = tm.tmHeight + tm.tmExternalLeading;

    ReleaseDC(pDC);

    return 0;
}

void CVarTypeDialog::OnPaint()
{
    CPaintDC dc(this); // device context for painting
    
    // TODO: Add your message handler code here

    // Set font & color.
    dc.SelectStockObject(ANSI_FIXED_FONT);
    dc.SetBkColor(PALETTEINDEX(COLOR_LTGRAY));
    dc.SetTextColor(PALETTEINDEX(COLOR_BLACK));
    
    // Output the contents.
    m_nBmpStatus = openSign;
    DisplayBitmap(&dc, m_nFontHeight, m_nFontWidth*2);
    m_strType = "struct A_STRUCT one;";
    dc.TextOut(m_nFontWidth*4, m_nFontHeight, m_strType);

    m_nBmpStatus = closeSign;
    DisplayBitmap(&dc, m_nFontHeight*3, m_nFontWidth*2);
    m_strType = "int i;";
    dc.TextOut(m_nFontWidth*4, m_nFontHeight*3, m_strType);
    
    // Do not call CDialog::OnPaint() for painting messages
}

BOOL CVarTypeDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    
    // Central the dialog position.
    CenterWindow();
        
    return TRUE;  // return TRUE  unless you set the focus to a control
}
