
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/VARVIEW.CPP   1.29   02 Apr 1996 09:24:44   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/VARVIEW.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:24:44   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:53:22   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:10:08   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:36:30   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:50:46   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:02   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:15:08   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:00   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:38:36   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:23:46   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:08:30   Shirley
** EasyPack/SLD Version 0.34b
** 
**    Rev 1.18   15 Jan 1996 16:13:26   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:07:46   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:10:20   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:10   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:32   Shirley
** EasyPack/SLD Version 0.31
** 
**    Rev 1.13   13 Nov 1995 09:24:14   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:32:24   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:30:48   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:26   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:46   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:18   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:08   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.6   25 Oct 1995 14:26:30   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:49:24   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:42   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:50:26   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:57:52   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:22   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:55:12   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: VARVIEW.CPP
//
//  Description: The implementation file for the class: CVarView.
//
//  Author: Chen Jun
//
//  Date: 07/29/95
//
//  Modification:
//      1. 07/29/95, Initial version of the class: CVarView.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include <limits.h>

#include "symblsvr.h"
#include "stkinit.h"
#include "varinit.h"

#include "varpane.h"

#include "vardoc.h"
#include "varview.h"
#include "varfrm.h"

#include "colors.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern CStringList* pVarSearchPatternList;  // Defined in VARSRCH.CPP
extern CStringList* pVarTypeCastList;       // Defined in VARCAST.CPP
extern CStringList* pVarAddVariableList;    // Defined in VARADD.CPP
extern CStringList* pVarEditVariableList;   // Defined in VAREDIT.CPP

extern class VarServer varObject;

extern CMDIChildWnd* pVariableWnd;


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CVarView* pVarView = 0;


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.

// Used in VARFRM.CPP
void VarOpenWindow(CMDIFrameWnd* pParent);

void VarAddVariable(const CString strToken);
void VarAddVariable(void);
void VarDeleteOneNode(void);
void VarDeleteAll(void);
BOOL VarIsEmpty(void);
void VarSearchToken(void);
void VarSearchNextToken(void);
void VarTypeCast(void);
void VarEditVariable(void);
void VarUpdateWholeWindow(void);

void VarGetHighlightName(CString& strName);
void VarGetHighlightValue(CString& strValue);
BOOL VarModifyValue(CString& strNewValue);


/////////////////////////////////////////////////////////////////////////////
// Public functions.

// Add a new variable to the Variable window from the Source window.
void VarAddVariable(const CString strToken)
{
    // Open the variable window if necessary.
    ::VarOpenWindow((CMDIFrameWnd* )(AfxGetApp()->m_pMainWnd));
    ASSERT ( ::pVariableWnd );
    ::pVariableWnd->MDIActivate();
    
    // Assertion of the input parameters.
    ASSERT ( ::pVarView );
    ASSERT ( !strToken.IsEmpty() );
    ASSERT ( '#' == strToken[0] );

    // Add to the server.
    CString strVarName = strToken;
    char* pszVarName = strVarName.GetBuffer(strVarName.GetLength());
    if ( 0 == ::varObject.AddVar(pszVarName) ) {
        // Add new variable.
        ::pVarView->AddNewVariable();
    }
    else {
        AfxMessageBox("Illegal variable.");
    }
}

// Add a new variable to the Variable window.
void VarAddVariable(void)
{
    // Assertion of the input parameters.
    ASSERT( ::pVarView );
    
    // Verified by the Variable server.
    if ( !::pVarAddVariableList->IsEmpty() ) {
        CString strVarName = ::pVarAddVariableList->GetTail();
        if ( '#' != strVarName[0] ) {
            strVarName = "#" + strVarName;
        }
        char* pszVarName = strVarName.GetBuffer(strVarName.GetLength());
        if ( 0 == ::varObject.AddVar(pszVarName) ) {
            // Add new variable.
            ::pVarView->AddNewVariable();
        }
        else {
            ::pVarAddVariableList->RemoveTail();
            AfxMessageBox("Illegal variable.");
        }
    }
}

// Delete one variable boot node.
void VarDeleteOneNode(void)
{
    // Assertion of the input parameters.
    ASSERT( ::pVarView );
    
    // Delete a boot node.
    ::pVarView->DeleteOneNode();
}

// Delete all the variables.
void VarDeleteAll(void)
{
    // Assertion of the input parameters.
    ASSERT( ::pVarView );
    
    // Delete all the nodes.
    ::pVarView->DeleteAllNode();
}

// Detect is the Variable window empty?
BOOL VarIsEmpty(void)
{
    // Assertion of the input parameters.
    ASSERT( ::pVarView );
    
    // Detect is the Variable window empty?
    return ( ::pVarView->IsEmpty() );
}

// Get the highlight variable name.
void VarGetHighlightName(CString& strName)
{
    // Assertion of the input parameters.
    ASSERT( ::pVarView );
    
    // Get the highlight variable name.
    ::pVarView->GetHighlightName(strName);
}

// Get the highlight variable value.
void VarGetHighlightValue(CString& strValue)
{
    // Assertion of the input parameters.
    ASSERT( ::pVarView );
    
    // Get the highlight variable value.
    ::pVarView->GetHighlightValue(strValue);
}

// Search the token from head.
void VarSearchToken(void)
{
    // Assertion of the input parameters.
    ASSERT( ::pVarView );
    
    // Search the token.
    if ( !::pVarSearchPatternList->IsEmpty() ) {
        ::pVarView->SearchToken(::pVarSearchPatternList->GetTail());
    }
}

// Search the token from the next line.
void VarSearchNextToken(void)
{
    // Assertion of the input parameters.
    ASSERT( ::pVarView );
    
    // Search the token.
    if ( !::pVarSearchPatternList->IsEmpty() ) {
        ::pVarView->SearchNextToken(::pVarSearchPatternList->GetTail());
    }
}

// Modify the variable's value and update the whole Variable window.
BOOL VarModifyValue(CString& strNewValue)
{
    // Assertion of the input parameters.
    ASSERT( ::pVarView );
    
    // Modify the value.
    return (::pVarView->ModifyValue(strNewValue));
}

// Type casing.
void VarTypeCast(void)
{
    // Assertion of the input parameters.
    ASSERT( ::pVarView );

    // Type casting.
    if ( !::pVarTypeCastList->IsEmpty() ) {
        ::pVarView->TypeCast(::pVarTypeCastList->GetTail());
    }
}

// Edit the variable name.
void VarEditVariable(void)
{
    // Assertion of the input parameters.
    ASSERT( ::pVarView );

    // Edit the variable name.
    if ( !::pVarEditVariableList->IsEmpty() ) {
        ::pVarView->EditVariableName(::pVarEditVariableList->GetTail());
    }
}

// Update both of the Variable server and window.
void VarUpdateWholeWindow(void)
{
    // Assertion of the input parameters.
    ASSERT( ::pVarView );

    // Update server & window.
    ::pVarView->UpdateWholeWindow();
}


/////////////////////////////////////////////////////////////////////////////
// CVarView

IMPLEMENT_DYNCREATE(CVarView, CScrollView)

/////////////////////////////////////////////////////////////////////////////
// CVarView construction, initialization and destruction.

// Initialize the class member.
void CVarView::InitialMember(void)
{
    // Initial class member.
    m_nErrorID = noError;
    
    m_nMaxRow = pageUnit;
    m_nMaxCol = 0;
    
    m_nCurCol = 0;
    m_nCurRow = 0;

    m_xCaret = 0;
    m_yCaret = 0;
    
    m_nClientLine = 0;
    
    m_bAdjustScrollRange = TRUE;
    
    m_bCaretOn = FALSE;

    m_nScrollBox = 0;
    m_bAdjustScrollBox = FALSE;
}

// Load bitmaps.
BOOL CVarView::AllocateBitmap(void)
{
    // Assertion of the input parameters.

    // Load Invalid bitmap.
    if( !m_bmpInvalid.LoadBitmap(IDB_VAR_INVALID) ) {
        m_nErrorID = bmpLoad;
        DisplayErrorMessage();
        ASSERT( FALSE );
        return (FALSE);
    }

    // Load Simple bitmap.
    if( !m_bmpSimple.LoadBitmap(IDB_VAR_SIMPLE) ) {
        m_nErrorID = bmpLoad;
        DisplayErrorMessage();
        ASSERT( FALSE );
        return (FALSE);
    }

    // Load Open bitmap.
    if( !m_bmpOpen.LoadBitmap(IDB_VAR_OPEN) ) {
        m_nErrorID = bmpLoad;
        DisplayErrorMessage();
        ASSERT( FALSE );
        return (FALSE);
    }

    // Load Close bitmap.
    if( !m_bmpClose.LoadBitmap(IDB_VAR_CLOSE) ) {
        m_nErrorID = bmpLoad;
        DisplayErrorMessage();
        ASSERT( FALSE );
        return (FALSE);
    }
    
    return (TRUE);
}

// Release bitmaps.
void CVarView::ReleaseBitmap(void)
{
    // Assertion of the input parameters.

    // Delete Invalid bitmap.
    ASSERT( m_bmpInvalid.m_hObject );
    if ( m_bmpInvalid.m_hObject ) {
        m_bmpInvalid.DeleteObject();
    }

    // Delete Simple bitmap.
    ASSERT( m_bmpSimple.m_hObject );
    if ( m_bmpSimple.m_hObject ) {
        m_bmpSimple.DeleteObject();
    }

    // Delete Open bitmap.
    ASSERT( m_bmpOpen.m_hObject );
    if ( m_bmpOpen.m_hObject ) {
        m_bmpOpen.DeleteObject();
    }

    // Delete Close bitmap.
    ASSERT( m_bmpClose.m_hObject );
    if ( m_bmpClose.m_hObject ) {
        m_bmpClose.DeleteObject();
    }
}

// Construction.
CVarView::CVarView()
{
    // Initial.
    InitialMember();
    
    // Load bitmap.
    if ( !AllocateBitmap() ) {
        m_nErrorID = insufficientMemory;
        DisplayErrorMessage();
        ASSERT( FALSE );
        return;
    }
    
    // Set the global pointer.
    ::pVarView = this;
}

// Destruction.
CVarView::~CVarView()
{
    // Release bitmap.
    ReleaseBitmap();
}


/////////////////////////////////////////////////////////////////////////////
// Public implementation.

// Update both of the Variable server and window.
void CVarView::UpdateWholeWindow(void)
{
    // Update all the nodes in the Variable server.
    (::varObject).UpdataAllNode();
    
    // Refresh the whole window.
    m_bAdjustScrollRange = TRUE;
    Invalidate();
}

// Add a new variable into the Variable window.
void CVarView::AddNewVariable(void)
{
    // Assertion of the input parameters.

    // Get the maximum line.
    int nMaxLine;
    ::varObject.VarMaxLine(nMaxLine);

    // Set the invalidate region.
    if ( nMaxLine + pageUnit <= m_nLimitLine ) {
        m_bAdjustScrollRange = TRUE;
        Invalidate();
    }
    else {
        // Exceed the line limit.
        m_nErrorID = insufficientMemory;
        DisplayErrorMessage();

        // Delete the added node.
        ::varObject.VarLineToNode(nMaxLine-1, m_pVarNode);
        ::varObject.Delete(m_pVarNode);
    }
}

// Delete a boot node.
void CVarView::DeleteOneNode(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nCurRow >= 0 );
    
    // Get the current node.
    if ( 0 == ::varObject.VarLineToNode(m_nCurRow, m_pVarNode) ) {
        if ( m_pVarNode ) {
            int nDelLine = m_pVarNode->line;
            if ( 0 != ::varObject.Delete(m_pVarNode) ) {
                return;
            }
            else {
                // Update m_nCurRow.
                if (0 != ::varObject.VarLineToNode(m_nCurRow, m_pVarNode)) {
                    m_nCurRow = max(m_nCurRow-1, 0);
                    if ( m_nCurRow < m_nClientLine ) {
                        SendMessage(WM_VSCROLL, SB_LINEUP, 0L);
                    }
                    else {
                        m_yCaret = m_nFontHeight*(m_nCurRow-m_nClientLine);
                        m_xCaret = 0;
                    }
                }
                if ( (0 == m_nClientLine) && (m_nMaxRow-pageUnit-1-nDelLine)<
                     m_rectClient.bottom/m_nFontHeight ) {
                    UpdateModifiedRegion(TRUE);
                }
                else {
                    UpdateModifiedRegion(FALSE);
                }
            }
        }
    }
}

// Delete all the nodes.
void CVarView::DeleteAllNode(void)
{
    // Assertion of the input parameters.
    
    // Delete all the nodes from Variable server.
    ::varObject.VarDeleteAll();
    
    // Set the invalidate region.
    InitialMember();
    Invalidate();
    SendMessage(WM_KEYDOWN, VK_HOME);
}

// Detect is the Variable window empty?
BOOL CVarView::IsEmpty(void)
{
    // Assertion of the input parameters.
    
    // Detect the maximum number of the variables in the Variable window.
    return ( (pageUnit==m_nMaxRow) );
}

// Get the highlight variable name.
void CVarView::GetHighlightName(CString& strName)
{
    // Assertion of the input parameters.
    
    // Get the current node.
    if ( 0 == ::varObject.VarLineToNode(m_nCurRow, m_pVarNode) ) {
        if ( m_pVarNode ) {
            strName = m_pVarNode->name;
        }
        else {
            strName = "";
        }
    }
    else {
        strName = "";
    }
}

// Get the highlight variable value.
void CVarView::GetHighlightValue(CString& strValue)
{
    // Assertion of the input parameters.
    
    // Get the current node.
    if ( 0 == ::varObject.VarLineToNode(m_nCurRow, m_pVarNode) ) {
        if ( m_pVarNode ) {
            strValue = m_pVarNode->value;
        }
        else {
            strValue = "";
        }
    }
    else {
        strValue = "";
    }
}

// Search the token.
void CVarView::SearchToken(CString& strToken)
{
    // Assertion of the input parameters.
    
    // Search the token from the Variable server.
    int nLastLine;
    char* pszToken = strToken.GetBuffer(strToken.GetLength());
    if ( 0 == ::varObject.Search(pszToken, nLastLine) ) {
        if ( m_nCurRow != nLastLine ) {
            int nOldRow = m_nCurRow;
            m_nCurRow = nLastLine;
            UpdateToLine(m_nCurRow);
            UpdateMarkLine(nOldRow);
            UpdateMarkLine(m_nCurRow);
            TurnOnCaret();
        }
    }
    else {
        ::AfxMessageBox("No token matched.");
    }
}

// Search the next token.
void CVarView::SearchNextToken(CString& strToken)
{
    // Assertion of the input parameters.
    ASSERT( m_nCurRow >= 0 );

    // Search the token from the Variable server.
    char* pszToken = strToken.GetBuffer(strToken.GetLength());
    int nLastLine;
    if ( 0 == ::varObject.SearchNext(pszToken, m_nCurRow+1, nLastLine) ) {
        if ( m_nCurRow != nLastLine ) {
            int nOldRow = m_nCurRow;
            m_nCurRow = nLastLine;
            UpdateToLine(m_nCurRow);
            UpdateMarkLine(nOldRow);
            UpdateMarkLine(m_nCurRow);
            TurnOnCaret();
        }
    }
    else {
        ::AfxMessageBox("No token matched.");
    }
}

// Modify the variable's value and update the whole Variable window.
BOOL CVarView::ModifyValue(CString& strNewValue)
{
    // Assertion of the input parameters.
    ASSERT( m_nCurRow >= 0 );

    // Modify the value by calling Variable's server.
    if ( 0 == ::varObject.IsLegalValue(m_nCurRow, strNewValue) ) {
        ::varObject.ModifyValue(m_nCurRow, strNewValue);
        // Update the whole Variable window.
        m_bAdjustScrollRange = TRUE;
        Invalidate();
        return (TRUE);
    }
    else {
        AfxMessageBox("Illegal value.");
        return (FALSE);
    }
}

// Type casing.
void CVarView::TypeCast(CString& /* strTypeCast */)
{
    // Assertion of the input parameters.
    ASSERT( m_nCurRow >= 0 );

/*
    // Do the type casting by calling Variable's server.
    ::varObject.TypeCast(m_nCurRow, strTypeCast);
    
    // Update the whole Variable window.
    m_bAdjustScrollRange = TRUE;
    Invalidate();
*/
}

/*
// Edit the variable name.
void CVarView::EditVariableName(CString& strVariableName)
{
    // Assertion of the input parameters.
    ASSERT( m_nCurRow >= 0 );
    
    // Get the highlight variable.
    if ( 0 == ::varObject.VarLineToNode(m_nCurRow, m_pVarNode) ) {
        if ( m_pVarNode && strVariableName != m_pVarNode->name ) {
            // Delete the highlight node.
            if ( 0 != ::varObject.Delete(m_pVarNode) ) {
                return;
            }
            // Add the new node.
            char* pszName = 
                strVariableName.GetBuffer(strVariableName.GetLength());
            if ( 0 == ::varObject.AddVar(pszName) ) {
                // Set the invalidate region.
                m_bAdjustScrollRange = TRUE;
                Invalidate();
            }
            else {
                AfxMessageBox("Cannot edit the variable name.");
            }
        }
    }
}
*/

// Edit the variable name.
void CVarView::EditVariableName(CString& strVariableName)
{
    // Assertion of the input parameters.
    ASSERT( m_nCurRow >= 0 );
    
    // Get the highlight variable.
    if ( 0 == ::varObject.VarLineToNode(m_nCurRow, m_pVarNode) ) {
        if ( m_pVarNode && strVariableName != m_pVarNode->name ) {
            // Edit the new node.
            CString str = strVariableName;
            if ( '#' != str[0] ) {
                str = "#" + str;
            }
            char* pszName = str.GetBuffer(str.GetLength());
            if ( 0 == ::varObject.EditNode(m_pVarNode, pszName) ) {
                // Set the invalidate region.
                m_bAdjustScrollRange = TRUE;
                Invalidate();
            }
        }
    }
}


/////////////////////////////////////////////////////////////////////////////
// Common function.

// Show the specific bitmap.
void CVarView::DisplayBitmap(CDC* pDC, const int xPos, const int yPos)
{
    // Assertion of the input parameters.
    ASSERT( pDC );

    // Prepare DC.
    CDC dc;
    CBitmap* bmpOld;
    dc.CreateCompatibleDC(pDC);

    // Select the bitmap.
    if ( invalidSign == m_nBmpStatus ) {
        bmpOld = dc.SelectObject(&m_bmpInvalid);
    }
    else if ( simpleSign == m_nBmpStatus ) {
        bmpOld = dc.SelectObject(&m_bmpSimple);
    }
    else if ( openSign == m_nBmpStatus ) {
        bmpOld = dc.SelectObject(&m_bmpOpen);
    }
    else if ( closeSign == m_nBmpStatus ) {
        bmpOld = dc.SelectObject(&m_bmpClose);
    }

    // Draw the bitmap.
    pDC->BitBlt(xPos, yPos, bmpWidth, bmpHeight, &dc, 0, 0, SRCCOPY);
    dc.SelectObject(bmpOld);
}

// Display the error message.
void CVarView::DisplayErrorMessage(void) const
{
    // Assertion of the input parameters.
    ASSERT( m_nErrorID > noError && m_nErrorID < maxError );
    
    // Create the error message table.
    char* pszErrorMessage[] = {
        "",
        "Insufficient memory.",
        "Cannot load bitmap for the Variable window."
    };
    
    // Show the error message.
    AfxMessageBox(pszErrorMessage[m_nErrorID]);
}

// Detect the variable format by referring to Variable server.
void CVarView::DetectVarFormat(void)
{
    // Assertion of the input parameters.
    
    // Detect the variable format.
    if ( !m_pVarNode ) {
        m_nBmpStatus = invalidSign;
    	return;
    }
    	
    int nFlag = m_pVarNode->flag;
    if ( nFlag & VAR_NOVALID ) {
        m_nBmpStatus = invalidSign;
    }
    else if ( nFlag & VAR_COMPLEX ) {
        if ( nFlag & VAR_EXTEND ) {
            m_nBmpStatus = openSign;
        }
        else {
            m_nBmpStatus = closeSign;
        }
    }
    else {
        m_nBmpStatus = simpleSign;
    }
}

/*
// Output all the variable to the window.
void CVarView::OutputAllVariable(CDC* pDC)
{
    // Assertion of the input parameters.
    ASSERT( m_pVarNode );
    ASSERT( m_nMaxRow >= 0 );
    ASSERT( m_nMaxCol >= 0 );
    
    // Detect the row limit.
    if ( m_nMaxRow >= m_nLimitLine ) {
        m_nErrorID = insufficientMemory;
        DisplayErrorMessage();
        return;
    }
    
    // Detect the variable format.
    DetectVarFormat();
        
    // Get name from Variable server.
    m_strName = m_pVarNode->name;

    // Get value from Variable server.
    if ( invalidSign == m_nBmpStatus ) {
        m_strValue = "Invalid Variable.";
    }
    else {
        m_strValue = m_pVarNode->value;
    }

    // Add to the whole result string.
    m_strResult = m_strName + " = " + m_strValue;

    // Adjust to the begin column.
    int nIndent = m_pVarNode->num * 2;
        
    // Show the bitmap.
    DisplayBitmap(pDC, m_nFontWidth*nIndent, 
        m_nFontHeight*(m_nMaxRow-pageUnit));

    // Show the result.
    if ( (m_nMaxRow-pageUnit) == m_nCurRow ) {
        // Mark the variable token.
        pDC->SetBkColor(PALETTEINDEX(COLOR_YELLOW));
        pDC->SetTextColor(PALETTEINDEX(COLOR_BLACK));
        pDC->TextOut(m_nFontWidth*(nIndent+2), 
                     m_nFontHeight*(m_nMaxRow-pageUnit), 
                     m_strName);
        pDC->SetBkColor(PALETTEINDEX(COLOR_WHITE));
        pDC->SetTextColor(PALETTEINDEX(COLOR_BLACK));
        pDC->TextOut(m_nFontWidth*(nIndent+2+m_strName.GetLength()), 
                     m_nFontHeight*(m_nMaxRow-pageUnit),
                     " = " + m_strValue);
        // Update the bottom pane to show Address & Type.
        UpdateBottomPane();
    }
    else {
        // Show the whole line.
        pDC->SetBkColor(PALETTEINDEX(COLOR_WHITE));
        pDC->SetTextColor(PALETTEINDEX(COLOR_BLACK));
        pDC->TextOut(m_nFontWidth*(nIndent+2), 
                     m_nFontHeight*(m_nMaxRow-pageUnit),
                     m_strResult);
    }

    // Adjust the scroll size.
    m_nMaxCol = max(m_nMaxCol, nIndent + 2 + m_strResult.GetLength());
    m_nMaxRow++;

    // Point to the son node.
    if ( m_pVarNode->son ) {
        m_pVarNode = m_pVarNode->son;
        OutputAllVariable(pDC);
        m_pVarNode = m_pVarNode->father;
    }
        
    // Point to the next node.
    if ( m_pVarNode->next ) {
        m_pVarNode = m_pVarNode->next;
        OutputAllVariable(pDC);
    }
}
*/

/*
// Output all the variable to the window.
void CVarView::OutputAllVariable(CDC* pDC)
{
    // Assertion of the input parameters.
    ASSERT( m_pVarNode );
    ASSERT( m_nMaxRow >= 0 );
    ASSERT( m_nMaxCol >= 0 );
    
    // Loop until end or limit.
    while ( m_pVarNode ) {
        // Detect the row limit.
        if ( m_nMaxRow >= m_nLimitLine ) {
            m_nErrorID = insufficientMemory;
            DisplayErrorMessage();
            return;
        }
        
        // Detect the variable format.
        DetectVarFormat();
            
        // Get name from Variable server.
        m_strName = m_pVarNode->name;
    
        // Get value from Variable server.
        if ( invalidSign == m_nBmpStatus ) {
            m_strValue = "Invalid Variable.";
        }
        else {
            m_strValue = m_pVarNode->value;
        }
    
        // Add to the whole result string.
        m_strResult = m_strName + " = " + m_strValue;
    
        // Adjust to the begin column.
        int nIndent = m_pVarNode->num * 2;
            
        // Show the bitmap.
        DisplayBitmap(pDC, m_nFontWidth*nIndent, 
            m_nFontHeight*(m_nMaxRow-pageUnit));
    
        // Show the result.
        if ( (m_nMaxRow-pageUnit) == m_nCurRow ) {
            // Mark the variable token.
            pDC->SetBkColor(PALETTEINDEX(COLOR_YELLOW));
            pDC->SetTextColor(PALETTEINDEX(COLOR_BLACK));
            pDC->TextOut(m_nFontWidth*(nIndent+2), 
                         m_nFontHeight*(m_nMaxRow-pageUnit), 
                         m_strName);
            pDC->SetBkColor(PALETTEINDEX(COLOR_WHITE));
            pDC->SetTextColor(PALETTEINDEX(COLOR_BLACK));
            pDC->TextOut(m_nFontWidth*(nIndent+2+m_strName.GetLength()), 
                         m_nFontHeight*(m_nMaxRow-pageUnit),
                         " = " + m_strValue);
            // Update the bottom pane to show Address & Type.
            UpdateBottomPane();
        }
        else {
            // Show the whole line.
            pDC->SetBkColor(PALETTEINDEX(COLOR_WHITE));
            pDC->SetTextColor(PALETTEINDEX(COLOR_BLACK));
            pDC->TextOut(m_nFontWidth*(nIndent+2), 
                         m_nFontHeight*(m_nMaxRow-pageUnit),
                         m_strResult);
        }
    
        // Adjust the scroll size.
        m_nMaxCol = max(m_nMaxCol, nIndent + 2 + m_strResult.GetLength());
        m_nMaxRow++;
    
        // Point to the son node.
        if ( m_pVarNode->son ) {
            m_pVarNode = m_pVarNode->son;
            OutputAllVariable(pDC);
            m_pVarNode = m_pVarNode->father;
        }
            
        // Point to the next node.
        if ( m_pVarNode->next ) {
            m_pVarNode = m_pVarNode->next;
        }
        else {
            break;
        }
    }
}
*/

// Output all the variable to the window.
void CVarView::OutputAllVariable(CDC* pDC)
{
    // Assertion of the input parameters.
    ASSERT( m_pVarNode );
    ASSERT( m_nMaxRow >= 0 );
    ASSERT( m_nMaxCol >= 0 );
    
    // Loop until end or limit.
    while ( m_pVarNode ) {
        // Detect the row & column limit.
        if ( m_nMaxRow >= m_nLimitLine || m_nMaxCol >= m_nLimitColumn ) {
            m_nErrorID = insufficientMemory;
            DisplayErrorMessage();
            return;
        }
        
        // Detect the variable format.
        DetectVarFormat();
            
        // Get name from Variable server.
        m_strName = m_pVarNode->name;
    
        // Get value from Variable server.
        if ( invalidSign == m_nBmpStatus ) {
            m_strValue = "Invalid Variable.";
        }
        else {
            m_strValue = m_pVarNode->value;
        }
    
        // Add to the whole result string.
        m_strResult = m_strName + " = " + m_strValue;
    
        // Adjust to the begin column.
        int nIndent = m_pVarNode->num * 2;
            
        // Show the bitmap.
        DisplayBitmap(pDC, m_nFontWidth*nIndent, 
            m_nFontHeight*(m_nMaxRow-pageUnit));
    
        // Show the result.
        if ( (m_nMaxRow-pageUnit) == m_nCurRow ) {
            // Mark the variable token.
            pDC->SetBkColor(PALETTEINDEX(COLOR_YELLOW));
            pDC->SetTextColor(PALETTEINDEX(COLOR_BLACK));
            pDC->TextOut(m_nFontWidth*(nIndent+2), 
                         m_nFontHeight*(m_nMaxRow-pageUnit), 
                         m_strName);
            pDC->SetBkColor(PALETTEINDEX(COLOR_WHITE));
            pDC->SetTextColor(PALETTEINDEX(COLOR_BLACK));
            pDC->TextOut(m_nFontWidth*(nIndent+2+m_strName.GetLength()), 
                         m_nFontHeight*(m_nMaxRow-pageUnit),
                         " = " + m_strValue);
            // Update the bottom pane to show Address & Type.
            UpdateBottomPane();
        }
        else {
            // Show the whole line.
            pDC->SetBkColor(PALETTEINDEX(COLOR_WHITE));
            pDC->SetTextColor(PALETTEINDEX(COLOR_BLACK));
            pDC->TextOut(m_nFontWidth*(nIndent+2), 
                         m_nFontHeight*(m_nMaxRow-pageUnit),
                         m_strResult);
        }
    
        // Adjust the scroll size.
        m_nMaxCol = max(m_nMaxCol, nIndent + 2 + m_strResult.GetLength());
        m_nMaxRow++;
    
        // Point to the son node.
        if ( m_pVarNode->son ) {
            m_pVarNode = m_pVarNode->son;
            continue;
        }
            
        // Point to the next node.
        if ( m_pVarNode->next ) {
            m_pVarNode = m_pVarNode->next;
        }
        else {
            while ( m_pVarNode = m_pVarNode->father ) {
                if ( m_pVarNode->next ) {
                    m_pVarNode = m_pVarNode->next;
                    break;
                }
            }
        }
    }
}

// Update the marked line.
void CVarView::UpdateMarkLine(int nMarkLine)
{
    // Assertion of the input parameters.
    ASSERT( nMarkLine >= 0 );

    // Get the current node from Variable server.
    if ( 0 == ::varObject.VarLineToNode(nMarkLine, m_pVarNode) ) {
        int nIndent = m_pVarNode->num * 2;
        m_strName = m_pVarNode->name;
        // Set the invalidate rectangle.
        CRect rect = m_rectClient;
        rect.top += m_nFontHeight * (nMarkLine - m_nClientLine);
        rect.bottom = rect.top + m_nFontHeight;
        //rect.left = m_nFontWidth*(nIndent+2);
        //rect.right = m_nFontWidth*((nIndent+2) + m_strName.GetLength());
        m_bAdjustScrollRange = FALSE;
        InvalidateRect(rect);
        UpdateWindow();
    }
}

// Set the invalidate region.
void CVarView::UpdateModifiedRegion(BOOL bAdjustScrollRange)
{
    // Assertion of the input parameters.
    
    // Set the invalidate region.
    CRect rect = m_rectClient;
    rect.top = m_nFontHeight * (m_nCurRow - m_nClientLine);
    m_bAdjustScrollRange = bAdjustScrollRange;
    InvalidateRect(rect);
    UpdateWindow();
}

// Update the bottom pane.
void CVarView::UpdateBottomPane(void)
{
    // Assertion of the input parameters.
    
    // Set the empty to the bottom pane.
    if ( !m_pVarNode ) {
        (((CVarFrame* )GetParent())->m_wndBottomPane).m_strAddress = "";
        (((CVarFrame* )GetParent())->m_wndBottomPane).m_strType = "";
    }
    else {
        // Get the address & type information of the current node.
        ::varObject.VarAddrToStr(m_pVarNode->addr, 
            (((CVarFrame* )GetParent())->m_wndBottomPane).m_strAddress);
        (((CVarFrame* )GetParent())->m_wndBottomPane).m_strType = 
            m_pVarNode->typeName;
    }

    // Set the bottom pane invalidate rectangle.
    (((CVarFrame* )GetParent())->m_wndBottomPane).Invalidate();
    (((CVarFrame* )GetParent())->m_wndBottomPane).UpdateWindow();
}

// Update to the special line.
void CVarView::UpdateToLine(int nLine)
{
    // Assertion of the input parameters.
    ASSERT( nLine >= 0 );

    // Convert line to logical units.
    CPoint pt(0, m_nFontHeight*nLine);
    ScrollToPosition(pt);
    
    // Adjust the related parameters.
    m_nClientLine = m_nCurRow;
    m_xCaret = 0;
    m_yCaret = 0;
}
   
// Turn on the caret if it was off.
void CVarView::TurnOnCaret(void)
{
    // Assertion of the input parameters.
    
    // Adjust the caret position.
    m_xCaret = m_xCaret / m_nFontWidth * m_nFontWidth;
    m_yCaret = m_yCaret / m_nFontHeight * m_nFontHeight;

    SetCaretPos(CPoint(m_xCaret, m_yCaret));

    // Show the caret.
    if ( FALSE == m_bCaretOn ) {
        ShowCaret();
        m_bCaretOn = TRUE;
    }
}

// Turn off the caret if it was on.
void CVarView::TurnOffCaret(void)
{
    // Assertion of the input parameters.

    // Hide the caret.
    if ( TRUE == m_bCaretOn ) {
        HideCaret();
        m_bCaretOn = FALSE;
    }
}


/////////////////////////////////////////////////////////////////////////////
// CVarView drawing and updating.

BOOL CVarView::PreCreateWindow(CREATESTRUCT& cs)
{
    // Register a custom WndClass and create a window.
    // This must be done because CVarFrame has a custom icon.
    const char* pszVariableViewClass =
        AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS,
            LoadCursor(NULL, IDC_IBEAM),
            (HBRUSH) (COLOR_WINDOW+1),
            LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDR_VARIABLE)));
    
    // Set to CREATESTRUCT.
    ASSERT( NULL == cs.lpszClass );
    cs.lpszClass = pszVariableViewClass;

    return TRUE;
}

void CVarView::OnInitialUpdate()
{
    CScrollView::OnInitialUpdate();

    // TODO: calculate the total size of this view.

    // Update the scroll range.
    UpdateScrollSizes();
}

void CVarView::UpdateScrollSizes(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nMaxRow >= 0 );
    ASSERT( m_nMaxCol >= 0 );

    // Calculate the total size of this view.
    CSize sizeTotal(m_nFontWidth * min(m_nLimitColumn, m_nMaxCol+1),
        m_nFontHeight * min(m_nLimitLine, m_nMaxRow+1));
    CSize sizePage(m_nFontWidth*pageScroll, m_nFontHeight*pageScroll);
    CSize sizeLine(m_nFontWidth*lineUnit, m_nFontHeight*lineUnit);

    SetScrollSizes(MM_TEXT, sizeTotal, sizePage, sizeLine);
}

void CVarView::AssumeScrollBox(void)
{
    // Assertion of the input parameters.

    // Assume the scroll box is at the bottom.
    if ( !m_bAdjustScrollBox ) {
        // Get the current scroll box position.
        CPoint pt = GetScrollPosition();
        m_nScrollBox = pt.y;
        m_bAdjustScrollBox = TRUE;

        // Set to the bottom.
        int nMinPos, nMaxPos;
        GetScrollRange(SB_VERT, &nMinPos, &nMaxPos);
        SetScrollPos(SB_VERT, nMaxPos);
    }
}

void CVarView::RestoreScrollBox(void)
{
    // Assertion of the input parameters.

    // Restore the scroll box position.
    if ( m_bAdjustScrollBox ) {
        SetScrollPos(SB_VERT, m_nScrollBox);
        m_bAdjustScrollBox = FALSE;
    }
}

void CVarView::OnPrepareDC(CDC* pDC, CPrintInfo* /* pInfo */)
{
    CScrollView::OnPrepareDC(pDC);

    // TODO: add extra preparing DC code here
    
    // Set the font.
    pDC->SelectStockObject(ANSI_FIXED_FONT);
}

void CVarView::OnDraw(CDC* pDC)
{
    CDocument* pDoc = GetDocument();

    // TODO: add draw code here
    
    // Initial maximum row & column.
    m_nMaxRow = pageUnit;
    m_nMaxCol = 0;
    
    // Set the variable node.
    m_pVarNode = ::varObject.varListHeader;
    
    // Output the contents.
    if ( m_pVarNode ) {
        AfxGetApp()->DoWaitCursor(1);
        OutputAllVariable(pDC);
        AfxGetApp()->DoWaitCursor(-1);
    }
    else {
        UpdateBottomPane();
    }

    // Calculate the total size of this view.
    if ( m_bAdjustScrollRange ) {
        UpdateScrollSizes();
        m_bAdjustScrollRange = FALSE;
    }
}

CVarDoc* CVarView::GetDocument() // non-debug version is inline
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CVarDoc)));
    return (CVarDoc*)m_pDocument;
}


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CVarView, CScrollView)
    //{{AFX_MSG_MAP(CVarView)
    ON_WM_CREATE()
    ON_WM_SIZE()
    ON_WM_SETFOCUS()
    ON_WM_KILLFOCUS()
    ON_WM_KEYDOWN()
    ON_WM_LBUTTONDOWN()
    ON_WM_LBUTTONDBLCLK()
    ON_WM_SETCURSOR()
    ON_WM_RBUTTONDOWN()
    ON_WM_HSCROLL()
    ON_WM_VSCROLL()
    ON_COMMAND(ID_SHIFTRETURN, OnShiftreturn)
    ON_WM_PAINT()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVarView message handlers

int CVarView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CScrollView::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    // Set standard font.
    CDC* pDC = GetDC();
    pDC->SelectStockObject(ANSI_FIXED_FONT);

    // Get the font size.
    TEXTMETRIC tm;
    pDC->GetTextMetrics(&tm);
    m_nFontWidth = tm.tmAveCharWidth;
    m_nFontHeight = tm.tmHeight + tm.tmExternalLeading;

    ReleaseDC(pDC);

    // Update the caret position.
    TurnOnCaret();
    
    // Set the limit row in this view: 2048 rows.
    m_nLimitLine = INT_MAX / m_nFontHeight - limitRow;
    m_nLimitColumn = INT_MAX / m_nFontWidth - limitColumn;

    return 0;
}

void CVarView::OnSize(UINT nType, int cx, int cy)
{
    CScrollView::OnSize(nType, cx, cy);
    
    // TODO: Add your message handler code here

    // Adjust the Variable view.
    CRect rect;
    ((CVarFrame* )GetParent())->GetClientRect(rect);
    rect = CRect(rect.left,rect.top-1,rect.right,rect.bottom-bottomHeight+1);
    MoveWindow(rect);
    
    // Get the client area size.
    GetClientRect(m_rectClient);
    
    // Adjust the local pane size.
    if ( 0 == (m_rectClient.Height() % m_nFontHeight) ) {
        m_rectClient.bottom += 1;
    }
    
    // Adjust the scroll range.
    UpdateScrollSizes();
    m_bAdjustScrollRange = FALSE;

    // Scroll to the current line.
    UpdateToLine(m_nCurRow);

    // Hide the caret.
    TurnOffCaret();
}

void CVarView::OnSetFocus(CWnd* pOldWnd)
{
    CScrollView::OnSetFocus(pOldWnd);
    
    // TODO: Add your message handler code here
    
    // Create the caret shape.
    CreateSolidCaret(caretWidth, m_nFontHeight);
    
    // Show the caret.
    TurnOnCaret();
}

void CVarView::OnKillFocus(CWnd* pNewWnd)
{
    CScrollView::OnKillFocus(pNewWnd);
    
    // TODO: Add your message handler code here
    
    // Hide the caret.
    TurnOffCaret();
    
    // Destroy the caret.
    DestroyCaret();
}

void CVarView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    // TODO: Add your message handler code here and/or call default
    
    // Assertion of the input parameters.
    ASSERT( m_nMaxRow >= 0 );
    ASSERT( m_nMaxCol >= 0 );
    ASSERT( m_nCurRow >= 0 );
    ASSERT( m_nCurCol >= 0 );
    
    // Adjust the caret position according to the highlight line.
    m_yCaret = m_nFontHeight * (m_nCurRow - m_nClientLine);
    int nFillRow = m_rectClient.Height() / m_nFontHeight;
    
    // Process the keyboard event.
    switch ( nChar ) {
        case VK_UP:
    		RestoreScrollBox();
            if ( 0 == m_nCurRow ) {
                break;
            }
            else {
                m_nCurRow--;
            }
            if ( m_yCaret - m_nFontHeight < m_rectClient.top ) {
                SendMessage(WM_VSCROLL, SB_LINEUP);
            }
            else {
                m_yCaret -= m_nFontHeight;
            }
            UpdateMarkLine(m_nCurRow+1);
            UpdateMarkLine(m_nCurRow);
            break;
        case VK_DOWN:
    		RestoreScrollBox();
            if ( m_nMaxRow - pageUnit - lineUnit <= m_nCurRow ) {
                AssumeScrollBox();
                break;
            }
            else {
                m_nCurRow++;
            }
            if (m_yCaret+m_nFontHeight >= m_rectClient.bottom-m_nFontHeight){
                SendMessage(WM_VSCROLL, SB_LINEDOWN);
            }
            else {
                m_yCaret += m_nFontHeight;
            }
            UpdateMarkLine(m_nCurRow-1);
            UpdateMarkLine(m_nCurRow);
            break;
        case VK_PRIOR:
    		RestoreScrollBox();
            if ( 0 == m_nCurRow ) {
                break;
            }
            else {
                SendMessage(WM_VSCROLL, SB_PAGEUP);
                int nOldRow = m_nCurRow;
                m_nCurRow = m_nClientLine + m_yCaret / m_nFontHeight;
                UpdateMarkLine(nOldRow);
                UpdateMarkLine(m_nCurRow);
            }
            break;
        case VK_NEXT:
    		RestoreScrollBox();
            if ( nFillRow + m_nClientLine + pageScroll > m_nMaxRow - pageUnit ) {
                AssumeScrollBox();
                break;
            }
            else {
                SendMessage(WM_VSCROLL, SB_PAGEDOWN);
                int nOldRow = m_nCurRow;
                m_nCurRow = m_nClientLine + m_yCaret / m_nFontHeight;
                UpdateMarkLine(nOldRow);
                UpdateMarkLine(m_nCurRow);
            }
            break;
        case VK_LEFT:
            if ( (GetKeyState(VK_SHIFT) & 0x8000) ) {
                // Left drag.
            }
            else {
                if ( 0 == m_nCurCol ) {
                    SendMessage(WM_HSCROLL, SB_TOP);
                    m_xCaret = 0;
                    break;
                }
                else {
                    m_nCurCol--;
                }
                if ( m_xCaret - m_nFontWidth < m_rectClient.left ) {
                    SendMessage(WM_HSCROLL, SB_LINELEFT);
                }
                else {
                    m_xCaret -= m_nFontWidth;
                }
            }
            break;         
        case VK_RIGHT:
            if ( (GetKeyState(VK_SHIFT) & 0x8000) ) {
                // Right drag.
            }
            else {
                if ( m_nMaxCol == m_nCurCol ) {
                    SendMessage(WM_HSCROLL, SB_BOTTOM);
                    m_xCaret = m_nFontWidth * m_nMaxCol;
                    break;
                }
                else {
                    m_nCurCol++;
                }
                if ( m_xCaret + m_nFontWidth >= m_rectClient.right ) {
                    SendMessage(WM_HSCROLL, SB_LINERIGHT);
                }
                else {
                    m_xCaret += m_nFontWidth;
                }
            }
            break;
        case VK_HOME:
            m_nCurCol = 0;
            SendMessage(WM_HSCROLL, SB_TOP);
            m_xCaret = 0;
            break;
        case VK_END:
            m_nCurCol = m_nMaxCol;
            SendMessage(WM_HSCROLL, SB_BOTTOM);
            m_xCaret = m_nFontWidth * m_nMaxCol;
            break;
        case VK_RETURN:
            // LB Double click.
    		RestoreScrollBox();
            SendMessage(WM_LBUTTONDBLCLK);
            break;
        case VK_DELETE:
            // Delete a variable.
    		RestoreScrollBox();
            DeleteOneNode();
            break;
        default:
            break;
    }
    
    // Update the caret position.
    TurnOnCaret();
    
    CScrollView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CVarView::OnLButtonDown(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
    
    // If there is any variables?
    if ( m_nMaxRow > pageUnit ) {
		RestoreScrollBox();
        // Get the old caret position.
        int nOldRow = m_nCurRow;
    
        // Get the caret position.
        m_xCaret = point.x / m_nFontWidth * m_nFontWidth;
        m_yCaret = point.y / m_nFontHeight * m_nFontHeight;
    
        // Set the current caret position.
        m_nCurCol = point.x / m_nFontWidth;
        m_nCurRow = m_nClientLine + point.y / m_nFontHeight;
    
        // Select the valid last line.
        if ( m_nCurRow > m_nMaxRow - pageUnit - 1 ) {
            m_nCurRow = m_nMaxRow - pageUnit - 1;
            m_yCaret = m_nFontHeight * (m_nCurRow - m_nClientLine);
        }
    
        // Redraw the window to highlight the variable token.
        if ( m_nCurRow != nOldRow ) {
            UpdateMarkLine(nOldRow);
            UpdateMarkLine(m_nCurRow);
        }
            
        // Update the caret position.
        SetFocus();
        TurnOnCaret();
    }

    CScrollView::OnLButtonDown(nFlags, point);
}

void CVarView::OnLButtonDblClk(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default

    // Expand or collapse the bitmap.
    ASSERT( m_nCurRow >= 0 );
	RestoreScrollBox();
    if ( 0 == ::varObject.VarLineToNode(m_nCurRow, m_pVarNode) ) {
        if ( m_pVarNode ) {
            DetectVarFormat();
            if ( openSign == m_nBmpStatus ) {
                if ( 0 == ::varObject.VarCompressNode(m_pVarNode) ) {
                    // Set the invalidate region.
                    UpdateModifiedRegion(TRUE);
                }
            }
            else if ( closeSign == m_nBmpStatus ) {
                if ( 0 == ::varObject.VarExtendedNode(m_pVarNode) ) {
                    // Get the maximum line.
                    int nMaxLine;
                    ::varObject.VarMaxLine(nMaxLine);
                    // Set the invalidate region.
                    if ( nMaxLine <= m_nLimitLine ) {
                        UpdateModifiedRegion(TRUE);
                    }
                    else {
                        // Exceed the line limit.
                        m_nErrorID = insufficientMemory;
                        DisplayErrorMessage();
                        // Compressed the extended node.
                        ::varObject.VarCompressNode(m_pVarNode);
                    }
                }
            }
        }
    }
    
    CScrollView::OnLButtonDblClk(nFlags, point);
}

void CVarView::OnRButtonDown(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
    
/*
    // Create the popup menu.
    CMenu* pPopupMenu = new CMenu;
    ASSERT( NULL != pPopupMenu );
    if ( !pPopupMenu ) {
        m_nErrorID = insufficientMemory;
        DisplayErrorMessage();
        return;
    }
    pPopupMenu->CreatePopupMenu();
    
    // Define the local menu.
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_ADDRESS, "char* as &Address");
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_STRING, "char* as &String");
    pPopupMenu->AppendMenu(MF_SEPARATOR);
    
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_BYTE, "&Byte");
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_WORD, "&Word");
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_LONG, "&Long");
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_FLOAT, "&Float");
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_DOUBLE, "&Double");
    pPopupMenu->AppendMenu(MF_SEPARATOR);
    
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_SIGNED, "S&igned Decimal");
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_UNSIGNED, "&Unsigned Decimal");
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_HEXADECIMAL, "Hexadecimal");
*/
    
    // Create the local menu.
    CMenu* pLocalMenu = new CMenu;
    ASSERT( NULL != pLocalMenu );
    if ( !pLocalMenu ) {
        m_nErrorID = insufficientMemory;
        DisplayErrorMessage();
        return;
    }
    pLocalMenu->CreatePopupMenu();

    // Define the local menu.
    pLocalMenu->AppendMenu(MF_STRING, ID_VARIABLE_ADD, "&Add...");
    pLocalMenu->AppendMenu(MF_STRING, ID_VARIABLE_EDIT, "&Edit...");
    pLocalMenu->AppendMenu(MF_STRING, ID_VARIABLE_DELETE, "&Delete");
    pLocalMenu->AppendMenu(MF_STRING, ID_VARIABLE_DELETEALL, "De&lete All");
//    pLocalMenu->AppendMenu(MF_STRING, ID_VARIABLE_UNDELETE, "&Undelete");
    pLocalMenu->AppendMenu(MF_SEPARATOR);

    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_MODIFYVALUES, "&Modify Value...");
    pLocalMenu->AppendMenu(MF_SEPARATOR);

/*
    pLocalMenu->AppendMenu(MF_POPUP, (UINT)(pPopupMenu->GetSafeHmenu()), "&Format");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_TYPECAST, "Type &Cast...");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
    
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_DISPLAYHORIZONTALLY, "Display &Horizontally");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_DISPLAYVERTICALLY, "Display &Vertically");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
    
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_SORTBYHISTORY, "Sort By H&istory");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_SORTBYNAME, "Sort By &Name");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
*/
    
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_SEARCH, "&Search...");
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_SEARCHNEXT, "Search &Next");
    
    // Adjust the cursor location.
    if ( 0 == point.x && 0 == point.y ) {
        CRect rect;
        GetClientRect(&rect);
        point = CPoint(rect.left+rect.Width()/2, rect.top+rect.Height()/2);
    }

    // Display the local menu.
    ClientToScreen(&point);
    
    // Active the local menu.
    pLocalMenu->TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, GetParent());

    // Release the allocated buffer.
//    delete pPopupMenu;
    delete pLocalMenu;
    
    CScrollView::OnRButtonDown(nFlags, point);
}

BOOL CVarView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
    // TODO: Add your message handler code here and/or call default

    // Disable parent window from pre-handling the WM_RBUTTONDOWN message.
    // MAINFRM latch WM_RBUTTONDOWN to implement local menu.
    if ( message == WM_RBUTTONDOWN ) {
        return FALSE;
    }

    return CScrollView::OnSetCursor(pWnd, nHitTest, message);
}

void CVarView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    // TODO: Add your message handler code here and/or call default
    
    // Disable the thumb direct operation.
    switch ( nSBCode ) {
        case SB_LINELEFT:
            break;
        case SB_LINERIGHT: 
            break;
        case SB_PAGELEFT:
            break;
        case SB_PAGERIGHT: 
            break;
        case SB_TOP:
            break;
        case SB_BOTTOM:
            break;
        /*
        case SB_ENDSCROLL:
            break;              
        case SB_THUMBPOSITION:
            break;
        case SB_THUMBTRACK:
            break;
        default:
            break;
        */
        default:
            return;
    }

    CScrollView::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CVarView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    // TODO: Add your message handler code here and/or call default

    // Disable the thumb direct operation.
    int nFillRow = m_rectClient.Height() / m_nFontHeight;
    int nTrackLine = nPos / m_nFontHeight;
    int nOldLine = m_nCurRow;

    switch ( nSBCode ) {
        case SB_LINEUP:
			RestoreScrollBox();
            m_nClientLine = max(m_nClientLine-lineUnit, 0);
            break;
        case SB_LINEDOWN:
			RestoreScrollBox();
            if ( nFillRow + m_nClientLine + lineUnit > m_nMaxRow - pageUnit ) {
                AssumeScrollBox();
                return;
            }
            else {
                m_nClientLine = min(m_nClientLine+lineUnit, m_nLimitLine);
            }
            break;
        case SB_PAGEUP:
			RestoreScrollBox();
            m_nClientLine = max(m_nClientLine-pageScroll, 0);
            break;
        case SB_PAGEDOWN:
			RestoreScrollBox();
            if ( nFillRow + m_nClientLine + pageScroll > m_nMaxRow - pageUnit ) {
                AssumeScrollBox();
                return;
            }
            else {
                m_nClientLine = min(m_nClientLine+pageScroll, m_nLimitLine);
            }
            break;
        /*
        case SB_TOP:
            break;
        case SB_BOTTOM:
            break;
        case SB_ENDSCROLL:        
            break;
		*/
        case SB_THUMBPOSITION:       
			RestoreScrollBox();
			nTrackLine = max(nTrackLine, 0);
			nTrackLine = min(nTrackLine, m_nMaxRow-pageUnit-1);
			m_nCurRow = nTrackLine;
            UpdateToLine(m_nCurRow);
            UpdateMarkLine(m_nCurRow);
            UpdateMarkLine(nOldLine);
		    TurnOffCaret();
            break;
		/*
        case SB_THUMBTRACK:     
            break;
        default:
            break;
        */
        default:
            return;
    }

    CScrollView::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CVarView::OnShiftreturn()
{
    // TODO: Add your command handler code here
    
    // Mouse right button down.
    SendMessage(WM_RBUTTONDOWN);
}

void CVarView::OnPaint()
{
    CPaintDC dc(this); // device context for painting
    
    // TODO: Add your message handler code here
    
    // Standard paint routine.
    RestoreScrollBox();
    OnPrepareDC(&dc);
    OnDraw(&dc);
    
    // Do not call CScrollView::OnPaint() for painting messages
}
