
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/XINIT.CPP   1.29   02 Apr 1996 09:30:56   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/XINIT.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:30:56   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:52:24   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:06:56   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:24   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:18   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:40   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:22   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:04   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:40   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:10   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:10:26   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:11:28   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:12:26   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:11:40   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:32:18   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:48   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:28:08   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:58   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:33:10   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:08   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:03:40   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:50   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:22   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:10   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:48:52   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.4   13 Oct 1995 13:20:08   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:51:58   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:57:54   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:24   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:14   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  XINIT.CPP
//
//  Description:The implement file of init routines
//
//  Author:     Roger Zhang
//
//  Date:       04/07/95
//
//  Modification:
//
//      1. 04/07/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "cpucom.h"                   
#include "xinit.h"
#include "symblsvr.h"
#include "communic.h"

/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
BOOL VarAllocateSpace(void);
void VarReleaseSpace(void);
BOOL StkAllocateSpace(void);
void StkReleaseSpace(void);

extern BOOL SetupCommunication(UINT pData);
extern BOOL SetCommType(int nTempCommType);

extern BOOL ReadLoadOption(void);
extern BOOL WriteLoadOption(void);

extern void InitRegSelect(void);

extern void DelLabel(void);
extern void NewLabel(void);

extern int InitGetCpuType(void);
extern int InitCpu(int iRoger);

CString strAppPath;

int nPortAddr = 0x300;         
int nPortType = 0; // 0 -> Parallel(PCE)
                   // 1 -> LPT1
                   // 2 -> LPT2
                   // 3 -> LPT3          
                   // 4 -> COM1
                   // 5 -> COM2
                   // 6 -> COM3
                   // 7 -> COM4
                   
const char * DefPortAddr[8] = {
    "280",  //PCE
    "378",  //LPT1
    "3BC",  //LPT2
    "3BC",  //LPT3
    "3F8",  //COM1
    "2F8",  //COM2
    "0",    //COM3
    "0"     //COM4
};                                       

int nBaudRate = 0;

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   ReadCommInfo
//
//  Description: Read communication information from .ini file
//
//  Input:  None
//
//  Output: None
//
//  Return: FALSE -- Fail to read.
//          TRUE  -- Read Ok.
//
/////////////////////////////////////////////////////////////////////////////
BOOL ReadCommInfo(void)
{
    nPortType = AfxGetApp()->GetProfileInt("COMM", "Type", 0);
    if(nPortType < 0 || nPortType > 2) {
//        AfxMessageBox(IDS_PRM_INITCOMMTYPE);
        return FALSE;
    }
    
    CString str = AfxGetApp()->GetProfileString("COMM", "Addr", 
        DefPortAddr[nPortType]);
    sscanf(str, "%x", &nPortAddr);
    return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   WriteCommInfo
//
//  Description: Write communication information to .ini file
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void WriteCommInfo(void)
{   
    AfxGetApp()->WriteProfileInt("COMM", "Type", nPortType);
    char ach[20];
    wsprintf(ach, "%X", nPortAddr);
    AfxGetApp()->WriteProfileString("COMM", "Addr", ach);
}                    

BOOL CommDlg(void)
{
    AfxGetApp()->DoWaitCursor(-1);
    CCommunicationDialog dlg;
    int nRet = dlg.DoModal() == IDOK;
    AfxGetApp()->DoWaitCursor(1);
    return nRet;
}


                     
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   Init
//
//  Description: Initial routine
//
//  Input:  None
//
//  Output: None
//
//  Return: 0 -- Initialize failure
//          1 -- Initialize Ok.
//
/////////////////////////////////////////////////////////////////////////////
int Init(void)
{   
    #ifdef _ZLR_
       
    // Read communication information from the private profile       
    if(!ReadCommInfo()) {  
        //DelLabel();
        AfxMessageBox("Please enter the communication type and address");
        if(!CommDlg()) { 
            AfxMessageBox(IDS_PRM_INITCOMMTYPE);
            return  0;
        }
    }

    BOOL fPortEcho;
KKK:
    // Set communication type
    if ( nPortType == 0 )     // PCE
         fPortEcho = SetCommType(1);
    else if ( nPortType > 0 && nPortType <= 3 )     // LPT1->LPT3
         fPortEcho = SetCommType(2);

    if ( fPortEcho == TRUE) {
        // Set port address
        fPortEcho = SetupCommunication(nPortAddr);
    }

    if (fPortEcho == FALSE) {
        AfxMessageBox("Setup Communication Error!");
        if( !CommDlg() )
            return 0;
        else goto KKK;
    }
    
    WriteCommInfo();
    
    // Select CPU Type
    int i = InitGetCpuType();  
    if(i < 0) {
     	AfxMessageBox("F/W can't support this CPU");
     	return	0;
    }
    i = InitCpu(i);
    if(!i)	return	0;

    //strAppPath = AfxGetApp()->GetProfileString("PATH", "ExePath");
          
    NewLabel();                
	//                                
	InitRegSelect();                                
                                
    // Read load option from the private profile      
    ReadLoadOption();                                   
    
    SymInitialize();

    //added by john 95.8
    i = InitBp();
    if(!i)  return  0;
    i = InitTrace();
    if(!i)  return  0;
    //************************

    nCurRegs = nMaxReg;

    // For Variable window.
    if ( !::VarAllocateSpace() ) {
        return (0);
    }

    // For Stack window.
    if ( !::StkAllocateSpace() ) {
        return (0);
    }

    return i;
    #else

    return 1;

    #endif
}                    

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   XPost
//
//  Description: Post routine on exit.
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void XPost(void)
{
    // Variable & Stack window.
    ::VarReleaseSpace();
    ::StkReleaseSpace();

    WriteCommInfo();
    WriteLoadOption();
}

/////////////////////////////////(EOF)///////////////////////////////////////
