
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/AA.CPP   1.13   13 Dec 1996 11:17:44   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/AA.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:17:44   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:58:44   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:45:58   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:57:58   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:45:32   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:47:44   ZJRD
** PIC/SLD Version 0.93
** 
**    Rev 1.7   28 Oct 1996 09:40:44   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:20   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:44:54   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:30:30   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:44:18   ZJRD
** PIC/SLD Version 0.60
** 
**    Rev 1.2   02 Sep 1996 11:25:40   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:04:22   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:17:38   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// aa.cpp
//
// Dragon
//                                                                           
// 8/7/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "aa.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void AATool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_bCross = " << m_bCross << "\n";
    dc << "m_bObject = " << m_bObject << "\n";
 //   dc << "m_bList = " << m_bList << "\n";
    dc << "m_bError = " << m_bError << "\n";
    dc << "m_nHex = " << m_nHex << "\n";
    dc << "m_nProcessor = " << m_nProcessor << "\n";
    dc << "m_strmore = " << m_strmore << "\n";
    dc << "m_strpath = " << m_strpath << "\n";
    dc << "m_strExe = " << m_strExe << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void AATool::SetDefault(void)
{
   m_bCross = FALSE;
   m_bObject = TRUE;
 //  m_bList = TRUE;
   m_bError = TRUE;
   m_nHex = 0;
   m_nProcessor = 0;
   m_strmore = "";
   m_strpath = "c:\\compiler"; 
   m_strExe  = "mpasm.exe";
}

BOOL AATool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 5;
    char ach[nCnt];
    
    if(fread(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_nProcessor = ach[0];
    m_nHex = ach[1];
    m_bError = ach[2];
 //   m_bList = ach[3];
    m_bCross = ach[3];
    m_bObject = ach[4];
    
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strmore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strmore.ReleaseBuffer(wLen);
    
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strpath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strpath.ReleaseBuffer(wLen);  
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strExe.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strExe.ReleaseBuffer(wLen);  
    
    return TRUE;
}                 

BOOL AATool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 5;

    char ach[nCnt];
    
    ach[0] = m_nProcessor;
    ach[1] = m_nHex;
    ach[2] = m_bError;
   // ach[3] = m_bList;
    ach[3] = m_bCross;
    ach[4] = m_bObject;
    
    if(fwrite(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strmore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strmore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strmore.ReleaseBuffer(wLen);  
    
              
    wLen =  m_strpath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strpath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strpath.ReleaseBuffer(wLen);
    
    wLen =  m_strExe.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strExe.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strExe.ReleaseBuffer(wLen);
    
    return TRUE;
}

static char * ar1[4] = { "/p16c5x ", "/p16cxx ", "/p17cxx " };
static char * ar2[4] = { "/aINHX8M ", "/a- " };

CString AATool::GetOption(void) const
{
    CString str = " ";
    
    str += ar1[m_nProcessor];
    str += ar2[m_nHex];
    
    if(!m_bError)
        str += "/e- ";
        
 //   if(!m_bList)
        str += "/l+ ";
        
    if(m_bCross)
        str += "/x- ";
        
    if(m_bObject)   
        str += "/o+ ";
        
    
    str += m_strmore;
    str += " ";
    
    return str;
}

