/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/ABIFNPIC.CPP   1.13   13 Dec 1996 11:17:44   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/ABIFNPIC.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:17:44   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:58:46   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:00   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:00   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:32   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:56   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:46   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:56   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.5   09 Oct 1996 13:47:28   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:36:44   ZJRD
** PIC/SLD Version 0.70
** 
**    Rev 1.3   06 Sep 1996 13:51:22   ZJRD
** PIC/SLD Version 0.60
** 
**    Rev 1.0   13 Aug 1996 09:20:10   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : ABIFNPIC.CPP
** Author:john chow
** Description:
**    Descript the ABI routine for PIC
**
**    Finished date: 96.7
**    modifed date:
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/


#include "stdafx.h"

#include "abibase.h"
#include "abitype.h"
#include "abimacro.h"
#include "abispa.h"
#include "cpust.h"
#include "serialcm.h"
#include "uiserial.h"

ADDR retAddr;
extern STATUS SendReceive(UINT wLoop, int tcount);
static UINT gRegLen = 0x7f;
/*****************************************************
**
** Name : AbiReset()
**
** Function
**
**    Input  : addr:the specified PC value after Reset. 
**                  If addr.addrType= =0, then this parameter has no 
**                        sense, and the PC will be initialized
**                  If addr.addrType == 0x16,FW will both reset target
**                  CPU and EP.
**
**
**    Output : STATUS
**
** Notes:
**
*****************************************************/
STATUS AbiReset(ADDR addr)
{                 
    STATUS status; 
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_RESET,uintLoop);
    SaveVar(addr, uintLoop, sizeof(ADDR));

    status = SendReceive(uintLoop, BASE_TIME); 
    
    return status;
}                      

/*****************************************************
**
** Name : AbiGo()
**
** Function
**
**    Input  : runFlag: indicates the mode of running: either normal or running.
**                      0 normal , 1 running.
**             fromAddr:the start PC to go. If fromAddrs dataType=0,                   
**                      indicate this parameter has no sense.
**             tillAddr:the end PC to go. If endAddrs dataType=0,                          indicate this parameter has no sense.
**
**
**    Output : STATUS
**
** Notes:
**
*****************************************************/
STATUS AbiGo(FLAG runFlag, ADDR fromAddr, ADDR tillAddr)
{ 
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_GO,uintLoop);
    SaveVar(runFlag, uintLoop,sizeof(FLAG));
    SaveVar(fromAddr,uintLoop,sizeof(ADDR));
    SaveVar(tillAddr,uintLoop,sizeof(ADDR));
    

    status = SendReceive(uintLoop, BASE_TIME);
    return status;
}

/*****************************************************
**
** Name : AbiAbort()
**
** Function
**
**    Input  :
**
**    Output : STATUS
**
** Notes:
**
*****************************************************/
STATUS AbiAbort()
{
    STATUS status; 
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_ABORT,uintLoop);
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    return status;
} 

/****************************************************
**
** Name : AbiDiagnostic()
**
** Function
**
**    Input  :          
**    Output : result 0 ok; !0 not ok 
**             STATUS
**
****************************************************/
STATUS AbiDiagnostic(unsigned char* uchOption,unsigned char* bResult)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_DIAGNOSTIC, lp);            
    SaveBuffer(uchOption,lp,14);

    status = SendReceive(lp, 15000);
    memcpy(bResult,&(inputStream[1]),21);
    return(status);
} 

/****************************************************
**
** Name : AbiSetCpuId()
**
** Function
**
**    Input  :  the CPU ID. to set
**
**    Output :  the result CPU ID
**              STATUS
** Notes:
**
****************************************************/
STATUS AbiSetCpuId(UINT nSetCpuId, UINT *nGetCpuId)
{
    STATUS status;
    UINT lp;
    UCHAR *uchPtr;

    lp = 0;
    SaveId(FW_SET_CPU_ID, lp);
    SaveVar(nSetCpuId, lp, sizeof(UINT));

    status = SendReceive(lp, BASE_TIME);

    uchPtr = &inputStream[1];
    *nGetCpuId = *((UINT*)uchPtr);

    return(status);
}

/****************************************************
**
** Name : AbiGetControl()
**
** Function
**
**    Input  :
**
**    Output :  STATUS            
**              *bControlFlag:  bit  0:Reset   0:disable 1:enable
**                              bit 1-2:clock
**                                  0 : LP
**                                  1 : XT
**                                  2 : HS
**                                  3 : RS
**                              bit    3: WDT(watch dog)  0:disable 1:enable
**                              bit    4: Prepherial   0:disable 1:enable
**                              bit5 -- bit7 : 0
** Notes:
**
****************************************************/
STATUS AbiGetControl(FLAG* bControlFlag)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_GET_CONTROL, lp);

    status = SendReceive(lp, BASE_TIME);
    if (status == ICE_OK) {
        *bControlFlag = inputStream[1];
    }

    return(status);
}                              

/****************************************************
**
** Name : AbiSetControl()
**
** Function
**
**    Input  :   controlFlag        same as AbiGetControl
**
**    Output : STATUS
**               
**
** Notes:
**
****************************************************/
STATUS AbiSetControl(FLAG bControlFlag)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_SET_CONTROL, lp);
    SaveVar(bControlFlag, lp, sizeof(FLAG));

    status = SendReceive(lp, BASE_TIME);
    return(status);
}

                
/****************************************************
**
** Name : AbiOutput()
**
** Function
**
**    Input  : bPort        output port  number
**                          0 RA
**                          1 RB
**                          2 RC
**                          3 RD
**                          4 RE
**                          5 RF
**          
**             bPortValue   the data to be sent.
**             bMaskFlag    the maskFlag of the output data
**                          0 mast    1 no-mask
**
**    Output : STATUS
**
** Notes:
**
****************************************************/
STATUS AbiOutput(BYTE bPort, BYTE bPortValue, BYTE bMaskFlag)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_OUTPUT,lp);                
    SaveVar(bPort, lp, sizeof(BYTE));
    SaveVar(bPortValue, lp, sizeof(BYTE));
    SaveVar(bMaskFlag, lp, sizeof(BYTE));
    
    status = SendReceive(lp, BASE_TIME);
    
    return(status);
}                         

/****************************************************
**
** Name : AbiInput()
**
** Function
**
**    Input  :  bPort       the number of input port .
**                          //defined in AbiOutput()
**              *bPortValue the port to store data.
**
**    Output :  STATUS
**
** Notes:
**
****************************************************/
STATUS AbiInput(BYTE bPort, BYTE *bPortValue)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_INPUT,lp); 
    SaveVar(bPort, lp, sizeof(BYTE));

    status = SendReceive(lp, BASE_TIME);
    if (status == ICE_OK) {
        memcpy(bPortValue, &inputStream[1], sizeof(BYTE));
    }
    return(status);
}       

/*****************************************************
**
** Name : AbiSetVerify()
**
** Function
**
**    Input  :  uVerifyFlag  0 : memory verification OFF, VERIFY_OFF
**                           1 : memory verification ON, VERIFY_ON
**
**    Output :  STATUS
**
** Notes:
**
*****************************************************/
STATUS AbiSetVerify(FLAG uVerifyFlag)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_SET_VERIFY_ONOFF,lp);
    SaveVar(uVerifyFlag, lp, sizeof(FLAG));

    status = SendReceive(lp, BASE_TIME);
    return status;
}

/*****************************************************
**
** Name : AbiSetTrigLogic()
**
** Function
**
**    Input  :  tmpTrigLogic        the struct that contains trigger logic conditions detail                   information.
**              typedef struct {
**                  BYTE bTriggerLogic, //set the trigger logic
**                      //0x1   EV1
**                      //0x2   EV2
**                      //0x3   EV3
**                      //0x4   EV1 or EV2
**                      //0x5   EV1 or EV3
**                      //0x6   EV2 or EV3
**                      //0x7   EV1 or EV2 or EV3
**                      //0x8   EV1 then EV2
**                      //0x9   EV1 then EV3
**                      //0xa  EV2 then EV1
**                      //0xb  EV2 then EV3
**                      //0xc  EV3 then EV1
**                      //0xd  EV3 then EV2
**                  BYTE bTriggerConditon
**                      //0x0   trigger off
**                      //0x1   Forward
**                      //0x2   Center
**                      //0x3   Backward
**              } TRIGGER_LOGIC ;
**
**    Output :  STATUS
**
** Notes:
**
*****************************************************/
STATUS AbiSetTrigLogic(TRIGGER_LOGIC trigLogicData)
{ 
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SET_TRIG_LOGIC,uintLoop);
    SaveVar(trigLogicData, uintLoop, sizeof(TRIGGER_LOGIC));

    status = SendReceive(uintLoop, BASE_TIME);
    return status;
}
                
/****************************************************
**
** Name : AbiGetCpuId()
**
** Function
**
**    Input  :  *nCpuId         CPU type
**
**    Output :  STATUS
**
** Notes:
**
****************************************************/
STATUS AbiGetCpuId(UINT *nCpuId)
{
    STATUS status;
    UINT lp;
    UCHAR *uchPtr;
    
    lp = 0;
    SaveId(FW_GET_CPU_ID, lp);
    status = SendReceive(lp, BASE_TIME);

    uchPtr = &inputStream[1];
    *nCpuId = *((UINT*)uchPtr);

    return(status);
}
                  
/**************************************************************************
**
** Name : AbiChecksum
**
** Function
**
**    Input  :  addr1       start address of checksum
**              addr2       end address of checksum
**              *uChecksum  checksum
**
**    Output :  STATUS
**
** Notes:
**
**************************************************************************/
STATUS AbiChecksum(ADDR addr1, ADDR addr2, UINT *uChecksum)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_CHECKSUM,lp);
    SaveVar(addr1,lp,sizeof(ADDR)); 
    SaveVar(addr2,lp,sizeof(ADDR));

   status = SendReceive(lp, BASE_TIME);
   
   if (status == ICE_OK)
      *uChecksum = *(UINT*)&inputStream[1]; /* checksum */

   return(status);
}                 

/**************************************************************************
**
** Name : AbiCompare
**
** Function
**
**    Input  : addr1        the start address of first block.
**             addr2        the end address  of first block.
**             addr3        the start address of second block.
**             
**
**    Output : STATUS
**             *findAddr    the first location of difference in first block.
** Notes:
**
**************************************************************************/
STATUS AbiCompare(ADDR addr1, ADDR addr2, ADDR destAddr,
                  ADDR* retAddr)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_COMPARE,lp);
    SaveVar(addr1,lp,sizeof(ADDR));
    SaveVar(addr2,lp,sizeof(ADDR));
    SaveVar(destAddr, lp, sizeof(destAddr));

    status = SendReceive(lp, BASE_TIME);
   
    if (status == ICE_FAIL_MEM_WRITE){
        memcpy(retAddr,&inputStream[1],sizeof(ADDR));
        status = ICE_FOUND; 
        return status;
    }    
    
    if(status == ICE_EP_RUNNING) return status;
    
    status = ICE_NOT_FOUND;
    return(status);
}

/**************************************************************************
**
** Name : AbiCopy
**
** Function
**
**    Input  : addr1        the start address of first block.
**             addr2        the end address of first block.
**             addr3        the start address of second block.
**
**    Output : STATUS
**
** Notes:
**
**************************************************************************/
STATUS AbiCopy(ADDR addr1, ADDR addr2, ADDR destAddr)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_COPY,lp);
    SaveVar(addr1,lp,sizeof(ADDR)); 
    SaveVar(addr2,lp,sizeof(ADDR));
    SaveVar(destAddr, lp, sizeof(ADDR));

    status = SendReceive(lp, 3*BASE_TIME);
    if (status == ICE_FAIL_MEM_WRITE) 
        memcpy(&retAddr,&inputStream[1],sizeof(ADDR));
    return(status);
}

/****************************************************************************
**
**  Name: AbiSetMemN
**
**  Description:
**
**  Parameters:
**     input:  addr     the start address of data buffer to write.
**             pszBuffer    the data buffer to be written.
**             len      the length of data buffer, the value must be in range 1~256
**
**
**     output: STATUS
**
**  Return data --
**
****************************************************************************/
STATUS AbiSetMemN(ADDR addr, WORD* pchBuff, UINT uPatternLen)
{
STATUS status;
ADDR addr2;
UINT lp; 

    lp = 0;
    addr2.addrType = addr.addrType;
    addr2.addr = addr.addr + uPatternLen-1;

    SaveId(FW_FILL,lp);
    SaveVar(addr,lp,sizeof(ADDR));
    SaveVar(addr2,lp,sizeof(ADDR));    
    SaveVar(uPatternLen,lp,sizeof(UINT));    
    SaveBuffer((char *)pchBuff,lp,uPatternLen*sizeof(WORD));

    status = SendReceive(lp, BASE_TIME);

    if (status == ICE_FAIL_MEM_WRITE)
      memcpy(&retAddr,&inputStream[1],sizeof(ADDR));
    return(status);

}
                    
/****************************************************************************
**
**  Name: AbiGetMemN
**
**  Description:
**
**  Parameters:
**     input:    addr1      the start address of data buffer to read.
**               addr2      the end address of data buffer to read.
**
**
**     output:   STATUS
**               *pszBuffer the data buffer for storing data.
**
**  Return data --
**
****************************************************************************/
STATUS AbiGetMemN(ADDR addr1, ADDR addr2,WORD* pchBuff)
{   
STATUS status;
UINT lp; 
UINT len;
    
    if (addr1.addrType == MEM_UNDEFINED) 
        return(ICE_PARA_ERROR);
        
    lp = 0;

    SaveId(FW_GET_MEM_N,lp);
    SaveVar(addr1,lp,sizeof(ADDR)); 
    SaveVar(addr2,lp,sizeof(ADDR));

    status = SendReceive(lp, BASE_TIME);
    if (status == ICE_OK){
        len =*(UINT*) &inputStream[1];
        memcpy(pchBuff,&inputStream[3],len*sizeof(WORD));
    }
    return( status );
}                    

/**************************************************************************
**
** Name : AbiSearch
**
** Function
**
**    Input  :     addr1        The start address of searching
**                 addr2        The end address  to be searched
**                 searchInfo   the data struct that has stored searching condition
**                              typedef struct {
**                                  FLAG caseFlag;  0:sensitive; 1  not sensitive
**                                  char srchBufLen;
**                                  WORD srchBuf[32];
**                              } SEARCH_INFO;
**
**
**    Output :     STATUS
**                 retAddr      the matched address if found
** Notes:
**
**************************************************************************/
STATUS AbiSearch(ADDR addr1, ADDR addr2, SEARCH_INFO searchInfo, 
                 ADDR* retAddr)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_SEARCH,lp);
    SaveVar(addr1,lp,sizeof(ADDR)); 
    SaveVar(addr2,lp,sizeof(ADDR));
    SaveVar(searchInfo,lp,sizeof(SEARCH_INFO));

    status = SendReceive(lp, BASE_TIME);
    if (status == ICE_OK) {
        if (inputStream[1] ==  ICE_MEM_SEARCH_NOT_FOUND)
            status = ICE_NOT_FOUND;
        else {    
            memcpy(retAddr,&inputStream[2],sizeof(ADDR));
            status = ICE_FOUND;
        }
    }        
    return(status);
}   

/**************************************************************************
**
** Name : AbiTest
**
** Function
**
**    Input  :  addr1   start address of testing
**              addr2   end addresss of testing
**
**    Output :  STATUS
**              retAddr   fail address if has
** Notes:
**
**************************************************************************/
STATUS AbiTest(ADDR addr1, ADDR addr2)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_TEST,lp);
    SaveVar(addr1,lp,sizeof(ADDR)); 
    SaveVar(addr2,lp,sizeof(ADDR));

    status = SendReceive(lp, BASE_TIME);
    
    if (status == ICE_OK) {
        if (inputStream[1] == ICE_OK_MEM_WRITE)
            status = ICE_OK_MEM_WRITE;
        else {    
            memcpy((char *)(&retAddr),&inputStream[2],sizeof(ADDR));
            status = ICE_FAIL_MEM_WRITE;
        }
    }        
    
    return(status);
}                                           

/*****************************************************
**
** Name : AbiGetTrigger()
**
** Function
**
**    Input  : 
**    Output
**
** Notes:
**
*****************************************************/
STATUS AbiGetTrigger( TRIGGER_LOGIC* pTrigLogic)
{ 
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_GET_TRIGGER,uintLoop);

    status = SendReceive(uintLoop, BASE_TIME);
    if (status == ICE_OK) {
        memcpy(pTrigLogic,&inputStream[1],sizeof(TRIGGER_LOGIC));    
    }
    return status;
}

/****************************************************
**
** Name : AbiGetRegLen()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetRegLen(UINT *wRegLen)
{  
    STATUS status;
    UINT lp = 0;

    SaveId(FW_GET_REG_LEN,lp);
    status = SendReceive(lp, BASE_TIME);
    
    if (status == ICE_OK) {
        *wRegLen =*((UINT*) &inputStream[1]);
        gRegLen = *((UINT * )&inputStream[1]);
    }
    else
        *wRegLen = 0x7f;
        
    return(status);
}
                       
/*****************************************************
**
** Name : AbiGetAllReg()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiGetAllReg(WORD* cpuValue)
{
    STATUS status;
    UINT lp;
    
    SaveId(FW_GET_ALL_REG,lp);
    status = SendReceive(lp, BASE_TIME);
    
    if(status == ICE_OK) {
        memcpy(cpuValue,&inputStream[1],0x160);    
         
    } 
   
    return(status);
}

/*****************************************************
**
** Name : AbiGetOneReg()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiGetOneReg(WORD iRegId, WORD* cpuValue)
{
    STATUS status;
    UINT lp;
    
    lp = 0;
    SaveId(FW_GET_ONE_REG,lp);
    SaveVar(iRegId,lp,sizeof(WORD)); 
    status = SendReceive(lp, BASE_TIME);
    
    if(status == ICE_OK) {                        
        memcpy(cpuValue,&inputStream[1],sizeof(WORD));    
    } 
   
    return(status);
}
                                 
/****************************************************
**
** Name : AbiSetReg()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiSetReg(WORD iRegId, WORD uRegValue)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_SET_ONE_REG,lp); 
    SaveVar(iRegId, lp, sizeof(WORD));
    SaveVar(uRegValue,lp,sizeof(WORD));
    status = SendReceive(lp, BASE_TIME);
    
    return(status);
}
             
/****************************************************
**
** Name : AbiGetFwId()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetFwId(UCHAR *uchMajor,  UCHAR *uchMinor)
{
    STATUS status;
    UINT lp;
    

    lp = 0;
    SaveId(FW_GET_FW_ID, lp);
    status = SendReceive(lp, BASE_TIME);
    
    if(status == ICE_OK) {                        
        *uchMajor = (UCHAR) inputStream[1];
        *uchMinor = (UCHAR) inputStream[2];
    }
    return(status);
}

/****************************************************
**
** Name : AbiGetFreq()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetFreq(float *fFreq,BYTE *bScale)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_GET_FREQ, lp);
    status = SendReceive(lp, BASE_TIME);

    if (status  == ICE_OK) {
        memcpy(fFreq, &inputStream[1],sizeof(float));
        *bScale = inputStream[5];      
    }

    return(status);
}

/****************************************************
**
** Name : AbiGetTimerCount()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetTimerCount(float *fTimerCounter)
{
    STATUS status;
    UINT lp = 0;

    SaveId(FW_GET_TIMER_COUNT, lp);
    status = SendReceive(lp, BASE_TIME);

    if ( ICE_OK == status ) {
        memcpy(fTimerCounter,&inputStream[1],sizeof(float));
        
    }
    return status;
} 
STATUS AbiGetTimerBase(float *fTimerCount)
{                 
	STATUS status;
    UINT lp = 0;

    SaveId(FW_GET_TIMER_BASE, lp);
    status = SendReceive(lp, BASE_TIME);

    if ( ICE_OK == status ) {
        memcpy(fTimerCount,&inputStream[1],sizeof(float));
        
    }
    return status;
}
/*
STATUS AbiGetTimerCount(TIMER_COUNT *pTimerCount)
{
    STATUS status;
    UINT lp = 0;

    SaveId(FW_GET_TIMER_COUNT, lp);
    status = SendReceive(lp, BASE_TIME);

    if ( ICE_OK == status ) {
        pTimerCount->ulLowCount = * (ULONG * ) &inputStream[1];
        pTimerCount->uchHighCount =  (UCHAR ) inputStream[5];
    }
    return status;
} */


/*****************************************************
**
** Name : AbiSetBp()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSetBp(ADDR bpAddr)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SET_BP,uintLoop);
    SaveVar(bpAddr, uintLoop, sizeof(ADDR));
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    return status;
}

/*****************************************************
**
** Name : AbiClrBp()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiClrBp(ADDR bpAddr)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_CLR_BP,uintLoop);
    SaveVar(bpAddr, uintLoop, sizeof(ADDR));
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    return status;
}

/*****************************************************
**
** Name : AbiGetBp()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiGetBp(ADDR addr1, ADDR addr2, ADDR* bpAddr)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_GET_BP,uintLoop);
    SaveVar(addr1,uintLoop,sizeof(ADDR));
    SaveVar(addr2,uintLoop,sizeof(ADDR));
    

    status = SendReceive(uintLoop, BASE_TIME);
    if (status == ICE_FOUND)
        memcpy(bpAddr, &inputStream[1],sizeof(ADDR));
    return status;
}
          
/*****************************************************
**
** Name : AbiCoverageGo()
**
** Function
**
**    Input  : coverageGoInfor
**
**    Output : abi status
**
** Notes:
**
*****************************************************/
STATUS AbiCoverageGo(COVERAGEGOINFOR coverageGoInfor)
{                                              
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_COVERAGE_GO,uintLoop);
    SaveVar(coverageGoInfor, uintLoop, sizeof(COVERAGEGOINFOR));

    status = SendReceive(uintLoop, BASE_TIME);
    return status;
 
 }          
 
/*****************************************************
**
** Name : AbiCoverageGet()
**
** Function
**
**    Input  : 
**
**    Output : abi status & coverageGetInfor
**
** Notes:
**
*****************************************************/
STATUS AbiCoverageGet(COVERAGEGETINFOR* coverageGetInfor)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_COVERAGE_GET,uintLoop);

    status = SendReceive(uintLoop, BASE_TIME);
    if (status == ICE_OK) {
        coverageGetInfor->uchNumber = (unsigned char) inputStream[1];
        if((coverageGetInfor->uchNumber)>16) coverageGetInfor->uchNumber = 16;
        memcpy(&(coverageGetInfor->usAddr[0]), 
               &(inputStream[2]), 
               (coverageGetInfor->uchNumber)*4);
    }
    return status;
} 

/*****************************************************
**
** Name : AbiSpaBpSet()
**
** Function
**
**    Input  : spaBpSetInfor
**
**    Output : abi status 
**
** Notes:
**
*****************************************************/
STATUS AbiSpaBpSet(SPABPSETINFOR spaBpSetInfor)
{                                              
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SPA_BP_SET,uintLoop);
    SaveVar(spaBpSetInfor, uintLoop, sizeof(spaBpSetInfor));

    status = SendReceive(uintLoop, BASE_TIME);
    return status;
 
}

/*****************************************************
**
** Name : AbiStepOver()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiStepOne()
{
    STATUS status; 
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_STEP_ONE,uintLoop);
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    return status;
}

/*****************************************************
**
** Name : AbiStepOver()
**
** Function
**
**    Input  :
**
**    Output :
** Return:
**       0: ICE_OK
**       9: CONTINUE;
** Notes:
**
*****************************************************/
STATUS AbiStepOver()
{
    STATUS status; 
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_STEP_OVER,uintLoop);
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    return status;
}

/****************************************************
**
** Name : AbiGetCpuStatus()
**
** Function : to get the current CPU status, Trace status,
**            Timer status etc..
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetCpuStatus(UINT *uCpuStatus)
{
    STATUS status;
    UINT lp;
    lp = 0;
    SaveId(FW_GET_CPU_STATUS, lp);
    status = SendReceive(lp, BASE_TIME);
    
    *uCpuStatus = *((UINT*) &inputStream[1]);  
    return status;
}

/*****************************************************
**
** Name : AbiStepRange()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiStepRange(ADDR stAddr, ADDR endAddr)
{
    STATUS status; 
    UINT lp;
    
    SaveId(FW_STEP_RANGE,lp);
    SaveVar(stAddr, lp,sizeof(ADDR));
    SaveVar(endAddr,lp, sizeof(ADDR));

    status = SendReceive(lp, BASE_TIME);
    return status;
}                                                  

/*****************************************************
**
** Name : AbiStepOverRange()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiStepOverRange(ADDR stAddr, ADDR endAddr)
{
    STATUS status;      
    UINT uintLoop;

    SaveId(FW_STEP_OVER_RANGE,uintLoop);
    SaveVar(stAddr, uintLoop, sizeof(ADDR));
    SaveVar(endAddr,uintLoop, sizeof(ADDR));
    
    status = SendReceive(uintLoop, BASE_TIME);
    return status;
}                    
                       
/****************************************************
**
** Name : AbiGetTargetSupport()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetTargetSupport(UINT *wCpuNum, UINT* wCpuType)
{  
    STATUS status;
    UINT lp = 0;
    UINT uint;
    UCHAR *uchPtr;
    UCHAR *uchCpuNum = (UCHAR *) wCpuType;

    SaveId(FW_GET_TARGET_SUPPORT, lp);
    status = SendReceive(lp, BASE_TIME);
    
    if (status == ICE_OK) {
        *wCpuNum = inputStream[1];
        *wCpuNum = *wCpuNum + inputStream[2]*256; 
        uchPtr = &inputStream[3];
        for (uint = 0; uint < (*wCpuNum) * 2; uint++) {
           * uchCpuNum ++ = *uchPtr++;
        }
    }

    return(status);
}
                       
/****************************************************
**
** Name : AbiGetFWSupport()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetFWSupport(UINT *wCpuNum, UINT* wCpuType)
{  
    STATUS status;
    UINT lp = 0;
    UINT uint;
    UCHAR *uchPtr;
    UCHAR *uchCpuNum = (UCHAR *) wCpuType;

    SaveId(FW_GET_FW_SUPPORT, lp);
    status = SendReceive(lp, BASE_TIME);
    
    if (status == ICE_OK) {
        *wCpuNum = *((UINT*) &inputStream[1]);

        uchPtr = &inputStream[3];
        for (uint = 0; uint < (*wCpuNum) * 2; uint++) {
           * uchCpuNum ++ = *uchPtr++;
        }
    }

    return(status);
}
               
/*****************************************************
**
** Name : AbiSetEvent()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSetEvent(BUS_EVENT busEvData)
{ 
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SET_EVENT,uintLoop);
    SaveVar(busEvData, uintLoop, sizeof(BUS_EVENT));

    status = SendReceive(uintLoop, BASE_TIME);
    return status;
}

/*****************************************************
**
** Name : AbiSetEvent()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSetQualify(BUS_EVENT busEvData)
{ 
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SET_QUALIFY,uintLoop);
    SaveVar(busEvData, uintLoop, sizeof(BUS_EVENT));

    status = SendReceive(uintLoop, BASE_TIME);
    return status;
}                        

/*****************************************************
**
** Name : AbiClrEvent()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiClrEvent(int evId)
{ 
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_CLR_EVENT,uintLoop);
    switch(evId) {
        case 0:
            outputStream[1] = 0;
            break;
        case 1:
            outputStream[1] = 1;
            break;
        case 2:
            outputStream[1] = 2;
            break;
        case 3:
            outputStream[1] = 3;
            break;
       default:
            return 1;
    }
    uintLoop = 2;
    status = SendReceive(uintLoop, BASE_TIME);
    return status;
}

/*****************************************************
**
** Name : AbiClrQualify()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiClrQualify()
{ 
    STATUS status;
    UINT uintLoop;
    BYTE evId;
    
    uintLoop = 0;
    SaveId(FW_CLR_QUALIFY,uintLoop);
    evId = 0;
    switch(evId) {
        case 0:
            outputStream[1] = 0;
            break;
        case 1:
            outputStream[1] = 1;
            break;
        case 2:
            outputStream[1] = 2;
            break;
        case 3:
            outputStream[1] = 3;
            break;
       default:
            return 1;
    }
    uintLoop = 2;
    status = SendReceive(uintLoop, BASE_TIME);
    return status;
}

/*****************************************************
**
** Name : AbiGetEvent()
**
** Function
**
**    Input  : none
**
**    Output : byControl: bit0:Qualify, bit1:EV1, bit2:EV2;
**                        = 0:disable, = 1:enable
**             byEv3: 0 or 1; 0:LOW, 1:HIGH
**             pQualify: the struct pointer to store QUALIFY info.
**             pEv1: the struct pointer to store EV1 info.
**             pEv2: the struct pointer to store EV2 info.
**
** Notes: F/W pQualify, pEv1, pEv2's buffer are 0x80, not
**        sizeof(QUALIFY);
**
*****************************************************/
STATUS AbiGetEvent(FLAG *byControl, FLAG *byEv3, QUALIFY *pQualify,
                   BUS_EVENT *pEv1, BUS_EVENT *pEv2)
{ 
    STATUS status;
    UINT uintLoop;

    char *pchQualify, *pchEv1, *pchEv2;
    
    pchQualify = (char *) pQualify;
    pchEv1 = (char *) pEv1;
    pchEv2 = (char *) pEv2;
    
    uintLoop = 0;
    SaveId(FW_GET_EVENT,uintLoop);

    status = SendReceive(uintLoop, BASE_TIME);
    if (status == ICE_OK) {
        *byControl = inputStream[1];
        *byEv3 = inputStream[2];
        
        memcpy(pchQualify, &inputStream[3], sizeof(QUALIFY)); 
        memcpy(pchEv1, &inputStream[33], sizeof(QUALIFY));
        memcpy(pchEv2, &inputStream[63], sizeof(QUALIFY));
        
    }
    return status;
}

/*****************************************************
**
** Name : AbiSetTraceStatus()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSetTraceStatus(FLAG uTraceFlag)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SET_TRACE_ONOFF,uintLoop);
    SaveVar(uTraceFlag, uintLoop, sizeof(FLAG));

    status = SendReceive(uintLoop, BASE_TIME);
    return status;
}

/*****************************************************
**
** Name : AbiGetTraceBuffer()
**
** Function : to get the trace buffer content
**
**    Input  : readDirect = 0:down;
**             startFrame =
**             endFrame =
**             aQualify =
**
**    Output :  traceInfo : the storage of
**              frameNum:
**              readEnd = 0:over, 1:not end
**
** Notes:
**
*****************************************************/
STATUS AbiGetTraceBuffer(BYTE bankSelect, UINT startFrame, UINT nLen,
                         QUALIFY aQualify,
                         TRACE_INFO* traceInfo, UCHAR* frameNum, FLAG* readEnd )
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_GET_TRACE_BUFFER,uintLoop);

    SaveVar(bankSelect, uintLoop, sizeof(BYTE));
    SaveVar(startFrame, uintLoop, sizeof(UINT));
    SaveVar(nLen, uintLoop, sizeof(UINT));
    SaveVar(aQualify, uintLoop, sizeof(QUALIFY));

    status = SendReceive(uintLoop, BASE_TIME);
    if (status == ICE_OK) {
        *frameNum = (UCHAR) inputStream[1];
        *readEnd  = (FLAG) inputStream[2];
        memcpy(traceInfo, &inputStream[3], (*frameNum) * sizeof(TRACE_INFO));
    }
    return status;
}

/*****************************************************
**
** Name : AbiGetTraceLastFrame()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiGetTraceLastFrame(BYTE bankSelect,UINT* uLastFrame)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_GET_TRACE_LAST_FRAME,uintLoop);   
    SaveVar(bankSelect, uintLoop, sizeof(BYTE));

    status = SendReceive(uintLoop, BASE_TIME);
    if (status == ICE_OK) {
        memcpy(uLastFrame, &inputStream[1],sizeof(UINT));
    }
    return(status);
}

/*****************************************************
**
** Name : AbiGetTraceSource()
**
** Function : to get the trace buffer content
**
**    Input  :
**             startFrame =
**             count =count from start frame
**             addrRange = address range area defined by caller
**             rangeCount = how many range area defined by caller
**
**    Output :  traceInfo : the storage of source trace
**              retCount: how trace frame returned
**              pInputBuf:trace information returned(only include frameNo
**                        and address)
**
** Notes: ADDED BY JOHN 96.5 to support Chris to speed the list source function
**
*****************************************************/
STATUS AbiGetTraceSource(BYTE bankSelect,UINT startFrame, BYTE count, WORD addrRange[10],
                         BYTE rangeCount,
                         BYTE* retCount,DWORD* pInputBuf )
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_GET_TRACE_SOURCE,uintLoop);

    SaveVar(bankSelect, uintLoop, sizeof(BYTE));
    SaveVar(startFrame, uintLoop, sizeof(UINT));
    SaveVar(count, uintLoop, sizeof(BYTE));
    SaveBuffer(&(addrRange[0]),uintLoop,10*sizeof(WORD));
    SaveVar(rangeCount, uintLoop, sizeof(BYTE));
    

    status = SendReceive(uintLoop, BASE_TIME);
    if (status == ICE_OK) {
        *retCount = (UCHAR) inputStream[1];
        memcpy(pInputBuf, &inputStream[2], *retCount * sizeof(DWORD) );
    }
    return status;
}

/*****************************************************
**
** Name : AbiSelectTraceBank()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSelectTraceBank (BYTE bOption)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SELECT_TRACE_BANK,uintLoop);      
    SaveVar(bOption, uintLoop, sizeof(BYTE));

    status = SendReceive(uintLoop, BASE_TIME);
    
    return(status);
}
                   
/*****************************************************
**
** Name : AbiSelectCCOrTrace ()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSelectCCOrTrace (BYTE bOption)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SELECT_TRACE_CC,uintLoop);      
    SaveVar(bOption, uintLoop, sizeof(BYTE));

    status = SendReceive(uintLoop, BASE_TIME);
    
    return(status);
}

/*****************************************************
**
** Name : AbiSelectBreak()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSelectBreak(BYTE bOption)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SELECT_BREAK,uintLoop);      
    SaveVar(bOption, uintLoop, sizeof(BYTE));

    status = SendReceive(uintLoop, BASE_TIME);
    
    return(status);
}

/*****************************************************
**
** Name : AbiSelectBaud()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSelectBaud(BYTE bOption)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SELECT_BAUD,uintLoop);      
    SaveVar(bOption, uintLoop, sizeof(BYTE));

    status = SendReceive(uintLoop, BASE_TIME);
    
    return(status);
}

/*****************************************************
**
** Name : AbiSelectEv3()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSelectEv3(BYTE bOption)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SELECT_EV3,uintLoop);      
    SaveVar(bOption, uintLoop, sizeof(BYTE));

    status = SendReceive(uintLoop, BASE_TIME);
    
    return(status);
}

/*****************************************************
**
** Name : AbiGetEv3()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiGetEv3(BYTE* bOption)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_GET_EV3,uintLoop);      

    status = SendReceive(uintLoop, BASE_TIME);
    
    *bOption = inputStream[1];
    
    return(status);
}

STATUS AbiSetTriggerStatus(FLAG bOption)
{                  
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SET_TRIGGER_STATUS,uintLoop);  
    SaveVar(bOption, uintLoop, sizeof(BYTE));    

    status = SendReceive(uintLoop, BASE_TIME);
    
    return(status);

 }


                                 
//double command
/*****************************************************
**
** Name : AbiClrAllBp()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiClrAllBp()   
{
    STATUS status; 
    ADDR bpAddr;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_CLR_BP,uintLoop);
    bpAddr.addrType = 0;
    SaveVar(bpAddr, uintLoop, sizeof(ADDR));
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    return status;
}



/**************************************************************************
**
** Name : AbiGetErrorAddr
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
ADDR AbiGetErrorAddr()
{ 
    return(retAddr);
}

/****************************************************************************
**
**  Name: AbiFill
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**  Return data --
**
****************************************************************************/
STATUS AbiFill(ADDR addr1, ADDR addr2,WORD* pchBuff, UINT uPatternLen)
{
    STATUS status;
    UINT lp; 
    
    lp =0;
    
    SaveId(FW_FILL,lp);           
    SaveVar(addr1,lp,sizeof(ADDR)); 
    SaveVar(addr2,lp,sizeof(ADDR));
    SaveVar(uPatternLen,lp,sizeof(UINT));

    SaveBuffer((char*)pchBuff,lp,uPatternLen*sizeof(WORD));

    status = SendReceive(lp, BASE_TIME);
    
    if (status == ICE_FAIL_MEM_WRITE)
      memcpy(&retAddr,&inputStream[1],sizeof(ADDR));
    return(status);

}

//FOR TEST COMMUNICATION
/*****************************************************
**
** Name : AbiTestCom(char* pTestData)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiTestCom(char* pTestData,char* pRetData)   
{
    STATUS status; 
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_TEST_COMMUNICATION,uintLoop);
    SaveBuffer(pTestData, uintLoop, 256);
    
    status = SendReceive(uintLoop, BASE_TIME);
    if (ICE_OK == status) 
    	memcpy(pRetData,&inputStream[1],256);
    
    return status;
} 

/*****************************************************
**
** Name : AbiFwInit()
**
** Function  : to init fw settings,please call this 
**			   function after SW init
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiFwInit()
{ 
    STATUS status; 
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_FW_INIT,uintLoop);
    
    status = SendReceive(uintLoop, BASE_TIME);
    return status;

 }

//this routine get the current time in cstring
CString GetTime()
{ 
 char* tmpStr = new char[100];
 ASSERT(tmpStr != NULL);
 time_t tmpTime;
 time(&tmpTime);
 sprintf(tmpStr,"%s",ctime(&tmpTime));
 tmpStr[strlen(tmpStr)-1] = 0;
 CString strRet = tmpStr;
 delete tmpStr;
 return strRet;
 }              
//this function is called from the shell window to test the communication
//the name is foolish because Annie is most foolish!
void JohnCmd(int nArgc, char* pszArgv[])
{
 CBaseSerialPICAgree* pTheCom = GetXviewAppJohn()->m_pTheCom;
 COMTESTERR tmpErr;                      
 char tmpStr[100];
 
 while(!TestKey(VK_ESCAPE)) {
	 if(!pTheCom->CommunicationTest(&tmpErr)) {
	 	ShowLine(GetTime().GetBuffer(100));
	 	ShowLine("FW return error?");
	 }
	 
	 if(!tmpErr.bResult) {
	 	ShowLine(GetTime().GetBuffer(100));
	 	sprintf(tmpStr,"Error in Byte %02X",tmpErr.nLoc);
	 	ShowLine(tmpStr);
	 	sprintf(tmpStr,"Send %02X  Receive %02X",tmpErr.bSend,tmpErr.bRet);
	 	ShowLine(tmpStr);
	 	sprintf(tmpStr,"Error Code %04X   Detail Error Code %04X",
	 			tmpErr.nError,tmpErr.nDetailError);	
	 	ShowLine(tmpStr);		
	 } else ShowLine("Test Ok!");
 } 	 
 	 	
 	
 }
////////////////////////                                 
