
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/ABITYPE.H__   1.13   13 Dec 1996 11:17:46   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/ABITYPE.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:17:46   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:58:48   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:02   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:00   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:00   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:16   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:10   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:26   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.5   09 Oct 1996 13:46:02   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:33:28   ZJRD
** PIC/SLD Version 0.70
** 
**    Rev 1.3   06 Sep 1996 13:47:24   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:28:28   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:06:44   ZJRD
** PIC/SLD Version 0.20
** 
**    Rev 1.0   13 Aug 1996 09:18:40   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : abitype.h
**
** Description: 
**
**
**
**
** Programmer: Frank Chang
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _ABITYPE_
    #define _ABITYPE_

    #ifndef _ABIBASE_
        #include "abibase.h"
    #endif

    typedef enum {
        NORMAL_RUN = 0,FREE_RUN
    } RUN_MODE;

    typedef enum {
        MEM_UNDEFINED   =0,   //for error or other using
        MEM_CODE,             //p:
        MEM_EXT_DATA,         //not support in pic,reserved
        MEM_INT_DATA,         //not support in pic,reserved
        MEM_SFR,              // not support in pic,reserved
        MEM_BIT               // not support in pic,reserved
    }ADDR_TYPE;
                   
    typedef enum {
        MAP_I =0,             //map p:0 p:ffff i
        MAP_IR,               //map p:0 p:ffff ir
        MAP_E,                //map x:0 p:ffff e
        MAP_ER,
        MAP_C,
        MAP_CR,
        MAP_G
    } MAP_ATTR;
    
    typedef enum {
        PORT_RA =0,
        PORT_RB,
        PORT_RC,
        PORT_RD,
        PORT_RE,
        PORT_RF,
   } PARA_PORT;

   typedef enum {
        CASE_SENSITIVE  = 0,
        CASE_INSENSITIVE
    }CASE_FLAG;
 
    /* define the F/W command ID for Xview  */
    typedef enum {  
        FW_RESET                        = 0x0,
        FW_GO                               = 0x1,
        FW_ABORT                        = 0x2,
        FW_DIAGNOSTIC                   = 0x3,
        FW_SET_CPU_ID                   = 0x4,
        FW_GET_CONTROL                  = 0x5,
        FW_SET_CONTROL                  = 0x6,
        FW_SET_TIMER_ONOFF          = 0x7,
        FW_SET_PORT                 =0X8 ,//RESERVED , NOT FOR PIC
        FW_OUTPUT                       = 0x9,
        FW_INPUT                        = 0xa,
        FW_SET_VERIFY_ONOFF         = 0xb,
        FW_SET_TRIG_ONOFF               = 0xc, //RESERVED , NOT FOR                                              PIC
        FW_SET_TRIG_LEVEL               = 0xd, //RESERVED , NOT FOR                                               PIC
        FW_SET_TRIG_LOGIC               = 0xe,
        FW_GET_CPU_ID                   = 0xf,
        FW_CHECKSUM                     = 0x10,
        FW_COMPARE                      = 0x11,
        FW_COPY                         = 0x12,
        FW_DOWNLOAD                     = 0x13, //RESERVED , NOT FOR                                    PIC
        FW_FILL                             = 0x14,
        FW_GET_MEM_N                    = 0x15,
        FW_SEARCH                       = 0x16,
        FW_TEST                             = 0x17,
        FW_SET_MEM_N                    = 0x18, //RESERVED , NOT FOR                                        PIC
        FW_UPLOAD                       = 0x19, //RESERVED , NOT FOR                                    PIC
        FW_GET_TRIGGER                  = 0x1a,
        FW_GET_REG_LEN                  = 0x1f,
        FW_GET_ALL_REG                  = 0x20,
        FW_GET_ONE_REG                  = 0x21,
        FW_SET_ONE_REG                  = 0x22,
        FW_GET_FW_ID                    = 0x23,
        FW_GET_FREQ                     = 0x24,
        FW_INIT_EPROM                   = 0x25, //RESERVED , NOT FOR                                    PIC
        FW_BURN_EPROM                   = 0x26, //RESERVED , NOT FOR                                    PIC
        FW_GET_TIMER_COUNT          = 0x27,
        FW_GET_MAP                      = 0x31, //RESERVED , NOT FOR                                    PIC
        FW_SET_MAP                      = 0x32, //RESERVED , NOT FOR                                    PIC
        FW_SET_BP                       = 0x33,
        FW_CLR_BP                       = 0x34,
        FW_GET_BP                       = 0x35,
        
        FW_COVERAGE_GO                  = 0x38,
        FW_COVERAGE_GET                 = 0x39,
        FW_SPA_BP_SET                   = 0x3b,
        
        FW_STEP_ONE                     = 0x40,
        FW_STEP_OVER                    = 0x41,
        FW_CYCLE                        = 0x42, //RESERVED , NOT FOR                                    PIC
        FW_GET_CPU_STATUS           = 0x43,
        FW_STEP_RANGE                   = 0x44,
        FW_STEP_OVER_RANGE          = 0x45,

        FW_GET_TARGET_SUPPORT       = 0x47,
        FW_GET_FW_SUPPORT           = 0x48,

        FW_SET_EVENT                    = 0x50,
        FW_CLR_EVENT                    = 0x51,
        FW_GET_EVENT                    = 0x52,

        FW_SET_TRACE_ONOFF          = 0x58,
        FW_GET_TRACE_BUFFER         = 0x59,
        FW_GET_TRACE_LAST_FRAME     = 0x5a,
        FW_GET_TRACE_SOURCE         = 0x5b,

        FW_FLASH_SWITCH                 = 0x60, //RESERVED , NOT FOR                                    PIC
        FW_FLASH_ERASE                  = 0x61, //RESERVED , NOT FOR                                    PIC
        FW_FLASH_PROGRAM            = 0x62,//RESERVED , NOT FOR                                     PIC
    //NEW COMMAND ID
        FW_SELECT_TRACE_BANK    =0X70,
        FW_SELECT_CALCULATE_TIME    =0X71,
        FW_SELECT_TRACE_CC      = 0X72,
        FW_SELECT_BREAK     =0X73,
        FW_SELECT_BAUD          =0X74,
        FW_SET_QUALIFY          =0X75,//These two command ids are not realy new ids,
        FW_CLR_QUALIFY          =0X76, //we only use it to separate qualify command from
                                //event command.But the parameters have no                          change.
        FW_SELECT_EV3       =0x77,
        FW_SET_TRIGGER_STATUS             =0x78,
        FW_GET_EV3			=0X79,
        //96.10.15
        FW_GET_TIMER_BASE = 0x83,
        //96.9.19
        FW_FW_INIT  = 0XFE,
        
        FW_TEST_COMMUNICATION = 0XFF//ONLY USED FOR COM TEST
    } FW_COMMAND_ID;

//for LEVEL command
    typedef struct {
        FLAG traceFlag;        /* 0 trace unchanged    */
                               /* 1 trace ON           */
                               /* 2 trace OFF          */
        FLAG timerFlag;        /* 0 timer unchanged    */
                               /* 1 timer ON           */
                               /* 2 timer OFF          */
        DWORD dwCond;          /* condition list       */
                            // EV1  AAAAAAAAH
                            // EV2  CCCCCCCCH
                            // EV3  F0F0F0F0H
                            // EV4  FF00FF00H
                            // EV5  FFFF0000H
                            // EV1 OR  EV2 = AAAAAAAAH OR  CCCCCCCCH = EEEEEEEEH
                            // EV2 AND EV3 = CCCCCCCCH AND F0F0F0F0H = C0C0C0C0H

    }  TRIGGER_LEVEL;
    
    //for CYCLE command, unreviewed
    typedef struct {
        WORD addr;
        UCHAR data;
        UCHAR status; //SPARE: 7~3
                      //XXXXX210
                      //0:S, 1:F, 2:R, 3:W, 4:AK
        UCHAR port;
    } CYCLE_INFO;

    
    //for MAP command
    typedef struct {
        ADDR stAddr;
        ADDR endAddr;
        char mapAttr;
    } MAP_INFO;         
    
    //for SEARCH command
    typedef struct {
        FLAG caseFlag;  //0:sensitive; 1 non_sensitive
        char srchBufLen;
        WORD srchBuf[32];
    } SEARCH_INFO;

    
    //for LIST command 
    typedef struct tracerec{
        WORD frameNo;
        WORD addr;  //bit 14 is the FLAG of FNOP  1:NOT executed;0:executed
        BYTE portB;
        BYTE exterbPort;
        }TRACE_INFO;

    //for Timer command
    typedef struct {
        ULONG ulLowCount;
        UCHAR uchHighCount;
    } TIMER_COUNT;
    
    //Reserved, for ICE_FAIL_MEM_WRITE message
/*    typedef struct{
        ADDR addr;
        DATA data;
    } RET_INFO;
*/                               



    //for EVENT, QUALIFY commands
    typedef struct {
        FLAG    bType;//0:qualify_cmd, 1:ev1, 2:ev2;
        FLAG    bAddrType;//0: not used
                          //1: bit wildcard;   023(01XX):
                          //   value = 0230 or 023f or 023x
                          //   mask  = 0FFC
                          //   each bit, 1:actual 0:wildcard
                          //2: range  10h-20h;
                          //3: exclusive range; ~10h-20h
                          //4: addr group;  <10h, 20h, 30h...>
        FLAG    bDataType;//0: not uuse
                          //1: bit wildcard;   02XX, 02x3, 02
                          //2: range
        FLAG    bIsEv1Counter;//0:not set,1 set
        WORD    wDataStart;
        WORD    wDataEnd;
        BYTE    bEv1Counter;
        BYTE    bAddressCounter;
        WORD    AddrGrp[10];             
    
    }BUS_EVENT, QUALIFY, *PBUSEVENT, *PQUALIFY;
    
    typedef struct {
                UCHAR bTriggerLogic; //set the trigger logic
                    //0x1   EV1
                    //0x2   EV2
                    //0x3   EV3
                    //0x4   EV1 or EV2
                    //0x5   EV1 or EV3
                    //0x6   EV2 or EV3
                    //0x7   EV1 or EV2 or EV3
                    //0x8   EV1 then EV2
                    //0x9   EV1 then EV3
                    //0xa  EV2 then EV1
                    //0xb  EV2 then EV3
                    //0xc  EV3 then EV1
                    //0xd  EV3 then EV2
                BYTE bTriggerCondition;
                    //0x0   trigger off
                    //0x1   Forward
                    //0x2   Center
                    //0x3   Backward
                } TRIGGER_LOGIC ;

//JOHN 96.8 ONLY USED TO TEST COMMUNICATION
typedef struct {
	BOOL bResult;// TRUE -- OK; FALSE WRONG
	int  nLoc; //error location    
	BYTE bSend;//byte send to fw
	BYTE bRet; //error byte return from firmware
	int nError;      //
	int nDetailError; //from CBaseCom
} COMTESTERR;	

#endif
