
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/AE.CPP   1.13   13 Dec 1996 11:17:56   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/AE.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:17:56   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:58:48   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:14   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:02   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:45:32   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:47:44   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:40:44   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:20   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:44:54   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:30:30   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:44:18   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:25:40   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:04:22   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:17:38   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// ac.cpp
//
// Roger Zhang
//                                                                           
// 5/2/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "ae.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void AETool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_strProg = " << m_strProg << "\n";
    dc << "m_strPath = " << m_strPath << "\n"; 
    
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void AETool::SetDefault(void)
{
    
    m_strProg = "";
    m_strPath = "c:\\dos\\edit.com";
    
}

BOOL AETool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strProg.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strProg.ReleaseBuffer(wLen);
     if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    
    return TRUE;
}                 

BOOL AETool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
             
    WORD wLen = m_strProg.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strProg.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strProg.ReleaseBuffer(wLen);
     
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen); 
    
    
    return TRUE;
}   
                            

CString AETool::GetOption(void) const
{
    CString str = " ";
    
    str += m_strPath;
    str += " "; 
    str += m_strProg;
        
    return str;     
}

