
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/BWSMDL.H__   1.13   13 Dec 1996 11:18:02   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/BWSMDL.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:02   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:02   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:20   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:14   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:22   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:38   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:34   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:54   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:28   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:32:06   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:45:56   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:27:02   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:05:30   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:08   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SRCMDL.H
//
//  Description:The header file for the class: 
//                  SourceModule
//                  BwsModuleInfo
//
//  Author:     Hu Wei
//
//  Date:       05/1/96
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _BWSMDL_
#define _BWSMDL_

/////////////////////////////////////////////////////////////////////////////
// BwsModuleInfo
/////////////////////////////////////////////////////////////////////////////
class BwsModuleInfo
{
public:       
    enum { MAX_MODULE = 5 }; 
    
    SourceModule m_Module[MAX_MODULE];
    int          m_nModuleLoaded[MAX_MODULE];
    int          m_nModuleIdx;       
    unsigned      * m_pModuleValue;
    unsigned long * m_pModule;
    unsigned short m_uModules;
    
    BwsModuleInfo(void);
    ~BwsModuleInfo();         
    
    BOOL Init(void);
    BOOL IsModuleOn(void) { return m_nModuleIdx != -1; }
    unsigned long CurModule(void) const;
    int LoadModuleIdx(unsigned long dwModuleIdx);
    int LoadPCModule(void);
    int Reload(void);
    
private:    
    void Clean(void);
    
    CString MakeModulePath(unsigned long dwModuleIdx) const;
    BOOL CleanOldModule(void);
};

extern BwsModuleInfo bwsMdlInfo;
/*
int SrcReadLine(void);
int SrcOpenFile(DWORD dwModule);
*/
#endif
//////////////////////////////(EOF)//////////////////////////////////////////

