
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/BWSWIN.H__   1.13   13 Dec 1996 11:18:04   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/BWSWIN.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:04   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:04   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:22   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:18   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:22   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:36   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:34   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:54   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:28   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:32:06   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:45:54   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:27:00   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:05:28   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:08   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  BWSWIN.H
//
//  Description:The header file for the class: CBrowseWindow
//
//  Author:     Hu Wei
//
//  Date:       05/1/95
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _BWSWIN_
#define _BWSWIN_

#define ID_VSCROLL 100
#define ID_HSCROLL 101  
/////////////////////////////////////////////////////////////////////////////
#ifndef _SRCWIN_
#define _SRCWIN_

class SyntaxColor {
public:
    SyntaxColor(void)  
    {
        EnableColor();
    }
    void EnableColor(void) {
        m_isColorOn = TRUE;
    
        m_nBackground = COLOR_WHITE;
        m_nForeground = COLOR_BLACK;
        m_nKeyword = COLOR_LTBLUE;
        m_nComment = COLOR_GREEN;
        m_nSource  = COLOR_BLACK;
        m_nMix     = COLOR_DKGRAY;
        m_nCodeLine= COLOR_BLACK;
        m_nNonCode = COLOR_DKGRAY;
        m_nForePCLine = COLOR_BLACK;
        m_nBackPCLine = COLOR_YELLOW;
        m_nForeBPLine = COLOR_BLACK;
        m_nBackBPLine = COLOR_RED;
        m_nSrcKey = COLOR_DKGRAY;
    }                  
    void DisableColor(void) {
        m_isColorOn = FALSE;

        m_nBackground = COLOR_WHITE;
        m_nForeground = COLOR_BLACK;
        m_nKeyword = COLOR_BLACK;
        m_nComment = COLOR_BLACK;
        m_nSource  = COLOR_BLACK;
        m_nMix     = COLOR_BLACK;
        m_nCodeLine= COLOR_BLACK;
        m_nNonCode = COLOR_BLACK;
        m_nForePCLine = COLOR_BLACK;
        m_nBackPCLine = COLOR_YELLOW;
        m_nForeBPLine = COLOR_BLACK;
        m_nBackBPLine = COLOR_RED;
        m_nSrcKey = COLOR_DKGRAY;
    }                 
    
    BOOL m_isColorOn;
    
    int m_nBackground;
    int m_nForeground;
    
    int m_nKeyword;
    int m_nSrcKey;
    int m_nComment;
    int m_nSource;
    int m_nMix;                 
    
    int m_nCodeLine;
    int m_nNonCode;   
    
    int m_nForePCLine;
    int m_nBackPCLine;
    
    int m_nForeBPLine;
    int m_nBackBPLine;
};     
#endif

#undef  BWS_TOOL_WND  
/////////////////////////////////////////////////////////////////////////////
// CBrowseWindow frame                                                       
/////////////////////////////////////////////////////////////////////////////

class CBrowseWindow : public CMDIChildWnd
{
    DECLARE_DYNCREATE(CBrowseWindow)
public:
    CBrowseWindow(BOOL isPCOn=FALSE);            
    BOOL Create(LPCSTR szTitle, LONG style = 0,
        const RECT& rect = rectDefault, CMDIFrameWnd * pParent = NULL );

// Attributes
protected:                             
    enum { MARKER_PC, MARKER_BP, MARKER_PCBP };
    enum { MAX_ASM_RANGE = 16384 /* 0x4000 */ };
    
    int     m_nFont;        // font number
    CSize   m_szFont;       // font size
    CSize   m_szView;       // rows and cols of viewport
    CRect   m_rectClip;     // Clip rectangle of full view                
    CRect   m_rectScroll;   // Clip rectangle for horz scroll
    CPoint  m_ptOffset;     // display offset     
    CPoint  m_ptCaret;      // caret position
    CPoint  m_ptIndex;      // index position
    int     m_nLeft;        // width for line,addr,BP space on left edge
    CScrollBar *m_pVScrollBar;
    CScrollBar *m_pHScrollBar;

public:    
#ifdef  BWS_TOOL_WND  
    CToolWnd   *m_pToolWnd;  
#endif
    
    void OpenSwitch(); 
    CSourceSearch   * m_pdlgSrch;    
    
    BOOL    m_isSel;
    CString m_strSel;
    int		m_nSelLine;
    int		m_nSelCol;
    
public:
    static CMenu NEAR m_menu;
    int     m_nDispMode;    // source,mixed,asm mode
    int     m_nbCanDo;
    
private:
    void DrawScrollRect(CDC *pDC);
    
// Operations
public:
    void SetStepOpt(void);
    void UpdateDisp(void);

	void CalcLeftEdge(void);
    int Row2Y(int nRow) const;
    int Col2X(int nCol) const;
    int Y2Row(int ny) const;
    int X2Col(int nx) const;              
    CRect Row2Rect(int nRow) const;
    
    BOOL IsXIn(int nx) const;
    BOOL IsYIn(int ny) const;
    
    int Line2Row(int nLine) const;
    int Row2Line(int nRow) const;
    
    void Caret2Index(void);
    void Index2Caret(void);
    
    void CalcFontSize(void);
    void CalcViewSize(int cx, int cy);
    void CalcScrollSize(void);
    
    void ShowSourceLine(CDC * pDC, int nRow, int nLine);
    void ShowDsmLine(CDC * pDC, int nRow, int nLine);
    void ShowMixedLine(CDC * pDC, int nRow, int nSrc, int nAsm);
    
    void ClearMarker(CDC * pDC, int nRow);
    void SetMarker(CDC * pDC, int nRow, int nType);
    
    BOOL UpdateSource(int nLine);
    BOOL UpdateAsm(long lAddr);
    BOOL UpdateMixed(int nLine);
    BOOL UpdateMixed(long lAddr);
    void UpdateMixedMode(int nOfs);
    
    void NewSource(void);
    BOOL LoadModule(unsigned long dwModule, BOOL isHist = TRUE);
    
    void UpdateRow(int nRow);

    void SelectText(BOOL isSel);

    void ShowPCMarker(void);
    void ShowPCAsmMarker(void);
    void ShowPCMixMarker(void);
    void ShowPCLineMarker(void);

    void SetTitle(void);
    void SetCaret(void);
    long GetCaretAddr(void);
    
    // these functions will change Offset & Index
    void OnUp(void);
    void OnDown(void);
    void OnLeft(void);
    void OnRight(void);
    void OnPgUp(void);
    void OnPgDn(void);
    void OnPgLeft(void);
    void OnPgRight(void);
    void OnHome(void);
    int  OnEnd(void);
    void OnUpMost(void);
    void OnDownMost(void);
    void HorzScroll(int nx);
    void VertScroll(int ny);

    void ScrollTo(int nLine, int nCol, int nLen, BOOL isLeft);
    BOOL Search(void);         
//    void SetBreakpoint(int nRow);
                                                            
	void OnLocalMenu(CPoint point);
	BOOL IsFunction();
	BOOL IsVariable();                                                            
// Implementation                 
public:
    virtual ~CBrowseWindow();

protected:
    // Generated message map functions
    virtual BOOL PreTranslateMessage(MSG *pMsg);
    //{{AFX_MSG(CBrowseWindow)
    afx_msg void OnSrchComboKillFocus();
    afx_msg LONG OnXMSrcShowPC(UINT wParam, LONG lParam);
    afx_msg LONG OnXMRepaint(UINT wParam, LONG lParam);
    afx_msg void OnChildActivate();
    afx_msg void OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd);
    afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnKillFocus(CWnd* pNewWnd);
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnPaint();
    afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnSetFocus(CWnd* pOldWnd);
    afx_msg void OnEditBrowsefromaddress();
    afx_msg void OnEditBrowsefromline();
    afx_msg void OnEditBrowsefrompc();
    afx_msg void OnEditSearch();
    afx_msg void OnEditSearchnext();
    afx_msg void OnFilePrevmodule();
    afx_msg void OnFileNextmodule();
    afx_msg void OnViewSourceonly();
    afx_msg void OnViewMixed();
    afx_msg void OnUpdateViewMixed(CCmdUI* pCmdUI);
    afx_msg void OnUpdateViewSourceonly(CCmdUI* pCmdUI);
    afx_msg void OnViewSymbolicdisassembly();
    afx_msg void OnUpdateViewSymbolicdisassembly(CCmdUI* pCmdUI);
    afx_msg void OnViewLinenumbering();
    afx_msg void OnUpdateViewLinenumbering(CCmdUI* pCmdUI);
    afx_msg void OnViewSyntaxcoloring();
    afx_msg void OnUpdateViewSyntaxcoloring(CCmdUI* pCmdUI);
    afx_msg void OnUpdateEditSearch(CCmdUI* pCmdUI);
    afx_msg void OnUpdateEditBrowsefromline(CCmdUI* pCmdUI);
    afx_msg void OnUpdateEditSearchnext(CCmdUI* pCmdUI);
    afx_msg void OnClose();
    afx_msg void OnUpdateFilePrevmodule(CCmdUI* pCmdUI);
    afx_msg void OnUpdateFileNextmodule(CCmdUI* pCmdUI);
    afx_msg void OnFileBrowsemodule();
    afx_msg void OnUpdateFileBrowsemodule(CCmdUI* pCmdUI);
    afx_msg void OnViewSma();
    afx_msg void OnViewAsm();
    afx_msg void OnShiftreturn();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
    afx_msg void OnUpdateSearchCombo(CCmdUI* pCmdUI);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnDestroy();
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	//}}AFX_MSG
    DECLARE_MESSAGE_MAP()

//    afx_msg void OnFileLoadinfo();
/*
    afx_msg void OnOptionsSourceextensionnames();
    afx_msg void OnOptionsSourceoptions();
    afx_msg void OnOptionsSourcepath();
    afx_msg void OnRunGotocursor();
    afx_msg void OnRunGofromcursor();
    afx_msg void OnRunJumptocursor();
*/  
/*
    afx_msg void OnSetBPFunc();
    afx_msg void OnClrBPFunc();
    afx_msg void OnSetBPVar();
    afx_msg void OnClrBPVar();
    afx_msg void OnShowLoadAddr();
    afx_msg void OnWatchVariable();
    afx_msg void OnInspectFunc();
*/
/*
    afx_msg void OnFileLoad();
    afx_msg void OnRunBreakpoint();
    afx_msg void OnRunJump();
    afx_msg void OnRunReset();
*/
}; 
extern BOOL g_bBrowseActive;
#endif
/////////////////////////(EOF)///////////////////////////////////////////////
