
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/CALCEXP.H__   1.13   13 Dec 1996 11:18:06   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/CALCEXP.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:06   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:06   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:24   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:18   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:08   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:22   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:20   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:40   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:14   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:31:36   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:45:20   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:26:26   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:05:02   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:17:56   ZJRD
** Initial revision.
** 
****************************************************************************/

// calcexp.h : header file
//

#ifdef _CHEN_

#ifndef _CALCEXP_H_
#define _CALCEXP_H_

#include "syntest.h"

/////////////////////////////////////////////////////////////////////////////
// CExpression

class CExpression : public CSyntaxTest
{
// Construction & Destruction
public:
    CExpression();
    ~CExpression();
    
// Attributes
public:
    CString m_strInput;
    CString m_strOutput;
    
private:
    enum { maxToken = 0x0FF };
    char m_pszToken[maxToken+1];
    char* m_pszProg;

    enum { undefine = 0, delimiter = 1, variable = 2, number = 3 };
    char m_chTokenType;
    
    enum { noError = 0, syntaxError = 1, dividedByZero = 2 };
    int m_nErrorID;

// Overrides

// Implementation
public:
    void ExpAction(int nArgc, char* pszArgv[]);
    
private:
    void CalcExp(const CString strInput, CString& strOutput);
    void SkipWhiteSpace(CString& strInput);
    void GetToken(void);
    BOOL IsWhite(const char ch);
    BOOL IsDelimiter(const char ch, char* psz);

    void GetExp(double& dResult);
    void Level1(double& dResult);
    void Level2(double& dResult);
    void Level3(double& dResult);
    void Level4(double& dResult);
    void Level5(double& dResult);
    void Level6(double& dResult);
    
    void Primitive(double& dResult);
    void Arith(char op, double& dResult, double& dHold);
    void Unary(char op, double& dResult);
    
    void DisplayErrorMessage(void);
};

#endif  // _CALCEXP_H_
#endif  // _CHEN_
