
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/CLISRV.H__   1.13   13 Dec 1996 11:18:06   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/CLISRV.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:06   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:06   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:24   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:20   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:45:26   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:47:38   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:40:38   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:14   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:44:48   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:30:16   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:44:02   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:25:24   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:04:08   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:17:32   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  clisrv.h
**
**  Description:
**     Prototypes for registering CLI commands
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/PICSLDV/SRC/LOG/CLISRV.H__   1.13   13 Dec 1996 11:18:06   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _CLISRV_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "basewind.h"
#include "cliconst.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/


/*****************************************************
**
** Server data structures for communication with CLI 
**
******************************************************/

/* NOTE:  OBSOLETED BY CLI_NEW_REGISTRATION; KEPT FOR COMPATIBLITY ONLY */
/*
** Struct to be sent as global handle in message to CLI Server
** in order to register server commands.
*/

typedef struct {
	U16	target;			/* to whome addressed? */
	U16	variantCode;		/* CLI_SERVER_REGISTRATION */
	HANDLE	stringResourceHandle;	/* dll handle          */
	U16	serverNameIndex;	/* a string index      */
	U16	dllNameIndex;		/* a string index      */
	U16	numCommands;		/* number of command/syntax pairs */
	U16	commandStartIndex;	/* a string index      */
} CSERVER_REGISTRATION;


/*
**  Struct to be allocated in global handle to be sent to CLI Server with
**  string results ==> to be displayed in transcript.
*/

typedef struct {
	U16	target;			/* to whome addressed? */
	U16	variantCode;		/* CLI_SERVER_RESULTS  */
	U16	resultTextLength;	/* size of results string buffer */
	CHAR	messageText[1];	/* text buffer -- variable sized */
} CSERVER_RESULTS;


/*
**  Struct for sending global variable values to CLI Server.
**  Send message to CLI Server; hWnd is CLI Server handle, wMsg is
**  CLI_SYSTEM_VARIABLE (defined in cliconst.h), wParam is 1 if CLI Server
**  is to deallocate memory, lParam is pointer to the following structure.
*/

typedef struct {
	U16	integerValueFlag;	/* 0 if string value, !0 if integer */
	S32	integerValue;		/* if flag !0, integer value of var */
	LPSTR	variableName;		/* name of system variable */
	LPSTR	stringValue;		/* string value if flag is 0 */
} CSERVER_VARIABLE_VALUE;


/*
** Replacement for CSERVER_REGISTRATION.
** Register with the CLI Server by sending this structure as a message:
** hWnd is the CLI Server handle, wMsg is CLI_NEW_SVR_REGISTRATION
** (defined in cliconst.h), wParam is 1 if CLI Server to deallocate
** memory, and lParam pointer to the structure below.
*/

typedef struct {
	HANDLE	stringResourceHandle;	/* dll handle          */
	U16	serverNameIndex;	/* a string index      */
	U16	dllNameIndex;		/* a string index      */
	U16	numberOfCommandsIndex;	/* a string index      */
	U16	commandStartIndex;	/* a string index      */
} CSERVER_NEW_REGISTRATION;


                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/


/**************************************************************************
**
** initCServer
**
** Description: Each DDL needs to call an init routine for each
**              server found in its DLL.
**
**	Parameters:
**    input:
**       cliHandle:  registration target for servers.
**       dllHandle:  handle to use in messages to tag this DLL.
** 
**    output:
**       always returns GOOD
**
***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif
RETCODE EXPORT InitCServer(HWND cliHandle, HANDLE dllHandle);
#ifdef __cplusplus
}
#endif

#define _CLISRV_
#endif
/******************************** E O F ***********************************/
