
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/CPUCFG.CPP   1.13   13 Dec 1996 11:18:10   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/CPUCFG.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:10   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:08   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:28   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:22   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:45:28   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:47:38   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:40:40   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:14   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:44:50   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:30:18   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:44:04   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:25:26   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:04:12   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:17:32   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  CPUCFG.CPP
//
//  Description:The implement file for the class: CRegcfgDialog
//
//  Author:     Roger Zhang
//
//  Date:       04/25/95
//
//  Modification:
//
//      1. 04/25/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "uicom.h"
#include "cpucom.h"
#include "cpucfg.h"
#include "hosterrs.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRegcfgDialog dialog

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CRegcfgDialog::CRegcfgDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CRegcfgDialog::IDD, pParent)
{
    ASSERT(nCurRegs <= nMaxReg);

    for(int i = 0; i < nMaxReg; i ++)   m_Reg[i] = FALSE;
    for(i = 0; i < nCurRegs; i ++)  m_Reg[RegSelect[i]] = TRUE; 
    //{{AFX_DATA_INIT(CRegcfgDialog)

    //}}AFX_DATA_INIT
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegcfgDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CRegcfgDialog)              
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CRegcfgDialog, CDialog)
    //{{AFX_MSG_MAP(CRegcfgDialog)
    ON_BN_CLICKED(IDC_REGCONFIG_UNSELECT, OnUnselectAll)
    ON_BN_CLICKED(IDC_REGCONFIG_SELECTALL, OnSelectAll)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CRegcfgDialog message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegcfgDialog::OnUnselectAll()
{
    // TODO: Add your control notification handler code here
    for(int i = 1; i < nMaxReg; i ++)                             
        m_btnReg[i].SetCheck(0);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegcfgDialog::OnSelectAll()
{
    // TODO: Add your control notification handler code here
    for(int i = 0; i < nMaxReg; i ++)   
        m_btnReg[i].SetCheck(1);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegcfgDialog::OnOK()
{
    // TODO: Add extra validation here
    for(int i = 0; i < nMaxReg; i ++) {  
        if(m_btnReg[i].GetCheck())  break;
    }
    if(i == nMaxReg)    ErrDisplayError(ER_PRE_SEL_REG);
    else {   
        for(i = 0; i < nMaxReg; i ++) {
            if(m_btnReg[i].GetCheck())  m_Reg[i] = TRUE;
            else m_Reg[i] = FALSE;
        }
        CDialog::OnOK();
    } 
}   

#define _COLWD   80
#define _ROWHT   18

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CRegcfgDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    
    CRect rect;
    GetWindowRect(rect);
    int nRows = (nMaxReg + 5)/6; 
    int nOfs = _ROWHT * nRows;
    
    VERIFY(SetWindowPos(NULL, 40, 40, rect.Width(), rect.Height() + nOfs, 
    	SWP_NOZORDER|SWP_NOREDRAW|SWP_NOACTIVATE));

    CenterWindow();

    CButton * btn = (CButton *)GetDlgItem(IDOK);
    btn->GetWindowRect(rect);
    ScreenToClient(rect);
    rect.OffsetRect(0, nOfs);
    btn->MoveWindow(rect);
    
    btn = (CButton *)GetDlgItem(IDCANCEL);
    btn->GetWindowRect(rect);
    ScreenToClient(rect);
    rect.OffsetRect(0, nOfs);
    btn->MoveWindow(rect);
    
    btn = (CButton *)GetDlgItem(IDC_REGCONFIG_SELECTALL);
    btn->GetWindowRect(rect);
    ScreenToClient(rect);
    rect.OffsetRect(0, nOfs);
    btn->MoveWindow(rect);
    
    btn = (CButton *)GetDlgItem(IDC_REGCONFIG_UNSELECT);
    btn->GetWindowRect(rect);
    ScreenToClient(rect);
    rect.OffsetRect(0, nOfs);
    btn->MoveWindow(rect);
//    btn->EnableWindow(0);
    
    btn = (CButton *)GetDlgItem(ID_HELP);
    btn->GetWindowRect(rect);
    ScreenToClient(rect);
    rect.OffsetRect(0, nOfs);
    btn->MoveWindow(rect);
    
    for(int i = 0, j = 0; j < nRows && i < nMaxReg; j ++) {
        for(int k = 0; k < 6 && i < nMaxReg; k ++, i++) {  
            rect.SetRect(10 + k * _COLWD, 10 + j * _ROWHT, 
                10 + k * _COLWD + 75, 10 + j * _ROWHT + 16);
            m_btnReg[i].Create("O&verwrite",WS_VISIBLE|WS_CHILD|WS_TABSTOP
                |BS_AUTOCHECKBOX, rect, this, IDC_REGCONFIG_FIRSTREG + i);
            m_btnReg[i].SetFont(GetFont(), TRUE);   
            m_btnReg[i].SetWindowText(RegName[i]);
            if(m_Reg[i])    m_btnReg[i].SetCheck(1);
            else    m_btnReg[i].SetCheck(0);
        }
    }                  
    m_btnReg[0].EnableWindow(0);
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////(EOF)///////////////////////////////////////
