
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DADEXT.CPP   1.13   13 Dec 1996 11:18:16   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DADEXT.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:16   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:16   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:34   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:28   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:30   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:54   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:44   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:54   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:26   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:36:40   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:51:18   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:32:26   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:09:40   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:20:08   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : dadext.cpp
** Author: Richard Guo
** Description: 
**    DAD public functions used in dadshell.cpp, dadmem.cpp, dadsrc.cpp files.
**
**
**    Finished date: 1996.6.23
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#include "stdafx.h"

#include "basictyp.h"
#include "abibase.h"
#include "dadcore.h"
#include "dad.h"
#include "dadpub.h" 
#include "dadconst.h" 
#include "dadext.h"

#include <ctype.h>

#include <stdio.h>       

extern BOOL isSymDsm; //define by Roger to decide whether the disasm can use symbols.

STATUS AbiGetMemN(ADDR addr1, ADDR addr2,WORD* pchBuff);
extern int AddrToSym(U8 type , U32 addr , char *str);


int ExternalDasmInit(WORD memStartAddr,
                int  memLineNo,
                ADDR &AddrFrom,
                ADDR &AddrTo,
                WORD * &pMemContent)
{ 
    
    if (pMemContent != NULL){
        delete [] pMemContent;
        pMemContent = NULL;
    }
            
    FLAG ABIAddrType; //refer to ABI address type

    ABIAddrType = ABI_CODE_ADDR_JOHN;
    
    // call memory to see cpu is valid
    // return ERR_DAD_CPU;
    
//check length
    if (ValidAddr(memStartAddr, ABIAddrType) == ERR_ADDR_LARGE)
        return ERR_ADDR_LARGE;
        
    ValidLen(memStartAddr, memLineNo, ABIAddrType);
    
    if (memLineNo <= 0) return ERR_DAD_MEM_INVALID_LENGTH;
    if(memLineNo > MAXMEMINSTRUCTION) memLineNo = MAXMEMINSTRUCTION;
       
                                               
    pMemContent = new WORD [memLineNo + 1];    
    
    
    for(int i=0; i< (memLineNo-1)/128; i++)
    { 
        AddrFrom.addrType = ABIAddrType;
    	AddrFrom.addr = (WORD)memStartAddr + i*128;
  
    	AddrTo.addrType = ABIAddrType;            
    	AddrTo.addr = (WORD)memStartAddr + (i+1)*128 - 1;
    	
	    if ( AbiGetMemN(AddrFrom, AddrTo, pMemContent + i*128) != ICE_OK)
    	{
       		delete [] pMemContent;
         	return ERR_DAD_ABI_GET_MEM;
		}         	
    }   
    
    AddrFrom.addrType = ABIAddrType;
    AddrFrom.addr = (WORD)memStartAddr + i*128;
  
    AddrTo.addrType = ABIAddrType;            
    AddrTo.addr = (WORD)memStartAddr + memLineNo - 1;
    
   	if ( AbiGetMemN(AddrFrom, AddrTo, pMemContent + i*128) != ICE_OK)
    {
    	delete [] pMemContent;
      	return ERR_DAD_ABI_GET_MEM;
	}         	
        
    AddrFrom.addrType = ABIAddrType;
    AddrFrom.addr = (WORD)memStartAddr;
                                  
    return 0;
}


/********************THIS BLOCK DESIGNED FOR INTERFACE WITH SYMBOL **************/
int GetSymbol(unsigned char Attribute,//xdata,idate,ibit,code,Sfr
              unsigned long Address,//0-0xffff
              char *Symbol, //return string containing symbol,ended with 0
              unsigned char len)// length of *Symbol buffer=128 bytes
                              //this function only defined for test use
{ 
   int result,lentemp,lenbak;              
   union AddrTemp addrTemp;//only defined for HextoText()
                             
   if(!isSymDsm) return -1;
   
   if(len<GATESLEN) return -1;
   
   result = AddrToSym(Attribute , Address , Symbol );   
   
   if ( result==0 ) 
   {
      if ( Symbol[0]!='#' ) return -1;
                                          
      //append address behind symbol
      strcat((char __far *)Symbol,"("); 
      switch(Attribute)
       {
        case ABI_CODE_ADDR_JOHN: strcat((char __far *)Symbol,"P:");
                                 break;
        case ABI_XDATA_ADDR    : strcat((char __far *)Symbol,"X:");
                                 break;
        case ABI_IDATA_ADDR    : strcat((char __far *)Symbol,"I:");
                                 break;
        case ABI_SFR_ADDR      : strcat((char __far *)Symbol,"R:");
                                 break;
        case ABI_BIT_ADDR      : strcat((char __far *)Symbol,"B:");
                                 break;
        }
   
      lenbak = strlen((char *)Symbol);
      addrTemp.addrShort= (WORD)Address;
      
      lentemp = HextoText(&(addrTemp.addrStruct), Symbol + lenbak, Attribute);
      Symbol[lenbak+lentemp]=0; 
      
      strcat((char __far *)Symbol,")"); 
      
      return strlen((const char __far *)Symbol);
      }
      
   return -1;//no
}
//return -1 error
//return 0 ok        

int HextoText(AddrStruct *Hex,char *textbuff,unsigned char Attribute)
{                                                             
    unsigned char ch;
  int i;
  i=0;
  if(Attribute==ABI_CODE_ADDR_JOHN || Attribute==ABI_XDATA_ADDR )
   {
    ch=(unsigned char)((Hex->addrh)/16);
    if(ch>9) { textbuff[i]='0';i++;}
    textbuff[i]=(unsigned char)((ch<=9)?'0'+ch:'A'+ch-10);i++;
    ch=(unsigned char)((Hex->addrh)%16);
    textbuff[i]=(unsigned char)((ch<=9)?'0'+ch:'A'+ch-10);i++;
    ch=(unsigned char)((Hex->addrl)/16);
    textbuff[i]=(unsigned char)((ch<=9)?'0'+ch:'A'+ch-10);i++;
    ch=(unsigned char)((Hex->addrl)%16);
    textbuff[i]=(unsigned char)((ch<=9)?'0'+ch:'A'+ch-10);i++;
    textbuff[i]='H';i++;
    return i;
    }

  if(Attribute==ABI_IDATA_ADDR || Attribute==ABI_BIT_ADDR)
   {
    ch=(unsigned char)((Hex->addrl)/16);
    if(ch>9) { textbuff[i]='0';i++;}
    textbuff[i]=(unsigned char)((ch<=9)?'0'+ch:'A'+ch-10);i++;
    ch=(unsigned char)((Hex->addrl)%16);
    textbuff[i]=(unsigned char)((ch<=9)?'0'+ch:'A'+ch-10);i++;
    textbuff[i]='H';i++;
    return i;
    }
    return 0;
}         


BOOL EnhanceHexFromString(const char* szSrc, WORD &nValue)
{ 
    char *pCur = (char*) szSrc;
    
    for (; !isxdigit(*pCur); pCur++);
    
    return HexFromString(pCur, nValue);
}
