
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DADMEM.CPP   1.13   13 Dec 1996 11:18:16   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DADMEM.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:16   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:16   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:34   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:30   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:50   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:12   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:00   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:14   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:50   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:18   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:36   ZJRD
** PIC/SLD Version 0.60
** 
**    Rev 1.2   02 Sep 1996 11:30:42   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:08:20   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:28   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : dadmem.cpp
** Author: Richard Guo
** Description:
**    DAD Functions used in memory window.
**
**
**    Finished date: 1996.6.23
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#include "stdafx.h"
#include "abibase.h"
#include "dad.h"
#include "dadconst.h" 
#include "cpucom.h" 
#include "cpuserve.h"  
#include "dadext.h" 
#include "dadpub.h"  
#include "basictyp.h"

extern int GetMemoryRange(CPUMEMORYRANGE *stRange);
void ErrShow(U32 errorCode,BOOL bUI);
void Showline(char*);

int MEMDisAsm(   
            WORD memStartAddr,   // the start address to be disassembly
            int  memLineNo,      //how many instructions to be disassembled
            DADMEMSTRU * dadMemStru, //struct array to save result
            int abiArea , //code area or xdata area
            int &nFinishNo //how many instructions is ok
            )

{ 

    nFinishNo = 0;

    ADDR AddrFrom, AddrTo;
   
    WORD *pMemContent = NULL;
    
    int nReturn;
    if ( (nReturn = ExternalDasmInit(memStartAddr, memLineNo, 
            AddrFrom, AddrTo, pMemContent)) != 0)
        return nReturn;
    
    GetPage();
    GetBank();    
    for (WORD i=AddrFrom.addr; i<=AddrTo.addr; i++)
    {                    
        // Get current page and bank. 
        // GetPageBank(nPage, nBank);
        dadMemStru->address = i;
        wsprintf(dadMemStru->code, "%04x", pMemContent[i-AddrFrom.addr]);
        Disassemble((dadMemStru)->instruction, 
                pMemContent[i - AddrFrom.addr]);
        nFinishNo++;    
        dadMemStru++;           
    }    
  
    delete [] pMemContent;
        
    return 0;//OK!
}
 
 
//disassembly function(from DisAsm()) and defined for source
int GetDsm (   
            WORD memStartAddr,   // the start address to be disassembly
            int  memLineNo,      //how many instructions to be disassembled
            DADMEMSTRU * dadMemStru, //struct array to save result
            int abiArea  //code area or xdata area
            )            
{            
    int finishedNo;
    
    memLineNo = memLineNo - 4;
    int result= MEMDisAsm(   
                memStartAddr,   // the start address to be disassembly
                memLineNo,      //how many instructions to be disassembled
                dadMemStru, //struct array to save result
                abiArea , //code area or xdata area
                finishedNo //how many instructions is ok
            );
                  
    
    dadMemStru[finishedNo].address = 0xffff; // mark the terminate
                      
    if(result==0)  return 0;  
    
  //  ErrShow(result, TRUE);
             
    return result;  
}   


//this function defined for lANE(MEM window) to call asssembly function                                                                
WORD MemAssemble(WORD laneAddr, const char *RogerInstr, int abiArea) 
{         
    if(strlen(RogerInstr) > 255) 
    {
      return -1;
    }
    
    FLAG ABIAddrType;
    WORD nCode;
    
    ABIAddrType = ABI_CODE_ADDR_JOHN;
   
    GetPage();
    GetBank();
    int nReturn = Assemble(RogerInstr, nCode); 
       
    if (nReturn >= 0){
        FillCodeMem(laneAddr, nCode);
        return laneAddr + 1;
    }         
    
    if (nReturn !=0)  DadErrShow(nReturn, TRUE);
    
    return -1;                    
}

/************************end of file*********************************/

