
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DADSHELL.CPP   1.13   13 Dec 1996 11:18:18   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DADSHELL.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:18   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:16   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:36   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:30   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:16   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:40   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:28   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:42   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:16   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.4   23 Sep 1996 10:36:10   ZJRD
** PIC/SLD Version 0.70
** 
**    Rev 1.3   06 Sep 1996 13:50:44   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:48   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:09:04   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:54   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : dadshell.cpp
** Author: Richard Guo
** Description:
**    DAD Functions used in shell window.
**
**
**    Finished date: 1996.6.21
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#include "stdafx.h"  
#include "afxext.h"
#include "hwtip.h"
#include "cpust.h" //96.4
            
#include "dad.h"

#include <string.h>

#include "basictyp.h"
#include "errcodec.h"
#include "shlcom.h" 
#include "abibase.h"

#include "dadpub.h"                 
#include "dadext.h"

//extern char * PromptStr[PMT_CNT];
extern void ShowLine(char* pszBuffer);

void SrcUpdate(void); //to update source window
void RepaintMemory(void);
void RepaintStack(void);
void RepaintVariable(void);

extern void ErrShow(U32 errorCode,BOOL bUI);
extern void CreateCmd(int nArgc, char* pszArgv[]);

STATUS AbiGetOneReg(WORD iRegId, WORD* cpuValue);

//for stop during disassemble in shell
#ifdef ESC_KEY  
int TestKey(WORD wKey); //1 for getkey ok
#endif

#define REG_PC 0


char ShellAddrStrA[10];          
char ShellAddrStrDA[10];             
unsigned short DadShellAddrA=0;
unsigned short DadShellAddrDA=0;

FLAG AddrTypeA = ABI_CODE_ADDR_JOHN;
FLAG AddrTypeDA = ABI_CODE_ADDR_JOHN; 

extern WORD nCodeMax;

                                      
BOOL GetDasmArg(int nArgc,char *psgArgv[], WORD &nAddrFrom, WORD &nLen);

char* LabelAnalyse(const char *strInstr,unsigned short usTmpAddr)
{ 
    if(':' != strInstr[0]) return (char*)strInstr;
    
    char* tmpStrPoint = strchr(strInstr + 1, ':');
    if (NULL == tmpStrPoint) return (char*)strInstr;      
    
    *tmpStrPoint = 0;                                        
    char strCreate[] = "CREATE";
    char *tmpStr = new char[strlen(strInstr + 1) + 10];
    
    if (NULL == tmpStr) {
        ErrShow(ER_EMU_INSUFFICIENT_MEMORY,TRUE);
        return (char*)strInstr;
    }    
    
    //NOW CREATE A SYMBOL FROM GATES                      
    strcpy(tmpStr,"#LABEL");
    strcat(tmpStr, strInstr + 1);
    
    char* pszArgv[3];  
    char  ShellAddrStrATmp[10];
    strcpy(ShellAddrStrATmp, ShellAddrStrA);
    
    pszArgv[0] = strCreate; pszArgv[1] = tmpStr; pszArgv[2] = ShellAddrStrATmp;        
    CreateCmd(3, pszArgv);                 
    //if only input label return the label addr
    
    delete [] tmpStr;
    return tmpStrPoint + 1;
}


//this function only used in converting DadShellAddrA to ShellAddrStrA
////to convert address to text used in shell window
//retur 0 refer ok
void ShellAddrHextoText(FLAG AddrType, char *ShellAddrStr, WORD DadShellAddr)
{
    ASSERT( ShellAddrStr != NULL);
    
    switch(AddrType)
    {
        case ABI_XDATA_ADDR:
            wsprintf(ShellAddrStr, " X:%04x ", DadShellAddr); 
            break;
        case ABI_CODE_ADDR_JOHN: 
        default:
            wsprintf(ShellAddrStr, " P:%04x ", DadShellAddr); 
            break;
     }
    StrToUpper(ShellAddrStr); 
}


//This function comes from DisAsm(),and it only translate instructions one by
//one.It doesn't save the result but it can show the results in shell window one by one                            
int DisAsmShell(WORD DAsmInCodeBlkLen,  // the code block length
                WORD DAsmStartAddr,   // the start address to be disassembly
                int &DAsmInstrNum,  // disassembly instruction number
                int &DAsmWordsNum, // despite the function's failure,they are valuable
                FLAG ABIAddrType  //refer to ABI address type
                )
               
{                         

    DAsmWordsNum = 0;
    DAsmInstrNum = 0;

    ADDR AddrFrom, AddrTo;
   
    WORD *pMemContent = NULL;
    
    int nReturn;
    if ( (nReturn = ExternalDasmInit(DAsmStartAddr, DAsmInCodeBlkLen,
            AddrFrom, AddrTo, pMemContent)) != 0)
        return nReturn;
        
    
    GetPage();
    GetBank();
    for (WORD i=AddrFrom.addr; i<=AddrTo.addr; i++)
    {
    
//******************STOP IF ESCAPE KEY IS DOWN*************************
        #ifdef ESC_KEY  
            if(TestKey(VK_ESCAPE)){
             delete [] pMemContent;
             return -106;          
            }
        #endif
//*********************************************************************
        char szInstruction[256];
        int  nReturn; 
        char szCode[10];
                // Get current page and bank. 
        
        nReturn = Disassemble(szInstruction, pMemContent[i - AddrFrom.addr]);       
        wsprintf(szCode, "%4x", pMemContent[i - AddrFrom.addr]);
        StrToUpper(szCode);
        
        DAsmWordsNum++;
        
//        if (nReturn < 0) return nReturn;
        
        DAsmInstrNum++;
        
     //show the result                            
       
       //get address symbol        
        char szSymStr[70];
        int nResTmp;
            
        nResTmp = GetSymbol(ABI_CODE_ADDR_JOHN, i, szSymStr, 64);    
        
        if( nResTmp>=0 )
        {
           char *tmppoint = strchr(szSymStr, '(');
           *tmppoint++ = ':';
           *tmppoint = '\0';
           ShowLine(szSymStr);
        }
                                               
        char ShellAddrStrDA[10];
        char ShellStr[256];
                                                       
        ShellAddrHextoText(ABI_CODE_ADDR_JOHN, ShellAddrStrDA, i); 
            
        wsprintf(ShellStr, "%s %s    %s", ShellAddrStrDA, szCode, szInstruction);
        
        ShowLine(ShellStr);
     }//while
   delete [] pMemContent;     
   return 0;//OK!
}

//return  0 ok
//return -3 invalid cpu moduel
//return -4 last instruction needs more code
//return -105 ABI reading error
//return -6 return for the code length is zero
//return -7 refer to having wrong address comparing to address type
//return -106 get ESCAPE KEY


 //this function defined for Roger(Shell window) to call asssembly function                                                                
void DadAssemble(char *RogerInstr) 
{         
    char AsmResult[5]; 
//if NULL input,return
    if( 0 == *RogerInstr ) {
        ADDR AddrFrom, AddrTo;
   
    	WORD *pMemContent = NULL;
    
    	int nReturn;
    	if ( (nReturn = ExternalDasmInit(DadShellAddrA, 1,
            AddrFrom, AddrTo, pMemContent)) != 0)
        	return ;
		
		char szInstruction[255]; 
		GetPage();
    	GetBank();
		ShellAddrHextoText(AddrTypeA,ShellAddrStrA,DadShellAddrA); 
		strcpy(szInstruction,ShellAddrStrA+1);
        nReturn = Disassemble(szInstruction+strlen(szInstruction), 
        	pMemContent[0]);       
        ShowLine(szInstruction);  
        PromptStr[PMT_RND] = ShellAddrStrA;          
        delete [] pMemContent;
                	
        return;
     }  
  
    if( strlen(RogerInstr) > 99 ) 
    {                                            
        ErrShow(ER_EMU_DAD_7,FALSE);
        return;
     }
 
 //analysis label if any   
    unsigned short usTmpAddr;
    char * szPoint = LabelAnalyse(RogerInstr, usTmpAddr);

//if only input label, goto label
    if(0 == *szPoint) {
        //DadShellAddrA = usTmpAddr; 
        //ShellAddrHextoText(AddrTypeA,ShellAddrStrA,DadShellAddrA);
        //PromptStr[PMT_RND] = ShellAddrStrA;
        return;
    }   
    
    GetPage();
    GetBank();
    
    WORD nCode;    
    
    int nReturn = Assemble(szPoint, nCode);
       
    if (nReturn >=0 )
    {
        FillCodeMem(DadShellAddrA, nCode);
		        
        DadShellAddrA = (DadShellAddrA+1)%nCodeMax;  
        ShellAddrHextoText(AddrTypeA,ShellAddrStrA,DadShellAddrA);
        PromptStr[PMT_RND] = ShellAddrStrA;          
        if(AddrTypeA == ABI_CODE_ADDR_JOHN)
            SrcUpdate();  
        RepaintMemory();
        RepaintStack();
        RepaintVariable();
    } 
    if (nReturn != 0)  DadErrShow(nReturn, FALSE);
}
 
//this function defined for shell window's disassemble commmand using(only called by Chen)
void DisassembleCmd(int nArgc,char *psgArgv[])
{
    if(GetXviewAppJohn()->m_nCpuStatus == STATUS_GO ) {
        ::ErrShow(ER_GOFLY_ERR_MSG, FALSE);
        return;
     }
         
    
    WORD nAddrFrom, nLen;
    if (!GetDasmArg(nArgc, psgArgv, nAddrFrom, nLen)) return;
    FLAG AddrTypeDA = ABI_CODE_ADDR_JOHN;      
    
 //show in shell window if necessary
    char ShellStrTmp[35];
    strcpy(ShellStrTmp,"LOC   OBJ CODE  SOURCE CODE ");
    ShowLine(ShellStrTmp);

    int nReturn;
    int DAsmInstrNum;
    int DAsmWordsNum;

    while(nLen != 0)
    {                    
        unsigned short temp;
   
        if(nLen > 0xf0) temp=0xf0; 
        else temp= nLen;
        
        nReturn = DisAsmShell(temp, nAddrFrom, DAsmInstrNum, DAsmWordsNum,
                 AddrTypeDA);
                 
        if(nReturn == -106) 
        { //ShowLine("Being interrupted!");
             return;                        
        }
   
        nLen = nLen - DAsmWordsNum;              
        nAddrFrom += DAsmWordsNum;
                                                
        if(nReturn < 0 && !(temp>=3 && nReturn==-4)) break;
     }
    
    if (nReturn != 0)   DadErrShow(nReturn, FALSE);
              
}
 

BOOL GetDasmArg(int nArgc,char *psgArgv[], WORD &nAddrFrom, WORD &nLen)
{
    switch(nArgc)
    {            
        case 1: //get PC from ABI    
            {
            STATUS m_nErrorID;
            m_nErrorID = AbiGetOneReg( REG_PC , &nAddrFrom ); 
            if(ICE_OK != m_nErrorID)    
            { 
                ShowLine("Communication error!");
                return FALSE;
            }
            
            nLen = DisassemblyDefaultLength;
            break;
            }
        case 2: 
            EnhanceHexFromString(psgArgv[1], nAddrFrom);
            nLen = DisassemblyDefaultLength;
            break;
        case 3: 
            EnhanceHexFromString(psgArgv[1], nAddrFrom);
            EnhanceHexFromString(psgArgv[2], nLen);
            nLen = nLen - nAddrFrom + 1;
           break; 
        case 4: 
            EnhanceHexFromString(psgArgv[1], nAddrFrom);
            EnhanceHexFromString(psgArgv[3], nLen);
           break; 
        default:
            return FALSE;
  } //switch
  
  return TRUE;
}
                                               
//this function prepared for chen(syntax) go give me the address                                               
void AssembleCmd(int nArgc,char *psgArgv[])
{      
    int i; i=0;
    
    DadShellAddrA = 0;
    ShellAddrHextoText(AddrTypeA, ShellAddrStrA, DadShellAddrA);
    PromptStr[PMT_RND] = ShellAddrStrA;
 
    if (nArgc==1)
    { 
    //get PC from ABI    
        STATUS  m_nErrorID = AbiGetOneReg( REG_PC , &DadShellAddrA ); 
        if(ICE_OK != m_nErrorID)    
        {      
            ErrShow(ER_ICE_OK+m_nErrorID,FALSE);
            return;
        }
    
        ShellAddrHextoText(AddrTypeA, ShellAddrStrA, DadShellAddrA);
        PromptStr[PMT_RND] = ShellAddrStrA;
        return;
    }
   
    EnhanceHexFromString(psgArgv[1], DadShellAddrA);
    
     
    ShellAddrHextoText(AddrTypeA, ShellAddrStrA, DadShellAddrA);
    PromptStr[PMT_RND] = ShellAddrStrA;    
 
    return;  
}      
