
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/DADSRC.CPP   1.13   13 Dec 1996 11:18:18   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/DADSRC.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:18   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:18   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:36   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:30   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:00   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:22   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:10   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:24   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:58   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.4   23 Sep 1996 10:35:36   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:58   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:04   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:08:34   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:38   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : dadsrc.cpp
** Author: Richard Guo
** Description:
**    DAD Functions used in source window and SPA.
**
**
**    Finished date: 1996.6.23
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#include "stdafx.h"
#include "dad.h"
#ifdef SOURCE
#include "dadext.h"
#include "dadpub.h"
#include "cpucom.h"
#include "cpuserve.h"   
#include "dadconst.h"

int GetMemoryRange(CPUMEMORYRANGE *stRange);

//editted because of the request that I must fill the buffer if having dad error
int OwnSRCDisAsm(   
            unsigned int DAsmStartAddr,   // the start address to be disassembly
            unsigned int DAsmInCodeBlkLen,  // the code block length
            unsigned int *DAsmInstrNum,  // disassembly instruction number
            unsigned int *DAsmBytesNum, // despite the function's failure,they are valuable
            char        **InstrArray,// these to buffers contain the results(instructions and length)
            unsigned int *AddrLenArray, // max array numbler is 100
            char        **LabelArray  // contain the label string if finding
            )

{ 
    *DAsmInstrNum = 0;
    *DAsmBytesNum = 0;
    
    ADDR AddrFrom, AddrTo;
   
    WORD *pMemContent = NULL;
    
    int nReturn;
    if ( (nReturn = ExternalDasmInit((long)DAsmStartAddr, (int)DAsmInCodeBlkLen, 
            AddrFrom, AddrTo, pMemContent)) != 0) 
    {
    	if (nReturn != ERR_DAD_ABI_GET_MEM)
            return nReturn;  
        else{
        	pMemContent = new WORD[AddrTo.addr - AddrFrom.addr + 1];
        	memset(pMemContent, 0, AddrTo.addr - AddrFrom.addr + 1);
        }
    }
            
            
    GetPage();
    GetBank();
    for (WORD i=AddrFrom.addr; i<=AddrTo.addr; i++, (*DAsmInstrNum)++,
            (*DAsmBytesNum)++)
    {                    
     
     //record the result                            
        int nReturn;
          
          wsprintf(InstrArray[*DAsmInstrNum], "%04X   ", pMemContent[*DAsmInstrNum]);
      //    StrToUpper(InstrArray[*DAsmInstrNum]);
          
          nReturn = Disassemble(InstrArray[*DAsmInstrNum] + 
          		strlen(InstrArray[*DAsmInstrNum]),
          		pMemContent[*DAsmInstrNum]);
          
 //       nReturn = Disassemble(InstrArray[*DAsmInstrNum], pMemContent[*DAsmInstrNum]);                    
 //       if (nReturn < 0) return nReturn;

     //num
        AddrLenArray[*DAsmInstrNum] = 1;
     
     //label      
        char SymStr[70];
        int ResTmp;
      
        ResTmp = GetSymbol(ABI_CODE_ADDR_JOHN,(unsigned long)i, SymStr,64);    
        if( ResTmp>=0 )
        {
            char *tmppoint;
            tmppoint = SymStr;
            while(*tmppoint!=0 && *tmppoint!='(') tmppoint++;
            *tmppoint=0;
            strcat((char *)SymStr,":");
            strcpy(LabelArray[*DAsmInstrNum], (char *)SymStr);
        }                           
        else LabelArray[*DAsmInstrNum][0] = '\0';
    }

   delete [] pMemContent;
   return 0;//OK!
//return  0 ok
//return <=-100 DADOne error
//return -2 too many instructions
//return -3 invalid cpu moduel
//return -4 last instruction needs more code
//return -6 return for the code length is zero
//return -7 refer to having wrong address comparing to address type
//return -105 ABI reading error
}
  
//disassembly function(from DisAsm()) and defined for source
int SRCDisAsm(   
            unsigned int DAsmStartAddr,   // the start address to be disassembly
            unsigned int DAsmInCodeBlkLen,  // the code block length
            unsigned int *DAsmInstrNum,  // disassembly instruction number
            unsigned int *DAsmBytesNum, // despite the function's failure,they are valuable
            char        **InstrArray,// these to buffers contain the results(instructions and length)
            unsigned int *AddrLenArray, // 
            char        **LabelArray  // contain the label string if finding
            )
{ 
    int result= OwnSRCDisAsm(   
            DAsmStartAddr,   // the start address to be disassembly
            DAsmInCodeBlkLen,  // the code block length
            DAsmInstrNum,  // disassembly instruction number
            DAsmBytesNum, // despite the function's failure,they are valuable
            InstrArray,// these to buffers contain the results(instructions and length)
            AddrLenArray, // max array numbler is 100
            LabelArray  // contain the label string if finding
            );          
    
    for(unsigned int i = *DAsmInstrNum; i < DAsmInCodeBlkLen; i++)
    {
    	InstrArray[i][0] = '\0'; 
    	AddrLenArray[i] = 1;
    	LabelArray[i][0] = '\0';
    }
            
    if(result==0 || result==-4)  return 0;
    
 //   DadErrShow(result, TRUE);
    //fill the buff
    
    if(DAsmInCodeBlkLen==0) DAsmInCodeBlkLen = MAXINSTRUCTION;
    *DAsmInstrNum= DAsmInCodeBlkLen;
    *DAsmBytesNum= DAsmInCodeBlkLen;
    for(i=0; i< DAsmInCodeBlkLen; i++) 
    {
        AddrLenArray[i]=1;               
        InstrArray[i][0] = '\0';
//        strcpy(InstrArray[i],"NOP"); 
        LabelArray[i][0] = 0;
    }             
    return result;  
}              

//added by john 96.4
int SpaDisAsm(   
            unsigned short DAsmStartAddr,   // the start address to be disassembly
            unsigned short DAsmInCodeBlkLen,  // the code block length
            unsigned short &usNextAddr,
            CStringList* &pList
            )

{ 
    ADDR AddrFrom, AddrTo;
   
    WORD *pMemContent = NULL;
    
    int nReturn;
    if ( (nReturn = ExternalDasmInit((long)DAsmStartAddr, (int)DAsmInCodeBlkLen, 
            AddrFrom, AddrTo, pMemContent)) != 0)
        return nReturn;
        
    char szDasmBuf[256];
    char *szFormat = "%04X     %04X    ";
    WORD i;
    
    wsprintf(szDasmBuf, szFormat, i, i);
    int nSpace = strlen(szDasmBuf);

	GetPage();
	GetBank();      
    for (i=AddrFrom.addr; i<=AddrTo.addr; i++)
    {                    
     
     //record the result                            
        
        int nReturn;     
        
        wsprintf(szDasmBuf, szFormat, i, pMemContent[i-AddrFrom.addr]);
        
        nReturn = Disassemble(szDasmBuf + nSpace, pMemContent[i - AddrFrom.addr]);                    
//        if (nReturn < 0 ) return nReturn;
        
        CString tmpStr = szDasmBuf;
        pList->AddTail(tmpStr);
         
     } //while
                                                  
    CPUMEMORYRANGE stRange;
    GetMemoryRange( &stRange );
                                                      
    usNextAddr = (unsigned short)((AddrTo.addr+1)%(stRange.pMax+1L));
    
       

    return 0;//OK!
//return  0 ok
//return <=-100 DADOne error
//return -2 too many instructions
//return -3 invalid cpu moduel
//return -4 last instruction needs more code
//return -6 return for the code length is zero
//return -7 refer to having wrong address comparing to address type
//return -105 ABI reading error
  }

  
#endif
