
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/EMUGO.H__   1.13   13 Dec 1996 11:18:22   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/EMUGO.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:22   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:22   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:40   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:34   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:16   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:30   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:28   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:50   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:24   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:31:54   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:45:42   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:26:48   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:05:20   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:04   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: EMUGO.H
//
//  Description: The header file for the class: CEmulationGo.
//
//  Author: Chen Jun
//
//  Date: 05/06/95
//
//  Modification:
//      1. 05/06/95, Initial version of the class: CEmulationGo.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _EMUGO_
#define _EMUGO_

#include "membase.h"


/////////////////////////////////////////////////////////////////////////////
// CEmulationGo class.
class CEmulationGo : public CMemoryBase
{
// Construction & Destruction.
public:
    CEmulationGo();
    ~CEmulationGo();
    
// Member variables.
private:
    CMemoryAddr m_FromAddr, m_TillAddr;
    unsigned char m_uchRunFlag;
    unsigned char m_uchFlyFlag;
    
    CMemoryAddr m_Addr[4], m_BPAddr[2];

    enum { PC = 0 };
    unsigned short m_uPC;
    
    int m_nMonitorTimer;
    BOOL m_bStartTimer;
    int m_nTimerCount;
    
protected:

public:

// Implementations.
private:
    void SetRunFlag(unsigned char uchRunFlag);  
    void SetFlyFlag(unsigned char uchFlyFlag);
    void GoKernel(void);
    BOOL DetectEPStop(void);
    
    void SetMonitorTimer(char* pszTimer);
    void UpdateAllWindows(void);

protected:

public:
    void GoAction(int nArgc, char* pszArgv[]);

    void EmuServerGo(int nMode, unsigned short uAddr);
    
    BOOL GoForGofly();

};  // End of class: CEmulationGo.

#endif
//////////////////////////////// End of File ////////////////////////////////
