
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/EMUJUMP.CPP   1.13   13 Dec 1996 11:18:22   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/EMUJUMP.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:22   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:22   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:40   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:36   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:28   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:42   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:38   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:00   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:34   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:32:20   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:46:10   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:27:16   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:05:42   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:14   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: EMUJUMP.CPP
//
//  Description: The implementation file for the class: CEmulationJump.
//
//  Author: Chen Jun
//
//  Date: 05/08/95
//
//  Modification:
//      1. 05/08/95, Initial version of the class: CEmulationJump.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"
                     
#include "basictyp.h"                     
#include "emujump.h"
#include "errcodec.h"                       
#include "cpust.h" //john 96.4
extern void ErrShow(U32 errorCode,BOOL bUI);


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
extern void ErrShow(U32 errorCode,BOOL bUI);
void JumpCmd(int nArgc, char* pszArgv[]);
void EmuServerJump(unsigned short uAddr);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
#ifndef _SERVER_NO_ABI
    extern STATUS AbiSetReg(WORD iRegId, WORD uRegValue);
#endif  // _SERVER_NO_ABI



/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   JumpCmd().
//
//  Description: The main control routine of Jump command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void JumpCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Execute Jump command.
    CEmulationJump* pEmulationJump = new CEmulationJump;
    if ( !pEmulationJump ) {
        ::ErrShow(ER_EMU_INSUFFICIENT_MEMORY,TRUE);
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationJump->JumpAction(nArgc, pszArgv);
        delete pEmulationJump;
    }

//    CEmulationJump objJump;
//    objJump.JumpAction(nArgc, pszArgv);

}   // End of JumpCmd().

// Jump server.
void EmuServerJump(unsigned short uAddr)
{
    // Assertion of the input parameters.
    
    // Execute Jump command.
    CEmulationJump* pEmulationJump = new CEmulationJump;
    if ( !pEmulationJump ) {
        ::ErrShow(ER_EMU_INSUFFICIENT_MEMORY,TRUE);
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationJump->EmuServerJump(uAddr);
        delete pEmulationJump;
    }

}   // End of EmuServerJump().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CEmulationJump.

// Construction.
CEmulationJump::CEmulationJump()
{

}   // End of CEmulationJump::CEmulationJump().


// Destruction.
CEmulationJump::~CEmulationJump()
{

}   // End of CEmulationJump::~CEmulationJump().


// Emulation Jump command.
void CEmulationJump::JumpAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }

    // Set the parameters.
    switch ( nArgc ) {
        case 2:
            // Jump adr
            m_nRegID = PC;
            SetAddrVar(pszArgv[1], m_JumpAddr);
            break;
        default:
            ASSERT( FALSE );
            break;
    }
    
    // Call the Jump kernel.
    JumpKernel();

}   // End of CEmulationJump::JumpAction().


// Jump kernel routine.
void CEmulationJump::JumpKernel(void)
{
    // Assertion of the input parameters.
    
    // Test parameters.
    //DumpVar(m_nRegID);
    //DumpVar((unsigned long)m_JumpAddr.m_uAddr);
    //john 96.4
    if(GetXviewAppJohn()->m_nCpuStatus == STATUS_GO) {
    	if ( !m_isServer ) ::ErrShow(ER_GOFLY_ERR_MSG,FALSE);
        	else ::ErrShow(ER_GOFLY_ERR_MSG,TRUE);
        return;	
    }
    // Call the ABI function.
    m_nErrorID = AbiSetReg(m_nRegID, (unsigned int)m_JumpAddr.m_uAddr);
    
    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
    }

}   // End of CEmulationJump::JumpKernel().


// Jump server.
void CEmulationJump::EmuServerJump(unsigned short uAddr)
{
    // Assertion of the input parameters.

    // Set the parameters.
    m_nRegID = PC;
    m_JumpAddr = CMemoryAddr(uAddr, MEM_PROGRAM);
    
    // Call the Jump kernel.
    m_isServer = TRUE;
    JumpKernel();

}   // End of CEmulationJump::EmuServerJump().

//////////////////////////////// End of File ////////////////////////////////
