
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/EMUPATCH.H__   1.13   13 Dec 1996 11:18:24   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/EMUPATCH.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:24   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:24   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:42   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:36   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:46   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:10   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:58   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:12   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:46   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:14   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:28   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:36   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:14   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:26   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: EMUPATCH.H
//
//  Description: The header file for the class: CEmulationPatch.
//
//  Author: Chen Jun
//
//  Date: 05/08/95
//
//  Modification:
//      1. 05/08/95, Initial version of the class: CEmulationPatch.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _EMUPATCH_
#define _EMUPATCH_

#include "membase.h"


/////////////////////////////////////////////////////////////////////////////
// CEmulationPatch class.
class CEmulationPatch : public CMemoryBase
{
// Construction & Destruction.
public:
    CEmulationPatch();
    ~CEmulationPatch();
    
// Member variables.
private:
    CMemoryAddr m_Addr1, m_Addr2, m_Addr3, m_Addr4;
    
protected:

public:

// Implementations.
private:
    void PatchKernel(void);
    void DisplayPatch(void);
    void SetPatchData(void) const;
    void GetPatchData(void);

protected:

public:
    void PatchAction(int nArgc, char* pszArgv[]);

};  // End of class: CEmulationPatch.



/////////////////////////////////////////////////////////////////////////////
// CPatchData class.
class CPatchData : public CMemoryBase
{
// Construction & Destruction.
public:
    CPatchData();
    ~CPatchData();
    
// Member variables.
private:
    CMemoryAddr m_Addr1, m_Addr2, m_Addr3, m_Addr4;
    
protected:

public:

// Implementations.
private:

protected:

public:
    void SetPatchData(const CMemoryAddr Addr1, const CMemoryAddr Addr2,
                      const CMemoryAddr Addr3, const CMemoryAddr Addr4);
    
    void GetPatchData(CMemoryAddr& Addr1, CMemoryAddr& Addr2,
                      CMemoryAddr& Addr3, CMemoryAddr& Addr4) const;

};  // End of class: CPatchData.

#endif
//////////////////////////////// End of File ////////////////////////////////
