
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/EMUSTEP.H__   1.13   13 Dec 1996 11:18:24   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/EMUSTEP.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:24   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:24   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:42   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:38   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:32   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:48   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:44   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:04   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:38   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:32:32   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:46:24   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:27:30   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:05:54   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:18   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: EMUSTEP.H
//
//  Description: The header file for the class: CEmulationStep.
//               And for the STEPOption command.
//
//  Author: Chen Jun
//
//  Date: 05/10/95
//
//  Modification:
//      1. 05/10/95, Initial version of the class: CEmulationStep.
//      2. 05/10/95, Initial version of the command: STEPOption.
//      3. 10/10/95, Remove Stepoption command.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _EMUSTEP_
#define _EMUSTEP_

#include "membase.h"


/////////////////////////////////////////////////////////////////////////////
// CEmulationStep class.
class CEmulationStep : public CMemoryBase
{
// Construction & Destruction.
public:
    CEmulationStep();
    ~CEmulationStep();
    
// Member variables.
private:
    BOOL m_isStepOver;
    BOOL m_isStepForever;
    BOOL m_isStepCount;
    BOOL m_isTillCall;
    BOOL m_isTillRet;
    BOOL m_isAddr;
    BOOL m_isRegMatch;
    BOOL m_isMemMatch;
    BOOL m_isIntoCall;
    BOOL m_isOverRet;
    
    unsigned short m_uStepCount;    // Step counter.

    CMemoryAddr m_FromAddr, m_TillAddr; // Address range.

    unsigned short m_uInputCount;   // Input count.
    
    int m_nRegID;                   // Register ID.
    unsigned int m_uRegData;        // Input Register value.
    
    CMemoryAddr m_MatchAddr;        // Matched address.
    unsigned char m_uchMemData;     // Input Memory value.
    
    CMemoryAddr m_TestAddr;
    
    enum { INSTRUCTION = 0, STATEMENT, LINE };
    int m_nStepOption;
    
    unsigned short m_uBpAddr;
    
protected:

public:

// Implementations.
private:
    void StepKernel(void);
    void StepRangeKernel(void);

    void DisplayStepCount(void);
    BOOL StepMatchCount(void);
    BOOL StepMatchCall(void);
    BOOL StepMatchRet(void);
    BOOL StepMatchAddr(void);
    BOOL StepMatchReg(void);
    BOOL StepMatchMem(void);
    void GetStepRange(unsigned short& uStart, unsigned short& uEnd);
    
    void UpdateAllWindows(void);

    void StepOptionKernel(void);

protected:

public:
    void StepAction(int nArgc, char* pszArgv[]);
    void StepOptionAction(int nArgc, char* pszArgv[]);

    void EmuServerStep(long lCount);
    void EmuServerStepOver(long lCount);

};  // End of class: CEmulationStep.

#endif
//////////////////////////////// End of File ////////////////////////////////
