
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/EMUTMPBP.CPP   1.13   13 Dec 1996 11:18:24   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/EMUTMPBP.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:24   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:24   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:42   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:38   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:54   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:18   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:06   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:22   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:56   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:30   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:52   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:58   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:28   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:34   ZJRD
** Initial revision.
** 
****************************************************************************/

#include "stdafx.h"
#include "abibase.h"

//typedef unsigned short PADDR;
unsigned short uTempBp;
BOOL fTempBp = FALSE;

extern BOOL BptSearchBpt(unsigned short addr,BYTE &eFlag);
extern STATUS AbiSetBp(ADDR);
extern STATUS AbiClrBp(ADDR);
 
STATUS EmuSetTempBp(unsigned short uAddr);
STATUS EmuClrTempBp();
ADDR MakeAbiAddr(unsigned short uAddr);

/***************************************************************************
**
**  Name: EmuClrTempBp
**
**  Function: Clear two links.
**            1. index link
**            2. temporary breakpoints link
**
**  Return: the return code from ABI
**
***************************************************************************/

STATUS EmuSetTempBp(unsigned short uAddr)
{
    STATUS status;
    BYTE fEnable;

    if ( !::BptSearchBpt(uAddr, fEnable) ) {
        status = ::AbiSetBp(MakeAbiAddr(uAddr));
        if (status == ICE_OK) {
            fTempBp = TRUE;
            uTempBp = uAddr;
        }
        return status;
    }
    return (ICE_OK);
}

/***************************************************************************
**
**  Name: EmuClrTempBp
**
**  Function: Clear two links.
**            1. index link
**            2. temporary breakpoints link
**
**  Return: the return code from ABI
**
***************************************************************************/
STATUS EmuClrTempBp()
{
    STATUS status = ICE_OK;

    if ( TRUE == fTempBp ) {
        status = AbiClrBp(MakeAbiAddr(uTempBp));
    	fTempBp = FALSE;
    }
    return status;
}            

/***************************************************************************
**
**  Name: MakeAbiAddr
**
**  Function: convert unsigned short address position into struct ADDR
**
**
**
***************************************************************************/
ADDR MakeAbiAddr(unsigned short uAddr)
{
    ADDR structAddr;
    structAddr.addrType = 0x1;
    structAddr.addr = uAddr;
    return (structAddr);
}
