/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/EVSVR.CPP   1.13   13 Dec 1996 11:18:28   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/EVSVR.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:28   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:28   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:46   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:40   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:45:24   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:47:34   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:40:36   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:10   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.5   09 Oct 1996 13:44:44   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:30:10   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:43:52   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:25:16   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.0   13 Aug 1996 09:17:30   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : 	EVSVR.CPP
** Author: 		Chris Fang
** Description: implement file of Event Server
**              Event Server: the server of ev1, ev2, ev3 and qualify
**
** coding from: June 14, 1996
** Finished date: 
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**							INCLUDE	SECTION
**
****************************************************************************/
#include "stdafx.h"
#include "ctype.h"

#include "evsvr.h"
#include "traceimp.h"
#include "abiextfn.h"
#include "cpust.h"
#include "hosterrs.h"

/***************************************************************************
**
**							GLOBAL	VARIABLE SECTION
**
****************************************************************************/

CBusEvent ev1(1),ev2(2);
CExtEvent ev3;

CBusEvent qlfy(0);

/***************************************************************************
**
**							INTERFACE ROUTINE SECTION
**
****************************************************************************/
//interface to shell
void Ev1Cmd(int nArgc, char* pszArgv[])
{
	ev1.ShellCmd(nArgc, pszArgv);
	ev1.m_tmpBusEv.bType = 1;
}
                          
//interface to shell                          
void Ev2Cmd(int nArgc, char* pszArgv[])
{
	ev2.ShellCmd(nArgc, pszArgv);
	ev2.m_tmpBusEv.bType = 2;
}
                    
//interface to shell                    
void Ev3Cmd(int nArgc, char* pszArgv[])
{
	ev3.ShellCmd(nArgc, pszArgv);
}
                    
//interface to shell                    
void EventCmd(int nArgc, char* pszArgv[])
{
static char Argtmp[256];
char* ArgPointTmp[20];
int ArgMaxTmp;

	Argtmp[0]=NULL;
	ArgMaxTmp = nArgc;
	for(int i=0; i< ArgMaxTmp ; i++)
		ArgPointTmp[i] = pszArgv[i];
  
	if (1==nArgc)				//display all event
	{
		strcpy(Argtmp,"EV1");
		ArgPointTmp[0]=Argtmp;
		Ev1Cmd(nArgc,ArgPointTmp);
		
		strcpy(Argtmp,"EV2");
		ArgPointTmp[0]=Argtmp;
		Ev2Cmd(ArgMaxTmp,ArgPointTmp);
		
		strcpy(Argtmp,"EV3");
		ArgPointTmp[0]=Argtmp;
		Ev3Cmd(ArgMaxTmp,ArgPointTmp);
		return;
	}
    
	if(0==stricmp(pszArgv[1], "1"))
	{
		strcpy(Argtmp,"EV1");
		ArgPointTmp[0]=Argtmp;
		for(int i=1; i< ArgMaxTmp-1 ; i++)
			ArgPointTmp[i] = ArgPointTmp[i+1];
		ArgMaxTmp--;
		Ev1Cmd(ArgMaxTmp,ArgPointTmp);
		return;
	}
   
	if(0==stricmp(pszArgv[1], "2"))
	{
		strcpy(Argtmp,"EV2");
		ArgPointTmp[0]=Argtmp;
		for(int i=1; i< ArgMaxTmp-1 ; i++)
			ArgPointTmp[i] = ArgPointTmp[i+1];
		ArgMaxTmp--;
		Ev2Cmd(ArgMaxTmp,ArgPointTmp);
		return;
	}
   
	if(0==stricmp(pszArgv[1], "3"))
	{
		strcpy(Argtmp,"EV3");
		ArgPointTmp[0]=Argtmp;
		for(int i=1; i<ArgMaxTmp-1 ; i++)
			ArgPointTmp[i] = ArgPointTmp[i+1];
		ArgMaxTmp--;
		Ev3Cmd(ArgMaxTmp,ArgPointTmp);
		return;
	}
   
	if(0 == stricmp(pszArgv[1], "CLEAR"))
	{
		strcpy(Argtmp,"EV1");
		ArgPointTmp[0]=Argtmp;
		Ev1Cmd(nArgc,ArgPointTmp);
		strcpy(Argtmp,"EV2");
		ArgPointTmp[0]=Argtmp;
		Ev2Cmd(ArgMaxTmp,ArgPointTmp);
		return;
	}
         
	ShowLine("Syntax error!");
}

void QualifyCmd(int nArgc,char* pszArgv[])
{
	qlfy.ShellCmd(nArgc, pszArgv);
	qlfy.m_tmpBusEv.bType = 0;
}

/***************************************************************************
**
**							CLASS IMPLEMENT	SECTION
**Class: CBusEvent, CExtEvent
**
****************************************************************************/

CBusEvent::CBusEvent(BYTE nEventID)
{
	ASSERT(nEventID>=0&&nEventID<=2);
	m_eventID = nEventID;
	m_busEv.bType = m_eventID;
	m_tmpBusEv.bType = m_eventID;
	m_nClearflag = 1;
	m_bFromShell=TRUE;
}

CBusEvent::~CBusEvent()
{
}

//init event              
int CBusEvent::Init()
{
    int   nErrorID;

    if(m_eventID)					//ev1, ev2
    	nErrorID = AbiClrEvent(m_eventID);
    else                            //qualify
		nErrorID = AbiClrQualify();

	if(ICE_OK == nErrorID)
	{
		m_nClearflag = 1;
		return TRUE;
	}
	//DisplayErrorMessageBox(nErrorID);   
	return FALSE;
}
            
//analyse the shell command                             
void CBusEvent::ShellCmd(int nArgc, char* pszArgv[])
{
	char*  stop_at;
	void (CBusEvent::* myFunc) ();//to decide CLEAR OR ...
	int indexhere;
   
	// Assertion of the input parameters.                
	ASSERT( nArgc > 0 );
	for (int i=0; i<nArgc; i++)
		ASSERT(pszArgv[i]);

	//init                    
	m_tmpBusEv.bAddrType = 0;
	m_tmpBusEv.bDataType = 0;
	m_tmpBusEv.bIsEv1Counter = 0;
	myFunc=CBusEvent::ShowToShell;
	indexhere=1;
	ArgMax = nArgc;
    for(int ii=0; ii<ArgMax ; ii++)
		ArgPoint[ii] = pszArgv[ii];

	while(indexhere<ArgMax)
	{
		if(0==_stricmp(ArgPoint[indexhere], "ADDRESS"))
		{
			SetAddr(&indexhere);
			myFunc=CBusEvent::SetbyShell;
		}
     	else if(0==_stricmp(ArgPoint[indexhere], "DATUM"))
		{
			SetData(&indexhere);
			myFunc=CBusEvent::SetbyShell;
		}
		else if(0==_stricmp(ArgPoint[indexhere], "COUNT"))
		{
			m_tmpBusEv.bIsEv1Counter=1;
			indexhere++;
			if(ISCOUNT(ArgPoint[indexhere]))
			{ 
				m_tmpBusEv.bEv1Counter =(BYTE)strtoul(ArgPoint[indexhere],
														&stop_at,16);
				indexhere++;
			}
			else
				ASSERT(0);
			myFunc=CBusEvent::SetbyShell;
		}
		else if(0==_stricmp(ArgPoint[indexhere], "CLEAR"))
		{
			myFunc=CBusEvent::Clear;
			indexhere++;
		}
	}//while
	(this->*myFunc)();
}
                           
//analyse card address
void CBusEvent::WildCardAddr(char *pszArgv)
{
	ASSERT(pszArgv);
   
CString str;

    // Binary or Hexadecimal wildcard code.
	if('B'==toupper(*(pszArgv+strlen(pszArgv)-1))&&17==strlen(pszArgv))
	{
		// Binary code.
		ASSERT(17==strlen(pszArgv));
		str = strupr(pszArgv);
		if(str=="XXXXXXXXXXXXXXXXB")
		{
			m_tmpBusEv.bAddrType=0;
			return;
		}
		m_tmpBusEv.AddrGrp[1]=0x0ffff;
		m_tmpBusEv.AddrGrp[0]=0;
		for(int i=0; i<17-1; i++)
		{
			if('0'!=pszArgv[i]&&
				'1'!=pszArgv[i]&&
				'X'!=toupper(pszArgv[i]))
				ASSERT(0);
        
			if('0'==pszArgv[i])
				m_tmpBusEv.AddrGrp[0] &= ~((WORD)1<<(15-i));
			if('1'==pszArgv[i])
				m_tmpBusEv.AddrGrp[0]|=((WORD)1<<(15-i));
			if('X'==toupper(pszArgv[i]))
				m_tmpBusEv.AddrGrp[1] &= ~((WORD)1<<(15-i));
		}
		m_tmpBusEv.bAddrType =1;
		return;
	}
	else
	{
		// Hexidecimal code.
		ASSERT(4==strlen(pszArgv));
		str = strupr(pszArgv);
		if(str == "XXXX")
		{
			m_tmpBusEv.bAddrType = 0;
			return;
		}
		int i = 4096;
		int j = 1;
		m_tmpBusEv.AddrGrp[1] = 0x0ffff;
		m_tmpBusEv.AddrGrp[0] = 0;
		char* p = pszArgv;
		while ( *p )
		{
			if ( isxdigit(*p) || 'X' == toupper(*p) ) 
			{ 
				if(isdigit(*p))
					m_tmpBusEv.AddrGrp[0] +=(WORD)(*p - '0')*i;
				else
				{ 
					if(toupper(*p)>='A'&&toupper(*p)<='F')
					m_tmpBusEv.AddrGrp[0] +=(WORD)(toupper(*p) - 'A'+10)*i;
				}
				if('X'==toupper(*p))
				{
					switch(j)
					{
						case 1:
							m_tmpBusEv.AddrGrp[1] =0x0fff;
							break;
						case 2:
							m_tmpBusEv.AddrGrp[1] &=0xf0ff;
							break;
						case 3:
							m_tmpBusEv.AddrGrp[1] &=0xff0f;
							break;
						case 4:
							m_tmpBusEv.AddrGrp[1] &=0x0fff0;
					}
				}
				p++;
				j++;
				i =(int)i/16;
			}
			else 
				ASSERT(0);
		}
		m_tmpBusEv.bAddrType = 1;
		return ;  
	}
	return;
}
                      
//analyse card datd                      
void CBusEvent::WildCardData(char *pszArgv)
{
   ASSERT( pszArgv );

CString  str;

//	Binary or Hexadecimal wildcard code.
	if ( 'B' == toupper(*(pszArgv+strlen(pszArgv)-1))&&17==strlen(pszArgv))
	{
		// Binary code.
		ASSERT(17==strlen(pszArgv));
		str=strupr(pszArgv);
		if(str=="XXXXXXXXXXXXXXXXB")
		{
			m_tmpBusEv.bDataType = 0;
			return;
		}
		m_tmpBusEv.wDataEnd=0xffff;
		m_tmpBusEv.wDataStart=0;
		for ( int i = 0; i < 17-1; i++ ) 
		{
			if('0' != pszArgv[i] &&
			'1' != pszArgv[i] &&
			'X' != toupper(pszArgv[i]))
				ASSERT(0);
			if ('0'==pszArgv[i])
				m_tmpBusEv.wDataStart &= (WORD)~(1<<(15-i));
			if ('1'==pszArgv[i])
				m_tmpBusEv.wDataStart |= (WORD)(1<<(15-i));
			if ('X'==toupper(pszArgv[i]))
				m_tmpBusEv.wDataEnd &= (WORD)~(1<<(15-i));
		}
		m_tmpBusEv.bDataType =1;
		return ;
	}
	else 
	{
		// Hexidecimal code.
		ASSERT( 4 == strlen(pszArgv));
		str = strupr(pszArgv);
		if(str == "XXXX")
		{
			m_tmpBusEv.bDataType = 0;
			return;
		}
		int i = 4096;
		int j = 1;  
		     
		m_tmpBusEv.wDataEnd = 0xffff;
		m_tmpBusEv.wDataStart = 0;
		char *p=pszArgv;
		while ( *p ) 
		{
			if ( isxdigit(*p) || 'X' == toupper(*p))
			{
				if(isdigit(*p)) 
				m_tmpBusEv.wDataStart +=(WORD)(*p - '0')*i;
				else
				{ 
					if(toupper(*p)>='A'&&toupper(*p)<='F')
					m_tmpBusEv.wDataStart +=(WORD)(toupper(*p) - 'A'+10)*i;
				}
				if('X'==toupper(*p))
				{
					switch(j)
					{
						case 1:
							m_tmpBusEv.wDataEnd =0x0fff;
							break;
						case 2:
							m_tmpBusEv.wDataEnd &=0xf0ff;
							break;
						case 3:
							m_tmpBusEv.wDataEnd &=0xff0f;
							break;
						case 4:
							m_tmpBusEv.wDataEnd &=0xfff0;
					}
				}
				p++;
				j++;
				i =(int)i/16;
			}
			else 
				ASSERT(0);
			m_tmpBusEv.bDataType =1;
		}
	}
	return;
}
               
//set address               
void CBusEvent::SetAddr(int* indexhere)
{
  (*indexhere)++;
  ASSERT(*indexhere<ArgMax);
  
  //for range cmd
  if(IsKeyword(g_range,ArgPoint[*indexhere]))
   {
    m_tmpBusEv.bAddrType = 2;
    (*indexhere)++;
    ASSERT(*indexhere<ArgMax);
    if (IsPAddr(ArgPoint[*indexhere]))
     m_tmpBusEv.AddrGrp[0] = g_adr;
    (*indexhere)++;
    ASSERT(*indexhere<ArgMax);
    if (IsPAddr(ArgPoint[*indexhere]))
     m_tmpBusEv.AddrGrp[1] = g_adr;
    (*indexhere)++;
    m_tmpBusEv.bAddressCounter=2;
    }        
  else
  //for xaddr  
  if(IsWildCardAddr(ArgPoint[*indexhere]))
   {
    WildCardAddr(ArgPoint[*indexhere]);       
    (*indexhere)++;
    }
  else  
  //for maximum ten addresses
  if (IsPAddr(ArgPoint[*indexhere])) 
   {
    int nums=0;                       
    m_tmpBusEv.bAddrType = 4;
    while(*indexhere<ArgMax  &&   nums<10 &&  
         IsPAddr(ArgPoint[*indexhere]))
     {
		if (IsPAddr(ArgPoint[*indexhere]))
       m_tmpBusEv.AddrGrp[nums] = g_adr;
      (*indexhere)++;  nums++;
      m_tmpBusEv.bAddressCounter=(BYTE)nums;
      }//while
    }//if
}//function
             
//set data             
void CBusEvent::SetData(int* indexhere)
{
  
  char*   stop_at;
  
  (*indexhere)++;
  ASSERT(*indexhere<ArgMax);
  
  //for range cmd
	if(IsKeyword(g_range, ArgPoint[*indexhere]))
	{
		m_tmpBusEv.bDataType = 2;
		(*indexhere)++;
		ASSERT(*indexhere<ArgMax);
		if (ISEVENTDATA(ArgPoint[*indexhere]))
		m_tmpBusEv.wDataStart = (WORD)strtoul(ArgPoint[*indexhere],&stop_at,16);
		(*indexhere)++;
		ASSERT(*indexhere<ArgMax);
		if (ISEVENTDATA(ArgPoint[*indexhere]))
		m_tmpBusEv.wDataEnd = (WORD)strtoul(ArgPoint[*indexhere],&stop_at,16);
		(*indexhere)++;
	}
	else if(IsWildCardAddr(ArgPoint[*indexhere]))
	{
		WildCardData(ArgPoint[*indexhere]);
		(*indexhere)++;
	}
	else if (ISEVENTDATA(ArgPoint[*indexhere])) 
	{
		m_tmpBusEv.bDataType = 1;
		m_tmpBusEv.wDataStart = (WORD)strtoul(ArgPoint[*indexhere],&stop_at,16);
		m_tmpBusEv.wDataEnd=0xffff;
		(*indexhere)++;
	}
}
          
//show event in shell
void CBusEvent::ShowToShell()
{
char str[30];

	if(1 == m_nClearflag)
	{
		if(m_eventID)
			wsprintf(str,"EV%u is clear ",m_eventID);
		else
			wsprintf(str,"Qualify is clear ");
		ShowLine(str);
	}
    
	else      
 /**************************************************************/   
	{ 
    int i;  WORD ii;
    CString  strBit = "";
    m_nClearflag = 0;
    CString strTmp = "";
    CString   strTmp2 = "";
    switch(m_eventID)
    {
        case 0:
        	m_strDisplay = "Qualify ";
        	break;
        case 1:
			m_strDisplay = "EV1 ";
        	break;
        case 2:
        	m_strDisplay = "EV2 ";
    }

    switch(m_busEv.bAddrType)
    {
        case 0:
         strTmp = "Address XXXXH ";
         m_strDisplay += strTmp;         
         break;
        case 1:
        strTmp = "Address ";
        for ( i=15;i>=0;i--)
        {
			if(0==(m_busEv.AddrGrp[1] & (((WORD)1)<<i) ))
			strBit = "X";
			else
			{
				if(0==(m_busEv.AddrGrp[0]&(((WORD)1)<<i))) 
					strBit = "0";
				else
					strBit = "1";
            }
            strTmp += strBit;
          }//for
        strTmp += "B ";
        m_strDisplay += strTmp;
        break;
		case 2:
		wsprintf(strTmp.GetBuffer(40),"Address range %04X %04X ",
				m_busEv.AddrGrp[0],
				m_busEv.AddrGrp[1]);
        strTmp.ReleaseBuffer(); 
        m_strDisplay += strTmp;            
        break;
        case 3:
        wsprintf(strTmp.GetBuffer(40),"Address ~range %04X %04X ",
            m_busEv.AddrGrp[0],
            m_busEv.AddrGrp[1]);
        strTmp.ReleaseBuffer();
        m_strDisplay += strTmp;
        break;
		case 4:
		ASSERT(m_busEv.bAddressCounter<=10);
		strTmp = "Address ";
		for (ii=0;ii<m_busEv.bAddressCounter;ii++)
		{
            wsprintf(strTmp2.GetBuffer(40),"%04X ",m_busEv.AddrGrp[ii]);
            strTmp2.ReleaseBuffer();
            strTmp += strTmp2;
        }
        m_strDisplay += strTmp;
        break;
        default:
        ASSERT(0);
       }//switch
       
    switch(m_busEv.bDataType)
	{
		case 0:
			strTmp = "Datum XXXXH ";
			m_strDisplay += strTmp;
        break;
        case 1:
        strTmp = "Datum ";
        for (i=15;i>=0;i--)
        {
            if(0==(m_busEv.wDataEnd&(((ULONG)1)<<i)))
            strBit = "X";
            else
            {   
            if(0==(m_busEv.wDataStart&(((ULONG)1)<<i))) 
                strBit = "0";
            else
                strBit = "1";
            }
            strTmp += strBit;
           }//for
        strTmp += "B ";
        m_strDisplay += strTmp;
        break;    
        case 2:
        wsprintf(strTmp.GetBuffer(40),"Datum range 0x%04X 0x%04X ",
				(WORD)m_busEv.wDataStart,(WORD)m_busEv.wDataEnd);
		strTmp.ReleaseBuffer();
		m_strDisplay += strTmp;
		break;
        default:
        ASSERT(0);
       }//switch
    
    switch(m_busEv.bIsEv1Counter)
	{
        case 0:
            strTmp = "";
            break;
        case 1:
            //wsprintf(strTmp.GetBuffer(20),"Count %04X",m_busEv.bEv1Counter);
            wsprintf(strTmp.GetBuffer(20),"Count 0x%04X",m_busEv.bEv1Counter);
            strTmp.ReleaseBuffer();
            break;    
        default:
            ASSERT(0);
	}
    m_strDisplay += strTmp;
/**********************************************************************/    
    if (m_strDisplay == "EV1 " 
    	|| m_strDisplay == "EV2 "
    	||m_strDisplay=="Qualify ")
       m_strDisplay += "is clear ";
    ShowLine(m_strDisplay.GetBuffer(m_strDisplay.GetLength()));
    }
}

//clear event
void CBusEvent::Clear()
{
char  str[50];
unsigned char status;

    GetCpuStatus(status);
	if(status==STATUS_GO)				//CPU is run
	{
		m_setStatus=ICE_EP_RUNNING;
		if(m_bFromShell)
		{
			ErrGetErrorText(ER_GOFLY_ERR_MSG, str);
			ShowLine(str);
		}	
		return;
	}

    if(m_eventID)
    	m_setStatus=AbiClrEvent(m_eventID);
    else
    	m_setStatus=AbiClrQualify();

    if(ICE_OK==m_setStatus)
    {
		if(m_bFromShell)
		{
			if(m_eventID)
				wsprintf(str,"Ev%1u is clear successfully.", m_eventID);
			else
				wsprintf(str,"Qualify is clear successfully.");
    		ShowLine(str);
    	}	
    	m_nClearflag = 1;
    }
    else if(m_bFromShell)
    	DisplayErrorMessage(m_setStatus);
    else
    	DisplayErrorMessageBox(m_setStatus);
    return;
}
             
//set event in shell             
void CBusEvent::SetbyShell()
{
char	str[50];
unsigned char status;

    GetCpuStatus(status);
	if(status==STATUS_GO)				//CPU is run
	{
		m_setStatus=ICE_EP_RUNNING;
		if(m_bFromShell)
		{
			ErrGetErrorText(ER_GOFLY_ERR_MSG, str);
			ShowLine(str);
		}	
		return;
	}
	if(m_eventID)
		m_setStatus=AbiSetEvent(m_tmpBusEv);
	else
		m_setStatus=AbiSetQualify(m_tmpBusEv);
	if(ICE_OK==m_setStatus)
    {
    	m_nClearflag = 0;
    	m_strDisplay = "";
    	memcpy(&m_busEv,&m_tmpBusEv,sizeof(BUS_EVENT));
    	if(m_bFromShell)
    	{
    		if(m_eventID)
    			wsprintf(str,"Ev%1u is set successfully.", m_eventID);
	    	else
    			wsprintf(str,"Qualify is set successfully.");
    		ShowLine(str);
    	}
    	return ;
    }
    else if(m_bFromShell)
    {
    	DisplayErrorMessage(m_setStatus);
    }
    return ;
}
                    
//External Event.
CExtEvent::CExtEvent()
{
	m_bEv3Option=0;
	m_bFromShell=TRUE;
}

CExtEvent::~CExtEvent()
{
}

int CExtEvent::Init()
{                
    STATUS status;
        
    status = AbiGetEv3(&m_bEv3Option);
       
    if(ICE_OK == status)
		return TRUE;
	DisplayErrorMessage(status);
	return FALSE;
}
                     
//analyse shell command
void CExtEvent::ShellCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.                
    ASSERT( nArgc==1||nArgc==2);
    if(nArgc==1)
		ShowToShell();
	else
	{
		BYTE temp=BYTE(pszArgv[1][3]-'0');
		if(temp<0||temp>7)
			return;
		SetEv3(temp);
	}		
}
                       
//show extern event to shell                       
void CExtEvent::ShowToShell()
{
	char	msg[30];
	
	wsprintf(msg, "Ev3 is BIT%d", m_bEv3Option);
    ShowLine(msg);
    return;
}
                            
//set from shell
void CExtEvent::SetEv3(BYTE bit)
{
char str[50];
unsigned char cstatus;

    GetCpuStatus(cstatus);
	if(cstatus==STATUS_GO)				//CPU is run
	{
		m_setStatus=ICE_EP_RUNNING;
		if(m_bFromShell)
		{
			ErrGetErrorText(ER_GOFLY_ERR_MSG, str);
			ShowLine(str);
		}	
		return;
	}
                
    ASSERT(bit>=0&&bit<=7);
    m_setStatus=AbiSelectEv3(bit);
       
    if(ICE_OK==m_setStatus)
	{
		if(m_bFromShell)
		{
			ShowLine("EV3 is set successfully ");
		}	
		m_bEv3Option=bit;
	}	
	else if(m_bFromShell)
		DisplayErrorMessage(m_setStatus);
	return;
}
