/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/EVSVR.H__   1.13   13 Dec 1996 11:18:28   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/EVSVR.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:28   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:28   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:46   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:40   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:36   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:51:00   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:50   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:58   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:32   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:36:52   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:51:30   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:32:38   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:09:52   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:20:12   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : 	EVSVR.H
** Author: 		Chris Fang
** Description: head file of Event Server
**              Event Server: the server of ev1, ev2, ev3 and qualify
**
** coding from: June 14, 1996
** Finished date: 
**
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _EVSVR_H_
#define _EVSVR_H_

/***************************************************************************
**
**							INCLUDE	SECTION
**
****************************************************************************/
#include "abitype.h"

/***************************************************************************
**
**							INTERFACE ROUTINE SECTION
**
****************************************************************************/

void Ev1Cmd(int nArgc, char* pszArgv[]);
void Ev2Cmd(int nArgc, char* pszArgv[]);
void Ev3Cmd(int nArgc, char* pszArgv[]);
void EventCmd(int nArgc, char* pszArgv[]);
void QualifyCmd(int nArgc,char* pszArgv[]);

/***************************************************************************
**
**							DECLARE	SECTION
**Class: CBusEvent, CExtEvent, CQualify
**
****************************************************************************/

class CBusEvent
{
//member data
public:
    BUS_EVENT     m_busEv;
    BUS_EVENT     m_tmpBusEv;
    BYTE          m_eventID;            //0: qualify, 1: ev1, 2: ev2
    BOOL          m_nClearflag;         //1=clear
    CString       m_strDisplay;         //for display on shell
	STATUS		  m_setStatus;
	BOOL		  m_bFromShell;
	char * ArgPoint[35];
	int ArgMax;

//constructor
public:
    CBusEvent(BYTE nEventID);
    
    ~CBusEvent();

//member
//function          
private:                   
    void WildCardAddr(char *Input);
    void WildCardData(char *Input); 
    void SetAddr(int* indexhere);//analysis input for addr
    void SetData(int* indexhere);//analysis input for data
    void SetStatus(int* indexhere);//analysis input for status
public:               
    void ShellCmd(int nArgc, char* pszArgv[]);
    void ShowToShell();
    void Clear();
    void SetbyShell();
    int Init();
};

class CExtEvent
{
//member
public:
    BYTE         m_bEv3Option;          // 0~7: pin0~7
    STATUS		  m_setStatus;
	BOOL		  m_bFromShell;

//contructor
public:
    CExtEvent();
    ~CExtEvent();

//function
public:              
    void ShellCmd(int nArgc, char* pszArgv[]);
    void ShowToShell();
    void SetEv3(BYTE bit);
    int Init();
};

extern CBusEvent ev1,ev2;
extern CExtEvent ev3;

extern CBusEvent qlfy;

#endif
