
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/FLDDLG.CPP   1.13   13 Dec 1996 11:18:30   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/FLDDLG.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:30   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:28   ZJRD
** PIC/SLD Version 0.97
** 
**    Rev 1.11   11 Nov 1996 12:46:46   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:42   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:54   ZJRD
** PIC/SLD Version 0.94
** 
**    Rev 1.8   30 Oct 1996 12:49:10   ZJRD
** PIC/SLD Version 0.93
** 
**    Rev 1.7   28 Oct 1996 09:42:04   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:20   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:56   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.4   23 Sep 1996 10:33:16   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:47:10   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:28:14   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:06:32   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:34   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  FLDDLG.CPP
//
//  Description:The Implementation file of dialog box for Peripheral window
//
//  Author:     Jerry Yan
//
//  Date:       09/18/95
//
//  Modification:
//
//      1. 09/18/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"
#include "xview.h"
#include "flddlg.h"
#include "listcol.h"
#include "mylist.h"   
#include "spin.h"
#include "abibase.h"
#include "cpucom.h"
#include "cpuserve.h" 
#include "uicom.h"
#include "hosterrs.h"
//#include "errcodec.h"   

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
extern UINT cpuid; 
extern HINSTANCE hPerLib; 
//extern STATUS AbiGetOneReg(REG_ID,UINT*);
//extern STATUS AbiSetReg(REG_ID,UINT); 
extern STATUS AbiGetCpuId(UINT*);
extern  int Hex2Dec(char *); 
extern REGISTER RegVal[MAXRANGE];
extern int ITEMRANGE;   
extern int START_ID; 
extern int CheckString(CString string);
extern STATUS AbiSetReg(WORD iRegId, WORD uRegValue);   
extern STATUS AbiGetOneReg(WORD iRegId, WORD* cpuValue);     
extern int CpuIDToIndex(REG_ID reg_id);
CString strBitName[8],strBitValue[8];
#define  TWIPS_PER_INCH 1440
int ColWidth;                         
extern unsigned char gEPModule;
/////////////////////////////////////////////////////////////////////////////
// CFldDlg dialog




CFldDlg::CFldDlg(CWnd* pParent /*=NULL*/,int index)
    : CDialog(CFldDlg::IDD, pParent)
{   
     m_pParent=pParent; 
     m_nIndex=index;  
     m_nFldMax=1;
    //{{AFX_DATA_INIT(CFldDlg)
    m_nFldVal = "";
    m_RegVal = "";  
	//}}AFX_DATA_INIT

    
}

void CFldDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CFldDlg)
    DDX_Text(pDX, IDC_FIELD_VAL, m_nFldVal);
    DDX_Text(pDX, IDC_REG_VAL, m_RegVal);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFldDlg, CDialog)
    //{{AFX_MSG_MAP(CFldDlg)
    ON_LBN_SELCHANGE(IDC_FIELD_LIST, OnSelchangeFieldList)
    ON_BN_CLICKED(IDC_NEXT_BUTT, OnNextButt)
    ON_BN_CLICKED(IDC_PREV_BUTT, OnPrevButt)
    ON_BN_CLICKED(IDC_CLOSE_BUTT, OnCloseButt)
    ON_BN_CLICKED(IDC_WRI_BUTT, OnWriButt)
    ON_WM_VSCROLL()
	ON_EN_SETFOCUS(IDC_REG_VAL, OnSetfocusRegVal)
	ON_LBN_SETFOCUS(IDC_FIELD_LIST, OnSetfocusFieldList)
	ON_EN_SETFOCUS(IDC_FIELD_VAL, OnSetfocusFieldVal)
	ON_WM_DESTROY()
    ON_EN_KILLFOCUS(IDC_REG_VAL,OnRegValKillFocus)    
    ON_EN_KILLFOCUS(IDC_FIELD_VAL,OnFieldValKillFocus)  
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFldDlg message handlers

BOOL CFldDlg::OnInitDialog()
{
    CDialog::OnInitDialog();  
    
    CenterWindow();
    
  //SetWindowPlacement
    m_bCanClose=TRUE; 
    HFONT hFont;
    hFont=(HFONT)GetStockObject(ANSI_FIXED_FONT);
    CFont Font; 
    GetDlgItem(IDC_FIELD_LIST)->SetFont(Font.FromHandle(hFont));
//    GetDlgItem(IDC_RO_EDIT)->SetFont(Font.FromHandle(hFont));
    ((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->SetHorizontalExtent(1400);   
    
    
    char szBuff[256]="";
    char sztemp[256]="";
    DWORD dw,regdata;
    int reg_index;           
    
    PERI_DRAWDATA* lpDrawData;    
    lpDrawData=(PERI_DRAWDATA*)(((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemDataPtr(m_nIndex) ); 
    
//bitplace is the offset of the place of selected item in current selected register.	
    int bitplace=lpDrawData->offset; //LOBYTE( LOWORD(dw) );

//reg_index is the first place of the selected register in the listbox.
    reg_index=m_nIndex-bitplace;   //LOBYTE( LOWORD(dw) );   
    
    lpDrawData=(PERI_DRAWDATA*)(((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemDataPtr(reg_index));
    ::LoadString(hPerLib,lpDrawData->StringID,sztemp,127); 
    SetWindowText(sztemp);
    
//m_nRegid is the selected register id of this cpu.
    m_nRegid=lpDrawData->Index;//HIBYTE(LOWORD(dw));   
    
    
    //SET register value
    m_nRegVal=RegVal[m_nRegid].value;

    SetDlgList(m_nRegid);   
    GridInit(m_nRegid);
    
    if (bitplace) 
         bitplace=bitplace-1;
    else bitplace=0;
    ((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->SetCurSel(bitplace);
    SetEdit(bitplace);      
    
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFldDlg::OnSelchangeFieldList()
{   
    int  cursel;                                                    
    // set field value      
    cursel=((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->GetCurSel();      
    
    SetEdit(cursel);
    
}







void CFldDlg::OnNextButt()
{      
    m_bCanClose=TRUE;
    m_nRegid=(m_nRegid+1)%ITEMRANGE; 
    PERI_DRAWDATA *lpDrawData;    
    // change m_nIndex;
 
    int count;
    count=((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetCount();
    m_nIndex=(m_nIndex+1)%count; 
    lpDrawData=(PERI_DRAWDATA*)(((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemDataPtr(m_nIndex)); 
    while(lpDrawData->isBit) // dw&(0x0ff))
    { 
      m_nIndex=(m_nIndex+1)%count;
      lpDrawData=(PERI_DRAWDATA*)(((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemDataPtr(m_nIndex)); 
      
     }
    /////////////////////////////////////////////////////////////////// 
    
    char sztemp[128];    
    ::LoadString(hPerLib,m_nRegid*PERI_REGISTER_INTERVAL+START_ID,sztemp,127);  
    SetWindowText(sztemp);
    m_nRegVal=RegVal[m_nRegid].value;

    SetDlgList(m_nRegid); 
    GridInit(m_nRegid); 
    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->SetCurSel(0);
    SetEdit(0); 
}
             
             
void CFldDlg::SetDlgList(int regid)
{ 
    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->ResetContent();
    int i;
    int Noteid=START_ID+PERI_REGISTER_INTERVAL*regid;
    int Addrid;                                     
    int regval,regvaltemp; 
    
    if( gEPModule==0 )
        Addrid=START_ID+PERI_5X_INTERVAL+regid;
    else
        Addrid=START_ID+PERI_6X_INTERVAL+regid;
        
         
 //   regval=RegVal[regid].value;                                
 //   m_nRegVal=regval;
    regval=m_nRegVal;                            
    char sztemp[256]; 
    if(regval<=0x0f)
    	sprintf(m_RegVal.GetBuffer(7),"0x0%X",regval);
    else	
    	sprintf(m_RegVal.GetBuffer(7),"0x%X",regval);	
    UpdateData(FALSE); 
    m_RegVal.ReleaseBuffer();

    
    ::LoadString(hPerLib,Addrid,sztemp,255); 
    
    //set field listbox        
    char *szaddr;
    szaddr=strtok(sztemp,",");  
    szaddr=strtok(NULL,",");
    
    char szBuff[256]="";
    int len,curid,power=1;
    int n,m=0; 
    int id=Noteid;
    while( szaddr)
    {  
       n=0;                       
       id++;
       curid=id;

       len=strlen(szaddr);   
       power=1;
       regvaltemp=regval>>(atoi(szaddr));
       for(i=0;i<(len+1)/2;i++)
          { 
            n+=((regvaltemp&(0x1))<<i);
            regvaltemp=regvaltemp>>1;
            power=power*2;
            
           }                        
       regvaltemp=regval ; 
       
       if(strstr(RegName[CpuIDToIndex(RegVal[regid].id)],"FSR")==NULL||m!=0 )                                
//       if(!(regid==10&&m==0))
         id=id+power;    

//////////////////////////////////////////////////////////////////           
//       if(!(regid==10&&m==0))
       if(strstr(RegName[CpuIDToIndex(RegVal[regid].id)],"FSR")==NULL||m!=0 )                                
       	  ::LoadString(hPerLib,curid+1+n,szBuff,255); 
       else
       	  ::LoadString(hPerLib,curid,szBuff,255); 
       ((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->AddString(szBuff); 
       DWORD d=0;
       d=curid;  
       d=d<<16;
       d=d+Addrid;      
       ((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->SetItemData( m,d);
       szaddr=strtok(NULL,",");  
       m++;
     }  
          
}             


void CFldDlg::SetEdit(int cursel)
{                               
    DWORD dw;
    char sztemp[256]="";
    dw=((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->GetItemData(cursel);
    ::LoadString(hPerLib,LOWORD(dw),sztemp,31); 
    
    int i;
    char *addr; 
    addr=strtok(sztemp,",");  
    
    for (i=0;i<=cursel;i++)
        addr=strtok(NULL,",");
    
    int len;
    len=(strlen(addr)+1)/2    ;
    
    char q[2];
    q[0]=addr[0]; 
    
    int regval=m_nRegVal;
    regval=regval>>atoi(q);
    
    int n=0,power=1;       
    m_nFldMax=1;
    for (i=0;i<len;i++)
        {
         
         n+= (regval&0x1)*power;
         regval=regval>>1; 
         m_nFldMax*=2;
         power=power*2;
         }
    
////////////////////////////////////////////////////////////////////
    ((CSpinControl*)GetDlgItem(1995))->SetRange(0,m_nFldMax);   
    
/////////////////////////////////////////////////////////////////////   
    if(n<=0x0f)
	    sprintf(m_nFldVal.GetBuffer(7),"0x0%X",n);
    else
     	sprintf(m_nFldVal.GetBuffer(7),"0x%X",n);

    UpdateData(FALSE);
    m_nFldVal.ReleaseBuffer();
    //set notes 
    char szBuff[256]="";
    int nLen=strlen(addr);
    szBuff[0]=addr[0];
    if(nLen>2)
    {
      szBuff[1]='-';
      szBuff[2]=addr[nLen-1];
      szBuff[3]=':';
    }  
    else szBuff[1]=':';
    ////////////////////////////////////////////////////
    GetDlgItem(IDC_RO_EDIT0)->SetWindowText(szBuff);
////////////////////////////////////////////////////////    
    ::LoadString(hPerLib,HIWORD(dw),sztemp,255); 
    
    strncpy(szBuff,&sztemp[10],127);
    len=strlen(szBuff);
    
   
    GetDlgItem(IDC_RO_EDIT1)->SetWindowText(szBuff);
//  ret=pdc->ExtTextOut(0,0,ETO_CLIPPED,&rect,szBuff,len,NULL);
  
    ::LoadString(hPerLib,HIWORD(dw)+n+1,sztemp,255);  
    strncpy(szBuff,&sztemp[10],128);   
    SetDlgItemText(IDC_RO_EDIT2,szBuff); 
    SetGrid(m_nRegVal);
}              



void CFldDlg::OnPrevButt()
{
    m_bCanClose=TRUE;
    if(m_nRegid==0)
       m_nRegid=ITEMRANGE-1;
    else   
       m_nRegid=m_nRegid-1; 
    char sztemp[128]   ;
    ::LoadString(hPerLib,m_nRegid*PERI_REGISTER_INTERVAL+START_ID,sztemp,127);  
    SetWindowText(sztemp);   
    PERI_DRAWDATA* lpDrawData;
    // change m_nIndex;
    if(m_nIndex<=0)    
    {
      lpDrawData=(PERI_DRAWDATA*)(((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemDataPtr(m_nIndex)); 
      m_nIndex=m_nIndex-(int)(lpDrawData->offset)-1; 
      if(m_nIndex<0)  
      	  m_nIndex=((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetCount()-1;
    }
    else
      m_nIndex=((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetCount()-1;
    
    lpDrawData=(PERI_DRAWDATA*)(((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemDataPtr(m_nIndex)); 
    m_nIndex=m_nIndex-(int)(lpDrawData->offset);
    
    ///////////////////////////////////////////////////////////////////
    m_nRegVal=RegVal[m_nRegid].value;

    SetDlgList(m_nRegid); 
    GridInit(m_nRegid);
    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->SetCurSel(0);
    SetEdit(0);
}



void CFldDlg::OnCloseButt()
{
      m_bCanClose=TRUE;
  //  if(m_bCanClose)
      CDialog::OnCancel();
 
}



void CFldDlg::OnWriButt()
{
    int regval;                            
    if(GetFocus()!=GetDlgItem(IDC_WRI_BUTT) )
       GetDlgItem(IDC_WRI_BUTT)->SetFocus();
    if(m_bCanClose)                          
     {
    	
    	regval=Hex2Dec(m_RegVal.GetBuffer(7));
    	RegVal[m_nRegid].value=regval; 
////////////////////////////////////////////////////////////
	   	AbiSetReg((WORD)RegVal[m_nRegid].id,(WORD)RegVal[m_nRegid].value); 
   		AbiGetOneReg((WORD)RegVal[m_nRegid].id,(WORD*)&(RegVal[m_nRegid].value));
   		RegValue[RegVal[m_nRegid].id]=RegVal[m_nRegid].value;
//////////////////////////////////////////////////////////////
    	regval=RegVal[m_nRegid].value; 
    	if(regval<=0x0f)                              
    	    sprintf(m_RegVal.GetBuffer(7),"0x0%X",regval);
    	else
    		sprintf(m_RegVal.GetBuffer(7),"0x%X",regval);
    	UpdateData(FALSE); 
    	m_RegVal.ReleaseBuffer(); 
    
    	PERI_DRAWDATA* lpDrawData;
    	lpDrawData=(PERI_DRAWDATA*)(((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemDataPtr(m_nIndex)); 
    	int reg_index; 
    	reg_index=m_nIndex-(int)(lpDrawData->offset);
	         
	    PERI_DRAWDATA* lpData;
	    lpData=(PERI_DRAWDATA*)(((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemDataPtr(reg_index) );
	    lpData->chVal=(char)(regval);
	    ((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->DeleteString(reg_index);
    	((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->InsertString(reg_index,(LPSTR)lpData) ;
    	((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->SetItemDataPtr(reg_index,lpData);
    	if( lpData->isExpanded) 
    	{
//        	lpData=((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemDataPtr(reg_index);
        	((CMyList*)(m_pParent->GetDlgItem(IDC_LIST1)))->DeleteBitItem(reg_index,lpData);
        	((CMyList*)(m_pParent->GetDlgItem(IDC_LIST1)))->InsertBitItem(reg_index,lpData);    
    	}  
    
    	RepaintCPU();
		RepaintMemory();
//		RepaintBMemory();
	
		RepaintStack();
		RepaintVariable(); 
    	CDialog::OnOK(); 
   	   }
//   	   else
//   	   {  
//            AfxMessageBox("Your input is not valible!",MB_OK);
//        }
   	m_bCanClose=TRUE;    
}


void CFldDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    int fldval; 
    int regval;
    int sign; 
    char Buff[8]="";  
    char sztemp[256];
    
    if(pScrollBar==(CScrollBar*)GetDlgItem(1995))
    {
       if(nSBCode==SB_LINEUP)
       {
      	 sign=Hex2Dec(m_nFldVal.GetBuffer(7))    ;
    	 fldval=(sign+1)%m_nFldMax; 
    	 sign=fldval-sign;
         if(fldval<=0x0f)
            sprintf(m_nFldVal.GetBuffer(7),"0x0%X",fldval);
         else                                             
         	sprintf(m_nFldVal.GetBuffer(7),"0x%X",fldval);
    	 UpdateData(FALSE);   
         GetDlgItemText(IDC_RO_EDIT0,Buff,7);
    	 char* token;
    	 token=strtok(Buff,":");
         regval=Hex2Dec(m_RegVal.GetBuffer(7));
    	 m_RegVal.ReleaseBuffer();
    	 if(sign>0)
        	regval+=(abs(sign)<< atoi(token));
    	 else regval-=(abs(sign)<< atoi(token)); 
    
    	 m_nRegVal=regval;
    	 if(regval<=0x0f)
			sprintf(m_RegVal.GetBuffer(7),"0x0%X",regval);    	 
    	 else
    	    sprintf(m_RegVal.GetBuffer(7),"0x%X",regval);
    	 UpdateData(FALSE);
    	 m_RegVal.ReleaseBuffer(); 
////////////////////////////////////////   
    //SendMessage(WM_COMMAND,IDC_FIELD_VAL, MAKELONG(GetDlgItem(IDC_FIELD_VAL)->m_hWnd,EN_CHANGE));
       }  
       else
       {
         sign=Hex2Dec(m_nFldVal.GetBuffer(7));  
         if(sign==0)
            fldval=m_nFldMax-1;
         else   
            fldval=(abs(sign-1))%m_nFldMax;          
    	 sign=fldval-sign;
         if(fldval<=0x0f)
            sprintf(m_nFldVal.GetBuffer(7),"0x0%X",fldval);
         else
          	sprintf(m_nFldVal.GetBuffer(7),"0x%X",fldval);   
    	 UpdateData(FALSE);  
         GetDlgItemText(IDC_RO_EDIT0,Buff,7);
    	 char* token;
    	 token=strtok(Buff,":");
         regval=Hex2Dec(m_RegVal.GetBuffer(7)); 
    	 m_RegVal.ReleaseBuffer();
    	 if(sign>0)
        	regval+=(abs(sign)<< atoi(token));
    	 else regval-=(abs(sign)<< atoi(token));
    	 m_nRegVal=regval;
   		 if(regval<=0x0f)
   		   	sprintf(m_RegVal.GetBuffer(7),"0x0%X",regval);
   		 else
   		 	sprintf(m_RegVal.GetBuffer(7),"0x%X",regval);
    	 UpdateData(FALSE); 
   		 m_RegVal.ReleaseBuffer(); 
    
    //SendMessage(WM_COMMAND,IDC_FIELD_VAL, MAKELONG(GetDlgItem(IDC_FIELD_VAL)->m_hWnd,EN_CHANGE));
        }      
  	    SetGrid(regval); 
        int cursel;
	    cursel=((CListBox*)GetDlgItem(IDC_FIELD_LIST))->GetCurSel();
        DWORD dw;
    	dw=((CListBox*)GetDlgItem(IDC_FIELD_LIST))->GetItemData(cursel);
//modify for FSR    
		if(strstr(RegName[CpuIDToIndex(RegVal[m_nRegid].id)],"FSR")!=NULL&&cursel==0 )   
    		::LoadString(hPerLib,HIWORD(dw),sztemp,255);
    	else	
    		::LoadString(hPerLib,HIWORD(dw)+1+fldval,sztemp,255);
    	m_nFldVal.ReleaseBuffer();
    	((CListBox*)GetDlgItem(IDC_FIELD_LIST))->InsertString(cursel,sztemp);
    	((CListBox*)GetDlgItem(IDC_FIELD_LIST))->DeleteString(cursel+1);
	    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->SetItemData(cursel,dw); 
    	((CListBox*)GetDlgItem(IDC_FIELD_LIST))->SetCurSel(cursel);

    	char szBuff[256]="";
        strncpy(szBuff,&sztemp[10],128);   
   		SetDlgItemText(IDC_RO_EDIT2,szBuff);
   }   
  ///////////////////////////////////////////////////
    CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
} 


void CFldDlg::GridInit(int regid)
{ 
	int j, i,nCol=0;
	char sztemp[64]="";
	char Buffer[256]="";
	char buf[16]="";              
	char tem[8]="";
	int Addrid;
	if( gEPModule==0)
        Addrid=START_ID+PERI_5X_INTERVAL+regid;
    else
        Addrid=START_ID+PERI_6X_INTERVAL+regid;	   
        
	::LoadString(hPerLib,Addrid,sztemp,255); 
	char *szaddr;
	int len,n,count=0; 
	szaddr=strtok(sztemp,",");  
	for(i=0;i<8;i++){
	    strBitName[i]='\0';
        strBitValue[i]='\0';
     }    	       
	while(nCol<8)
	 {   
		szaddr=strtok(NULL,","); 
		if(szaddr!=NULL)
		{
		    len=strlen(szaddr); 
		    nCol=atoi(szaddr);
		    if( (len==1) )
		    {
     		    ((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->GetText(count,Buffer); 
			    strncpy(buf,Buffer,7);
				int c=0;
				while(buf[c]!=' ') c++;
//				ASSERT(c<7);
				buf[c]=0;             
				strBitName[nCol]=buf;
//				strBitName[nCol].ReleaseBuffer();
				nCol++;             
				
			 }
			 else
			 { 			 		  	
			        j=0;
			 	 	n=(len+1)/2;
			 	 	((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->GetText(count,Buffer); 
			   		strncpy(buf,Buffer,15);
			   		while (buf[j]!='-'&&buf[j]!=0) j++;
			   		if(!buf[j])
			   		{   j=0;
			   			while(buf[j]!=':'&&buf[j]!=0) j++;
			   			strncpy(tem,buf,j);tem[j]=0;	
				   		strBitName[nCol]=tem;
			 		    nCol++;
			 		    memset(tem,0,8);                         
			 		    strncpy(tem,&buf[j+1],j);
			 		    strBitName[nCol]=tem;
			 		    nCol++;
			   		}
			   		else
			   		{	    
			   			strncpy(tem,buf,j);	
			   			for(i=0;i<n;i++)
			   			{	
					   		if(buf[j-1]=='0')       //added on 18/Jan.
    				   		  tem[j-1]=( '0' + i); 
					   		else
					   		  tem[j-1]=(buf[j-1]+i);
					   		tem[j]=0;
				   			strBitName[nCol]=tem;
				 		    nCol++;
				 		  }  
				 	}	  
		      }    
	    }     
		else break;		
		count++;		       		
	 }	
}
                 
                 
                 
                 
                 
void CFldDlg::SetGrid(int regvalue)
{
    int nCol;  
    int n;
	for ( nCol = 0; nCol < 8; nCol++)
	{   
       n=regvalue%2;
       regvalue=regvalue>>1;
       strBitValue[nCol]=n?'1':'0';
 	}            
 	CRect rect;
    GetClientRect(&rect);
    rect.top=m_GridRect.top;
    rect.bottom=m_GridRect.bottom+2;
    InvalidateRect(&rect,TRUE );
// 	Invalidate(TRUE);
 	UpdateWindow();
}


void CFldDlg::OnRegValKillFocus()
{
    int tem, cursel;
    tem=m_nRegVal;  
    
    cursel=((CListBox*)GetDlgItem(IDC_FIELD_LIST))->GetCurSel();    
    UpdateData(TRUE); 
    AnsiUpper(m_RegVal.GetBuffer(7)); 
    m_RegVal.ReleaseBuffer(); 
    int bCheckStr=CheckString(m_RegVal);
    if(!bCheckStr )  
    {
          m_bCanClose=FALSE;
//        AfxMessageBox("Your input is not valible!",MB_OK);
		  ErrDisplayError(ER_PRE_INVALID_INPUT);           
       	  if(tem<=0x0f)
       	  	sprintf(m_RegVal.GetBuffer(7),"0x0%X",tem);
       	  else
       	  	sprintf(m_RegVal.GetBuffer(7),"0x%X",tem);	
          UpdateData(FALSE);
           // GetFocus()->PostMessage(WM_LBUTTONUP); 
          GetDlgItem(IDC_FIELD_LIST)->PostMessage(WM_LBUTTONDOWN);
          GetDlgItem(IDC_FIELD_LIST)->PostMessage(WM_LBUTTONUP); 

     } 
     else
     {
          if(bCheckStr==2)
          {   
              int regtemp=atoi( m_RegVal.GetBuffer(7) );
              if(regtemp>255)
		      {
		          m_bCanClose=FALSE;
//        AfxMessageBox("Your input is not valible!",MB_OK);
				  ErrDisplayError(ER_PRE_INVALID_INPUT);           
       			  if(tem<=0x0f)
       	  			sprintf(m_RegVal.GetBuffer(7),"0x0%X",tem);
       	  		  else
       	  			sprintf(m_RegVal.GetBuffer(7),"0x%X",tem);	
          		  UpdateData(FALSE);
           // GetFocus()->PostMessage(WM_LBUTTONUP); 
          		  GetDlgItem(IDC_FIELD_LIST)->PostMessage(WM_LBUTTONDOWN);
          		  GetDlgItem(IDC_FIELD_LIST)->PostMessage(WM_LBUTTONUP); 
             	  return ;	
              }
              else
              
                 m_nRegVal=regtemp;
              
          }	  	
          else
    	     m_nRegVal=Hex2Dec(m_RegVal.GetBuffer(7));
    	  m_RegVal.ReleaseBuffer();

    	  UpdateData(FALSE);
    	  if(tem!=m_nRegVal)
   		   {
    			SetDlgList(m_nRegid); 
//   				GridInit(m_nRegid); 
       			((CListBox*)GetDlgItem(IDC_FIELD_LIST))->SetCurSel(cursel);
   	    		SetEdit(cursel); 
   		    }          
   	 }
}   


void CFldDlg::OnFieldValKillFocus()
{
	int  cursel;
    CString tem;
    tem=m_nFldVal;  
    
    cursel=((CListBox*)GetDlgItem(IDC_FIELD_LIST))->GetCurSel();    
    UpdateData(TRUE); 
    AnsiUpper(m_nFldVal.GetBuffer(16)); 
    m_nFldVal.ReleaseBuffer(); 
    int tint=Hex2Dec(m_nFldVal.GetBuffer(7));
    m_nFldVal.ReleaseBuffer();
    if(!(CheckString(m_nFldVal)&&(tint<m_nFldMax)) )  
      {
          m_bCanClose=FALSE;
//        AfxMessageBox("Your input is not valible!",MB_OK);
          ErrDisplayError(ER_PRE_INVALID_INPUT);  
          m_nFldVal=tem;
          UpdateData(FALSE);            
           
           //GetFocus()->SetCapture();
            GetDlgItem(IDC_FIELD_LIST)->PostMessage(WM_LBUTTONDOWN); 
            GetDlgItem(IDC_FIELD_LIST)->PostMessage(WM_LBUTTONUP); 

      } 
    
    else
     {
       if( tint>=m_nFldMax) 
        {
            m_bCanClose=FALSE;
            ErrDisplayError(ER_PRE_VALUE_TOO_LARGE);
            m_nFldVal=tem;
            UpdateData(FALSE);
           //GetFocus()->PostMessage(WM_LBUTTONUP);
            GetDlgItem(IDC_FIELD_LIST)->PostMessage(WM_LBUTTONDOWN);
            GetDlgItem(IDC_FIELD_LIST)->PostMessage(WM_LBUTTONUP); 
         }  
       else
         {
    		UpdateData(FALSE);
    	//	OnChangeFieldVal();
        	char Buff[8];
    		GetDlgItemText(IDC_RO_EDIT0,Buff,7);
    		char* token;
    		token=strtok(Buff,":");
            int regval,sign;
            sign=Hex2Dec(m_nFldVal.GetBuffer(7))-Hex2Dec(tem.GetBuffer(7));
    		m_nFldVal.ReleaseBuffer();
    		tem.ReleaseBuffer(); 
            regval=Hex2Dec(m_RegVal.GetBuffer(7)); 
   		    m_RegVal.ReleaseBuffer();
   			if(sign>0)
      		 	regval+=(abs(sign)<< atoi(token));
   			else regval-=(abs(sign)<< atoi(token));
   			m_nRegVal=regval;
   			if(regval<=0x0f)
   				sprintf(m_RegVal.GetBuffer(7),"0x0%X",regval);
   			else	
   				sprintf(m_RegVal.GetBuffer(7),"0x%X",regval);
    		UpdateData(FALSE); 
   			m_RegVal.ReleaseBuffer(); 
  	        SetGrid(m_nRegVal);	  
   		  }	
      } 
    char sztemp[256];
    cursel=((CListBox*)GetDlgItem(IDC_FIELD_LIST))->GetCurSel();
    DWORD dw;
    dw=((CListBox*)GetDlgItem(IDC_FIELD_LIST))->GetItemData(cursel);
//modify for FSR
    if(strstr(RegName[CpuIDToIndex(RegVal[m_nRegid].id)],"FSR")!=NULL&&cursel==0 )
    	::LoadString(hPerLib,HIWORD(dw),sztemp,255);
    else	
    	::LoadString(hPerLib,HIWORD(dw)+1+Hex2Dec(m_nFldVal.GetBuffer(7)),sztemp,255);
    m_nFldVal.ReleaseBuffer();
    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->InsertString(cursel,sztemp);
    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->DeleteString(cursel+1);
   
    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->SetItemData(cursel,dw); 
    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->SetCurSel(cursel);

    char szBuff[256]="";
    strncpy(szBuff,&sztemp[10],128);   
    SetDlgItemText(IDC_RO_EDIT2,szBuff);
}				         

void CFldDlg::OnSetfocusRegVal()
{
	m_bCanClose=TRUE;
}

void CFldDlg::OnSetfocusFieldList()
{
	m_bCanClose=TRUE;
}

void CFldDlg::OnSetfocusFieldVal()
{
  m_bCanClose=TRUE;
}

void CFldDlg::OnDestroy()
{
	(m_pParent->GetDlgItem(IDC_LIST1) )->SendMessage(WM_LBUTTONDOWN); 
   (m_pParent->GetDlgItem(IDC_LIST1) )->SendMessage(WM_LBUTTONUP);
   ((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->SetCurSel(m_nIndex);
  
	CDialog::OnDestroy();
}




void CFldDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
    dc.SetBkMode(TRANSPARENT);
    int org_x,org_y,end_x,end_y;
    CRect ClientRect;
    GetClientRect(&ClientRect);
    org_x=ClientRect.Width()/8+10;
    org_y=65+10;             
    end_x=ClientRect.Width()-org_x;
    CSize size=dc.GetOutputTextExtent("II",2);
	end_y=org_y+(2+size.cy)*2+1;  
    m_DefCellSize.cx=(end_x-org_x-7)/8;
	m_DefCellSize.cy=size.cy+1;    	
	m_GridRect.SetRect(org_x,org_y,end_x,end_y);
//////////////////////////////////////////////////////////////////
	CaluGridRect( &dc);
    GridSetName(&dc); 
    DrawFrame(&dc,m_GridRect,0);
    m_GridRect.InflateRect(1,1);
	DrawFrame(&dc,m_GridRect,1);

//	3D style of the control.
	CRect rect;
	GetDlgItem(IDC_STATIC_REGISTER)->GetWindowRect(&rect);
	ScreenToClient(&rect);
	rect.InflateRect(1,1);
	DrawFrame(&dc,rect,1);

	GetDlgItem(IDC_STATIC_FIELD)->GetWindowRect(&rect);	
	ScreenToClient(&rect);
	rect.InflateRect(1,1);
	DrawFrame(&dc,rect,1);

	GetDlgItem(IDC_STATIC_FIELDVALUE)->GetWindowRect(&rect);	
	ScreenToClient(&rect);
	rect.InflateRect(1,1);
	DrawFrame(&dc,rect,1);

	GetDlgItem(IDC_RO_EDIT0)->GetWindowRect(&rect);
	ScreenToClient(&rect);
	rect.InflateRect(1,1);
	DrawFrame(&dc,rect,1);

	GetDlgItem(IDC_RO_EDIT1)->GetWindowRect(&rect);	
	CRect rect1;                                    
	GetDlgItem(IDC_RO_EDIT2)->GetWindowRect(&rect1);
	rect=rect|rect1;
	ScreenToClient(&rect);
	rect.InflateRect(1,1);
	DrawFrame(&dc,rect,0);
	// Do not call CDialog::OnPaint() for painting messages
}


void CFldDlg::CaluGridRect(CDC* pDC)
{
	int i,nLen; 
	CSize size;
	for(i=0;i<8;i++){
	  nLen=strBitName[i].GetLength() ;   
	  size=pDC->GetOutputTextExtent(strBitName[i].GetBuffer(nLen+1),nLen);
	  strBitName[i].ReleaseBuffer();
	  if(size.cx>m_DefCellSize.cx+1){
	    m_GridRect.OffsetRect(-(size.cx-m_DefCellSize.cx)/2,0);
	    m_GridRect.right+=size.cx-m_DefCellSize.cx+2;
	    m_nAbnormal[i]=size.cx+2;
	  }
	  else                     
	    m_nAbnormal[i]=0;
	} 
	 
} 

void CFldDlg::DrawFrame(CDC * pdc, CRect rect,UINT flag)
{
    
//	ScreenToClient(&rect);
//	rect.InflateRect(1,1);
	    
    CPen* pOldPen,*pPen=new CPen;
//    pPen->CreatePen(PS_SOLID, 1,RGB(0,0,0) );
    CPoint points[4];   
    if(flag==0){
        points[0]=CPoint(rect.left,rect.bottom);
    	points[1]=CPoint(rect.left,rect.top);
    	points[2]=CPoint(rect.right,rect.top);
    	points[3]=CPoint(rect.right,rect.bottom); 
     }
    else{ 	
        points[0]=CPoint(rect.left,rect.bottom);
    	points[1]=CPoint(rect.right,rect.bottom); 
    	points[2]=CPoint(rect.right,rect.top);
    	points[3]=CPoint(rect.left,rect.top);
     }
//    pOldPen=pdc->SelectObject(pPen); 
    pdc->MoveTo(points[0]);
 	pdc->LineTo(points[1]);
 	pdc->LineTo(points[2]);
    pPen->DeleteObject();
       
    pPen->CreatePen(PS_SOLID,1,RGB(255,255,255) );
    pOldPen=pdc->SelectObject(pPen);
 	pdc->LineTo(points[3]);
 	pdc->LineTo(points[0]);
    pdc->SelectObject(pOldPen);
    pPen->DeleteObject();
    delete pPen;
}    

// Modified by Gates Hua
/*
void CFldDlg::GridSetName(CDC* pDC)
{
	CRect CellRect; 
	CPen *pOldPen;

	int i,nLeft=m_GridRect.TopLeft().x,nRight,nLen ;
	nRight=nLeft;
	for(i=0;i<8;i++){
	  if(m_nAbnormal[i]==0){
	      nRight+=m_DefCellSize.cx;
          CellRect.SetRect(nLeft,m_GridRect.top,nRight,
                           m_GridRect.top+m_DefCellSize.cy); 		 	  
          nLeft+=m_DefCellSize.cx;nLeft++;nRight++; 
      }
      else{
        nRight+=m_nAbnormal[i];  
        CellRect.SetRect(nLeft,m_GridRect.top,nRight,
                       m_GridRect.top+m_DefCellSize.cy); 		 	  
        nLeft+=m_nAbnormal[i];nLeft++;nRight++; 
      } 
      if(i!=7){
         pDC->MoveTo(nRight,m_GridRect.top);  
         pDC->LineTo(nRight,m_GridRect.bottom);
         pOldPen=(CPen*)pDC->SelectStockObject(WHITE_PEN);
         pDC->MoveTo(nRight+1,m_GridRect.top);  
         pDC->LineTo(nRight+1,m_GridRect.bottom);
         pDC->SelectObject(pOldPen);
      }
      nLen= strBitName[i].GetLength();
      pDC->DrawText(strBitName[i].GetBuffer(nLen+1),nLen,&CellRect,
                    DT_CENTER);
      strBitName[i].ReleaseBuffer();
      CellRect.OffsetRect(0,m_DefCellSize.cy);
      nLen= strBitValue[i].GetLength();
      pDC->DrawText(strBitValue[i].GetBuffer(nLen+1),nLen,&CellRect,
                    DT_CENTER);     
      strBitValue[i].ReleaseBuffer();                    
    } 
    pDC->MoveTo(m_GridRect.right,(m_GridRect.bottom+m_GridRect.top)/2);
	pDC->LineTo(m_GridRect.left, (m_GridRect.bottom+m_GridRect.top)/2);
    pOldPen=(CPen*)pDC->SelectStockObject(WHITE_PEN);
    pDC->MoveTo(m_GridRect.right,(m_GridRect.bottom+m_GridRect.top)/2+1);
	pDC->LineTo(m_GridRect.left, (m_GridRect.bottom+m_GridRect.top)/2+1);
    pDC->SelectObject(pOldPen);
}
*/
void CFldDlg::GridSetName(CDC* pDC)
{
	CRect CellRect; 
	CPen *pOldPen;

	int i,nLeft=m_GridRect.TopLeft().x,nRight,nLen ;
	nRight=nLeft;
	for(i=7;i>=0;i--){
	  if(m_nAbnormal[i]==0){
	      nRight+=m_DefCellSize.cx;
          CellRect.SetRect(nLeft,m_GridRect.top,nRight,
                           m_GridRect.top+m_DefCellSize.cy); 		 	  
          nLeft+=m_DefCellSize.cx;nLeft++;nRight++; 
      }
      else{
        nRight+=m_nAbnormal[i];  
        CellRect.SetRect(nLeft,m_GridRect.top,nRight,
                       m_GridRect.top+m_DefCellSize.cy); 		 	  
        nLeft+=m_nAbnormal[i];nLeft++;nRight++; 
      } 
      if(i!=0){
         pDC->MoveTo(nRight,m_GridRect.top);  
         pDC->LineTo(nRight,m_GridRect.bottom);
         pOldPen=(CPen*)pDC->SelectStockObject(WHITE_PEN);
         pDC->MoveTo(nRight+1,m_GridRect.top);  
         pDC->LineTo(nRight+1,m_GridRect.bottom);
         pDC->SelectObject(pOldPen);
      }
      nLen= strBitName[i].GetLength();
      pDC->DrawText(strBitName[i].GetBuffer(nLen+1),nLen,&CellRect,
                    DT_CENTER);
      strBitName[i].ReleaseBuffer();
      CellRect.OffsetRect(0,m_DefCellSize.cy);
      nLen= strBitValue[i].GetLength();
      pDC->DrawText(strBitValue[i].GetBuffer(nLen+1),nLen,&CellRect,
                    DT_CENTER);     
      strBitValue[i].ReleaseBuffer();                    
    } 
    pDC->MoveTo(m_GridRect.right,(m_GridRect.bottom+m_GridRect.top)/2);
	pDC->LineTo(m_GridRect.left, (m_GridRect.bottom+m_GridRect.top)/2);
    pOldPen=(CPen*)pDC->SelectStockObject(WHITE_PEN);
    pDC->MoveTo(m_GridRect.right,(m_GridRect.bottom+m_GridRect.top)/2+1);
	pDC->LineTo(m_GridRect.left, (m_GridRect.bottom+m_GridRect.top)/2+1);
    pDC->SelectObject(pOldPen);
}
