
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/FMTSYM.H__   1.13   13 Dec 1996 11:18:32   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/FMTSYM.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:32   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:32   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:50   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:44   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:02   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:24   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:12   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:26   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:00   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:40   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:04   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:10   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:36   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:40   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:   Fmtsym.h
**
**  Description:  Describe the class of CFormatSymbol. The sub class deprived
**                from the class CFormatString. This class process the symbol
**                The symbol format is:
**                   #ModuleName:#SymbolName
**
**  Status:       Initialization
**                1996/02/16                    Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef __FMTSYM__H
#define __FMTSYM__H

class CFormatSymbol : public CFormatString
{
   private:
      CString  m_strOriginSymbol;   // Oringinal symbol string as the format
                                    // #ModuleName:#SymbolName
      CString  m_strModule;         // The module name
      CString  m_strSymbol;         // The symbol name
      DWORD    m_dwData;            // Converted address data
      unsigned char m_uchType;      // Segment space type
      
   public:
      UINT     m_uSymData;          // 0 -- Symbol
                                    // 1 -- Symbol Data   
      
      // Constructor
      CFormatSymbol(const CString& str);
      CFormatSymbol(const char* lpsz);

      //Implementation
      virtual  void Convert();      // Process the convert   
      
      CString  GetModuleName()      // Return the module name
      {
         return m_strModule;
      };
      
      CString  GetSymbolName()      // Return the symbol name
      {
         return m_strSymbol;
      };
      
      DWORD    GetAddress()            // Return the symbol data
      {
         return m_dwData;
      };
      
      unsigned char GetSpace()      // Return the space type
      {
         return m_uchType;
      };
};

#endif

//////////////////////////////////(EOF)///////////////////////////////////////
