 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/GRASCIVW.CPP   1.11   13 Dec 1996 11:18:32   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/GRASCIVW.CPP  $
** 
**    Rev 1.11   13 Dec 1996 11:18:32   ZJRD
** PIC/SLD Version 0.98
** 
**    Rev 1.10   22 Nov 1996 10:59:32   ZJRD
** No change.
** 
**    Rev 1.9   11 Nov 1996 12:46:50   ZJRD
** No change.
** 
**    Rev 1.8   06 Nov 1996 12:58:46   ZJRD
** No change.
** 
**    Rev 1.7   02 Nov 1996 09:48:46   ZJRD
** No change.
** 
**    Rev 1.6   30 Oct 1996 12:51:10   ZJRD
** No change.
** 
**    Rev 1.5   28 Oct 1996 09:44:00   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.4   21 Oct 1996 09:18:10   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.2   23 Sep 1996 10:37:12   ZJRD
** PIC/SLD Version 0.70
** 
**    Rev 1.1   06 Sep 1996 13:52:00   ZJRD
** PIC/SLD Version 0.60
** 
**    Rev 1.0   02 Sep 1996 11:33:06   ZJRD
** Initial revision.
**
****************************************************************************/

// memview.cpp : implementation file
//

#include "stdafx.h" 
#include "btnbar.h"
#include "mainfrm.h"
#include "grascivw.h"    
#include "gregvw.h"
#include "uicom.h" 
#include "resource.h"

// Added by Gates Hua
#include "cpust.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
extern UINT cpuid;                         
extern BOOL SetGRMem(int addr1,int addr2,BYTE* pMemByte);
extern BOOL GetGRMem(int addr1,int addr2,BYTE* pMemByte);                         
extern BOOL GetCpuStatus(unsigned char & uchStatus);
void StringConvert(unsigned char* ch_des,BYTE* ch_src,int len)
{
	int j=0;
	for(int i=0;i<16;i++)
	{
		if(i<16-len) ch_des[i]=' ';
		else
		{
// Modified by Gates Hua
// -- start
//		  if(ch_src[j]<32) 
//		    ch_des[i]='.';
		  if(ch_src[j]<32||ch_src[j]>=0x80) 
		    ch_des[i]='.';
// -- end		    
		  else 
		    ch_des[i]=ch_src[j];				
		  j++;
		}   
	}	
}
/////////////////////////////////////////////////////////////////////////////
// CGRAsciiView

IMPLEMENT_DYNCREATE(CGRAsciiView, CView)

CGRAsciiView::CGRAsciiView()
{                 
    m_ptFirst=CPoint(0,0);
    m_szScroll=CSize(0,0);

//	m_nCellsPerLine=m_isByte?16:8;  //8 or 16
	m_nLineHeight=18;
	m_ptCaretPos=CPoint(0,1);      
	m_nFirstViewCol=0;
	m_nFirstViewLine=0;
}

CGRAsciiView::~CGRAsciiView()
{
}   

LONG CGRAsciiView::OnXMRepaint(UINT line,LONG) 
{
	if(line==-1)
		Invalidate();
	else
	{
		CRect rect;
		rect.left=0;
		rect.top=(line-m_nFirstViewLine+1)*m_nLineHeight;
		rect.bottom=rect.top+m_nLineHeight;
		rect.right=m_rectClient.right;
		InvalidateRect(&rect);
	}	
	UpdateWindow();	
	return 1;	
	
}

void CGRAsciiView::CaretMove(int flag)
{                                                          
            //AfxMessageBox("Your press right arrow.",MB_OK);
    CRect rect=m_rectClient;
    G_Register_Cell greg; 
    int start,end;
    greg=Caret2GReg(m_ptCaretPos);	
    start=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[greg.gBank].nStartAddr;
    end=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[greg.gBank].nEndAddr;

    switch(flag){
    //right
    case 0: 
    case 6: 
 
//    	if( end-start<=m_ptCaretPos.y*16+m_ptCaretPos.x)  break;
        if(m_ptCaretPos.x+m_nFirstViewCol<15)
        {
          	if(m_ptCaretPos.x*m_szFont.cx>m_rectClient.right-m_szFont.cx)
           	   SendMessage(WM_HSCROLL,SB_LINEDOWN,0); 
           	m_ptCaretPos.x++;
        }   	
/*          else 
            {    
               if(m_ptCaretPos.y<( (CGRegWnd*)pGRWnd)->m_nEndLine)
               {
                  if((m_ptCaretPos.y+1)*m_nLineHeight+m_szFont.cy>m_rectClient.bottom)
		          {
		           	  SendMessage(WM_VSCROLL,SB_LINEDOWN, 0);
		         	  ((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)->SendMessage(WM_VSCROLL,SB_LINEDOWN,0);
				  }	
                  m_ptCaretPos.y++;
			   	  m_ptCaretPos.x=0;	               
               }
            }      
*/
           SetAsciiCaretPos();        
           break;
    //left
    case 1: 
          if(greg.gOffset<=0) break;
          if(m_ptCaretPos.x>0) m_ptCaretPos.x--;
          else
             if(m_nFirstViewCol>0)
          	 {
                SendMessage(WM_HSCROLL,SB_LINEUP,0); 
	           	m_ptCaretPos.x--;
             }
             else break;   	
/*          else 
            {    
               if(m_ptCaretPos.y>0)
               {
                  if(m_ptCaretPos.y==m_nFirstViewLine)
                  {
                     SendMessage(WM_VSCROLL,SB_LINEUP, 0);
                     ((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)->SendMessage(WM_VSCROLL,SB_LINEUP,0);
                  }   
                  m_ptCaretPos.y--;
			   	  m_ptCaretPos.x=15;	               
               }
            }      
*/
           SetAsciiCaretPos();        
           break;  
     //Up
    case 2: 
    	    if( ((CGRegWnd*)pGRWnd)->IsBankFirstLine(m_ptCaretPos.y+m_nFirstViewLine-1) )
    	       if(m_ptCaretPos.x<(((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[greg.gBank].nStartAddr)%16) 
    	         break;
    		if(m_ptCaretPos.y<=0) return;
    		if(m_ptCaretPos.y==m_nFirstViewLine)
    		{
    			SendMessage(WM_VSCROLL,SB_LINEUP,0);
    		    ((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)->SendMessage(WM_VSCROLL,SB_LINEUP,0);
    		}		  
            m_ptCaretPos.y--;
            SetAsciiCaretPos();
            break;
    //Down
	case 3: 
    	    if( ((CGRegWnd*)pGRWnd)->IsBankFirstLine(m_ptCaretPos.y+m_nFirstViewLine+1) )
    	       if(m_ptCaretPos.x<(((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[greg.gBank+1].nStartAddr)%16) 
    	         break;
			if(m_ptCaretPos.y+m_nFirstViewLine>=( (CGRegWnd*)pGRWnd)->m_nEndLine) return ;
			if(m_ptCaretPos.y==m_nLastViewLine)
			{
				SendMessage(WM_VSCROLL,SB_LINEDOWN,0);
				((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)->SendMessage(WM_VSCROLL,SB_LINEDOWN,0);
				m_ptCaretPos.y--;
			}	
			m_ptCaretPos.y++;
			SetAsciiCaretPos();
			break;
    //Home      
    case 4: if(m_nFirstViewCol!=0)
                SendMessage(WM_HSCROLL,SB_PAGELEFT,0);
			if(greg.gOffset<16-start%16) 
				m_ptCaretPos.x=start%16;
			else 
            	m_ptCaretPos.x=0;
            SetAsciiCaretPos();   
            break;
    //End       
    case 5: 
            SendMessage(WM_HSCROLL,SB_PAGERIGHT,0);
            m_ptCaretPos.x=15-m_nFirstViewCol;
            SetAsciiCaretPos();
            break;
    default:break;
    }           
}                


G_Register_Cell CGRAsciiView::Caret2GReg(CPoint pt)
{ 
	G_Register_Cell cell;
	if(((CGRegWnd*)pGRWnd)->Line2Addr(pt.y+m_nFirstViewLine,cell.gBank,cell.gOffset) )  
    {
    	cell.gOffset+=pt.x+m_ptFirst.x/m_szFont.cx;
    }
    else cell.gBank=-1;
	return cell;
}

BOOL CGRAsciiView::InputCheck(UINT nChar) 
{                                          
    G_Register_Cell cell;
    cell=Caret2GReg(m_ptCaretPos);
 	int start=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[cell.gBank].nStartAddr;
//	if(m_ptCaretPos.y==0)
//    	cell.gOffset-=start%16;
    ((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][cell.gOffset]=nChar;
    int Addr=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[cell.gBank].nStartAddr+cell.gOffset;               
    SetGRMem(Addr,Addr,(BYTE*)&nChar);
    GetGRMem(Addr,Addr,(BYTE*)&nChar);
    ((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][cell.gOffset]=(BYTE)nChar;
//modified by jerry on 10/14/96
   	if(cpuid==9||cpuid==17||cpuid==20)
   	{                                               
  	   int nt;
  	   nt= (cell.gBank+1)%((CGRegWnd*)pGRWnd)->m_rRange.nBanks;
  	   ((CGRegWnd*)pGRWnd)->m_GRValue[nt][cell.gOffset]=(BYTE)nChar;
	}    
//end of modify   		
	
	return 1;
}                        

 
void CGRAsciiView::DrawGrid(CDC* pDC,int nRows)
{
 
	CRect  rect(0,0,m_rectClient.right,m_nLineHeight);
	::FillRect(pDC->m_hDC,&rect,(HBRUSH)::GetStockObject(LTGRAY_BRUSH) );



    int nGridHeight=m_nLineHeight;
   	pDC->MoveTo(0,m_nLineHeight);
	pDC->LineTo(m_rectClient.right,nGridHeight);
    for(int i=1;i<nRows-1;i++)
    {	
    	nGridHeight+=m_nLineHeight;
    	pDC->MoveTo(0,nGridHeight);
   		pDC->LineTo(m_rectClient.right,nGridHeight);
   	}	
/*   	while(m_rectClient.bottom-(nGridHeight-m_ptFirst.y*m_nLineHeight)>0)
   	{
		nGridHeight+=m_nLineHeight;
		pDC->MoveTo(0-m_ptFirst.x,nGridHeight-m_ptFirst.y*m_nLineHeight);
   		pDC->LineTo(min(nGridWidth-m_ptFirst.x,m_rectClient.right),nGridHeight-m_ptFirst.y*m_nLineHeight);
		pOldPen=(CPen*)pDC->SelectStockObject(WHITE_PEN);
    	pDC->MoveTo(0,nGridHeight-m_ptFirst.y*m_nLineHeight+1);
   		pDC->LineTo(m_nAddrColWidth,nGridHeight-m_ptFirst.y*m_nLineHeight+1);
		pDC->SelectObject(pOldPen);
	}	   		
*/
}      

/*           
BOOL CGRAsciiView::Create(CWnd* pParentWnd,DWORD dwStyle,CRect rect,UINT nID)
{
	if(pParentWnd!=NULL)
        ASSERT_VALID(pParentWnd);
    DWORD csStyle=CS_DBLCLKS;    
    dwStyle|=WS_CHILDWINDOW; 
    dwStyle=WS_CHILD|WS_VISIBLE; 

    if(!CWnd::Create(AfxRegisterWndClass(csStyle,0,(HBRUSH)::GetStockObject(WHITE_BRUSH)),NULL,dwStyle,rect,pParentWnd,nID)) 
          return 0;
	return 1;	    
}  

*/

BEGIN_MESSAGE_MAP(CGRAsciiView, CView)
	//{{AFX_MSG_MAP(CGRAsciiView)
	ON_WM_LBUTTONDOWN()
	ON_WM_CREATE()
	ON_WM_VSCROLL()
	ON_WM_CHAR()
	ON_WM_SIZE()
	ON_WM_HSCROLL()
	ON_WM_GETMINMAXINFO()
	ON_WM_KEYDOWN()
	ON_WM_SETFOCUS()
	ON_WM_KILLFOCUS() 
	ON_MESSAGE(XM_REPAINT, OnXMRepaint)
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_VIEW_WORD, OnViewWord)
	ON_UPDATE_COMMAND_UI(ID_VIEW_WORD, OnUpdateViewWord)
	ON_COMMAND(ID_VIEW_UNSIGNEDDECIMAL, OnViewUnsigneddecimal)
	ON_UPDATE_COMMAND_UI(ID_VIEW_UNSIGNEDDECIMAL, OnUpdateViewUnsigneddecimal)
	ON_COMMAND(ID_VIEW_SIGNEDDECIMAL, OnViewSigneddecimal)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SIGNEDDECIMAL, OnUpdateViewSigneddecimal)
	ON_COMMAND(ID_VIEW_REFRESH, OnViewRefresh)
	ON_COMMAND(ID_GROUP_MEMORY, OnGroupMemory)
	ON_COMMAND(ID_VIEW_BYTE, OnViewByte)
	ON_UPDATE_COMMAND_UI(ID_VIEW_BYTE, OnUpdateViewByte)
	ON_WM_SETCURSOR()
	ON_COMMAND(ID_VIEW_HEXADECIMAL, OnViewHexadecimal)
	ON_UPDATE_COMMAND_UI(ID_VIEW_HEXADECIMAL, OnUpdateViewHexadecimal)
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
	
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CGRAsciiView drawing



/////////////////////////////////////////////////////////////////////////////
// CGRAsciiView message handlers



void CGRAsciiView::OnLButtonDown(UINT nFlags, CPoint point)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
        return ;
    }    
    
	// TODO: Add your message handler code here and/or call default
    G_Register_Cell greg; 
    CPoint cp;
    cp.x=(point.x)/m_szFont.cx;
    cp.y=point.y/m_nLineHeight-1;
   	greg=Caret2GReg(cp);  
   	if(greg.gBank==-1) return ;
    int start,end;
    start=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[greg.gBank].nStartAddr;
    end=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[greg.gBank].nEndAddr;
	if(point.x<m_szFont.cx*16&&point.y>m_nLineHeight)
	{                                
	  int n=0;
	  for(int j=0;j<greg.gBank;j++)
	  	n+=((CGRegWnd*)pGRWnd)->m_arLinesPerBank[j];
	  if( (point.y/m_nLineHeight-1+m_nFirstViewLine<=((CGRegWnd*)pGRWnd)->m_nEndLine)&&
	  	   point.x+m_ptFirst.x<m_szFont.cx*16 )
//	  &&(end-start+1>point.x/m_szFont.cx+(point.y/m_nLineHeight-1-n)*16))
	  {	
	  	if(greg.gOffset>=0)
	  	{
	  		m_ptCaretPos.x=cp.x ;
		 	m_ptCaretPos.y=cp.y;
		 	SetAsciiCaretPos(); 
    	 	SetActiveWindow();
    	 	SetFocus();
    	} 
      }	
    }	
	CView::OnLButtonDown(nFlags, point);
}

void CGRAsciiView::SetAsciiCaretPos()
{                               
	POINT pt;
	pt.x=m_ptCaretPos.x*m_szFont.cx;
	pt.y=m_ptCaretPos.y*m_nLineHeight+m_nLineHeight;
	SetCaretPos(pt); 
 	if(m_ptCaretPos.x<0||m_ptCaretPos.x>15)
 	{ShowCaret();HideCaret();}
 	else ShowCaret();       

}

int CGRAsciiView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	TEXTMETRIC tm;
    CDC * pDC = GetDC();
    pDC->SelectStockObject(ANSI_FIXED_FONT);
    pDC->GetTextMetrics(&tm);
    ReleaseDC(pDC); 
    m_szFont.cy = tm.tmHeight + tm.tmExternalLeading;
    m_szFont.cx = tm.tmAveCharWidth;
	// TODO: Add your specialized creation code here
	DWORD dwStyle=GetStyle();
    dwStyle&=~WS_VSCROLL;
    SetWindowLong(m_hWnd,GWL_STYLE,dwStyle);     
	return 0;
}
 
 
 
void CGRAsciiView::OnDraw(CDC* pDC)
{
//	CPaintDC dc(this); // device context for painting
	pDC->SetBkMode(TRANSPARENT );
	pDC->SelectStockObject(ANSI_FIXED_FONT);

	int lines; 
	lines=m_rectClient.bottom/m_nLineHeight+1;
	DrawGrid(pDC,lines);
	CRect rect;
//	rect.SetRect(0-m_ptFirst.x,0,m_rectClient.right,m_nLineHeight);
	char text[17]="ASCII";
	pDC->TextOut(-m_ptFirst.x,0,text,5);
		
	BYTE *pMemByte; 
	UINT addr; 
    int nBank,nOffset,len;  
    int nst;    
	for(int i=0;i<min(lines,((CGRegWnd*)pGRWnd)->m_nEndLine+1-m_nFirstViewLine);i++)
	{
		addr=((CGRegWnd*)pGRWnd)->Line2Addr(i+m_nFirstViewLine,nBank,nOffset);
	    if(nOffset<0) nOffset=0;
	    pMemByte=(BYTE*)&((CGRegWnd*)pGRWnd)->m_GRValue[nBank][nOffset];
		nst=addr%16;
		if(nst) len=16-nst;
		else len=16;
//		if(addr+15<=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[nBank].nEndAddr)
//			len=16;
//		else len=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[nBank].nEndAddr-addr+1;	
		DrawLine(pDC,i,pMemByte,len);
	}	
	
}                     

void CGRAsciiView::DrawLine(CDC* pDC,int line,BYTE* pMemByte,int len)
{
	CRect rect(0,(line+1)*m_nLineHeight,m_rectClient.right,(line+2)*m_nLineHeight);


//	text=(unsigned char*)pMemByte;
	unsigned char str_des[16];
	StringConvert(str_des,pMemByte,len);                   
	pDC->TextOut(-m_ptFirst.x,rect.top,(char*)str_des,16);	
//	pDC->DrawText(str_des,16,&rect,DT_VCENTER|DT_LEFT);
}

void CGRAsciiView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
        return ;
    }    
	// TODO: Add your message handler code here and/or call default
	CRect rect; 
    rect=m_rectClient;
    int i;
    rect.left=0;
    rect.top=m_nLineHeight+1;
    switch(nSBCode) {
        case SB_LINEUP:
        case SB_PAGEUP: 
            if(m_ptFirst.y <= 0)  return;
			i = m_nLineHeight;
            m_ptFirst.y --;      
            m_nFirstViewLine--;
			m_nLastViewLine--;
            ScrollWindow(0, i,&rect, &rect);
            SetAsciiCaretPos();
            break;
        case SB_LINEDOWN:    
        case SB_PAGEDOWN:
            if(m_ptFirst.y >= ((CGRegWnd*)pGRWnd)->m_nVScrollRange)    return;
            i =m_nLineHeight;
            m_ptFirst.y ++;
            m_nFirstViewLine++;
			m_nLastViewLine++;
            ScrollWindow(0,-i,&rect,&rect);
            SetAsciiCaretPos();
            break;

        case SB_THUMBPOSITION:           
        case SB_THUMBTRACK:
            if(int(nPos) == m_ptFirst.y) return;     
            int t=0;
            t=  nPos-m_ptFirst.y;
            if(abs(t)<m_nLineHeight)
               return; 
            t=t/m_nLineHeight*m_nLineHeight;   
            m_ptFirst.y=m_ptFirst.y+t;
            m_nFirstViewLine+=t;
			m_nLastViewLine+=t;
            ScrollWindow( 0,t,&rect,&rect);   
            SetAsciiCaretPos();
////            SetScrollPos(SB_VERT, m_ptFirst.y);
            break;
    }          
    CRect cliprect;
	GetParent()->GetUpdateRect(&cliprect);
    GetParent()->InvalidateRect(&cliprect);
    GetParent()->UpdateWindow();    
	CView::OnVScroll(nSBCode, nPos, pScrollBar); 
}

void CGRAsciiView::Caret2Rect(CPoint point,CRect& rect)
{                                      
	CPoint pt;
	pt.x=point.x;
	pt.y=point.y+1;
	rect.left=m_szFont.cx*pt.x-m_szFont.cx/2;
	rect.top=m_nLineHeight*pt.y;
	rect.bottom=rect.top+m_nLineHeight;
	rect.right=rect.left+m_szFont.cx+m_szFont.cx/2;
//ect.SetRect(pt.x,pt.y,pt.x+m_szFont.cx,pt.y+m_szFont.cy);
	
}

void CGRAsciiView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: Add your message handler code here and/or call default

    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
        return ;
    }     
	if(!InputCheck(nChar) )
		return; 
	CRect rect;  
	Caret2Rect(m_ptCaretPos,rect);
    CaretMove(0);
	InvalidateRect(&rect); 
	if(cpuid==9||cpuid==17||cpuid==20) Invalidate();
	UpdateWindow();    
	if(cpuid==9||cpuid==17||cpuid==20)
		((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)->SendMessage(XM_REPAINT,-1,0);
	else
		((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)->SendMessage(XM_REPAINT,m_ptCaretPos.y+m_nFirstViewLine,0); 	
	CView::OnChar(nChar, nRepCnt, nFlags);
	
}

void CGRAsciiView::OnSize(UINT nType, int cx, int cy)
{

	CView::OnSize(nType, cx, cy);
	
	GetClientRect(&m_rectClient);

	m_szScroll.cx=m_szFont.cx*(1+16); 
	m_szScroll.cx=m_szScroll.cx-cx;
		if(m_szScroll.cx<=0) {
		m_szScroll.cx=0;
		m_nFirstViewCol=0;                      	
        m_ptFirst.x = 0;
        m_ptCaretPos.x = 0; 
        m_ptCaretPos.y=1;
        SetAsciiCaretPos();
	}
	SetScrollRange(SB_HORZ,0,m_szScroll.cx);  

//add on 9/4/96
	m_ptFirst.y=0;
	m_nFirstViewLine=0;   
	m_ptFirst.x=0;
	m_nFirstViewCol=0;
	
//end of add
	m_nLastViewLine=m_nFirstViewLine+cy/m_nLineHeight-1;
}

void CGRAsciiView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{                         
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
        return ;
    }    
	CRect rect;
	rect=m_rectClient;
//	rect.bottom=rect.top+m_nLineHeight;
    int i;                                
    switch(nSBCode) {
        case SB_LINELEFT:                 
            if(m_ptFirst.x <= 0)  return;  
            i = m_szFont.cx;
            m_ptFirst.x -= i;;
            m_nFirstViewCol--;   
            ScrollWindow(i, 0,&rect,&rect);
            SetScrollPos(SB_HORZ, m_ptFirst.x); 
            m_ptCaretPos.x+=1;
            SetAsciiCaretPos();
            break;
        case SB_LINERIGHT:
            if(m_ptFirst.x >= m_szScroll.cx)    return;
            i =m_szFont.cx;
            m_ptFirst.x += i; 
            m_nFirstViewCol++;
            ScrollWindow(-i,0,&rect,&rect);
            SetScrollPos(SB_HORZ, m_ptFirst.x);  
            m_ptCaretPos.x-=1;
            SetAsciiCaretPos();
            break;     
        case SB_PAGELEFT: 
            if(m_ptFirst.x == 0)    return;
/*          i =m_szFont.cx;
            m_ptFirst.x -= i;
            m_nFirstViewCol--;   
*/          i=m_ptFirst.x;
			m_ptFirst.x=0;
			m_nFirstViewCol=0;
			
            ScrollWindow(i, 0,&rect,&rect);
            SetScrollPos(SB_HORZ, m_ptFirst.x);
//          m_ptCaretPos.x++;
			m_ptCaretPos.x+=i/m_szFont.cx;
            SetAsciiCaretPos();
            break;
        case SB_PAGERIGHT:
/*          i =m_szFont.cx;
            m_ptFirst.x += i;;
			m_nFirstViewCol++;
*/
            if(m_ptFirst.x >= m_szScroll.cx)    return;
            i =m_szScroll.cx-m_ptFirst.x;
            if(i<m_szFont.cx) return;
            m_ptFirst.x =m_szScroll.cx/m_szFont.cx*m_szFont.cx;            
			m_nFirstViewCol+=i/m_szFont.cx;

            i=i/m_szFont.cx*m_szFont.cx;  
            ScrollWindow(-i, 0,&rect,&rect);
            SetScrollPos(SB_HORZ, m_ptFirst.x);
//          m_ptCaretPos.x--;
			m_ptCaretPos.x-=i/m_szFont.cx;
            SetAsciiCaretPos();  
            
            break;
        case SB_THUMBPOSITION:           
        case SB_THUMBTRACK:
            if(int(nPos) == m_ptFirst.x) return;       
            if(nPos>(UINT)m_ptFirst.x)
            {
                if(m_ptFirst.x >= m_szScroll.cx)    return;
                i =m_szScroll.cx-m_ptFirst.x;
//                m_nFirstViewCol+=(m_szScroll.cx-m_ptFirst.x)/m_nColWidth;    
                m_ptFirst.x =m_szScroll.cx;
				m_nFirstViewCol=m_ptFirst.x/m_szFont.cx;
                ScrollWindow(-i, 0,&rect,&rect);
                SetScrollPos(SB_HORZ, m_ptFirst.x);
            }   
            else
            {
                if(m_ptFirst.x == 0)    return;
                i = m_ptFirst.x;
                m_ptFirst.x =0;   
                m_nFirstViewCol=0;
                ScrollWindow(i, 0,&rect,&rect);
                SetScrollPos(SB_HORZ, m_ptFirst.x);
            }
            break;
    } 
    CRect cliprect;
    GetParent()->GetUpdateRect(&cliprect);
    GetParent()->InvalidateRect(&cliprect);
    GetParent()->UpdateWindow();    
	
	CView::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CGRAsciiView::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI)
{
	// TODO: Add your message handler code here and/or call default
	
	CView::OnGetMinMaxInfo(lpMMI);  
	
    lpMMI->ptMaxSize.x=0;

    lpMMI->ptMaxTrackSize.x=0;
}


void CGRAsciiView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
        return ;
    }    
	// TODO: Add your message handler code here and/or call default
     switch (nChar) {
        case VK_RIGHT:
               CaretMove(0);
               break;
        case VK_LEFT:
               CaretMove(1);
               break;
        case VK_UP:
               CaretMove(2);               
               break;
        case VK_DOWN:
               CaretMove(3);               
               break;
        case VK_PRIOR:
               SendMessage(WM_VSCROLL,SB_PAGEUP,0);
               ((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)->\
                   SendMessage(WM_VSCROLL,SB_PAGEUP,0); 
               break;         
        case VK_NEXT:
               SendMessage(WM_VSCROLL,SB_PAGEDOWN,0);           
               ((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)->\
                   SendMessage(WM_VSCROLL,SB_PAGEDOWN,0); 
               break;         
        case VK_HOME:       
               CaretMove(4);
               break;
        case VK_END:
               CaretMove(5);               
               break;
    
        case VK_TAB:
				 ((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)->\
				   SetFocus();
//               CaretMove(6);                       
               break; 
        case VK_RETURN:
                break;
                   
    }
    CView::OnKeyDown(nChar, nRepCnt, nFlags);	

}

void CGRAsciiView::OnSetFocus(CWnd* pOldWnd)
{
	CView::OnSetFocus(pOldWnd); 
    CreateSolidCaret(1,12);
    SetAsciiCaretPos();
}

void CGRAsciiView::OnKillFocus(CWnd* pNewWnd)
{
	CView::OnKillFocus(pNewWnd);
	
	  ::DestroyCaret();
	
}

void CGRAsciiView::OnRButtonDown(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
        return ;
    }    

    CMenu * pLocalMenu = new CMenu;

    ASSERT(pLocalMenu!=NULL);
    pLocalMenu->CreatePopupMenu();
    
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_REFRESH, "&Refresh");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
   
    pLocalMenu->AppendMenu(MF_STRING, ID_GROUP_MEMORY, "&Memory...");
//  pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_GOTO, "&Goto...");
    pLocalMenu->AppendMenu(MF_SEPARATOR);

    if(((CGRegView*)((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)))->m_nHexORDec==16)
   	{
   		pLocalMenu->AppendMenu(MF_STRING|MF_CHECKED,ID_VIEW_HEXADECIMAL, "&Hexadecimal");
	    pLocalMenu->AppendMenu(MF_STRING|MF_UNCHECKED,ID_VIEW_SIGNEDDECIMAL, "&Signed Decimal");
    	pLocalMenu->AppendMenu(MF_STRING|MF_UNCHECKED,ID_VIEW_UNSIGNEDDECIMAL, "&Unsigned Decimal");
   	}
    else
    	pLocalMenu->AppendMenu(MF_STRING|MF_UNCHECKED,ID_VIEW_HEXADECIMAL, "&Hexadecimal");	
	if(((CGRegView*)((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)))->m_isSigned
	     &&((CGRegView*)((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)))->m_nHexORDec==10)
	{
	    pLocalMenu->AppendMenu(MF_STRING|MF_CHECKED,ID_VIEW_SIGNEDDECIMAL, "&Signed Decimal");
    	pLocalMenu->AppendMenu(MF_STRING|MF_UNCHECKED,ID_VIEW_UNSIGNEDDECIMAL, "&Unsigned Decimal");
    }	
	if((!((CGRegView*)((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)))->m_isSigned)
	    &&((CGRegView*)((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)))->m_nHexORDec==10)
	{
	    pLocalMenu->AppendMenu(MF_STRING|MF_UNCHECKED,ID_VIEW_SIGNEDDECIMAL, "&Signed Decimal");
    	pLocalMenu->AppendMenu(MF_STRING|MF_CHECKED,ID_VIEW_UNSIGNEDDECIMAL, "&Unsigned Decimal");
    }	

    pLocalMenu->AppendMenu(MF_SEPARATOR);                   

    
    if(((CGRegView*)((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)))->m_isByte)
    {	pLocalMenu->AppendMenu(MF_STRING|MF_CHECKED,ID_VIEW_BYTE, "&Byte");
        pLocalMenu->AppendMenu(MF_STRING|MF_UNCHECKED,ID_VIEW_WORD, "&Word");
    }    
    else	                                                               
    {	pLocalMenu->AppendMenu(MF_STRING|MF_UNCHECKED,ID_VIEW_BYTE, "&Byte");
    	pLocalMenu->AppendMenu(MF_STRING|MF_CHECKED,ID_VIEW_WORD, "&Word");
    }
    
    ClientToScreen(&point);
    pLocalMenu->TrackPopupMenu(TPM_CENTERALIGN, point.x, point.y, pGRWnd);
    delete pLocalMenu;
    CView::OnRButtonDown(nFlags, point);
	
}

void CGRAsciiView::OnViewWord()
{
	((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0))->\
		SendMessage(WM_COMMAND,ID_VIEW_WORD,0);
}

void CGRAsciiView::OnUpdateViewWord(CCmdUI* pCmdUI)
{ 
pCmdUI->SetCheck(!((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0))->m_isByte);
}

void CGRAsciiView::OnViewUnsigneddecimal()
{
	((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0))->\
		SendMessage(WM_COMMAND,ID_VIEW_UNSIGNEDDECIMAL,0);
	
}

void CGRAsciiView::OnUpdateViewUnsigneddecimal(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck((!((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0))->m_isSigned)
	       &&((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0))->m_nHexORDec==10);
	
}

void CGRAsciiView::OnViewSigneddecimal()
{
	((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0))->\
		SendMessage(WM_COMMAND,ID_VIEW_SIGNEDDECIMAL);

	
}

void CGRAsciiView::OnUpdateViewSigneddecimal(CCmdUI* pCmdUI)
{
		pCmdUI->SetCheck(((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0))->m_isSigned
		&&((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0))->m_nHexORDec==10);
	
}

void CGRAsciiView::OnViewRefresh()
{
	((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0))->\
		SendMessage(WM_COMMAND,ID_VIEW_REFRESH,0);
}

void CGRAsciiView::OnGroupMemory()
{
	((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0))->\
		SendMessage(WM_COMMAND,ID_GROUP_MEMORY,0);
	
}

void CGRAsciiView::OnViewHexadecimal()
{
	((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0))->\
		SendMessage(WM_COMMAND,ID_VIEW_HEXADECIMAL,0);
}

void CGRAsciiView::OnUpdateViewHexadecimal(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(((CGRegView*)((CGRegWnd*)pGRWnd)->\
	  m_wndSplitter.GetPane(0,0))->m_nHexORDec==16);
	
}



void CGRAsciiView::OnViewByte()
{
	((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0))->\
		SendMessage(WM_COMMAND,ID_VIEW_BYTE,0);
}

void CGRAsciiView::OnUpdateViewByte(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(((CGRegView*)((CGRegView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,0)))->m_isByte);
	
}

BOOL CGRAsciiView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
	// TODO: Add your message handler code here and/or call default
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
////        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
//    ((CMainFrame*)AfxGetApp()->m_pMainWnd)->m_wndStatusBar.UpdateStatusBar(0, "EP is running !");		
//    return CView::OnSetCursor(pWnd, nHitTest, message);
//    }    
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
		if ( STATUS_GO == uchStatus )
    		((CMainFrame*)AfxGetApp()->m_pMainWnd)->m_wndStatusBar.UpdateStatusBar(0, "EP is running !");		
    	else 
    		((CMainFrame*)AfxGetApp()->m_pMainWnd)->m_wndStatusBar.UpdateStatusBar(0, "EP is sleeping !");		
	    return CView::OnSetCursor(pWnd, nHitTest, message);
    }    

    if((message==WM_LBUTTONDOWN||
        message==WM_RBUTTONDOWN||
        message==WM_LBUTTONUP||
        message==WM_RBUTTONUP||
        message==WM_MOUSEMOVE)&&HTCLIENT==nHitTest)
        return FALSE;
    return CView::OnSetCursor(pWnd, nHitTest, message);
}


void CGRAsciiView::OnMouseMove(UINT nFlags, CPoint point)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
    	CView::OnMouseMove(nFlags, point);
        return ;
    }     
    
    if(point.y>m_nLineHeight)
    {
        SetCursor(::LoadCursor(NULL,IDC_IBEAM)); 
    }
    else                                 
    {
        SetCursor(::LoadCursor(NULL,IDC_ARROW));
    }             
    
    CView::OnMouseMove(nFlags, point);
}
