 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/GREGVW.CPP   1.11   13 Dec 1996 11:18:34   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/GREGVW.CPP  $
** 
**    Rev 1.11   13 Dec 1996 11:18:34   ZJRD
** PIC/SLD Version 0.98
** 
**    Rev 1.10   22 Nov 1996 10:59:34   ZJRD
** No change.
** 
**    Rev 1.9   11 Nov 1996 12:46:50   ZJRD
** No change.
** 
**    Rev 1.8   06 Nov 1996 12:58:46   ZJRD
** No change.
** 
**    Rev 1.7   02 Nov 1996 09:48:46   ZJRD
** No change.
** 
**    Rev 1.6   30 Oct 1996 12:51:12   ZJRD
** No change.
** 
**    Rev 1.5   28 Oct 1996 09:44:00   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.4   21 Oct 1996 09:18:10   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.2   23 Sep 1996 10:37:12   ZJRD
** PIC/SLD Version 0.70
** 
**    Rev 1.1   06 Sep 1996 13:52:00   ZJRD
** PIC/SLD Version 0.60
** 
**    Rev 1.0   02 Sep 1996 11:33:08   ZJRD
** Initial revision.
**
****************************************************************************/

// memwivw.cpp : implementation of the CGRegView class
//
 
#include "stdafx.h"
#include "btnbar.h"
#include "mainfrm.h"
//#include "gregwnd.h"
#include "gregvw.h"
#include "memgtdlg.h"    
#include "memschdg.h" 
#include "address.h"
#include "addrapi.h"
#include "mempage.h"
#include "memdlg.h"
#include "cpuserve.h"
#include "uicom.h"
#include "grascivw.h"
#include "dadpub.h"

// Added by Gates Hua
#include "cpust.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif                     
void UnsignToSign(char* text, int);
extern BOOL GetCpuStatus(unsigned char & uchStatus);                  
extern BOOL IsNegative(UINT);                       
extern void UnsignToSign(char* text, int);  
//extern BOOL CheckLegal(UINT u,BOOL bSign);
extern int UnsignToSign( int u);
extern unsigned char Char2Value(UINT nChar);

extern BOOL SetGRMem(int addr1,int addr2,BYTE* pMemByte);
extern BOOL GetGRMem(int addr1,int addr2,BYTE* pMemByte);

extern BOOL MemServerSearch(unsigned short uStart, unsigned short uEnd,
    unsigned char uchType, char* pszPattern, int nInsensitive,
    unsigned short& uRetAddr);
extern UINT cpuid;
int gSpace=0;   

extern WORD gwGPRFViewStatus;
 //
 //0x0104=Byte Hex; 0x0101=Byte Signed;0x0102=Byte Unsigned ;
 //0x0004=Word Hex; 0x0001=Word Signed;0x0002=Word Unsigned;	
/////////////////////////////////////////////////////////////////////////////
// CGRegView

IMPLEMENT_DYNCREATE(CGRegView, CView)


/////////////////////////////////////////////////////////////////////////////
// CGRegView construction/destruction

CGRegView::CGRegView()
{            
    m_ptFirst=CPoint(0,0);
    m_szScroll=CSize(0,0);

//    m_isByte=0;
//    m_isSigned=0;
//    m_nHexORDec=16;

    m_isByte=(BOOL)(gwGPRFViewStatus&0x0100);
    m_isSigned=(BOOL)(gwGPRFViewStatus&0x0001);
    m_nHexORDec=(gwGPRFViewStatus&0x0004)?16:10;
    m_nCellsPerLine=m_isByte?16:8;  //8 or 16
    
    m_nLineHeight=18;
    m_ptCaretPos.x=0;      
    m_ptCaretPos.y=1;
    m_ptCaretPos.offset=0;

    m_nFirstViewCol=0; 
    m_nFirstViewLine=0;
//    m_nLastViewLine= 
	//Init();
    SetCellEndPos();
}


CGRegView::~CGRegView()
{  
	gwGPRFViewStatus=0;
    if(m_isByte) gwGPRFViewStatus|=0x0100;
	if(m_nHexORDec==16) gwGPRFViewStatus|=0x0004;
	else if(m_isSigned) gwGPRFViewStatus|=0x0001;
	else gwGPRFViewStatus|=0x0002;         
	             
}

void CGRegView::SetCellEndPos()
{
    if(m_isByte)
       if(m_nHexORDec==16)
            m_nCellEndPos=1;
       else if(m_isSigned)
            m_nCellEndPos=3;
       else m_nCellEndPos=2;
    else if(m_nHexORDec==16)
            m_nCellEndPos=3;
         else if(m_isSigned)
                m_nCellEndPos=5;
              else                       
                m_nCellEndPos=4;
}                 
                    
BOOL CGRegView::CaretOnWndEdge()
{
    CPoint pt;
    pt=GetCaretPos();
    if(m_rectClient.right<=pt.x+m_szFont.cx+m_szFont.cx/2)
       return 1;
    else return 0;   
}                    

LONG CGRegView::OnXMRepaint(UINT line,LONG) 
{
	if(line==-1)
		Invalidate();
	else
	{
		CRect rect;
		rect.left=m_nAddrColWidth;
		rect.top=(line-m_nFirstViewLine+1)*m_nLineHeight;
		rect.bottom=rect.top+m_nLineHeight;
		rect.right=m_rectClient.right;
		InvalidateRect(&rect);
	}	
	UpdateWindow();		   
	return 1;
}
                 
void CGRegView::CaretMove(int flag)
{                                                          
            //AfxMessageBox("Your press right arrow.",MB_OK);
    CRect rec1t=m_rectClient;
    G_Register_Cell greg=	Caret2GReg(m_ptCaretPos);      
    
    int start,end;
    start=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[greg.gBank].nStartAddr;
    end=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[greg.gBank].nEndAddr;
    switch(flag){
    //right
    case 0: 
    	if(cpuid<=2||cpuid==4||cpuid==7||cpuid==8)
      		if( end-start+2<=greg.gOffset)  break;
    	else
      		if( end-start+1<=greg.gOffset)  break;
        if(m_ptCaretPos.offset<m_nCellEndPos)
        {
          	m_ptCaretPos.offset++;
            if(CaretOnWndEdge())
              SendMessage(WM_HSCROLL,SB_LINEDOWN, 0); 
        }
        else 
        if(m_ptCaretPos.x<m_nCellsPerLine-1)
        {
           m_ptCaretPos.x++;
           m_ptCaretPos.offset=0;
           if(CaretOnWndEdge())
              SendMessage(WM_HSCROLL,SB_LINEDOWN, 0); 
        }      
/*      else
        {  
          if(m_nFirstViewCol!=0)
              SendMessage(WM_HSCROLL,SB_PAGELEFT,0);
          m_ptCaretPos.x=0;                  
          if(m_ptCaretPos.y<((CGRegWnd*)pGRWnd)->m_nEndLine)
              m_ptCaretPos.y++;
              m_ptCaretPos.offset=0;
        }
*/
        SetMemCaretPos(m_ptCaretPos);       
        break;
    //left
    case 1: 
	   	if(cpuid<2||cpuid==4||cpuid==7||cpuid==8)
   		{  
   		   if(!m_isByte)
   		   {
   		     if(greg.gOffset<-1) break; // 10/14/96 jerry //start%16-1) break;
   		     else
   		      	if(greg.gOffset==-1)  
    			   if(m_isSigned) 
    	   		   {   if(m_ptCaretPos.offset<=3) break;}
    	   		   else                          
    	   		   {   if(m_ptCaretPos.offset<=2) break;}
   		   }
   		   else  
   		   {
   		     if(greg.gOffset<0) break;
   		     else if(greg.gOffset==0&&m_ptCaretPos.offset==0) break;
   		   }
   		}
        else
    	{
    		if(greg.gOffset<0) break;
    		else if(greg.gOffset==0&&m_ptCaretPos.offset==0) break;
    	}

    	if(m_ptCaretPos.offset>0)
    		m_ptCaretPos.offset--;
    	else if(m_ptCaretPos.x)
        {	
        	if(m_nFirstViewCol==m_ptCaretPos.x)
        		SendMessage(WM_HSCROLL,SB_LINELEFT,0);
       		m_ptCaretPos.x--; 
        	m_ptCaretPos.offset=m_nCellEndPos;
        }
        else
        {   
         	if(m_nFirstViewLine!=0)
            {
               	if(m_ptCaretPos.y==m_nFirstViewLine)
               	{   
               		SendMessage(WM_VSCROLL,SB_LINEUP,0);
               		((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,1)->SendMessage(WM_VSCROLL,SB_LINEUP,0);
				}
            	m_ptCaretPos.y--;                    
               	m_ptCaretPos.x=m_nCellsPerLine-1;
                m_ptCaretPos.offset=m_nCellEndPos;
	        }                          
       }
       SetMemCaretPos(m_ptCaretPos);
       break;
    //Up
    case 2:     
    		if(m_ptCaretPos.y<=0) return;
    		if(m_isByte)
    		{
//				if(((CGRegWnd*)pGRWnd)->IsBankFirstLine(m_ptCaretPos.y+m_nFirstViewLine-1)
//				   &&m_ptCaretPos.x<start%16 )
//					break;
       	        if( ((CGRegWnd*)pGRWnd)->IsBankFirstLine(m_ptCaretPos.y-1) )
    	          if(m_ptCaretPos.x<(((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[greg.gBank].nStartAddr)%16) 
    	            break;

    		}
     		else	
 		       if(((CGRegWnd*)pGRWnd)->IsBankFirstLine(m_ptCaretPos.y-1)  )
    		      if(m_ptCaretPos.x<((((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[greg.gBank].nStartAddr)%16)/2) 
    		        break;
    		    
    		if(m_ptCaretPos.y==m_nFirstViewLine)
    		{
    			SendMessage(WM_VSCROLL,SB_LINEUP,0);
    			((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,1)->SendMessage(WM_VSCROLL,SB_LINEUP,0);
                m_ptCaretPos.y--;  
            }
            else m_ptCaretPos.y--;
            SetMemCaretPos(m_ptCaretPos);
            break;
    //Down
	case 3: 
			if(m_ptCaretPos.y>=((CGRegWnd*)pGRWnd)->m_nEndLine) return ;
    		if(m_isByte)
    		{
//				if(((CGRegWnd*)pGRWnd)->IsBankFirstLine(m_ptCaretPos.y+m_nFirstViewLine+1)
//				   &&m_ptCaretPos.x<start%16 )
//					break;
       	        if( ((CGRegWnd*)pGRWnd)->IsBankFirstLine(m_ptCaretPos.y+1) )
    	          if(m_ptCaretPos.x<(((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[greg.gBank+1].nStartAddr)%16) 
    	            break;

    		}
    		else	
       	        if( ((CGRegWnd*)pGRWnd)->IsBankFirstLine(m_ptCaretPos.y+1) )
    	          if(m_ptCaretPos.x<((((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[greg.gBank+1].nStartAddr)%16)/2) 
    	            break;

			if(m_ptCaretPos.y==m_nLastViewLine)
			{    
				SendMessage(WM_VSCROLL,SB_LINEDOWN,0);
    			((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,1)->SendMessage(WM_VSCROLL,SB_LINEDOWN,0);
			    m_ptCaretPos.y++;
			}	 
			else m_ptCaretPos.y++;
			SetMemCaretPos(m_ptCaretPos);
			break;
    //Home      
    case 4: if(m_nFirstViewCol!=0)
                SendMessage(WM_HSCROLL,SB_PAGELEFT,0);

			if(greg.gOffset<16-start%16) 
				if(m_isByte)
					m_ptCaretPos.x=start%16;
				else 	                    
					m_ptCaretPos.x=start%16/2;
			else 
            	m_ptCaretPos.x=0;

//          m_ptCaretPos.x=0;
            m_ptCaretPos.offset=0;
            
            SetMemCaretPos(m_ptCaretPos);   
            break;
    //End       
    case 5: 
            SendMessage(WM_HSCROLL,SB_PAGERIGHT,0);

            m_ptCaretPos.offset=m_nCellEndPos;
            m_ptCaretPos.x=m_nCellsPerLine-1;
            SetMemCaretPos(m_ptCaretPos);
            break;
    //Tab       
    case 6: 
            if(m_ptCaretPos.x<m_nCellsPerLine-1)
            	m_ptCaretPos.x++;
            SetMemCaretPos(m_ptCaretPos);
            break;  
    default:break;
    }           
}                        
                                                        
                                                        
G_Register_Cell CGRegView::Caret2GReg(CaretPos cp)
{ 
	G_Register_Cell cell;  
	
	((CGRegWnd*)pGRWnd)->Line2Addr(cp.y,cell.gBank,cell.gOffset);  
	int start=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[cell.gBank].nStartAddr;
	int  nst=start%16;
	if(m_isByte) cell.gOffset+=cp.x;
	else cell.gOffset+=cp.x*2;
	
	if( ((CGRegWnd*)pGRWnd)->IsBankFirstLine(cp.y) )
	{
//cell.gOffset-=nst;  modified on 10/14.96

/*		if(m_isByte&&cp.x<nst) cell.gOffset=-1;
		else if(!m_isByte&&cp.x<nst/2) cell.gOffset=-1;  
		else if(m_isByte) cell.gOffset+=cp.x;
		else cell.gOffset+=cp.x*2;
*/
	}
/*	else	 
	{
		if(m_isByte) cell.gOffset+=cp.x;
		else cell.gOffset+=cp.x*2;
	}
*/
	return cell;
}
                        
BOOL CGRegView::InputCheck(UINT nChar,int N, BOOL bSign,BOOL isByte) 
{                  	                        
    int pos;                 
    G_Register_Cell 	cell;
    cell=Caret2GReg(m_ptCaretPos);
    int  start=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[cell.gBank].nStartAddr; 		
//	if(m_ptCaretPos.y==0)
//		cell.gOffset-=start%16;  //modified by jerry on 10/14/96;

//	((CGRegWnd*)pGRWnd)->Line2Addr(m_ptCaretPos.y+m_nFirstViewLine,cell.gBank,cell.gOffset);  
//	cell.gOffset+=
    pos=m_ptCaretPos.offset;     
//  if(cpuid<=1&&cell.gOffset==14&&pos<=1)
    DWORD dwTemp;
    ASSERT(N==10||N==16);           
	int power=1;
    if(bSign)      //signed value
    {                                        
      ASSERT(N==10);  
	  WORD wTemp1,wTemp2;
      BOOL isNegative=0;
       int n,m=0;
      if(!m_isByte)      //WORD
      {
        int nTemp;          
        
        if(cell.gOffset<0)
        {
        	ASSERT(cell.gOffset==-1);
        	nTemp=((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][0];
        }
		else
		{
        	wTemp1=((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][cell.gOffset];
        	wTemp2=((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][cell.gOffset+1];
        	nTemp=wTemp1+(wTemp2<<8);
        }	
        if(cell.gOffset<0) ASSERT(nTemp>=0);////9/18/96
        if(nTemp<0) isNegative=1;
 
// Modify by Gates
        if(pos==0) 
        {   if(nChar=='+')
				{
					if ( isNegative ) nTemp = -nTemp;
				}
            else if(nChar=='-')
				{
					if(cell.gOffset<0) return 0;   //9/18/96
					if ( isNegative==0 ) nTemp = -nTemp;
				}
            else return 0;      
        }
        else
        {
        	if(nChar>'9'||nChar<'0') return 0;
  		    if(isNegative) 
        	    nTemp=((~nTemp)&0xffff)+1;
	        n=nTemp;
    	    dwTemp=nTemp;
    	    for(int i=5;i>pos;i--)
        	{
            	m=n%N;n/=N;
            	power*=10;
        	} 
        	m=n%N;           
	        dwTemp=dwTemp-m*power+(nChar-'0')*power; 

///////////////////////////9/18/96///////////////////////////////////
	        if(cell.gOffset<0)
	        {    if(dwTemp>0xff) return 0;}
	        else if(dwTemp>0x7fff) return 0;
		    if(isNegative) nTemp=(int)((~dwTemp)&0xffff)+1;
		    else nTemp=(int)dwTemp;             
        }   
//for fill the memory
        int Addr=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[cell.gBank].nStartAddr\
        			+cell.gOffset;  
//	    if( (cpuid<=2||cpuid==4)(cpuid<=2||cpuid==4||cpuid==7||cpuid==8)&Addr>=0x1F&&(!m_isByte)&&m_nHexORDec==10)
		if( cell.gOffset<0)
	    {
//	    	if(nTemp>255||nTemp<-255) return 0;
	    	if(nTemp>255) return 0;
	    }

//      if((cpuid<=2||cpuid==4)&&Addr>=0x1F)
		if(cell.gOffset<0)
        {
			SetGRMem(Addr+1,Addr+1,(BYTE*)&nTemp);
        	GetGRMem(Addr+1,Addr+1,(BYTE*)&nTemp);
        	nTemp=nTemp&0x00ff;
		}        			   
		else
		{
			SetGRMem(Addr,Addr+1,(BYTE*)&nTemp);
        	GetGRMem(Addr,Addr+1,(BYTE*)&nTemp);
        }	
		if(cell.gOffset<0)
			((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][0]=(BYTE)(nTemp&0xff);
//modified by jerry on 10/14/96
		   	if(cpuid==9||cpuid==17||cpuid==20)
   		   	{                                               
   	   	  	   int nt;
   	   	  	   nt= (cell.gBank+1)%((CGRegWnd*)pGRWnd)->m_rRange.nBanks;
   	   	  	   ((CGRegWnd*)pGRWnd)->m_GRValue[nt][0]=(BYTE)(nTemp&0xff);
   	   		}    
//end of modify   		
		else	
		{
			((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][cell.gOffset]=(BYTE)(nTemp&0xff);
        	((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][cell.gOffset+1]=(BYTE)(nTemp>>8);
//modified by jerry on 10/14/96
		   	if(cpuid==9||cpuid==17||cpuid==20)
   		   	{                                               
   	   	  	   int nt;
   	   	  	   nt= (cell.gBank+1)%((CGRegWnd*)pGRWnd)->m_rRange.nBanks;
   	   	  	   ((CGRegWnd*)pGRWnd)->m_GRValue[nt][cell.gOffset]=(BYTE)(nTemp&0xff);
   	   		   ((CGRegWnd*)pGRWnd)->m_GRValue[nt][cell.gOffset+1]=(BYTE)(nTemp>>8);
   	   		}    
//end of modify  
        }	
        return 1;
      }
      else    //BYTE
      {
        wTemp1=((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][cell.gOffset];
        isNegative=wTemp1&0x80  ;
        if(pos==0) 
        {   if(nChar=='+')
               wTemp1=isNegative?((~wTemp1)&0x0ff)+1:wTemp1;     
            else if(nChar=='-')
               wTemp1=isNegative?wTemp1:((~wTemp1)&0x0ff)+1;
            else return 0;      
            ((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][cell.gOffset]=(BYTE)wTemp1;
//modified by jerry on 10/14/96
		   	if(cpuid==9||cpuid==17||cpuid==20)
   		   	{                                               
   	   	  	   int nt;
   	   	  	   nt= (cell.gBank+1)%((CGRegWnd*)pGRWnd)->m_rRange.nBanks;
   	   	  	   ((CGRegWnd*)pGRWnd)->m_GRValue[nt][cell.gOffset]=(BYTE)wTemp1;
   	   		}    
//end of modify 
//            return 1;
        }
        else
        {
        	if(nChar>'9'||nChar<'0') return 0;
  		    if(isNegative) 
        	    wTemp1=((~wTemp1)&0x0ff)+1;
	        n=wTemp1;
	        dwTemp=wTemp1;
    	    for(int i=3;i>pos;i--)
        	{
            	m=n%N;n/=N;
            	power*=10;
        	} 
        	m=n%N;           
	        dwTemp=dwTemp-m*power+(nChar-'0')*power; 
            if(dwTemp>0x7f) return 0;
			if(isNegative) wTemp1=(WORD)((~dwTemp)&0x0ff)+1;
			else wTemp1=(WORD)dwTemp;
        }   
        int Addr=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[cell.gBank].nStartAddr\
        			+cell.gOffset;
		SetGRMem(Addr,Addr,(BYTE*)&wTemp1);
		GetGRMem(Addr,Addr,(BYTE*)&wTemp1);
		
		((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][cell.gOffset]=(BYTE)(wTemp1&0xff);
//modified by jerry on 10/14/96
	   	if(cpuid==9||cpuid==17||cpuid==20)
   	   	{                                               
   	   	  int nt;
   	   	  nt= (cell.gBank+1)%((CGRegWnd*)pGRWnd)->m_rRange.nBanks;
   	   	  ((CGRegWnd*)pGRWnd)->m_GRValue[nt][cell.gOffset]=(BYTE)(wTemp1&0xff);
   	   	}    
//end of modify   
        return 1;
////////////////            		
      }  
    }
     else  //unsigned   value
     {
//      ASSERT(N==10);
        unsigned char ch;
        if((ch=Char2Value(nChar))==255)  return 0;
        if(isByte)                         //BYTE
        {   
            unsigned char chTemp;
            chTemp=((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][cell.gOffset];

// Modify by Gates            
			if ( N == 10 ) {
            	if(nChar>'9'||nChar<'0') return 0;
                UINT u,q=0;
        		WORD wTemp;
        		wTemp=chTemp;
        		u=chTemp;
        		for(int j=3;j>pos+1;j--) 
        		{
     		       q=u%N;u/=N;
            	   power*=10;
        		} 
        		q=u%N;           
        		wTemp=wTemp-q*power+(nChar-'0')*power;
        		if(wTemp>0xff) return 0;
        		chTemp=wTemp;
			}
			else {
            	switch(pos){
            	case 0: chTemp=(chTemp&0x0f)|(ch<<4);break;
            	case 1: chTemp=(chTemp&0xf0)|(ch);break;
            	default:return 0;
            	} 
            }	
            int Addr=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[cell.gBank].nStartAddr\
        			+cell.gOffset;
			SetGRMem(Addr,Addr,(BYTE*)&chTemp);
       		GetGRMem(Addr,Addr,(BYTE*)&chTemp);
			((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][cell.gOffset]=chTemp;
//modified by jerry on 10/14/96
		   	if(cpuid==9||cpuid==17||cpuid==20)
    	   	{                                               
    	   	  int nt;
    	   	  nt= (cell.gBank+1)%((CGRegWnd*)pGRWnd)->m_rRange.nBanks;
    	   	  ((CGRegWnd*)pGRWnd)->m_GRValue[nt][cell.gOffset]=chTemp;	
    	   	  
    	   	}    
//end of modify   
        	chTemp=0;
        }
        else          //UNSIGNED WORD
        {
            UINT uTemp;        
            WORD wTemp1,wTemp2;
// add on 9/18/96            
	      	if(cell.gOffset<0)
	      	{
	      		ASSERT(cell.gOffset==-1); 
	      		uTemp=((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][0];  
	      	}
	      	else
	      	{	
	        	wTemp1=((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][cell.gOffset];
    	    	wTemp2=((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][cell.gOffset+1];
        		uTemp=wTemp1+(wTemp2<<8);
            }
            
//          UINT* pMemUInt=(UINT*)((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank];
//          uTemp=(UINT)pMemUInt[cell.gOffset]; 
            if(N==16)
            {
            	switch(pos){
            	case 0: uTemp=(uTemp&0x0fff)|(ch<<12);break;
            	case 1: uTemp=(uTemp&0xf0ff)|(ch<<8);break;
            	case 2: uTemp=(uTemp&0xff0f)|(ch<<4);break;
            	case 3: uTemp=(uTemp&0xfff0)|(ch);break;
            	default:return 0;
                }
            }   
            else
            {
            	if(nChar>'9'||nChar<'0') return 0;
                UINT u,q=0;
        		DWORD dwTemp;
        		dwTemp=uTemp;
        		u=uTemp;
//        		for(int j=3;j>pos+1;j--) // Modify by Gates Hua
        		for(int j=5;j>pos+1;j--)
        		{
     		       q=u%N;u/=N;
            	   power*=10;
        		} 
        		q=u%N;           
        		dwTemp=dwTemp-q*power+(nChar-'0')*power; 
        		if(cell.gOffset<0)
        			if(dwTemp>0xff) return 0;
        		else	  
        			if(dwTemp>0xffff) return 0;
        		uTemp=(UINT)dwTemp;       

            }                                          
//            if(!CheckLegal((UINT)uTemp,bSign) ) return 0;
//for fill the memory
     
            int Addr=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[cell.gBank].nStartAddr\
        			+cell.gOffset; 
        			

/////////////////////////////////////9/18/96/////////////////////////////
            if(cell.gOffset<0) if(uTemp>0xff)  return 0;
//			if((cpuid<=2||cpuid==4||cpuid==7||cpuid==8)&&Addr>=0x1F&&(!m_isByte)&&m_nHexORDec==10)        			
//     		{
//     			if(uTemp>0xff)  return 0;
//     		}
/////////////////////////////////////end of modify////////////////////////
	        
//	        if((cpuid<=2||cpuid==4||cpuid==7||cpuid==8)&&Addr>=0x1F)
	        if((cpuid<=2||cpuid==4||cpuid==7||cpuid==8)&&cell.gOffset<0)
    	    {
				SetGRMem(Addr+1,Addr+1,(BYTE*)&uTemp);
	       		GetGRMem(Addr+1,Addr+1,(BYTE*)&uTemp);
        		uTemp=uTemp&0x00ff;
			}        			   
			else
			{
				SetGRMem(Addr,Addr+1,(BYTE*)&uTemp);
    	    	GetGRMem(Addr,Addr+1,(BYTE*)&uTemp);
			}
			if(cell.gOffset<0)
			{
			    ((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][0]=(BYTE)(uTemp&0xff);
//by jerry on 10/14/96
    	    	if(cpuid==9||cpuid==17||cpuid==20)
    	    	{                                               
    	    	  int nt;
    	    	  nt= (cell.gBank+1)%((CGRegWnd*)pGRWnd)->m_rRange.nBanks;
    	    	  ((CGRegWnd*)pGRWnd)->m_GRValue[nt][0]=(BYTE)(uTemp&0xff);	
    	    	}              
//end of modified;    	    

			}
			else
			{
				((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][cell.gOffset]=(BYTE)(uTemp&0xff);
    	    	((CGRegWnd*)pGRWnd)->m_GRValue[cell.gBank][cell.gOffset+1]=(BYTE)(uTemp>>8);
//by jerry on 10/14/96
    	    	if(cpuid==9||cpuid==17||cpuid==20)
    	    	{                                               
    	    	  int nt;
    	    	  nt= (cell.gBank+1)%((CGRegWnd*)pGRWnd)->m_rRange.nBanks;
    	    	  ((CGRegWnd*)pGRWnd)->m_GRValue[nt][cell.gOffset]=(BYTE)(uTemp&0xff);	
    	    	  ((CGRegWnd*)pGRWnd)->m_GRValue[nt][cell.gOffset+1]=(BYTE)(uTemp>>8);
    	    	}              
//end of modified;    	    
    	    }	
        	uTemp=0;
        }
//      m_bWriteDone=0;    
        return 1;                       
     }    
return 1;
}                        

 
int CGRegView::GetGridWidth()
{
    int t=m_nAddrColWidth;
    for(int i=m_nFirstViewCol;i<m_nCellsPerLine;i++)
        t+=m_nColWidth;
    return t;    
}                
 
 
void CGRegView::DrawGrid(CDC* pDC,int nCols,int nRows)
{
    int nWidth=GetGridWidth();                       
    
    CPen *pGrayPen,* pOldPen;
    pGrayPen=new CPen;
    pGrayPen->CreatePen(PS_SOLID,1,PALETTEINDEX(11));
    pOldPen=pDC->SelectObject(pGrayPen);
    CRect  rect(0,0,min(nWidth,m_rectClient.right),m_nLineHeight);
    ::FillRect(pDC->m_hDC,&rect,(HBRUSH)::GetStockObject(LTGRAY_BRUSH) );
    rect.right=min(m_nAddrColWidth,m_rectClient.right);
    rect.bottom=m_rectClient.bottom;
    ::FillRect(pDC->m_hDC,&rect,(HBRUSH)::GetStockObject(LTGRAY_BRUSH) );
    pDC->MoveTo(m_nAddrColWidth,0);
    pDC->LineTo(m_nAddrColWidth,m_rectClient.bottom);

    int nGridWidth=m_nAddrColWidth,nGridHeight=m_nLineHeight;         
    for(int i=1;i<nCols;i++)
    {
        nGridWidth+=m_nColWidth;
        if(nGridWidth-m_ptFirst.x>m_nAddrColWidth){
            pDC->MoveTo(nGridWidth-m_ptFirst.x,0);
            pDC->LineTo(nGridWidth-m_ptFirst.x,m_rectClient.bottom);
        }   
    }
    pDC->MoveTo(0,m_nLineHeight);
    pDC->LineTo(min(m_rectClient.right,nGridWidth-m_ptFirst.x),m_nLineHeight);
    for(i=1;i<nRows-1;i++)
    {   
        nGridHeight+=m_nLineHeight;
        pDC->MoveTo(BANKWIDTH,nGridHeight);
        pDC->LineTo(min(m_rectClient.right,nGridWidth-m_ptFirst.x),nGridHeight);//-m_ptFirst.y*m_nLineHeight);
    }            
    pDC->SelectObject(pOldPen);
    pGrayPen->DeleteObject();
    delete pGrayPen;
    pOldPen=(CPen*)pDC->SelectStockObject(WHITE_PEN);

//add on 9/18/96
    pDC->MoveTo(BANKWIDTH-1,0);
    pDC->LineTo(BANKWIDTH-1,m_rectClient.bottom);
                         
//3D Style White                                         
    pDC->MoveTo(min(m_rectClient.right,nGridWidth-m_ptFirst.x),0);
    pDC->LineTo(0,0);
    pDC->LineTo(0,m_rectClient.bottom);
    nGridHeight=m_nLineHeight+1;
//9/19/96
    pDC->MoveTo(0,m_nLineHeight);
    pDC->LineTo(BANKWIDTH,m_nLineHeight);
    
    for(i=1;i<nRows;i++)    
    {
          pDC->MoveTo(BANKWIDTH,nGridHeight);
          pDC->LineTo(m_nAddrColWidth,nGridHeight);
          nGridHeight+=m_nLineHeight;
    }
    nGridWidth=m_nAddrColWidth+1;
    for(i=1;i<nCols;i++)
    {     
          pDC->MoveTo(nGridWidth,0);
          pDC->LineTo(nGridWidth,m_nLineHeight);
          nGridWidth+=m_nColWidth;
    }               
    pDC->SelectObject(pOldPen);

//3D Style Black 

    //add on 9/18/96
    pDC->MoveTo(BANKWIDTH,0);
    pDC->LineTo(BANKWIDTH,m_rectClient.bottom);

    pDC->MoveTo(m_nAddrColWidth,0);
    pDC->LineTo(m_nAddrColWidth,m_rectClient.bottom);
    pDC->MoveTo(BANKWIDTH,m_nLineHeight);
    pDC->LineTo(min(m_rectClient.right,nGridWidth-m_ptFirst.x),m_nLineHeight);      
    nGridHeight=m_nLineHeight;

//9/19/96
    pDC->MoveTo(0,m_nLineHeight);
    pDC->LineTo(BANKWIDTH,m_nLineHeight);

    for(i=1;i<nRows;i++)    
    {
          pDC->MoveTo(BANKWIDTH,nGridHeight);
          pDC->LineTo(m_nAddrColWidth,nGridHeight);
          nGridHeight+=m_nLineHeight;
    }
    nGridWidth=m_nAddrColWidth;
    for(i=1;i<nCols;i++)
    {     
          pDC->MoveTo(nGridWidth,0);
          pDC->LineTo(nGridWidth,m_nLineHeight);
          nGridWidth+=m_nColWidth;
    }               

}

BEGIN_MESSAGE_MAP(CGRegView, CView)
    //{{AFX_MSG_MAP(CGRegView)
    ON_WM_LBUTTONDOWN()
    ON_WM_CREATE()
    ON_WM_VSCROLL()
    ON_WM_CHAR()
    ON_WM_SIZE()
    ON_WM_HSCROLL()
    ON_COMMAND(ID_VIEW_SIGNEDDECIMAL, OnViewSigned)
    ON_COMMAND(ID_VIEW_UNSIGNEDDECIMAL, OnViewUnsigned)
    ON_WM_SETFOCUS()
    ON_WM_KILLFOCUS()
    ON_WM_KEYDOWN()
    ON_WM_MOUSEMOVE()
    ON_WM_SETCURSOR()
    ON_WM_LBUTTONUP()
    ON_WM_RBUTTONDOWN()
    ON_COMMAND(ID_EDIT_SEARCH, OnEditSearch)
    ON_COMMAND(ID_EDIT_SEARCHNEXT, OnEditSearchnext)
    ON_COMMAND(ID_EDIT_GOTO, OnEditGoto)
    ON_UPDATE_COMMAND_UI(ID_EDIT_GOTO, OnUpdateEditGoto)
	ON_COMMAND(ID_GROUP_MEMORY, OnGroupMemory)
	ON_COMMAND(ID_VIEW_HEXADECIMAL, OnViewHexadecimal)
	ON_COMMAND(ID_VIEW_BYTE, OnViewByte)  
	ON_MESSAGE(XM_REPAINT, OnXMRepaint)
	ON_COMMAND(ID_VIEW_WORD, OnViewWord)
	ON_UPDATE_COMMAND_UI(ID_VIEW_WORD, OnUpdateViewWord)
	ON_UPDATE_COMMAND_UI(ID_VIEW_BYTE, OnUpdateViewByte)
	ON_UPDATE_COMMAND_UI(ID_VIEW_HEXADECIMAL, OnUpdateViewHexadecimal)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SIGNEDDECIMAL, OnUpdateViewSigneddecimal)
	ON_UPDATE_COMMAND_UI(ID_VIEW_UNSIGNEDDECIMAL, OnUpdateViewUnsigneddecimal)
	ON_COMMAND(ID_VIEW_REFRESH, OnViewRefresh)
	//}}AFX_MSG_MAP
   

END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CGRegView drawing



/////////////////////////////////////////////////////////////////////////////
// CGRegView message handlers


void CGRegView::SetMemCaretPos(CaretPos pt)
{
    CPoint point;
    point.y=(1+pt.y-m_nFirstViewLine)*m_nLineHeight;
    point.x=(pt.x-m_nFirstViewCol)*m_nColWidth+\
    		m_nAddrColWidth+m_szFont.cx/2+pt.offset*m_szFont.cx;
    SetCaretPos(point); 
    if(pt.y<m_nFirstViewLine||point.x<m_nAddrColWidth)
    {ShowCaret(); HideCaret();}
    else ShowCaret();       
}   
 
CaretPos CGRegView::Point2Caret(CPoint pt)
{
	 CaretPos cp;
	 int temp,t;
	 t= (pt.x-m_nAddrColWidth)%m_nColWidth  ;
	 temp=t?(pt.x-m_nAddrColWidth)/m_nColWidth:(pt.x-m_nAddrColWidth)/m_nColWidth-1;
	 cp.x=m_nFirstViewCol+temp;
	 temp =(pt.y-m_nLineHeight)%m_nLineHeight?(pt.y-m_nLineHeight)/m_nLineHeight:(pt.y-m_nLineHeight)/m_nLineHeight-1;
	 cp.y=m_nFirstViewLine+temp;
	 
	 if(t<m_szFont.cx/2) cp.offset=0;
	 else cp.offset=(t-m_szFont.cx)/m_szFont.cx;
	 return cp;
}

void CGRegView::OnLButtonDown(UINT nFlags, CPoint point)
{

    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
        return ;
    }    

    // TODO: Add your message handler code here and/or call default
    if(!HitTest(point))  return ;	
    BOOL bCaret=0;
    CaretPos cp;
    cp=Point2Caret(point);    
    G_Register_Cell greg=Caret2GReg(cp);
    int start,end;
    start=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[greg.gBank].nStartAddr;
    end=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[greg.gBank].nEndAddr;
    if( (cp.y<=((CGRegWnd*)pGRWnd)->m_nEndLine)&&(end-start+1>greg.gOffset) )
    {
		if(cpuid<=2||cpuid==4||cpuid==7||cpuid==8)
		{
		  if(greg.gBank==0)
		  {
		  	if(greg.gOffset>=0)//=start%16-1)  modified on 10/14/96 by jerry
		  	{
		  		bCaret=1;
//		  		if(greg.gOffset==start%16-1&&cp.offset<2)  //modified on 10/14/96 by jerry
//		  	  		bCaret=0;
		  	}	  
		  }
		  else
		    bCaret=1;	
		}
		else                     
			if(greg.gOffset>=0) bCaret=1;
//add on 10/15/96 by jerry    
    	if((!m_isByte)&&greg.gOffset==-1)  
    	   if(m_isSigned) 
    	   {   if(cp.offset>2) bCaret=1;}
    	   else                          
    	   {   if(cp.offset>1) bCaret=1;}
    	   
//end of add            
		if(bCaret)
		{  
    		m_ptCaretPos=cp;
    		SetMemCaretPos(cp);
    		SetActiveWindow();	
    		SetFocus();
    	}	
    }
    CView::OnLButtonDown(nFlags, point);
}

BOOL CGRegView::HitTest(CPoint pt)
{
    if(pt.x<m_nAddrColWidth||pt.y<m_nLineHeight||
       pt.x>m_nAddrColWidth+(m_nCellsPerLine-m_nFirstViewCol)*m_nColWidth)
        return 0; 
        
    else return 1;    
}                                                           


G_Register_Cell CGRegView::Point2Cell(CPoint pt)
{
     G_Register_Cell  cell;
//     CPoint point;
     cell.gPoint.y=pt.y/m_nLineHeight-1;
     cell.gPoint.x=(pt.x-m_nAddrColWidth)/m_nColWidth+m_nFirstViewCol;
     ((CGRegWnd*)pGRWnd)->Line2Addr(cell.gPoint.y+m_nFirstViewLine,cell.gBank,cell.gOffset);
     return cell;
}


int CGRegView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{

    if (CView::OnCreate(lpCreateStruct) == -1)
        return -1;
          
    TEXTMETRIC tm;
    CDC * pDC = GetDC();
    pDC->SelectStockObject(ANSI_FIXED_FONT);
    pDC->GetTextMetrics(&tm);
    ReleaseDC(pDC); 

    m_szFont.cy = tm.tmHeight + tm.tmExternalLeading;
    m_szFont.cx = tm.tmAveCharWidth;
    
    if(m_isByte)
       if(m_nHexORDec==16)
            m_nColWidth=3*m_szFont.cx;
       else if(m_isSigned)
                 m_nColWidth=5*m_szFont.cx;
       else m_nColWidth=4*m_szFont.cx;
    else if(m_nHexORDec==16)
            m_nColWidth=5*m_szFont.cx;
         else if(m_isSigned)
                  m_nColWidth=7*m_szFont.cx;
              else                       
                  m_nColWidth=6*m_szFont.cx;  
    
    m_nAddrColWidth=5*m_szFont.cx+BANKWIDTH; 
    
    DWORD dwStyle=GetStyle();
    dwStyle&=~WS_VSCROLL;
    SetWindowLong(m_hWnd,GWL_STYLE,dwStyle);     
 
    return 0;
}
                            
void CGRegView::OnDraw(CDC* pDC)
{
    pDC->SetBkMode(TRANSPARENT );
    pDC->SelectStockObject(ANSI_FIXED_FONT);

    int lines; 
    lines=m_rectClient.bottom/m_nLineHeight+1;
    DrawGrid(pDC,1+m_nCellsPerLine,lines);
    CRect rect;
    rect.SetRect(0,0,BANKWIDTH,m_nLineHeight); 
    pDC->DrawText("Bank",4,&rect,DT_VCENTER|DT_CENTER);
    rect.SetRect(BANKWIDTH,0,m_nAddrColWidth,m_nLineHeight);
    pDC->DrawText("Addr",4,&rect,DT_VCENTER|DT_CENTER);
    
    rect.SetRect(m_nAddrColWidth,0,m_nAddrColWidth+m_nColWidth,m_nLineHeight);
    char text[4]="";
    for(int i=m_nFirstViewCol;i<m_nCellsPerLine;i++)
    {
        sprintf(text,"%X",i);
        pDC->DrawText(text,1,&rect,DT_VCENTER|DT_CENTER);
        rect.OffsetRect(m_nColWidth,0);
    }
    
    UINT addr; 
    int nst;
    int nBank,nOffset,num;                                 
    CPen *pOldPen;
    pOldPen=(CPen*)pDC->SelectStockObject(BLACK_PEN);    
    for(i=0;i<min(lines,((CGRegWnd*)pGRWnd)->m_nEndLine+1-m_nFirstViewLine);i++)
    {
        addr=((CGRegWnd*)pGRWnd)->Line2Addr(i+m_nFirstViewLine,nBank,nOffset);
        if(IsBankSeperator(i+m_nFirstViewLine) )
        {
// bank number
			rect.SetRect(0,(i+1)*m_nLineHeight,BANKWIDTH,(i+2)*m_nLineHeight);
			sprintf(text,"%d",nBank);
			pDC->DrawText(text,1,&rect,DT_VCENTER|DT_CENTER);
        	pDC->MoveTo(0,(i+2)*m_nLineHeight);
        	pDC->LineTo(BANKWIDTH,(i+2)*m_nLineHeight);
        	pDC->SelectStockObject(WHITE_PEN);
        	pDC->MoveTo(0,(i+2)*m_nLineHeight+1);
        	pDC->LineTo(BANKWIDTH,(i+2)*m_nLineHeight+1);
        	pDC->SelectObject(pOldPen);
        }	             
        num=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[nBank].nEndAddr-\
        	((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[nBank].nStartAddr+1;
        nst=addr%16;
//      num+=nst;
/*
        if(num-nOffset>16)	num=m_nCellsPerLine;
        else num=m_nCellsPerLine==16?num-nOffset:(num-nOffset)/2;
*/      if(m_isByte)
			num=m_nCellsPerLine-nst;
		else
			num=m_nCellsPerLine-nst/2;                                   
		if(nOffset<0) nOffset=0;	
        DrawLine(pDC,i,addr,&((CGRegWnd*)pGRWnd)->m_GRValue[nBank][nOffset],num);
    }           
//    if(!m_pMemLayout->m_bWriteDone)
    DrawNewData( pDC);
   	BYTE currentBank;
	currentBank=GetBank(); 
	char txt[6]="";
	CString title="General Purpose Register File [Bank ";
	sprintf(txt,"%d]",currentBank);
	title+=txt;
	pGRWnd->SetWindowText(title);

}                     

BOOL CGRegView::IsBankSeperator(int line)
{
	int tem=0;
	for(int i=0;i<((CGRegWnd*)pGRWnd)->m_rRange.nBanks;i++)
	{
		tem+=((CGRegWnd*)pGRWnd)->m_arLinesPerBank[i];
		if(tem-1==line) return TRUE;	
		if(tem>line) return FALSE;
	}
	return FALSE;		
}
                      
void CGRegView::DrawNewData(CDC*)
{
/*  pDC->SetTextColor(RGB(255,0,0));
    pDC->SetBkMode(OPAQUE);
    CRect rect;
    int x,y; 
    for(int i=0;i<m_pMemLayout->m_arrayNewData.GetSize();i++)
    {
        x=m_pMemLayout->m_arrayNewData[i]&0x000f;
        y=m_pMemLayout->m_arrayNewData[i]>>4;
        rect.top=(y-m_pMemLayout->m_nFirstViewableLine+1)*m_nLineHeight+1;
        rect.left=(x-m_nFirstViewableCol)*m_nColWidth+m_nAddrColWidth;
        rect.bottom=rect.top+m_nLineHeight;
        rect.right=rect.left+m_nColWidth;    

        int* pMemInt=(int*)( m_pMemLayout->m_pMemByte ); 
        int addr=(y-m_pMemLayout->m_nStartLine)*m_nCellsPerLine+x; 
        int integer;
        char text[7]="";
        integer=pMemInt[addr];
        if(m_nHexORDec==16)
        {   sprintf(text,"%04X",integer); 
            text[4]=0;
        }    
        else
        if(!m_isSigned)
        {  sprintf(text,"%05u",integer); text[5]=0;}
        else{ UnsignToSign(text,integer);text[6]=0;}
        if(rect.left>=m_nAddrColWidth)
            pDC->DrawText(text,-1,&rect,DT_VCENTER|DT_CENTER);
        
    }
    
    pDC->SetTextColor(RGB(0,0,0));
    pDC->SetBkMode(TRANSPARENT);
*/
    
}    

    
void CGRegView::DrawLine(CDC* pDC,int line,UINT addr,BYTE* pMemByte,int num )
{
    CRect rect(BANKWIDTH,(line+1)*m_nLineHeight+1,m_nAddrColWidth,(line+2)*m_nLineHeight);
    char text[7]="";
    int nst=addr%16;
    sprintf(text,"%03X",addr-nst); 
    pDC->DrawText(text,3,&rect,DT_VCENTER|DT_CENTER);

    if(m_isByte)
    	rect.SetRect(m_nAddrColWidth+nst*m_nColWidth-m_ptFirst.x,(line+1)*m_nLineHeight+1,\
                 m_nAddrColWidth+(nst+1)*m_nColWidth-m_ptFirst.x,(line+2)*m_nLineHeight);
    else             
		rect.SetRect(m_nAddrColWidth+nst/2*m_nColWidth-m_ptFirst.x,(line+1)*m_nLineHeight+1,\
                 m_nAddrColWidth+(nst/2+1)*m_nColWidth-m_ptFirst.x,(line+2)*m_nLineHeight);
    if(m_isByte)
    {
        BYTE byte;
        int ntemp;
        for(int i=0;i<min(num,m_nCellsPerLine);i++)
        {
            byte=pMemByte[i];
            if(m_nHexORDec==16)
            {   sprintf(text,"%02X",byte); 
                text[2]=0;
            }    
            else
               if(!m_isSigned)
               {  sprintf(text,"%03u",(UINT)byte); text[3]=0;}
               else
               { 
			      if(byte&0x80)        
	  			  {		
	  	  			 ntemp=((~byte)&0xff)+1;
	  	  	 		 sprintf(text,"-%03u",ntemp);
	  	  		  }
	  	  		  else 	                         
	  	  			 sprintf(text,"+%03u",byte); text[4]=0;
//                  sprintf(text,"%+04d",(char)byte); text[4]=0;
               }
            if(rect.left>=m_nAddrColWidth)
                pDC->DrawText(text,-1,&rect,DT_VCENTER|DT_CENTER);
            rect.OffsetRect(m_nColWidth ,0);
        }

    }
    else 
    {
        int* pMemInt;
        int integer;                    
        int ntemp;
        int max=min(num,m_nCellsPerLine);
        if( (cpuid<=2||cpuid==4||cpuid==7||cpuid==8)&&nst!=0)
           	pMemInt=(int*)&(pMemByte[1]);
        else    	 
        	pMemInt=(int*)(pMemByte ); 	 
        if( (cpuid<=2||cpuid==4||cpuid==7||cpuid==8)&&nst!=0)
        {
            integer=pMemByte[0];
            if(m_nHexORDec==16)
            {   sprintf(text,"%04X",integer); 
                text[4]=0;
            }    
            else
               if(!m_isSigned)
               {  
               		sprintf(text,"%05u",(UINT)integer); 
               		text[5]=0;
               }
               else
               {    
//            		UnsignToSign(text,integer);
	  	  			if(integer&0x8000)  
  	  	  			{		
	  	  	 			ntemp=((~integer)&0xffff)+1;
	  	  	 			sprintf(text,"-%05u",ntemp);
	  	  			}
	  	  			else 	                         
	  	  				sprintf(text,"+%05u",integer);
               		text[6]=0;
               }
            if(rect.left>=m_nAddrColWidth)
                pDC->DrawText(text,-1,&rect,DT_VCENTER|DT_CENTER);
            rect.OffsetRect(m_nColWidth ,0);
        	max--;
        }	                         
        
        for(int i=0;i<max;i++)
        {
            integer=pMemInt[i];
            if(m_nHexORDec==16)
            {   sprintf(text,"%04X",integer); 
                text[4]=0;
            }    
            else
               if(!m_isSigned)
               {  
               		sprintf(text,"%05u",(UINT)integer); 
               		text[5]=0;
               }
               else
               {    
//            		UnsignToSign(text,integer);
	  	  			if(integer&0x8000)  
  	  	  			{		
	  	  	 			ntemp=((~integer)&0xffff)+1;
	  	  	 			sprintf(text,"-%05u",ntemp);
	  	  			}
	  	  			else 	                         
	  	  				sprintf(text,"+%05u",integer);
               		text[6]=0;
               }
            if(rect.left>=m_nAddrColWidth)
                pDC->DrawText(text,-1,&rect,DT_VCENTER|DT_CENTER);
            rect.OffsetRect(m_nColWidth ,0);
        }
    }
//  pDC->SetBkMode(TRANSPARENT);    
        
}
       

void CGRegView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* )
{
    // TODO: Add your message handler code here and/or call default
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
        return ;
    }     
    
    
    CRect rect; 
    rect=m_rectClient;
    int i;
    rect.left=0;
    rect.top=m_nLineHeight+1;
    switch(nSBCode) {
        case SB_LINEUP:
        case SB_PAGEUP: 
            if(m_ptFirst.y <= 0)  return;
            i = m_nLineHeight;
            m_ptFirst.y --;      
            ScrollWindow(0, i,&rect, &rect);
			GetScrollBarCtrl(SB_VERT)->SetScrollPos( m_ptFirst.y);
			m_nFirstViewLine--;
			m_nLastViewLine--;
//            SetScrollPos(SB_VERT, m_ptFirst.y);
            SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_LINEDOWN:    
        case SB_PAGEDOWN:
            if(m_ptFirst.y>= ((CGRegWnd*)pGRWnd)->m_nVScrollRange)    return;
            i =m_nLineHeight;
            m_ptFirst.y ++;;
            ScrollWindow(0,-i,&rect,&rect);
			m_nFirstViewLine++;
			m_nLastViewLine++;
			GetScrollBarCtrl(SB_VERT)->SetScrollPos( m_ptFirst.y);
			SetScrollPos(SB_VERT, m_ptFirst.y);
            SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_THUMBTRACK:  
        case SB_THUMBPOSITION:           
            if(int(nPos) == m_ptFirst.y) return;     
            int t=0;
            t=nPos-m_ptFirst.y;                    
            
            m_ptFirst.y=m_ptFirst.y+t;
	
            ScrollWindow( 0,t,&rect,&rect);   
            m_nFirstViewLine+=t;
            m_nLastViewLine+=t;
//            SetScrollPos(SB_VERT, m_ptFirst.y); 
            Invalidate();
            UpdateWindow();                     
            return;
    }  
    rect=m_rectClient;        
    rect.top=rect.bottom-m_rectClient.bottom%m_nLineHeight-m_nLineHeight;
    InvalidateRect(&rect);
    UpdateWindow();    
//    CView::OnVScroll(nSBCode, nPos, pScrollBar);
}       


void CGRegView::Caret2Rect(CaretPos cp,CRect& rect)
{
	int x,y;
	x=cp.x-m_nFirstViewCol;
	y=1+cp.y-m_nFirstViewLine;
	rect.left=m_nAddrColWidth+x*m_nColWidth;
	rect.top=y*m_nLineHeight;
	rect.right=rect.left+m_nColWidth;
	rect.bottom=rect.top+m_nLineHeight;
}

 
void CGRegView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    // TODO: Add your message handler code here and/or call default      // TODO: Add your message handler code here and/or call default
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
        return ;
    }     
    
    if(!InputCheck(	nChar,m_nHexORDec,m_isSigned,m_isByte) )
        return; 
    CRect rect;
	Caret2Rect(m_ptCaretPos,rect);  

////to support highlight the modified data
    UINT newdata=0;
//end of add
    CaretMove(0);// move right      
    InvalidateRect(&rect);
    if(cpuid==9||cpuid==17||cpuid==20) Invalidate();
    UpdateWindow();                                        
	if(cpuid==9||cpuid==17||cpuid==20)
		((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,1)->SendMessage(XM_REPAINT,-1,0);
	else
		((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,1)->SendMessage(XM_REPAINT,m_ptCaretPos.y,0); 	
    CView::OnChar(nChar, nRepCnt, nFlags);
    
}

void CGRegView::OnSize(UINT nType, int cx, int cy)
{
	CView::OnSize(nType, cx, cy);
	
	GetClientRect(&m_rectClient);
    ((CGRegWnd*)pGRWnd)->m_nVScrollRange=( (CGRegWnd*)pGRWnd)->m_nEndLine-cy/18+2;
	m_szScroll.cx=m_nColWidth*(m_nCellsPerLine); 
	m_szScroll.cx=m_szScroll.cx-(cx-m_nAddrColWidth)/m_nColWidth*m_nColWidth;
	if(m_szScroll.cx<=0) m_szScroll.cx=0;
	SetScrollRange(SB_HORZ,0,m_szScroll.cx);

//	SetScrollRange(SB_VERT,0,( (CGRegWnd*)pGRWnd)->m_nVScrollRange);   
	GetScrollBarCtrl(SB_VERT)->SetScrollRange(0,( (CGRegWnd*)pGRWnd)->m_nVScrollRange);
//will be free out later

//add on 9/4/96
	m_ptFirst.y=0;
	m_nFirstViewLine=0;
//end of add

	m_nLastViewLine=m_nFirstViewLine+cy/m_nLineHeight-1; 
	m_ptFirst.x=0;
	m_nFirstViewCol=0;  

	SetMemCaretPos(m_ptCaretPos);
	SetScrollPos(SB_HORZ,0);
}

void CGRegView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
        return ;
    }     
    CRect rect;
    rect=m_rectClient;
    rect.left=m_nAddrColWidth+1;
    int i;                                
    switch(nSBCode) {
        case SB_LINELEFT:                 
            if(m_ptFirst.x <= 0)  return;  
            i = m_nColWidth;
            m_ptFirst.x -= i;;   
            m_nFirstViewCol--;
            ScrollWindow(i, 0,&rect,&rect);
            SetScrollPos(SB_HORZ, m_ptFirst.x);
//            m_ptCaretPos.x--;
            SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_LINERIGHT:
            if(m_ptFirst.x >= m_szScroll.cx)    return;
               i =m_nColWidth;
            m_nFirstViewCol++;     
            m_ptFirst.x += i;
            ScrollWindow(-i,0,&rect,&rect);
            SetScrollPos(SB_HORZ, m_ptFirst.x);
            SetMemCaretPos(m_ptCaretPos);
            break;     
        case SB_PAGELEFT: 
            if(m_ptFirst.x == 0)    return;
            i = m_ptFirst.x;
            m_ptFirst.x =0;   
            m_nFirstViewCol=0;
            ScrollWindow(i, 0,&rect,&rect);
            SetScrollPos(SB_HORZ, m_ptFirst.x); 
            SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_PAGERIGHT:
            if(m_ptFirst.x >= m_szScroll.cx)    return;
            i =m_szScroll.cx-m_ptFirst.x;
            m_nFirstViewCol+=(m_szScroll.cx-m_ptFirst.x)/m_nColWidth;    
            m_ptFirst.x =m_szScroll.cx;
            ScrollWindow(-i, 0,&rect,&rect);
            SetScrollPos(SB_HORZ, m_ptFirst.x);
            SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_THUMBTRACK:
            
            break;
        case SB_THUMBPOSITION:           
            if(int(nPos) == m_ptFirst.x) return;       
            if(nPos>(UINT)m_ptFirst.x)
            {
                if(m_ptFirst.x >= m_szScroll.cx)    return;
                i =m_szScroll.cx-m_ptFirst.x;
                m_nFirstViewCol+=(m_szScroll.cx-m_ptFirst.x)/m_nColWidth;    
                m_ptFirst.x =m_szScroll.cx;
                ScrollWindow(-i, 0,&rect,&rect);
                SetScrollPos(SB_HORZ, m_ptFirst.x);
            }   
            else
            {
                if(m_ptFirst.x == 0)    return;
                i = m_ptFirst.x;
                m_ptFirst.x =0;   
                m_nFirstViewCol=0;
                ScrollWindow(i, 0,&rect,&rect);
                SetScrollPos(SB_HORZ, m_ptFirst.x);
            }
            
            break;
    } 
    CView::OnHScroll(nSBCode, nPos, pScrollBar);
}    


void CGRegView::OnViewWord()
{
	m_isByte=0;
    m_nCellsPerLine=8;  //8 or 16
//  m_isSigned=0;
//  m_nHexORDec=16;

	if(m_isSigned) m_nHexORDec=10;
	if(m_nHexORDec==16)
       m_nColWidth=5*m_szFont.cx;
    else if(m_isSigned)
       m_nColWidth=7*m_szFont.cx;
    else                       
       m_nColWidth=6*m_szFont.cx;  

    m_ptCaretPos.x=0;
    m_ptCaretPos.y=1;
    m_ptCaretPos.offset=0;      

    m_ptFirst.x=0;
    m_nFirstViewCol=0;

	m_szScroll.cx=m_nColWidth*m_nCellsPerLine;
	m_szScroll.cx=m_szScroll.cx-(m_rectClient.right-m_nAddrColWidth)/m_nColWidth*m_nColWidth;
	SetScrollRange(SB_HORZ,0,m_szScroll.cx);
	SetScrollPos(SB_HORZ,0);
	SetCellEndPos();
    SetMemCaretPos(m_ptCaretPos);   
    Invalidate();
    UpdateWindow();
}


void CGRegView::OnViewByte()
{
	m_isByte=1;
    m_nCellsPerLine=16;  //8 or 16
//  m_isSigned=0;
//  m_nHexORDec=16;
	if(m_isSigned) m_nHexORDec=10;
    if(m_nHexORDec==16)
       m_nColWidth=3*m_szFont.cx;
    else if(m_isSigned)
       m_nColWidth=5*m_szFont.cx;
    else m_nColWidth=4*m_szFont.cx;

    m_ptCaretPos.x=0;
    m_ptCaretPos.y=1;
    m_ptCaretPos.offset=0;      

    m_ptFirst.x=0;
    m_nFirstViewCol=0;

	m_szScroll.cx=m_nColWidth*m_nCellsPerLine;
	m_szScroll.cx=m_szScroll.cx-(m_rectClient.right-m_nAddrColWidth)/m_nColWidth*m_nColWidth;
	SetScrollRange(SB_HORZ,0,m_szScroll.cx);
	SetScrollPos(SB_HORZ,0);
	SetCellEndPos();        
	SetMemCaretPos(m_ptCaretPos);
    Invalidate();
    UpdateWindow();
                     	
	// TODO: Add your command handler code here
}

void CGRegView::OnViewHexadecimal()
{
//  m_isByte=0;
    m_isSigned=0;
    m_nHexORDec=16;
    m_nCellsPerLine=m_isByte?16:8;  //8 or 16
    m_ptCaretPos.x=0;
    m_ptCaretPos.y=1;
    m_ptCaretPos.offset=0;      

    m_ptFirst.x=0;
    m_nFirstViewCol=0;

    if(m_isByte)
        m_nColWidth=3*m_szFont.cx;
    else
        m_nColWidth=5*m_szFont.cx;

	m_szScroll.cx=m_nColWidth*m_nCellsPerLine;
	m_szScroll.cx=m_szScroll.cx-(m_rectClient.right-m_nAddrColWidth)/m_nColWidth*m_nColWidth;
	SetScrollRange(SB_HORZ,0,m_szScroll.cx);
	SetScrollPos(SB_HORZ,0);   
	SetCellEndPos();  
    SetMemCaretPos(m_ptCaretPos);	 
    Invalidate();
    UpdateWindow();
    
}

void CGRegView::OnViewSigned()
{
//  m_isByte=0;
    m_isSigned=1;
    m_nHexORDec=10;
    m_nCellsPerLine=m_isByte?16:8;  //8 or 16
    m_ptCaretPos.x=0;
    m_ptCaretPos.y=1;
    m_ptCaretPos.offset=0;

    m_ptFirst.x=0;
    m_nFirstViewCol=0;

    if(m_isByte)      
        m_nColWidth=5*m_szFont.cx;
    else
        m_nColWidth=7*m_szFont.cx;
//    m_ptFirst.x=0;
	m_szScroll.cx=m_nColWidth*m_nCellsPerLine;
	m_szScroll.cx=m_szScroll.cx-(m_rectClient.right-m_nAddrColWidth)/m_nColWidth*m_nColWidth;
    SetScrollRange(SB_HORZ,0,m_szScroll.cx);
    SetScrollPos(SB_HORZ,0);
    SetCellEndPos();             
    SetMemCaretPos(m_ptCaretPos);    
    Invalidate();
    UpdateWindow();
}

void CGRegView::OnViewUnsigned()
{
//  m_isByte=0;
    m_isSigned=0;
    m_nHexORDec=10;
    m_nCellsPerLine=m_isByte?16:8;  //8 or 16
    m_ptCaretPos.x=0;
    m_ptCaretPos.y=1;
    m_ptCaretPos.offset=0;
    m_ptFirst.x=0;
    m_nFirstViewCol=0;
    
    if(m_isByte)
       m_nColWidth=4*m_szFont.cx;
    else
       m_nColWidth=6*m_szFont.cx;
//    m_ptFirst.x=0; 
//modifed by jerry 2/7
	m_szScroll.cx=m_nColWidth*m_nCellsPerLine;
	m_szScroll.cx=m_szScroll.cx-(m_rectClient.right-m_nAddrColWidth)/m_nColWidth*m_nColWidth;
	SetScrollRange(SB_HORZ,0,m_szScroll.cx);
	SetScrollPos(SB_HORZ,0);
    SetCellEndPos();             
    SetMemCaretPos(m_ptCaretPos);    
    Invalidate();
    UpdateWindow();
}
    
    
void CGRegView::OnSetFocus(CWnd* pOldWnd)
{
    CView::OnSetFocus(pOldWnd); 
    CreateSolidCaret(1,12);
    SetMemCaretPos(m_ptCaretPos);
}      
       
void CGRegView::OnKillFocus(CWnd* pNewWnd)
{
    CView::OnKillFocus(pNewWnd);
    
    ::DestroyCaret();
    
}
 
/////////////////////////////////////////////////////////////////////////////
// CGRegView diagnostics

#ifdef _DEBUG
void CGRegView::AssertValid() const
{
    CView::AssertValid();
}

void CGRegView::Dump(CDumpContext& dc) const
{
    CView::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGRegView message handlers

void CGRegView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
        return ;
    }     
     switch (nChar) {
        case VK_RIGHT:
               CaretMove(0);
               break;     	
        case VK_LEFT:
               CaretMove(1);
               break;
        case VK_UP:
               CaretMove(2);               
               break;
        case VK_DOWN:
               CaretMove(3);               
               break;
        case VK_PRIOR:
               SendMessage(WM_VSCROLL,SB_PAGEUP,0);
               ((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,1)->\
                   SendMessage(WM_VSCROLL,SB_PAGEUP,0); 
               break;         
        case VK_NEXT:
               SendMessage(WM_VSCROLL,SB_PAGEDOWN,0);           
               ((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,1)->\
                   SendMessage(WM_VSCROLL,SB_PAGEDOWN,0); 
               break;    
        case VK_HOME:       
               CaretMove(4);
               break;
        case VK_END:
               CaretMove(5);               
               break;
    
        case VK_TAB:
//               CaretMove(6);                       
			 ((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,1)->\
				   SetFocus();

               break; 
        case VK_RETURN:
                break;
                   
    }
    CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CGRegView::OnMouseMove(UINT nFlags, CPoint point)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
    	CView::OnMouseMove(nFlags, point);
        return ;
    }     
    
    if(HitTest(point))
    {
        SetCursor(::LoadCursor(NULL,IDC_IBEAM)); 
    }
    else                                 
    {
        SetCursor(::LoadCursor(NULL,IDC_ARROW));
    }             
    
    CView::OnMouseMove(nFlags, point);
}

BOOL CGRegView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
    // TODO: Add your message handler code here and/or call default
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
////        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
//    ((CMainFrame*)AfxGetApp()->m_pMainWnd)->m_wndStatusBar.UpdateStatusBar(0, "EP is running !");		
//    return CView::OnSetCursor(pWnd, nHitTest, message);
//    }    
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
		if ( STATUS_GO == uchStatus )
	    	((CMainFrame*)AfxGetApp()->m_pMainWnd)->m_wndStatusBar.UpdateStatusBar(0, "EP is running !");		
	    else 
	    	((CMainFrame*)AfxGetApp()->m_pMainWnd)->m_wndStatusBar.UpdateStatusBar(0, "EP is sleeping !");		
	    return CView::OnSetCursor(pWnd, nHitTest, message);
    }    

    if((message==WM_LBUTTONDOWN||
        message==WM_RBUTTONDOWN||
        message==WM_LBUTTONUP||
        message==WM_RBUTTONUP||
        message==WM_MOUSEMOVE)&&HTCLIENT==nHitTest)
        return FALSE;
    return CView::OnSetCursor(pWnd, nHitTest, message);
}

void CGRegView::OnLButtonUp(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
    CView::OnLButtonUp(nFlags, point);
}

void CGRegView::OnRButtonDown(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
// Modified by Gates Hua    
//    if(uchStatus==1){
	if ( STATUS_GO == uchStatus || STATUS_SLEEPING == uchStatus ) {
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
        return ;
    }    

    CMenu * pLocalMenu = new CMenu;

    ASSERT(pLocalMenu!=NULL);
    pLocalMenu->CreatePopupMenu();
    
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_REFRESH, "&Refresh");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
   
    pLocalMenu->AppendMenu(MF_STRING, ID_GROUP_MEMORY, "&Memory...");
//  pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_GOTO, "&Goto...");
    pLocalMenu->AppendMenu(MF_SEPARATOR);

    if(m_nHexORDec==16)
   	{
   		pLocalMenu->AppendMenu(MF_STRING|MF_CHECKED,ID_VIEW_HEXADECIMAL, "&Hexadecimal");
	    pLocalMenu->AppendMenu(MF_STRING|MF_UNCHECKED,ID_VIEW_SIGNEDDECIMAL, "&Signed Decimal");
    	pLocalMenu->AppendMenu(MF_STRING|MF_UNCHECKED,ID_VIEW_UNSIGNEDDECIMAL, "&Unsigned Decimal");
   	}
    else
    	pLocalMenu->AppendMenu(MF_STRING|MF_UNCHECKED,ID_VIEW_HEXADECIMAL, "&Hexadecimal");	
	if(m_isSigned&&m_nHexORDec==10)
	{
	    pLocalMenu->AppendMenu(MF_STRING|MF_CHECKED,ID_VIEW_SIGNEDDECIMAL, "&Signed Decimal");
    	pLocalMenu->AppendMenu(MF_STRING|MF_UNCHECKED,ID_VIEW_UNSIGNEDDECIMAL, "&Unsigned Decimal");
    }	
	if((!m_isSigned)&&m_nHexORDec==10)
	{
	    pLocalMenu->AppendMenu(MF_STRING|MF_UNCHECKED,ID_VIEW_SIGNEDDECIMAL, "&Signed Decimal");
    	pLocalMenu->AppendMenu(MF_STRING|MF_CHECKED,ID_VIEW_UNSIGNEDDECIMAL, "&Unsigned Decimal");
    }	

    pLocalMenu->AppendMenu(MF_SEPARATOR);                   

    
    if(m_isByte)
    {	pLocalMenu->AppendMenu(MF_STRING|MF_CHECKED,ID_VIEW_BYTE, "&Byte");
        pLocalMenu->AppendMenu(MF_STRING|MF_UNCHECKED,ID_VIEW_WORD, "&Word");
    }    
    else	                                                               
    {	pLocalMenu->AppendMenu(MF_STRING|MF_UNCHECKED,ID_VIEW_BYTE, "&Byte");
    	pLocalMenu->AppendMenu(MF_STRING|MF_CHECKED,ID_VIEW_WORD, "&Word");
    }
    
    ClientToScreen(&point);
    pLocalMenu->TrackPopupMenu(TPM_CENTERALIGN, point.x, point.y, pGRWnd);
    delete pLocalMenu;
    CView::OnRButtonDown(nFlags, point);
}


void CGRegView::OnEditSearch()
{
    // TODO: Add your command handler code here
    CMemSearchDlg dlg(this);
    int i;
    dlg.m_nSpaceType =3;
    G_Register_Cell cell=Caret2GReg(m_ptCaretPos);
    int start=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[cell.gBank].nStartAddr;
    if(m_ptCaretPos.y==0)                  
        dlg.m_StartAddress=start+cell.gOffset-start%16;
    else    
    	dlg.m_StartAddress=start+cell.gOffset;
    strcpy(dlg.m_str, m_searchStr);
    i = dlg.DoModal();
    if (i)
    {
        m_searchStr=dlg.m_str;
        if (dlg.m_lFindAddress == -1)
        {
           MessageBox("Not Found!",NULL, MB_OK);
           return;
        } 
        GotoAddress(dlg.m_lFindAddress);
    }   
}
     
     
void CGRegView::OnEditSearchnext()
{   
    int i;
    unsigned short startAddress;
    unsigned short addr;
    long FindAddress;
    BOOL bFind;
    char *text;                                   
    
    G_Register_Cell cell=Caret2GReg(m_ptCaretPos);
    text = new char [200];
    ASSERT(NULL != text);
    i = strlen(m_searchStr);
    int start=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[cell.gBank].nStartAddr;
    int end=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[cell.gBank].nEndAddr; 
    if (i<=0) 
       OnEditSearch();
    else
    {
       BeginWaitCursor();

       if(m_ptCaretPos.y==0)            
          startAddress =start+cell.gOffset-start%16+1;
       else   
       	  startAddress =start+cell.gOffset+1;
       	  
       strcpy(text, m_searchStr.GetBuffer(16)+2);
       m_searchStr.ReleaseBuffer();
       bFind = MemServerSearch((WORD)startAddress,(WORD)end,
                               3,text,0,addr);
       EndWaitCursor();
       if (!bFind)
       {
          MessageBox("Not Found!",NULL, MB_OK);
          return;
       }
       else
       {
          FindAddress = (long)addr;
		  GotoAddress(FindAddress); 
//          SetScrollPos(SB_VERT, (UINT)(m_lStartAddress/0x10), TRUE);
//		  InvalidateRect(NULL, FALSE);
       }
    }
    delete []text;
}

void CGRegView::Addr2CaretPos(int address,CaretPos& cp)
{
    for(int i=0;i<((CGRegWnd*)pGRWnd)->m_rRange.nBanks;i++)
    {
		if(((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[i].nEndAddr>=address)
		break;
	}
	int lines=0,addr;
	for(int j=0;j<i;j++)
		lines+=((CGRegWnd*)pGRWnd)->m_arLinesPerBank[j];
	addr=((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[i-1].nStartAddr;

//	while(addr+15<((CGRegWnd*)pGRWnd)->m_rRange.RFileRange[i].nEndAddr)
//	{
//		lines++;addr+=16;
//	}
	cp.y=lines+address/16;	
//	cp.y=lines+1;
	cp.offset=0;
	if(m_isByte) cp.x=address%16; //address-addr; 
	else cp.x=address%16/2; //(address-addr)/2; 

}

void CGRegView::GotoAddress(long address)
{
	CaretPos cp;
	Addr2CaretPos((int)address,cp); 
	if(cp.y>m_nLastViewLine)
	{
		m_nLastViewLine+=cp.y-m_nFirstViewLine ;
		m_nFirstViewLine=cp.y;
	    m_ptFirst.y=m_nFirstViewLine;
	    SetScrollPos(SB_VERT,m_ptFirst.y);
        ((CGRAsciiView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,1))->\
      	  m_nLastViewLine=m_nLastViewLine;       
    	((CGRAsciiView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,1))->\
    	  m_nFirstViewLine=m_nFirstViewLine;        
        ((CGRAsciiView*)((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,1))->\
    	  m_ptFirst.y=m_ptFirst.y;                                     
    	
    }	
	((CGRegWnd*)pGRWnd)->m_wndSplitter.GetPane(0,1)->	
	SendMessage(XM_REPAINT,0,0);
	m_ptCaretPos=cp;
    SetMemCaretPos(m_ptCaretPos);
} 
 
void CGRegView::OnEditGoto()
{
	CMemGtDlg* pMemGtDlg;
	pMemGtDlg=new CMemGtDlg; 
	pMemGtDlg->m_nSpace=3;
	if(1==pMemGtDlg->DoModal() )
	{
      GotoAddress(pMemGtDlg->m_lAddress);
   	  Invalidate();
	  UpdateWindow();
	}	
	delete pMemGtDlg;
}

void CGRegView::OnUpdateEditGoto(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    unsigned char uchCpuStatus;
    if (IsIconic())
       pCmdUI->Enable(FALSE);
    else
       pCmdUI->Enable(TRUE);
#ifndef _NOABI        
    if (GetCpuStatus(uchCpuStatus)) {
// Modified by Gates Hua    
//      if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
      if ( STATUS_GO == uchCpuStatus || STATUS_SLEEPING == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
        pCmdUI->Enable(FALSE);
      }
      else {
        pCmdUI->Enable(TRUE);
      }      
    }         
#endif    
}




void CGRegView::OnGroupMemory()
{
	// TODO: Add your command handler code here
	gSpace=1;
	CMemDlg memoryDlg(this);
    memoryDlg.DoModal();
}

void CGRegView::OnUpdateViewWord(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(!m_isByte)          ;
	// TODO: Add your command update UI handler code here
}

void CGRegView::OnUpdateViewByte(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
pCmdUI->SetCheck(m_isByte);
}

void CGRegView::OnUpdateViewHexadecimal(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
pCmdUI->SetCheck(m_nHexORDec==16);	
}

void CGRegView::OnUpdateViewSigneddecimal(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck(m_isSigned&&m_nHexORDec==10);
}

void CGRegView::OnUpdateViewUnsigneddecimal(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetCheck((!m_isSigned)&&m_nHexORDec==10);
}

void CGRegView::OnViewRefresh()
{
	// TODO: Add your command handler code here
	pGRWnd->SendMessage(XM_REPAINT,0,0);	
}
