 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/GREGWND.CPP   1.11   13 Dec 1996 11:18:34   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/GREGWND.CPP  $
** 
**    Rev 1.11   13 Dec 1996 11:18:34   ZJRD
** No change.
** 
**    Rev 1.10   22 Nov 1996 10:59:34   ZJRD
** No change.
** 
**    Rev 1.9   11 Nov 1996 12:46:52   ZJRD
** No change.
** 
**    Rev 1.8   06 Nov 1996 12:58:48   ZJRD
** No change.
** 
**    Rev 1.7   02 Nov 1996 09:48:44   ZJRD
** No change.
** 
**    Rev 1.6   30 Oct 1996 12:51:10   ZJRD
** No change.
** 
**    Rev 1.5   28 Oct 1996 09:44:00   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.4   21 Oct 1996 09:18:08   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.2   23 Sep 1996 10:37:10   ZJRD
** PIC/SLD Version 0.70
** 
**    Rev 1.1   06 Sep 1996 13:51:58   ZJRD
** PIC/SLD Version 0.60
** 
**    Rev 1.0   02 Sep 1996 11:33:06   ZJRD
** Initial revision.
**
****************************************************************************/

// memwnd.cpp : implementation file
//

#include "stdafx.h"
#include "uicom.h" 
#include "resource.h"
//#include "gregwnd.h"
#include "gregvw.h"
#include "grascivw.h"
#include "abibase.h"
#include "abiextfn.h"
extern UINT cpuid;
//extern BOOL isMemOn[3];
//extern CMDIChildWnd* pMemWnd[3];

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif    

extern BOOL GetCpuStatus(unsigned char & uchStatus);
//extern BOOL GetGRMem(int,int ,BYTE*);

BOOL SetGRMem(int addr1,int addr2,BYTE* pMemByte)
{                                       
    ADDR    start , end;
    WORD    *pData;
    int nByte;
    int i;
    
    start.addrType = end.addrType = 3;
    start.addr = (WORD) addr1;
    end.addr = (WORD) addr2;
    nByte = addr2 - addr1 + 1;
    if ( nByte < 1 ) return FALSE;
    pData = new WORD[ nByte + 1 ];
    if ( pData == 0 ) return FALSE;
    for(i=0;i<nByte;i++) {
    	pData[i] = (WORD) pMemByte[i];
    }
    if ( ICE_OK != AbiSetMemN(start,pData,nByte) ) {
    	delete pData;
        return FALSE;
    }
     RepaintStack();
    RepaintVariable();
   	delete pData;
	return TRUE;
}

BOOL GetGRMem(int addr1,int addr2,BYTE* pMemByte)
{                                       
    ADDR    start , end;
    WORD    *pData;
    int nByte;
    int i;
    
    start.addrType = end.addrType = 3;
    start.addr = (WORD) addr1;
    end.addr = (WORD) addr2;
    nByte = addr2 - addr1 + 1;
    if ( nByte < 1 ) return FALSE;
    pData = new WORD[ nByte + 1 ];
    if ( pData == 0 ) return FALSE;
    if ( ICE_OK != AbiGetMemN(start,end,pData) ) {
    	delete pData;
        return FALSE;
    }
    for(i=0;i<nByte;i++) {
    	pMemByte[i] = (BYTE) pData[i];
    }
    if((cpuid<=2||cpuid==4||cpuid==7||cpuid==8)) pMemByte[nByte]=0;
	delete pData;
	return TRUE;
}

extern CPURegisterFileRange GetCpuRFileRange();


void CGRegWnd::Init()
{
	int i;      
	int temp;
	m_nEndLine=0;
	m_rRange=GetCpuRFileRange();
	for(i=0;i<m_rRange.nBanks;i++)
	{
		temp=1+m_rRange.RFileRange[i].nEndAddr-m_rRange.RFileRange[i].nStartAddr;
		m_arLinesPerBank[i]=temp%16?temp/16+1:temp/16;
		m_nEndLine+=m_arLinesPerBank[i];
		GetMem(i);
	}   
//	if(cpuid==0) m_arLinesPerBank[0]++;                                
	m_nEndLine--;	
}


LONG CGRegWnd::OnXMRepaint(UINT,LONG)
{
	for(int i=0;i<m_rRange.nBanks;i++)
	{
		GetMem(i);
	}             	
	((CGRegView*)(m_wndSplitter.GetPane(0,0)) )->SendMessage(XM_REPAINT,-1,0);
	((CGRegView*)(m_wndSplitter.GetPane(0,1)) )->SendMessage(XM_REPAINT,-1,0);
	return 1;
}   


BOOL CGRegWnd::IsBankFirstLine(int line)
{
	int i; 
	int temp=0;
	if(line<0) return 0;
	for(i=0;i<m_rRange.nBanks;i++)
	{
		if( temp==line) return 1;
		temp+=m_arLinesPerBank[i];
	}
	return 0;	
}

UINT CGRegWnd::Line2Addr(int line,int& nBank,int& nOffset)
{
	int i;                    
	int temp=0;
	UINT addr; 
	int nst;
	 
	for(i=0;i<m_rRange.nBanks;i++)
	{
		temp+=m_arLinesPerBank[i];
		if(line<temp)
		{
//		  if(line+1<temp) i--;	
		  addr=m_rRange.RFileRange[i].nStartAddr;   
		  nst=addr%16;                              
		  nBank=i;

          if(line!=temp-m_arLinesPerBank[i])
//          if(line!=0&&nBank==0)
            addr=(addr/16)*16+(line-(temp-m_arLinesPerBank[i]))*16;
//         	addr=(addr/16+line)*16; //modified on 9/24/96.jerry
//          else if(line!=0) addr=(addr/16)*16+(line-(temp-m_arLinesPerBank[i]))*16;   //modify  Am.8:40 on 9/18/96

//		  for( j=0;j<line-(temp-m_arLinesPerBank[i]);j++)
//		  	addr+=16; 

//		  addr=(temp-m_arLinesPerBank[i])*32+(line-(temp-m_arLinesPerBank[i]))*16;

		  if(line!=temp-m_arLinesPerBank[i]) nOffset=(line-(temp-m_arLinesPerBank[i]))*16-nst;
		  else	  nOffset=-nst;//nOffset=0; //j*16;	//on 10/14/96
//		  nOffset=nOffset-nst;	
		  return addr;	
		}  	
	}
	return 0;
}                      

BOOL CGRegWnd::GetMem(int nBank)
{                           
	
	return GetGRMem(m_rRange.RFileRange[nBank].nStartAddr,
		m_rRange.RFileRange[nBank].nEndAddr,(BYTE*)m_GRValue[nBank]);
	
}




void GROpenWindow(CMDIFrameWnd * pParent, BOOL isHide)
{               
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
    if(uchStatus==1){
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
        return ;
    }    
    // if window already opened, do nothing
    if(isGROn)    return;                 
    
    ////////////////////////////////////////
    pGRWnd = new CGRegWnd;               
    
    // set flags depending on whether hide the window          
    DWORD dwFlag = isHide ? 0 : WS_VISIBLE;          
    //DWORD dwFlag = (!x_dwStyle && !isHide) ? WS_VISIBLE : 0;
    
    // if can't create, then the application halt
    if(!((CGRegWnd *)pGRWnd)->Create("General Purpose Register File", WS_CHILD
        |WS_OVERLAPPEDWINDOW|dwFlag,
        CFrameWnd::rectDefault, pParent))
        ASSERT(0);                               
        
    // set the flag        
    isGROn = TRUE;              
    
    /*if(x_dwStyle)                
    	pCpuWnd->SetWindowPlacement(&x_wp);*/
}

/////////////////////////////////////////////////////////////////////////////
//  Static member variable initialization
/////////////////////////////////////////////////////////////////////////////

CMenu NEAR CGRegWnd::m_menu;                              
/////////////////////////////////////////////////////////////////////////////
// CGRegWnd

IMPLEMENT_DYNCREATE(CGRegWnd, CMDIChildWnd)

CGRegWnd::CGRegWnd()
{                     
	m_nIDHelp = IDR_GPRF;   
	Init();
}

CGRegWnd::~CGRegWnd()
{
	isGROn=0;  
//	GetWindowRect(&grectGRWindow);
} 



BOOL CGRegWnd::Create(LPCSTR szTitle, LONG style,
    const RECT& rect, CMDIFrameWnd * pParent)
{
    // Setup the shared m_menu
    if(m_menu.m_hMenu == NULL)
        m_menu.LoadMenu(IDR_GPRF);
    m_hMenuShared = m_menu.m_hMenu;

    const char * pszGPRFClass =
        AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW,
            LoadCursor(NULL, IDC_ARROW),
            (HBRUSH)(GetStockObject(LTGRAY_BRUSH)),
            AfxGetApp()->LoadIcon(IDR_GPRF));
//    if(!(CMDIChildWnd::Create(NULL, szTitle,
    if(!(CMDIChildWnd::Create(pszGPRFClass, szTitle,
        style, rect, pParent))) 
        return FALSE;  
      return 1;  
}        

BOOL CGRegWnd::OnCreateClient(LPCREATESTRUCT /*lpcs*/, CCreateContext* pContext)
{
	DWORD dwStyle;
    dwStyle=WS_CHILD|WS_VISIBLE|WS_VSCROLL;
    if ( !m_wndSplitter.CreateStatic(this, 1,2,dwStyle) ) {
//        m_nErrorID = failSplitter;
//        DisplayErrorMessage();
//        ASSERT( FALSE );
        return FALSE;
    }
 CRect rect,re;
 GetClientRect(&rect); 
 re=rect;
 re.right=rect.right*3/4;  
    // Add the first splitter pane - the CStackView view in row 0.
    if ( !m_wndSplitter.CreateView(0, 0, RUNTIME_CLASS(CGRegView),
           re.Size(), pContext) ) {
 //       m_nErrorID = splitterPane;
 //       DisplayErrorMessage();
 //       ASSERT( FALSE );
        return FALSE;
    }
 rect.left=re.right;
      
    // Add the second splitter pane - the CVarView view in row 1.
    if ( !m_wndSplitter.CreateView( 0,1,RUNTIME_CLASS(CGRAsciiView),
            re.Size(), pContext) ) {
        //m_nErrorID = splitterPane;
       // DisplayErrorMessage();
       // ASSERT( FALSE );
        return FALSE;
    }
    // Activate the CStackView.
    SetActiveView((CView* )(m_wndSplitter.GetPane(0,0)));
    return TRUE;
}

BEGIN_MESSAGE_MAP(CGRegWnd, CMDIChildWnd)
	//{{AFX_MSG_MAP(CGRegWnd)
	ON_WM_GETMINMAXINFO()
	ON_WM_SIZE()       
	ON_MESSAGE(XM_REPAINT, OnXMRepaint)
	ON_WM_MDIACTIVATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CGRegWnd message handlers



void CGRegWnd::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI)
{
	// TODO: Add your message handler code here and/or call default
	lpMMI->ptMaxSize.y=(m_nEndLine+2)*18+45;
    lpMMI->ptMaxTrackSize.y=(m_nEndLine+2)*18+45;	
	CMDIChildWnd::OnGetMinMaxInfo(lpMMI);
}
   

void CGRegWnd::OnSize(UINT nType, int cx, int cy)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
    if(uchStatus==1){
//        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
        return ;
    }    
	CMDIChildWnd::OnSize(nType, cx, cy);
//	m_nVScrollRange=m_nEndLine-cy/18+2;
}
 
void CGRegWnd::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd)
{
   CMDIChildWnd::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);
    
    // TODO: Add your message handler code here
    if(bActivate && pActivateWnd == this)
        AfxGetApp()->m_pMainWnd->SendMessage(XM_MDIACTIVE, WORD(bActivate), 
            LONG(WID_MEMORY));
    else if(!bActivate && !pActivateWnd)
        AfxGetApp()->m_pMainWnd->SendMessage(XM_MDIACTIVE, WORD(bActivate)); 

if(GetStyle()&WS_MAXIMIZE)
	GetParent()->RedrawWindow(NULL,NULL,RDW_INVALIDATE|RDW_UPDATENOW | RDW_ERASE|RDW_ALLCHILDREN ); 
//    GetParent()->Invalidate();
//    GetParent()->UpdateWindow();  

}


