
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/LABELDLG.CPP   1.13   13 Dec 1996 11:18:42   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/LABELDLG.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:42   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:42   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:00   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:54   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:12   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:32   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:24   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:40   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:18   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:34:02   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:48:06   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:29:18   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:07:12   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:56   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  LABELDLG.CPP
//
//  Description:The implement file for the class: CLabelDialog
//
//  Author:     Roger Zhang
//
//  Date:       08/17/95
//
//  Modification:
//
//      1. 08/17/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include <limits.h>
#include <stdlib.h>
#include <string.h>
#include "dibapi.h"
#include "labeldlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLabelDialog dialog


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CLabelDialog::CLabelDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CLabelDialog::IDD, pParent)
{
    m_hDIB = NULL;
    m_palDIB = NULL;
    //{{AFX_DATA_INIT(CLabelDialog)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
    Create(CLabelDialog::IDD, pParent);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CLabelDialog::~CLabelDialog()
{
    if (m_hDIB != NULL)     ::GlobalFree((HGLOBAL) m_hDIB);
    if (m_palDIB != NULL)   delete m_palDIB;
}
    
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLabelDialog::InitDIBData()
{
    if (m_hDIB == NULL) return;
    
    LPSTR lpDIB = (LPSTR) ::GlobalLock((HGLOBAL) m_hDIB);
    if (::DIBWidth(lpDIB) > INT_MAX ||::DIBHeight(lpDIB) > INT_MAX) {
        ::GlobalUnlock((HGLOBAL) m_hDIB);
        ::GlobalFree((HGLOBAL) m_hDIB);
        m_hDIB = NULL;
        AfxMessageBox("DIB is too large");
        return;
    }
    ::GlobalUnlock((HGLOBAL) m_hDIB);
    // Create copy of palette
    m_palDIB = new CPalette;
    if (m_palDIB == NULL) {
        // we must be really low on memory
        ::GlobalFree((HGLOBAL) m_hDIB);
        m_hDIB = NULL;
        return;
    }
    if (::CreateDIBPalette(m_hDIB, m_palDIB) == NULL) {
        // DIB may not have a palette
        delete m_palDIB;
        m_palDIB = NULL;
        return;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output:                                          
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CLabelDialog::OpenDIB(const char* pszPathName)
{
    CFile file;
    CFileException fe;
    if(!file.Open(pszPathName, CFile::modeRead|CFile::shareDenyWrite, &fe)) {
        AfxMessageBox("Open DIB error!");
        return FALSE;
    }

    // replace calls to Serialize with ReadDIBFile function
    TRY
    {
        m_hDIB = ::ReadDIBFile(file);
    }
    CATCH (CFileException, eLoad)
    {
        file.Abort(); // will not throw an exception
        AfxMessageBox("Read DIB error!");
        m_hDIB = NULL;
        return FALSE;
    }
    END_CATCH

    InitDIBData();

    if (m_hDIB == NULL) {
        // may not be DIB format
        AfxMessageBox("Couldn't load DIB");
        return FALSE;
    }
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
LRESULT CLabelDialog::OnDoRealize(WPARAM wParam, LPARAM)
{
    ASSERT(wParam != NULL);
    if (m_hDIB == NULL)
        return 0L;  

    if (m_palDIB != NULL) {
        CClientDC dc(this);
        CPalette* oldPalette = 
            dc.SelectPalette(m_palDIB, ((HWND)wParam) != m_hWnd);

        if (oldPalette != NULL) {
            UINT nColorsChanged = dc.RealizePalette();
            dc.SelectPalette(oldPalette, TRUE);
        } else {
            TRACE0("\tSelectPalette failed\n");
        }
    }

    return 0L;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLabelDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CLabelDialog)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLabelDialog, CDialog)
    //{{AFX_MSG_MAP(CLabelDialog)
    ON_WM_PAINT()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLabelDialog message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CLabelDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    
    CenterWindow();
    SetWindowPos(&wndTopMost, 0, 0, 10, 10, SWP_NOMOVE|SWP_NOSIZE);

	extern char szAppPath[];
	char szName[260];                   
	strcpy(szName, szAppPath);
	strcat(szName, "label.bmp");
	
    /*GetModuleFileName(AfxGetApp()->m_hInstance, szName, sizeof(szName));

    char path_buffer[_MAX_PATH];
    char drive[_MAX_DRIVE];
    char dir[_MAX_DIR];
    char fname[_MAX_FNAME];
    char ext[_MAX_EXT];
    _splitpath(szName, drive, dir, NULL, NULL);
    _makepath(szName, drive, dir, "label", "bmp" );*/
    
    OpenDIB(szName/*"label.bmp"*/);
    OnDoRealize((WPARAM)m_hWnd, 0);   // same as SendMessage(WM_DOREALIZE);
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLabelDialog::OnPaint()
{
    CPaintDC dc(this); // device context for painting
    
    // TODO: Add your message handler code here
    if (m_hDIB != NULL) {
        LPSTR lpDIB = (LPSTR) ::GlobalLock((HGLOBAL) m_hDIB);
        int cxDIB = (int) ::DIBWidth(lpDIB);         // Size of DIB - x
        int cyDIB = (int) ::DIBHeight(lpDIB);        // Size of DIB - y
        ::GlobalUnlock((HGLOBAL) m_hDIB);
        CRect rcDIB;
        rcDIB.top = rcDIB.left = 0;
        rcDIB.right = cxDIB;
        rcDIB.bottom = cyDIB;
        CRect rcDest = rcDIB;
        ::PaintDIB(dc.m_hDC, &rcDest, m_hDIB, &rcDIB, m_palDIB);
    }
    
    // Do not call CDialog::OnPaint() for painting messages
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLabelDialog::OnOK()
{
    // TODO: Add extra validation here
}   

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLabelDialog::OnCancel()
{
    // TODO: Add extra validation here
}   

////////////////////////////////(EOF)////////////////////////////////////////
