
/*************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/LDRPIC.CPP   1.13   13 Dec 1996 11:18:44   ZJRD  $   
**
**    $Log:   D:/PICSLDV/SRC/LOG/LDRPIC.CPP  $   
** 
**    Rev 1.13   13 Dec 1996 11:18:44   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:44   ZJRD
** PIC/SLD Version 0.97
** 
**    Rev 1.11   11 Nov 1996 12:47:02   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:58   ZJRD
** PIC/SLD Version 0.95
** 
**    Rev 1.9   02 Nov 1996 09:48:34   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:58   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:48   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:56   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.4   23 Sep 1996 10:36:46   ZJRD
** PIC/SLD Version 0.70
** 
**    Rev 1.3   06 Sep 1996 13:51:24   ZJRD
** PIC/SLD Version 0.60
** 
**    Rev 1.2   02 Sep 1996 11:32:32   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:09:46   ZJRD
** PIC/SLD Version 0.20
** 
**************************************************************************/

/****************************************************************************
**
**  Name:  ldrpic.cpp
**
**  Description:
**      Defines the class behaviors for the application.
**
**  Status:  CODED
**
**  Author:  Daniel Lin
**
**  Date:    15 May, 1996
**    Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h" 
#include "string.h"

#include "symblsvr.h"
#include "hosterrs.h"
#include "ldr.h"
#include "ldrpic.h"
#include "symstack.h"
#include "abibase.h"
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

// Globle definition
class CPicLoader ldrObject;   // global load object .

int     nGLoaded = 0;

typedef enum {
     VAR_UNKNOWN  = 0,
     VAR_FUNCTION = 1,
     VAR_DATA     = 2
}VARTYPE;


                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern struct   StoreExtendVar *varExtHdrPtr,*varExtPtr;
extern U32      start , end;
extern struct   BlockBlock far *curBlock ;
extern SYM_DESCRIPTOR curModDesc;
extern U32      uLoadBytes;

extern void     SendTextToDoc(LPSTR);
extern BOOL     SrcInitModule(void);
extern void     SrcSetLoadFileName(const char*);
extern STATUS   AbiSetReg(WORD iRegId, WORD uRegValue);
extern STATUS   AbiGetOneReg(WORD iRegId, WORD* cpuValue);
extern STATUS   AbiReset(ADDR addr);
extern void     SrcResetView(void);
extern STATUS   AbiFill(ADDR addr1, ADDR addr2,
                      WORD* pchBuff, UINT uPatternLen);
extern void     TestMessage(void);
extern int      TestKey(WORD wKey);
extern BOOL     IsLoadCanceled(void);
extern UINT     GetCpuId();

extern DWORD    dwpMax;        // program  max address



                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
int LoadCodFile(LPCSTR lpFileName, int nOnDemand, int nFlag);

BOOL FindModule( CString );

WORD  IndexDelta = 0;

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
                        
BOOL FindModule( CString path )
{
   CString strExtend;
   
   strExtend = path.Right( 2 );
   strExtend.MakeUpper();
   if ( ".C" == strExtend ) 
      return TRUE;
   else {
      strExtend = path.Right( 4 );
      strExtend.MakeUpper();
      if ( ".CPP" == strExtend ) 
         return TRUE;
      else
         if (".ASM" == strExtend )
            return TRUE;
   }
   
   return FALSE;            
}

/****************************************************************************
**
**  LoadAction
**
**  Description:
**     Globle function called by srcmdl
**
**  Parameters:
**     input:
**       const char *  str     File to be loaded
**
**     output:
**        int
**
*****************************************************************************/

int
LoadAction(const char * str, int nFlag1, int onDemand)
{
   int retCode = 0;
   int nFlag = nFlag1;
   int pos;
   char* fn;
   CString extend;
   CString filename = str;
   
   nGLoaded = 0;
   
   fn = new char[filename.GetLength()+3];
   strcpy(fn, filename.GetBuffer(filename.GetLength()));
    
   retCode = ldrObject.LdrLoadProcess(LPSTR(str),
                                      onDemand,
                                      nFlag);
   if ( -1 == retCode ) {       // Open file error | Esc by user | Fill error
     SrcInitModule();  
     return -1;
   }      
    
   ////////// 
   // 
   // ret == -1      error(open error, distinguish compiler error)
   // ret == -2      down load code and symbol from COD file
   // ret == -3      down load code from hex file and symbol from COD file
   //   
   //////////
   
   ///////
   //
   // Down load code from COD file, load symbol from COD file
   //
   ///////
   if ( retCode == -2 ) {
      pos = filename.ReverseFind('.');
      if (pos != -1) {     // fine '.', filename have extend
         extend = filename.Right(3);
         extend.MakeUpper();
      }
      else {     // not find '.', no extend filename
         if ( NULL != fn ) delete []fn;
         SrcInitModule();
         return -1;      
      }
   
      if ( extend == "COD" ) {   // Load Code binary file
         retCode =LoadCodFile(fn,      // CODE file name
                              0,
                              nFlag
                              );          
      }
      else {
        ldrObject.Warning( ER_LDR_UNKNOWN_FORMAT );
        SrcInitModule();
        return -1;
     }      
   }
   else {
       ///////
       //
       // Down load code from Hex file, load symbol from COD file
       //
       ///////
       if ( retCode == -3 ) {         
          pos = filename.ReverseFind('.');
          if (pos != -1) {     // fine '.', filename have extend
             fn[pos+1] = 'C';
             fn[pos+2] = 'O';
             fn[pos+3] = 'D';
          }
          else {    // not find '.', no extend filename
             filename += ".COD";         
             if ( fn != NULL ) delete []fn;
             fn = new char [filename.GetLength()+3];
             strcpy(fn, filename.GetBuffer(filename.GetLength()));
          }         
       
          nFlag &= ~LDR_CODE;        // Should not fill code
          if (LOAD_SYM(nFlag) ) {
	          retCode = LoadCodFile(fn,         // CODE file name
	                                0,
	                                //ldrObject.m_ldrFlags
	                                nFlag);          
		  }		                                
       } 
   }
   
   
   nGLoaded = 100;   
   
   if ( ldrObject.m_window != LOAD_FROM_DIALOG ) {
      SrcSetLoadFileName( fn );
   }   

//   SrcInitModule();
   
//   SrcResetView();                  
   if ( NULL != fn ) delete []fn;
   
   //////
   //
   // Set PC position
   //
   //////      
   ADDR adrReset;
   adrReset.addrType = 0;
   adrReset.addr = 0;
   if ( AbiReset( adrReset ) != ICE_OK ) {
     SrcInitModule();
     return -1;
   }
   
   WORD curPC = 0;
   AbiGetOneReg( 0, &curPC );
   ldrObject.m_lPCAddr = (long)curPC;
   ldrObject.m_startaddress = (U32)ldrObject.m_lPCAddr;
         
/*
   if ( AbiSetReg( 0 , WORD(ldrObject.m_lPCAddr)) != ICE_OK ) {
     SrcInitModule();
     return -1;
   }            
*/              
   SrcInitModule();
   SrcResetView();                  
   
   return 0;
}                                           

/****************************************************************************
**
**  LoadCodFile
**
**  Description:
**     Globle function called by others
**
**  Parameters:
**     input:
**       LPCSTR   lpFileName     File to be loaded
**       int      nOnDemand      Demand flag(no use)
**       int      nFlag          Load flags(LOAD_SYM, LOAD_COD, LOAD_WAR)   
**
**     output:
**        int
**
*****************************************************************************/
                        
int 
LoadCodFile(LPCSTR lpFileName, int nOnDemand, int nFlag)
{  
   BOOL  bLoadOk = FALSE;
   
   SrcInitModule();      

   ldrObject.InitPicLoader();
   ldrObject.LoadInit();
   
   ldrObject.DeleteContent();               // Delete all pointer
   
   ldrObject.m_strCodFileName = lpFileName;
   ldrObject.m_strFileName = 
      new char [ldrObject.m_strCodFileName.GetLength() + 2];
   strcpy(ldrObject.m_strFileName,
          ldrObject.m_strCodFileName.GetBuffer(ldrObject.m_strCodFileName.GetLength()));               
   ldrObject.m_nOnDemand = nOnDemand;
   ldrObject.m_nFlag = nFlag;

   bLoadOk = ldrObject.DoLoad();
   if ( bLoadOk ) {
      if ( LOAD_CODE( nFlag ) ) {
         ////////
         //
         // Call AbiFill() fill code to ICE memory
         //
         ////////
         ldrObject.FillCode();
         if ( LOAD_SYM( nFlag ) )
            nGLoaded = 30;
         else
            nGLoaded = 100;   
      }

	   if ( TestKey(VK_ESCAPE) == 1 ) { 
	       ldrObject.m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
	       return( FALSE );
	   }                  
	   if ( (ldrObject.m_window == LOAD_FROM_DIALOG)&&
	   		(ldrObject.m_ldrFlags & LDR_STATUS) ) {
	       if ( IsLoadCanceled() ) {
	           ldrObject.m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
	           return( FALSE );
	       }                  
	       TestMessage();
	   }               
	   
      if ( LOAD_SYM( nFlag ) ) {
         if ( ldrObject.LinkToSymbol() ) {
            ldrObject.m_IsLoaded = TRUE;
            nGLoaded = 100;
         }   
         else {
            ldrObject.m_IsLoaded = FALSE;
            nGLoaded = 100;
         }   
      }
   }      
   else {
      ldrObject.Warning( ER_LDR_NO_SYM, RE_LDR_COMPILER );
   }  
   
   nGLoaded = 100;
         
   if ( TestKey(VK_ESCAPE) == 1 ) { 
       ldrObject.m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
       return( FALSE );
   }                  
   if ( (ldrObject.m_window == LOAD_FROM_DIALOG)&&
   		(ldrObject.m_ldrFlags & LDR_STATUS) ) {
       if ( IsLoadCanceled() ) {
           ldrObject.m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
           return( FALSE );
       }                  
       TestMessage();
   }

   if ( TRUE == SrcInitModule() ) 
      return 0;   
   else 
      return -1;

   //return 0;       
   
   nGLoaded = 100;
   ldrObject.TestCancel();
}

////////
//
// Constructor
//                        
////////

CPicLoader :: CPicLoader()
{
   InitPicLoader();
}

///////
//
// Destructor
//
///////

CPicLoader :: ~CPicLoader()
{
   DeleteContent(); 
}

void
CPicLoader :: InitPicLoader()
{
   m_strFileName = NULL;      
   m_strCodFileName  = "";
   m_nDirBlockCount  = 0;         // Directory block count
   m_nSSymBlockCount = 0;         // Short symbol count
   m_nNameBlockCount = 0;         // Name block count
   m_nLineBlockCount = 0;         // Line number count
   m_nMapBlockCount  = 0;         // Map block count
   m_nLocalVarBlockCount   = 0;   // Local var count
   m_nLSymBlockCount = 0;         // Long symbol count   
   m_nDbMsgBlockCount   = 0;      // Debug block count
   
   memset( m_nIndex, -1, sizeof(m_nIndex) );
   m_nModuleCount    = 0;         // The module number
   m_nVarsCount      = 0;  

   m_nOnDemand = 0;
   m_nFlag = 0;
   m_nCodeBlock = 0;              // Code block count;
   
   m_bHaveGlobleSym = FALSE;
   m_bHaveNameBlock = FALSE;
   m_bHaveLineBlock = FALSE;
   m_bHaveMapBlock = FALSE;
   m_bHaveLocalVars = FALSE;
   m_bHaveLongSym = FALSE;
   m_bHaveDbMsg = FALSE;
}

/****************************************************************************
**
**  DoLoad
**
**  Description:
**     Main routine of load code binary file
**
**  Parameters:
**     input:
**        none
**
**     output:
**        BOOL    TRUE     load successful
**                FAILURE  load failure
**
*****************************************************************************/

BOOL
CPicLoader :: DoLoad()
{
   int err = 0;
    
   if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
       m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
       return( FALSE );
   }                  
   if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
       if ( IsLoadCanceled() ) {
           m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
           return( FALSE );
       }                  
       TestMessage();
   }

   if ( !OpenCodFile( m_strCodFileName ) )  return FALSE;
     
   //     
   // Get the first block of "Directory block"
   //
   GetDirBlock( &m_dirBlock );   

   //   
   // Set some member data
   //
   m_nDirBlockCount  = 1;
   m_nSSymBlockCount = m_dirBlock.Symend-m_dirBlock.Symtab+1;
   if ( (m_dirBlock.Symend !=0) && (m_dirBlock.Symtab != 0) ) 
      m_bHaveGlobleSym = TRUE;      
      
   m_nNameBlockCount = m_dirBlock.Namend-m_dirBlock.Namtab+1;      
   if ( (m_dirBlock.Namend != 0) && (m_dirBlock.Namtab != 0) )
      m_bHaveNameBlock = TRUE;      

   m_nLineBlockCount = m_dirBlock.Lstend-m_dirBlock.Lsttab+1;      
   if ( (m_dirBlock.Lstend != 0) && (m_dirBlock.Lsttab != 0) )      
      m_bHaveLineBlock = TRUE;      

   m_nMapBlockCount  = m_dirBlock.MemMapend-m_dirBlock.MemMapOfs+1;      
   if ( (m_dirBlock.MemMapend != 0) && (m_dirBlock.MemMapOfs != 0) )
      m_bHaveMapBlock = TRUE;      

   m_nLocalVarBlockCount   = m_dirBlock.Localend-m_dirBlock.LocalVARS+1;      
   if ( (m_dirBlock.Localend != 0) && (m_dirBlock.LocalVARS != 0) )
      m_bHaveLocalVars = TRUE;      

   m_nLSymBlockCount = m_dirBlock.LSymEnd-m_dirBlock.LSymTab+1;         
   if ( (m_dirBlock.LSymEnd != 0) && (m_dirBlock.LSymTab != 0) )
      m_bHaveLongSym = TRUE;      

   m_nDbMsgBlockCount   = m_dirBlock.MessEnd-m_dirBlock.MessTab+1;         
   if ( (m_dirBlock.MessEnd != 0) && (m_dirBlock.MessTab != 0) )
      m_bHaveDbMsg = TRUE;      
   
   m_symBlock  = new SSymbol* [m_nSSymBlockCount*512/sizeof(SSymbol)];
   memset( m_symBlock, 0, m_nSSymBlockCount*512/sizeof(SSymbol) );
   m_nameTab   = new NameTab* [m_nNameBlockCount*512/sizeof(NameTab)];
   memset( m_nameTab, 0, m_nNameBlockCount*512/sizeof(NameTab) );
   m_moduleBlock = new NameTab* [m_nNameBlockCount*512/sizeof(NameTab)];
   memset( m_moduleBlock, 0, m_nNameBlockCount*512/sizeof(NameTab) );
   m_lineInfor = new LineInfor* [m_nLineBlockCount*512/sizeof(LineInfor)];    
   memset( m_lineInfor, 0, m_nLineBlockCount*512/sizeof(LineInfor) );
   m_localVars = new LocalVars* [m_nLocalVarBlockCount*32];    // ????
   memset( m_localVars, 0, m_nLocalVarBlockCount*32 );
   
   PICWORD        iCount = 0; 
   int            jCount, kCount;
   SSymbol        *SymbolInfor;
   NameTab        *NameInfor;
   LineInfor      *LineInformation;

  if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
     m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
     return( FALSE );
  }                  
      
  if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
     if ( IsLoadCanceled() ) {
         m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
         return( FALSE );
     }                  
     TestMessage();
  }
  
  
  int nCpuID = GetCpuId();
  int nBlockCount = 0;
  
  switch ( nCpuID ) {
      case  0:             //EPPIC16C54          ,//=0x0     xx   SUPPORT
      case  1:             //EPPIC16C54A         ,//=0x1     xx   SUPPORT
      case  2:             //EPPIC16CR54         ,//=0x2     xx   SUPPORT
      case  3:             //EPPIC16C55          ,//=0x3     xx   SUPPORT
            // Only has 512 bytes in ROM
            nBlockCount = int((dwpMax/0x1FF)*2);
            break;
            
      case  4:             //EPPIC16C56          ,//=0x4     xx   SUPPORT
            // Only has 1024 bytes in ROM          
            nBlockCount = int((dwpMax/0x1FF)*2);
            break;
         
      case  5:             //EPPIC16C57          ,//=0x5     xx   SUPPORT
      case  6:             //EPPIC16CR57A        ,//=0x6     xx   SUPPORT
      case  7:             //EPPIC16C58A         ,//=0x7     xx   SUPPORT
      case  8:             //EPPIC16CR58A        ,//=0x8     xx   SUPPORT
            // Only has 2048 bytes in ROM
            nBlockCount = int((dwpMax/0x1FF)*2);
            break;
                  
      case  9:             //EPPIC16C61          ,//=0x9     xx   SUPPORT
      case  10:            //EPPIC16C620         ,//=0xa     xx   SUPPORT
      case  11:            //EPPIC16C621         ,//=0xb     xx   SUPPORT
      case  12:            //EPPIC16C622         ,//=0xc     xx   SUPPORT
      case  13:            //EPPIC16C62A         ,//=0xd     xx   SUPPORT
      case  14:            //EPPIC16C63          ,//=0xe     xx   SUPPORT
      case  15:            //EPPIC16C64A         ,//=0xf     xx   SUPPORT
      case  16:            //EPPIC16C65A         ,//=0x10    xx   SUPPORT
            nBlockCount = int((dwpMax/0x1FF)*2);
            break;
            
      case  17:            //EPPIC16C71          ,//=0x11    xx   SUPPORT
      case  18:            //EPPIC16C73A         ,//=0x12    xx   SUPPORT
      case  19:            //EPPIC16C74A         ,//=0x13    xx   SUPPORT
      case  20:            //EPPIC16C84          ,//=0x14    xx   SUPPORT
            nBlockCount = int((dwpMax/0x1FF)*2);
            break;
            
      default:
            break;
  }

  
  nBlockCount = 127;
  for ( iCount = 0; iCount < nBlockCount; iCount ++ ) {
    if ( m_dirBlock.Index[iCount] != 0 ) {
      m_nCodeBlock ++;
    }
  } 
  
/*  
  if ( m_nCodeBlock != nBlockCount ) {
      //DeleteContent();
      //Warning( ER_LDR_UNKNOWN_FORMAT, RE_LDR_COMPILER );      
      return FALSE;
  }    
*/
  
  if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
     m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
     return( FALSE );
  }                  
      
  if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
     if ( IsLoadCanceled() ) {
         m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
         return( FALSE );
     }                  
     TestMessage();
  }
   
   m_chBuffer = new char[m_nCodeBlock*512];
   if (m_chBuffer == NULL) {
      m_CodeFile.Close();
      return FALSE;
   }      
      
   if ( 0 != m_dirBlock.Symtab ) {
      //
      // Get the globle variable
      //
      kCount = 0;   
      m_symbolPointer = new LONG* [m_nSSymBlockCount];
      for ( iCount = (int)m_dirBlock.Symtab; 
            iCount <= m_dirBlock.Symend; 
            iCount ++ ) {
         SymbolInfor = new SSymbol[32];            
         m_symbolPointer[kCount] = (LONG *)SymbolInfor;
         GetSymbolShortInfor(iCount, SymbolInfor);
         for ( jCount = 0; jCount < 32; jCount ++ ) {
            m_symBlock[jCount+kCount*32] = &SymbolInfor[jCount];
         }       
         kCount ++;
      } /* end for */
   }      

  if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
     m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
     return( FALSE );
  }                  
      
  if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
     if ( IsLoadCanceled() ) {
         m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
         return( FALSE );
     }                  
     TestMessage();
  }
   
   if ( 0 != m_dirBlock.Namtab ) {
      //
      // Get source file name block
      //   
      kCount = 0;
      m_namePointer = new LONG* [m_nNameBlockCount];
      for ( iCount = (int)m_dirBlock.Namtab;
            iCount <= m_dirBlock.Namend;
            iCount ++ ) {
         NameInfor = new NameTab[8];   
         m_namePointer[kCount] = (LONG *)NameInfor;
         GetFileInfor( iCount, NameInfor );
         for ( jCount = 0; jCount < 8; jCount ++ ) {
            m_nameTab[jCount+kCount*8] = &NameInfor[jCount];
         }
         kCount ++;
      } /* end of for */
         
      //
      // Get the module name
      //
      kCount = 0;   
      CString path;
      int pCount = 0;
      do {
         path = m_nameTab[kCount]->modulename;
         if ( FindModule( path ) ) {
            m_moduleBlock[pCount] = m_nameTab[kCount];
            m_nIndex[pCount] = kCount;         
            pCount ++;
         }   
         kCount ++;
      } while ( m_nameTab[kCount]->namelen != 0 );
      m_nModuleCount = pCount;
   }      

  if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
     m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
     return( FALSE );
  }                  
      
  if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
     if ( IsLoadCanceled() ) {
         m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
         return( FALSE );
     }                  
     TestMessage();
  }
   
   if ( 0 != m_dirBlock.Lsttab ) {
      //   
      // Get line information block
      //   
      kCount = 0;
      m_linePointer = new LONG* [m_nLineBlockCount];
      for ( iCount = (int)m_dirBlock.Lsttab;
            iCount <= m_dirBlock.Lstend;
            iCount ++ ) {
         LineInformation = new LineInfor[85];   
         m_linePointer[kCount] = (LONG *)LineInformation;
         GetLineInfor( iCount, LineInformation );
         for ( jCount = 0; jCount < 85; jCount ++ ) {
            m_lineInfor[jCount+kCount*85] = &LineInformation[jCount];
         }
         kCount ++;
      } /* end of for */
   }      

  if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
     m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
     return( FALSE );
  }                  
      
  if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
     if ( IsLoadCanceled() ) {
         m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
         return( FALSE );
     }                  
     TestMessage();
  }
   
   LocalVARSHead* localvarshead  = new LocalVARSHead;
   LocalVars*     localvars; 
   LONG           sAddr, eAddr;
   int            iTemp = 0;
   
   if ( 0 != m_dirBlock.LocalVARS ) {
      //
      // Get local variable
      //
      m_CodeFile.Seek( m_dirBlock.LocalVARS* BLOCKSIZE, CFile::begin );         
      
      for ( iCount = (int)m_dirBlock.LocalVARS; 
            iCount <= m_dirBlock.Localend;
            iCount ++ ) {
         kCount = 0; 
         do {
            GetLocalVarHead( localvarshead );      // Get head
   
            // Convert block address range         
            sAddr = 0; eAddr = 0;
            sAddr |= localvarshead->HStartAddress;
            sAddr << 4;
            sAddr |= localvarshead->LStartAddress;
            
            eAddr |= localvarshead->HEndAddress;
            eAddr << 4;
            eAddr |= localvarshead->LEndAddress;
            
            if ( !strncmp(localvarshead->LocalHeader, "__LOCAL", 7) ) {
               localvars = new LocalVars;
               strcpy(localvars->VarSymbol.SymbolName, "$$BLOCK");
               localvars->lBlockStartAddress = sAddr;
               localvars->lBlockEndAddress = eAddr;
               m_localVars[iTemp] = localvars;
               iTemp++;
               kCount ++;
            }               
            
            // Get local vars define                                         
            CString varname;
            char chVarName[10];
            BOOL  bIs = TRUE;
            do {
               localvars = new LocalVars;
               GetLocalVars( &(localvars->VarSymbol) );
               memset( chVarName, 0, 10 );
               strncpy( chVarName, localvars->VarSymbol.SymbolName, 7 );
               varname = chVarName;
               varname.MakeUpper();
               if ( ("__LOCAL" == varname) || 
                    (localvars->VarSymbol.NameLen == 0) ) {
                  bIs = FALSE;
                  m_CodeFile.Seek( (LONG)(-16), CFile::current ); //Back a 16 byte
               }
               else {
                  localvars->lBlockStartAddress = sAddr;
                  localvars->lBlockEndAddress = eAddr;
                  m_localVars[iTemp] = localvars;
                  iTemp ++;
                  kCount ++;
               }               
            } while ( bIs );
            
            if ( (bIs == FALSE) && (localvars->VarSymbol.NameLen == 0) )
               goto OUT;
         } while ( kCount < 31 );
      }
      
      OUT:
      m_nVarsCount = iTemp;
   }      
   
   m_CodeFile.Seek(512, CFile::begin);
   m_CodeFile.Read(m_chBuffer, 512*m_nCodeBlock);
   m_CodeFile.GetStatus(m_nStatus);
   m_CodeFile.Close();
   
   return TRUE;
}

/****************************************************************************
**
**  OpenCodFile
**
**  Description:
**     Open the file to be load
**
**  Parameters:
**     input:
**       CString&   strFileName     File to be loaded
**
**     output:
**        BOOL    TRUE     successful
**                FAILURE  failure
**
*****************************************************************************/

BOOL
CPicLoader :: OpenCodFile(CString& strFileName)
{
   CFileException e;
   if (!m_CodeFile.Open( strFileName.GetBuffer( strFileName.GetLength() ),
                         CFile::modeRead, &e) ) {
         #ifdef _DEBUG
            afxDump << "File could not be opened " << e.m_cause << "\r\n";
         #endif
         
         return FALSE;
   }
   
   return TRUE;
}

/****************************************************************************
**
**  GetDirBlock
**
**  Description:
**     Get the first block's(directory block) information. It is very
**     important
**
**  Parameters:
**     input:
**        DIRECTORY_BLOCK   *dirblock;     --  Store the information
**
**     output:
**        none:
**
*****************************************************************************/

void 
CPicLoader::GetDirBlock(DirectoryBlock *blockbuf)
{
   m_CodeFile.Read( blockbuf, sizeof( DirectoryBlock ) );
}

/****************************************************************************
**
**  GetSymbolShortInfo
**
**  Description:
**     Get the symbol's simple information
**
**  Parameters:
**     input:
**        WORD    Symtab         --    the block num
**        SSymbol *symbolbuf     --    store the symbol information
**
**     output:
**        none:
**
*****************************************************************************/

void 
CPicLoader::GetSymbolShortInfor(PICWORD Symtab, SSymbol *symbolbuf)
{
   m_CodeFile.Seek( ( Symtab * BLOCKSIZE ), CFile::begin );
   m_CodeFile.Read( symbolbuf, BLOCKSIZE );
}

/****************************************************************************
**
**  GetFileInfo
**
**  Description:
**     Get the source file module information
**
**  Parameters:
**     input:
**        WORD NameStarttab   -- the first name block number
**        WORD NameEndtab     -- the last name block number
**        NameTab *nameinfor  -- file module namr information
**     output:
**        none:
**
*****************************************************************************/

void 
CPicLoader::GetFileInfor(PICWORD nameblock, 
                         NameTab *nameinfor)
{
   m_CodeFile.Seek( nameblock*BLOCKSIZE, CFile::begin );
   m_CodeFile.Read( nameinfor, BLOCKSIZE );
}

/****************************************************************************
**
**  GetLineInfor
**
**  Description:
**     Get the line message information
**
**  Parameters:
**     input:
**        LineInfor  *linrinformation  --    line message information buffer
**
**     output:
**        none:
**
*****************************************************************************/

void 
CPicLoader::GetLineInfor(PICWORD lineblock, LineInfor *lineformation)
{
   m_CodeFile.Seek( lineblock * BLOCKSIZE, CFile::begin );
   m_CodeFile.Read( lineformation, 510 );
}

/****************************************************************************
**
**  GetLocalVarHead & GetLocalVars
**
**  Description:
**     Get the local variable information
**
**  Parameters:
**     input:
**
**     output:
**        none:
**
*****************************************************************************/

void 
CPicLoader :: GetLocalVarHead( LocalVARSHead*  localvarshead )
{
   m_CodeFile.Read( localvarshead, 16 );
}


void 
CPicLoader :: GetLocalVars( SSymbol* localvars )
{
   m_CodeFile.Read( localvars, 16 );
}

/****************************************************************************
**
**  LinkToSymbol
**
**  Description:
**     Link the load information to symbol server
**
**  Parameters:
**     input:
**
**     output:
**        none:
**
*****************************************************************************/

BOOL
CPicLoader :: LinkToSymbol()
{
   int nModule;
   int nTypeIndex;
   int err = 0;

   if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
       m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
       return( FALSE );
   }                  
   if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
       if ( IsLoadCanceled() ) {
           m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
           return( FALSE );
       }                  
       TestMessage();
   }
   
   if ( GOOD != StartAddSymbol() ) {
      m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
      return( FALSE );
   }

   if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
       m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
       return( FALSE );
   }                  
   if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
       if ( IsLoadCanceled() ) {
           m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
           return( FALSE );
       }                  
       TestMessage();
   }

   // Link all globle variables
   //
   if ( m_bHaveGlobleSym ) {
      if ( LoadGlobleVariable() == FALSE ) {
         m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
         return( FALSE );
      }
   }   
   nGLoaded = 60;

   if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
       m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
       return( FALSE );
   }                  
   if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
       if ( IsLoadCanceled() ) {
           m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
           return( FALSE );
       }                  
       TestMessage();
   }
      
   for ( nModule = 0; nModule < m_nModuleCount; nModule++ ) {
      if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
         m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
         return( FALSE );
      }                  
      
      if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
         if ( IsLoadCanceled() ) {
             m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
             return( FALSE );
         }                  
         TestMessage();
      }
   
      //
      // Only support one module
      // Do not support #include *.c as a module
      //   
      if ( GOOD != StartAddModule(nModule) ) {
         m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
         return( FALSE );
      }
         
      ////////
      //         
      // Add function type
      //
      ////////
      for ( nTypeIndex = 0; nTypeIndex < 152; nTypeIndex ++ ) {
         if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
            m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
            return( FALSE );
         }                  
         
         if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
            if ( IsLoadCanceled() ) {
                m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
                return( FALSE );
            }                  
            TestMessage();
         }
      
         if ( TRUE != LoadPicFuncType(nTypeIndex) ) {
            m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
            return( FALSE );
         }
      }
      nGLoaded = 70;
      
      
      if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
         m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
         return( FALSE );
      }                  
      
      if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
         if ( IsLoadCanceled() ) {
             m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
             return( FALSE );
         }                  
         TestMessage();
      }
      
      ////////
      //
      // Add Function
      // Add block
      // Add local varible
      //
      ////////
      if ( m_bHaveLocalVars ) {
         if ( TRUE != GetBlockInfor() ) {
            m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
            return( FALSE );
         }
      }         
        nGLoaded = 80;
      
      if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
         m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
         return( FALSE );
      }                  
      
      if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
         if ( IsLoadCanceled() ) {
             m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
             return( FALSE );
         }                  
         TestMessage();
      }

      ////////
      //
      // Add Line number
      //
      ////////
      if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
         m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
         return( FALSE );
      }                  
      
      if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
         if ( IsLoadCanceled() ) {
             m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
             return( FALSE );
         }                  
         TestMessage();
      }
      
      if ( m_bHaveLineBlock ) {
         if ( TRUE != SetLineInfor() ) {
            m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
            return( FALSE );
         }
      }   
      nGLoaded = 90;
      
      ////////
      //
      // End of add module
      //
      ////////
      if (GOOD != EndAddModule()) {
         m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
         return( FALSE );
      }
   }      
   
   EndAddSymbol();   

   nGLoaded = 95;
   
   return TRUE;
}

/****************************************************************************
**
**  LoadPicFuncType
**
**  Description:
**     Load the types from PIC file information to the types in symbol
**    server. (Define in SYMBLVR.H)
**
**  Parameters:
**     input:
**        int  nType    --    Type from PIC file information
**
**     output:
**        BOOL    -- TRUE     success
**                   FALSE    failure
**
*****************************************************************************/

BOOL
CPicLoader :: LoadPicFuncType(int nType)
{
   TYPE_HEADER_TYPE typeHdrInfo;
   char typeName[256];
   TYPE_INDEX  typeIndex;
   U8 frameType=0, argCount;
   U32 attr;
   U16 retIndex;
   RETCODE  retCode;
   
   switch( nType ) {
      case  FUNC_VOID_NONE     : //16 void func(void) or void func()
            argCount = 0;
            retIndex = BI_VOID;
            break;
            
      case  FUNC_LONG_NONE     : //26 long func(void) or int func()
            argCount = 0;
            retIndex = BI_S32_LONG;
            break;
            
      case  FUNC_INT_NONE      : //21 int func(void) or int func()
            argCount = 0;
            retIndex = BI_S16_SHORT;
            break;
           
      case  FUNC_LONG_BYTE     : //27 long func(int) or int func(char)
            argCount = 1;
            retIndex = BI_S32_LONG;
            break;
            
      case  FUNC_VOID_BYTE     : //17 void func(int) or void func(char)
            argCount = 1;
            retIndex = BI_VOID;
            break;
            
      case  FUNC_INT_BYTE      : //22 int func(int) or int func(char)
            argCount = 1;
            retIndex = BI_S16_SHORT;
            break;

      case  FUNC_VOID_TWOBYTE  : //18 two parameter: void func(int, int)
            retIndex = BI_VOID;
            argCount = 2;
            break;

      case  FUNC_INT_TWOBYTE   : //23 two parameter: int func(int, int)
            retIndex = BI_S16_SHORT;
            argCount = 2;
            break;
            
      case  FUNC_LONG_TWOBYTE  : //28 two parameter: long func(int, int)
            retIndex = BI_S32_LONG;
            argCount = 2;
            break;

      //////////
      // ????????
      //////////
      
      case  FUNC_VOID_LONG     : //19 void func(long):not support
            retIndex = BI_VOID;
            argCount = 2;
            break;
                  
      case  FUNC_VOID_UNDEF    : //20 ????
            retIndex = BI_VOID;
            argCount = 0;
            break;
      
      case  FUNC_INT_LONG      : //24 int func(long):not support
            retIndex = BI_S16_SHORT;
            argCount = 1;
            break;
      
      case  FUNC_INT_UNDEF     : //25 ????
            retIndex = BI_S16_SHORT;
            argCount = 0;
            break;
      
      case  FUNC_LONG_LONG     : //29 long func(long):not support
            argCount = 1;
            retIndex = BI_S32_LONG;
            break;
      
      case  FUNC_LONG_UNDEF    : //30
            argCount = 0;
            retIndex = BI_S32_LONG;
            break;
      
      default:
            return TRUE;
   }

   memset(typeName, 0, sizeof(typeName));   
   typeHdrInfo.typeChoice = (TYPE_CLASS) COMPLEX_TYPE_CLASS;
   typeHdrInfo.typeName = typeName;                    
   typeHdrInfo.sizeInMAUs = 0;      
   typeHdrInfo.sizeCalculated = FALSE;
   
   attr = 0xFFFFFFFF;                                
   typeHdrInfo.t.complexType = TY_FUNC_DEP;

   typeIndex = 256+nType-16;
   retCode = SymAddTypeHeader(typeIndex , &typeHdrInfo);
   if ( retCode != GOOD ) {
       m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
       return( FALSE );
   }
   retCode = SymAddTypeFunc(typeIndex, 
                            attr,
                            frameType,
                            0L,
                            retIndex,
                            argCount,
                            0,
                            "");
   if ( retCode != GOOD ) {
       m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
       return( FALSE );
   }

   return TRUE;
}

/****************************************************************************
**
**  ProPrecessStruct
**
**  Description:
**    Calculate the struct / union's size.
**    Distinguish the variable is struct or union
**
**  Parameters:
**     input:
**        int nWhich             -- the variable no.
**        int nPicTypeIndex      -- the variable type in PIC file
**        int size               -- struct/union size
**        int strucOrUnion       -- is strunt or is union
**                                  1 struct
**                                  0 union
**
**     output:
**        BOOL    --    TRUE     success
**                      FALSE    failure
**
*****************************************************************************/

void
CPicLoader :: PreProcessStruct(int nWhich, int /*nPicTypeIndex*/, 
                               int& size, int& StructOrUnion)
{
  int iCount, jCount;
  int nDef;
  int nSize = 0;
  BOOL   bIsStruct;
   
  for ( iCount = nWhich-1;;iCount -- ) {
    if (m_localVars[iCount]->VarSymbol.SymbolType == I_STRUCT )
       continue;
    else
       break;   
  }
           
  nDef = iCount;
  if (m_localVars[nDef]->VarSymbol.SymbolType == C_STRUCT ) {
     //
     // Add struct type
     //
     nSize = m_localVars[nDef]->VarSymbol.SymbolValue;
     for ( iCount = nDef-1; ;iCount-- ) {
         if (IsStructElement(m_localVars[iCount]->VarSymbol.SymbolType)){

         }
         else
            break;
     }
     jCount = iCount;

     BOOL   bIsOnlyOne = FALSE;
     if (jCount == (nDef-1))
         bIsOnlyOne = TRUE;

     // Distinguish the last element's offset
     //          
     if (m_localVars[nDef-1]->VarSymbol.SymbolValue == 0) {
        bIsStruct = FALSE;
     }   
     else
        bIsStruct = TRUE;         
     size = nSize;
     
     if (!bIsStruct) {
       if (bIsOnlyOne)
         StructOrUnion = 1;         // 1 is struct
       else
         StructOrUnion = 0;         // 1 is struct
     }       
     else   
       StructOrUnion = 1;                  // 0 is union   
  }
}                               

/****************************************************************************
**
**  GetStructType
**
**  Description:
**    If current variable is a struct variable, add it type to symbol server.
**    Calculate the element and the element type
**
**  Parameters:
**     input:
**        int nWhich                -- the variable no.
**        int nType                 -- the variable type in PIC file
**        TYPE_INDEX & typeIndex    -- the type index in symbol server
**
**     output:
**        BOOL    --    TRUE     success
**                      FALSE    failure
**
*****************************************************************************/

BOOL
CPicLoader :: GetStructType(int nWhich, int nPicTypeIndex, WORD& nSymTypeIndex)
{
   TYPE_HEADER_TYPE typeHdrInfo;
   char typeName[256];
   TYPE_INDEX  typeIndex;
   U8 frameType=0;
   RETCODE  retCode;
   int iCount, jCount;
   TYPE_S_U_STRUCT typeOfStruct;
   int nDef;

   int size = 0;
   int StructOrUnion;
   PreProcessStruct(nWhich, nPicTypeIndex, size, StructOrUnion);
   
   memset(typeName, 0, sizeof(typeName));   
   typeHdrInfo.typeChoice = (TYPE_CLASS) COMPLEX_TYPE_CLASS;
   typeHdrInfo.typeName = typeName;                    
   if (size != 0) {
      typeHdrInfo.sizeCalculated = TRUE;
      typeHdrInfo.sizeInMAUs = size;
   }         
   else {
      typeHdrInfo.sizeCalculated = FALSE;
      typeHdrInfo.sizeInMAUs = 0;
   }         

   if (StructOrUnion == 1)    // Struct   
      typeHdrInfo.t.complexType = TY_STRUCT;
   else                       // Union
      typeHdrInfo.t.complexType = TY_UNION;            
      
   switch ( nPicTypeIndex ) {
      //case C_STRUCT           : //76 struct/union typedef
      case I_STRUCT           : //77 variable of struct/union
           for ( iCount = nWhich-1;;iCount -- ) {
               if (m_localVars[iCount]->VarSymbol.SymbolType == I_STRUCT )
                  continue;
               else
                  break;   
           }
           
           nDef = iCount;
           if (m_localVars[nDef]->VarSymbol.SymbolType == C_STRUCT ) {
              //
              // Add struct type
              //
              strcpy(typeName, m_localVars[nDef]->VarSymbol.SymbolName );
              
              //
              // the index in symbol is
              //     the type index after the function type(286)
              //
              //
              typeIndex = 286+IndexDelta;    // 286 --> skip the head 30 
                                             //         function type
              retCode = SymAddTypeHeader(typeIndex , &typeHdrInfo);
              if ( retCode != GOOD ) {
                  m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
                  return( FALSE );
              }
              
              for ( iCount = nDef-1; ;iCount-- ) {
                  if (IsStructElement(m_localVars[iCount]->VarSymbol.SymbolType)){
                     
                  }
                  else
                     break;
              }
              jCount = iCount;
              
              for ( iCount = nDef-1; iCount > jCount; iCount-- ) {
                  typeOfStruct.offset = (U16)m_localVars[iCount]->VarSymbol.SymbolValue;
                  typeOfStruct.name = 
                        new char [strlen(m_localVars[iCount]->VarSymbol.SymbolName)+2];
                  strcpy(typeOfStruct.name,
                         m_localVars[iCount]->VarSymbol.SymbolName);
                  ConvStrctElemtType(m_localVars[iCount]->VarSymbol.SymbolType, 
                                     typeOfStruct.typeIndex );
                  retCode = SymAddTypeStructUnion(typeIndex, 
                                                  &typeOfStruct);
                  if ( retCode != GOOD ) {
                      m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                      return( FALSE );
                  }
                  if ( typeOfStruct.name ) delete []typeOfStruct.name ;
              }
              nSymTypeIndex = WORD(typeIndex);
           }
           else
              return FALSE;
                            
           break;
               
      default:
           return FALSE;
   }            
   
   IndexDelta++;
   return TRUE;      
}

/****************************************************************************
**
**  PreProcessGlobleStruct
**
**  Description:
**    Calculate the struct / union's size.
**    Distinguish the variable is struct or union
**
**  Parameters:
**     input:
**        int nWhich             -- the variable no.
**        int nPicTypeIndex      -- the variable type in PIC file
**        int size               -- struct/union size
**        int strucOrUnion       -- is strunt or is union
**                                  1 struct
**                                  0 union
**
**     output:
**        BOOL    --    TRUE     success
**                      FALSE    failure
**
*****************************************************************************/

void
CPicLoader :: PreProcessGlobleStruct(int nWhich, int /*nPicTypeIndex*/, 
                                     int& size, int& StructOrUnion)
{
  int iCount, jCount;
  int nDef;
  int nSize = 0;
  BOOL   bIsStruct;
   
  for ( iCount = nWhich;;iCount -- ) {
    if (m_symBlock[iCount]->SymbolType == I_STRUCT )
       continue;
    else
       break;   
  }
           
  nDef = iCount;
  if (m_symBlock[nDef]->SymbolType == C_STRUCT ) {
     //
     // Add struct type
     //
     nSize = m_symBlock[nDef]->SymbolValue;
     for ( iCount = nDef-1; ;iCount-- ) {
         if (IsStructElement(m_symBlock[iCount]->SymbolType)){

         }
         else
            break;
     }
     jCount = iCount;

     BOOL   bIsOnlyOne = FALSE;
     if (jCount == (nDef-1))
         bIsOnlyOne = TRUE;

     // Distinguish the last element's offset
     //          
     if (m_symBlock[nDef-1]->SymbolValue == 0) {
        bIsStruct = FALSE;
     }   
     else
        bIsStruct = TRUE;         
     size = nSize;
     
     if (!bIsStruct) {
       if (bIsOnlyOne)
         StructOrUnion = 1;         // 1 is struct
       else
         StructOrUnion = 0;         // 1 is struct
     }       
     else   
       StructOrUnion = 1;                  // 0 is union   
  }
}                               

/****************************************************************************
**
**  GetGlobleStructType
**
**  Description:
**    If current variable is a struct variable, add it type to symbol server.
**    Calculate the element and the element type
**
**  Parameters:
**     input:
**        int nWhich                -- the variable no.
**        int nType                 -- the variable type in PIC file
**        TYPE_INDEX & typeIndex    -- the type index in symbol server
**
**     output:
**        BOOL    --    TRUE     success
**                      FALSE    failure
**
*****************************************************************************/

BOOL
CPicLoader :: GetGlobleStructType(int nWhich, int nPicTypeIndex, WORD& nSymTypeIndex)
{
   TYPE_HEADER_TYPE typeHdrInfo;
   char typeName[256];
   TYPE_INDEX  typeIndex;
   U8 frameType=0;
   RETCODE  retCode;
   int iCount, jCount;
   TYPE_S_U_STRUCT typeOfStruct;
   int nDef;

   int size = 0;
   int StructOrUnion;
   PreProcessGlobleStruct(nWhich, nPicTypeIndex, size, StructOrUnion);
   
   memset(typeName, 0, sizeof(typeName));   
   typeHdrInfo.typeChoice = (TYPE_CLASS) COMPLEX_TYPE_CLASS;
   typeHdrInfo.typeName = typeName;                    
   if (size != 0) {
      typeHdrInfo.sizeCalculated = TRUE;
      typeHdrInfo.sizeInMAUs = size;
   }         
   else {
      typeHdrInfo.sizeCalculated = FALSE;
      typeHdrInfo.sizeInMAUs = 0;
   }         

   if (StructOrUnion == 1)    // Struct   
      typeHdrInfo.t.complexType = TY_STRUCT;
   else                       // Union
      typeHdrInfo.t.complexType = TY_UNION;            
      
   switch ( nPicTypeIndex ) {
      //case C_STRUCT           : //76 struct/union typedef
      case I_STRUCT           : //77 variable of struct/union
           for ( iCount = nWhich-1;;iCount -- ) {
               if (m_symBlock[iCount]->SymbolType == I_STRUCT )
                  continue;
               else
                  break;   
           }
           
           nDef = iCount;
           if (m_symBlock[nDef]->SymbolType == C_STRUCT ) {
              //
              // Add struct type
              //
              strcpy(typeName, m_symBlock[nDef]->SymbolName );
              
              //
              // the index in symbol is
              //     the type index after the function type(286)
              //
              //
              typeIndex = 286+IndexDelta;    // 286 --> skip the head 30 
                                             //         function type
              retCode = SymAddTypeHeader(typeIndex , &typeHdrInfo);
              if ( retCode != GOOD ) {
                  m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
                  return( FALSE );
              }
              
              for ( iCount = nDef-1; ;iCount-- ) {
                  if (IsStructElement(m_symBlock[iCount]->SymbolType)){
                     
                  }
                  else
                     break;
              }
              jCount = iCount;
              
              for ( iCount = nDef-1; iCount > jCount; iCount-- ) {
                  typeOfStruct.offset = (U16)m_symBlock[iCount]->SymbolValue;
                  typeOfStruct.name = 
                        new char [strlen(m_symBlock[iCount]->SymbolName)+2];
                  strcpy(typeOfStruct.name,
                         m_symBlock[iCount]->SymbolName);
                  ConvStrctElemtType(m_symBlock[iCount]->SymbolType, 
                                     typeOfStruct.typeIndex );
                  retCode = SymAddTypeStructUnion(typeIndex, 
                                                  &typeOfStruct);
                  if ( retCode != GOOD ) {
                      m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                      return( FALSE );
                  }
                  if ( typeOfStruct.name ) delete []typeOfStruct.name ;
              }
              nSymTypeIndex = WORD(typeIndex);
           }
           else
              return FALSE;
                            
           break;
               
      default:
           return FALSE;
   }            
   
   IndexDelta++;
   return TRUE;      
}

/****************************************************************************
**
**  IsStructElement
**
**  Description:
**    Distinguish the current variable is a struct/union element or not
**
**  Parameters:
**     input:
**        int nType                 -- the variable type in PIC file
**
**     output:
**        BOOL    --    TRUE     is a element
**                      FALSE    is not a element
**
*****************************************************************************/

BOOL
CPicLoader :: IsStructElement(int nType)
{
   switch( nType ) {
      case S_LONG             : //79 long variable
      case S_ULONG            : //80 unsigned long variable
      case S_SHORT            : //81 int variable
      case S_USHORT           : //82 char, unsigned char/int variable
           return TRUE; 
           
      default:
           return FALSE;         
   }
}

/****************************************************************************
**
**  ConvStructElemtType
**
**  Description:
**     Convert the types of the struct/union element from PIC file 
**    information to the types in symbol server. (Define in SYMBLVR.H)
**
**  Parameters:
**     input:
**        int nType                 -- the variable type in PIC file
**        TYPE_INDEX & typeIndex    -- the type index in symbol server
**
**     output:
**        BOOL    --    TRUE     convert success
**                      FALSE    convert failure.
**
*****************************************************************************/

BOOL
CPicLoader :: ConvStrctElemtType(int nType, TYPE_INDEX& typeIndex)
{
   WORD wType;
   
   switch( nType ) {
////////
// 
// Building type
//
////////
      case S_LONG             : //79 long variable
           wType = BI_S32_LONG;
           break;
           
      case S_ULONG            : //80 unsigned long variable
           wType = BI_S32_LONG;
           break;

      case S_SHORT            : //81 int variable
           wType = BI_S16_SHORT;
           break;
           
      case S_USHORT           : //82 char, unsigned char/int variable
           wType = BI_S16_USHORT;          
           break;
      default:
           return FALSE;         
   }
      
   typeIndex = wType;
      
   return TRUE;           
}

/****************************************************************************
**
**  IsPointer
**
**  Description:
**    Distinguish the current variable is pointer or not
**
**  Parameters:
**     input:
**        int nWhich                -- the variable no.
**        int nType                 -- the variable type in PIC file
**
**     output:
**        BOOL    --    TRUE     is pointer
**                      FALSE    is not pointer.
**
*****************************************************************************/

BOOL
CPicLoader :: IsPointer(int nWhich, int /*nType*/)
{
   int index = nWhich+1;   
   
   if ('*' == m_localVars[index]->VarSymbol.SymbolName[0] ) 
      return TRUE;
   else
      return FALSE;
}

/****************************************************************************
**
**  IsGloblePointer
**
**  Description:
**    Distinguish the current variable is pointer or not
**
**  Parameters:
**     input:
**        int nWhich                -- the variable no.
**        int nType                 -- the variable type in PIC file
**
**     output:
**        BOOL    --    TRUE     is pointer
**                      FALSE    is not pointer.
**
*****************************************************************************/

BOOL
CPicLoader :: IsGloblePointer(int nWhich, int /*nType*/)
{
   //int index = nWhich;   
   
   if ('*' == m_symBlock[nWhich]->SymbolName[0] ) 
      return TRUE;
   else
      return FALSE;
}

/****************************************************************************
**
**  GetPointerType
**
**  Description:
**     Get the pointer type  
**
**  Parameters:
**     input:
**        int nPicTypeIndex   -- the variable type in PIC file
**
**     output:
**        BOOL    --    TRUE     Convert sucess
**                      FALSE    Convert ffailure
**
*****************************************************************************/

BOOL
CPicLoader :: GetPointerType(int nPicTypeIndex, WORD& wSymTypeIndex)
{
   TYPE_INDEX  typeIndex;
   TYPE_INDEX  symType;
   TYPE_HEADER_TYPE typeHdrInfo;
   char typeName[256];
   RETCODE  retCode;
   
   typeIndex = 286+IndexDelta;    // 286 --> skip the head 30 
                                  //         function type
   memset(typeName, 0, sizeof(typeName));   
   typeHdrInfo.typeChoice = (TYPE_CLASS) COMPLEX_TYPE_CLASS;
   typeHdrInfo.typeName = typeName;                    
   typeHdrInfo.sizeCalculated = TRUE;
   typeHdrInfo.sizeInMAUs = 0x01L;
   switch ( nPicTypeIndex ) {
      case  C_USHORT:
            typeHdrInfo.t.complexType = TY_SMALL_PTR;
            break;
      
      case  C_ULONG:
            typeHdrInfo.t.complexType = TY_LARGE_PTR;
            break;
   }
   
   retCode = SymAddTypeHeader(typeIndex , &typeHdrInfo);
   if ( retCode != GOOD ) {
       m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
       return( FALSE );
   }
   if ( nPicTypeIndex == C_ULONG )
      symType = BI_S32_LONG;
   if ( nPicTypeIndex == C_USHORT )
      symType = BI_S16_SHORT;
      
   retCode = SymAddTypePointerTypeIndex(typeIndex , symType);
   if ( retCode != GOOD ) {
       m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
       return( FALSE );
   }

   wSymTypeIndex = (WORD)typeIndex;   
   IndexDelta++;                  // Globle index_delta increase
   
   return TRUE;   
}

/****************************************************************************
**
**  GetArrayType & CalcArraySize
**
**  Description:
**     Get the array type.
**     Calculate the array dimision(size)
**
**  Parameters:
**     input:
**        int nWhich          -- the variable no.
**        int nPicTypeIndex   -- the variable type in PIC file
**        WORD wSymTypeIndex  -- the variable type in symbol server
**
**     output:
**        BOOL    --    TRUE     Convert sucess
**                      FALSE    Convert ffailure
**        WORD    --    the array simision(size)
**
*****************************************************************************/

WORD
CPicLoader :: CalcArraySize(int /*nWhich*/, int /*nPicTypeIndex*/)
{
   WORD wSize = 1;
/*
   int  nIndex = nWhich+1;
   int  nType;   

   
   do {
      nType = m_localVars[nIndex]->VarSymbol.SymbolType; 
      //
      // The next variable is function
      //   
      if ( TRUE == LocalVarIsFunction(nType) ){
         wSize = 1;
         break;
      }
      
      //
      // The next variable is struct element
      //   
      if ( TRUE == IsStructElement(nType) ) {
         nIndex++;
         continue;
      }
      else 
      if ( nType == C_STRUCT ) {
         nIndex++;
         continue;
      }
      else {         
         wSize = WORD(m_localVars[nIndex]->VarSymbol.SymbolValue -
                      m_localVars[nWhich]->VarSymbol.SymbolValue);
         break;         
      }
      
      nIndex++;
   } while(1); 
   
   switch ( nPicTypeIndex ) {
      case WORD_ARRAY        :   //14 long array
      case U_WORD_ARRAY      :   //15 usigned long array
           wSize /= 2;
           break;
   }      
*/      
   return wSize;
}

BOOL
CPicLoader :: GetArrayType(int nWhich, int nPicTypeIndex, WORD& wSymTypeIndex)
{
   TYPE_INDEX  typeIndex;
   TYPE_HEADER_TYPE typeHdrInfo;
   char typeName[256];
   U32  size;
   RETCODE  retCode;
   TYPE_C_ARRAY_STRUCT arr;
   
   typeIndex = 286+IndexDelta;    // 286 --> skip the head 30 
                                  //         function type
   
   //
   // Calculate the array size
   //
   size = (U32)CalcArraySize(nWhich, nPicTypeIndex);
      
   memset(typeName, 0, sizeof(typeName));   
   typeHdrInfo.typeChoice = (TYPE_CLASS) COMPLEX_TYPE_CLASS;
   typeHdrInfo.typeName = typeName;
   typeHdrInfo.sizeCalculated = FALSE;
   typeHdrInfo.sizeInMAUs = 0;
   typeHdrInfo.t.complexType = TY_C_ARRAY;
   retCode = SymAddTypeHeader(typeIndex, &typeHdrInfo);
   if ( retCode != GOOD ) {
      m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
      return( FALSE );
   }
   
   switch ( nPicTypeIndex ) {
      case BYTE_ARRAY        :   //12 char, int array
           arr.typeIndex = BI_S16_SHORT;
           break;
           
      case U_BYTE_ARRAY      :   //13 usigned int array
           arr.typeIndex = BI_S16_USHORT;
           break;
            
      case WORD_ARRAY        :   //14 long array
      case U_WORD_ARRAY      :   //15 usigned long array
           arr.typeIndex = BI_S32_LONG;
           break;
   }
         
   arr.highBound = size-1;
   retCode = SymAddTypeCArray(typeIndex, &arr);
   if ( retCode != GOOD ) {
      m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
      return( FALSE );
   }
   
   wSymTypeIndex = (WORD)typeIndex;   
   IndexDelta++;                  // Globle index_delta increase
   
   return TRUE;
}

BOOL
CPicLoader :: GetGlobleArrayType(int nWhich, int nPicTypeIndex, WORD& wSymTypeIndex)
{
   TYPE_INDEX  typeIndex;
   TYPE_HEADER_TYPE typeHdrInfo;
   char typeName[256];
   U32  size;
   RETCODE  retCode;
   TYPE_C_ARRAY_STRUCT arr;
   
   typeIndex = 286+IndexDelta;    // 286 --> skip the head 30 
                                  //         function type
   
   //
   // Calculate the array size
   //
   size = (U32)CalcArraySize(nWhich, nPicTypeIndex);
      
   memset(typeName, 0, sizeof(typeName));   
   typeHdrInfo.typeChoice = (TYPE_CLASS) COMPLEX_TYPE_CLASS;
   typeHdrInfo.typeName = typeName;
   typeHdrInfo.sizeCalculated = FALSE;
   typeHdrInfo.sizeInMAUs = 0;
   typeHdrInfo.t.complexType = TY_C_ARRAY;
   retCode = SymAddTypeHeader(typeIndex, &typeHdrInfo);
   if ( retCode != GOOD ) {
      m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
      return( FALSE );
   }
   
   switch ( nPicTypeIndex ) {
      case BYTE_ARRAY        :   //12 char, int array
           arr.typeIndex = BI_S16_SHORT;
           break;
           
      case U_BYTE_ARRAY      :   //13 usigned int array
           arr.typeIndex = BI_S16_USHORT;
           break;
            
      case WORD_ARRAY        :   //14 long array
      case U_WORD_ARRAY      :   //15 usigned long array
           arr.typeIndex = BI_S32_LONG;
           break;
   }
         
   arr.highBound = size-1;
   retCode = SymAddTypeCArray(typeIndex, &arr);
   if ( retCode != GOOD ) {
      m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
      return( FALSE );
   }
   
   wSymTypeIndex = (WORD)typeIndex;   
   IndexDelta++;                  // Globle index_delta increase
   
   return TRUE;
}

/****************************************************************************
**
**  GetBitfieldType
**
**  Description:
**     Get the bit field type.
**     In code  C file, the "bits" is bit field type
**      e.g.    bits bBits;
**                   bBits = 1;
**                   bBit2.3 = 1;
**     Process the bit field:
**          Each bit field in a bits type is processed to TY_BITFIELD
**          The bits type( such as bBits ) is processed to a struct whose 
**          name is "bits", every element of the struct is the type added
**          before as TY_BITFIELD.
**
**  Parameters:
**     input:
**        WORD wSymTypeIndex  -- the variable type in symbol server
**
**     output:
**        BOOL    --    TRUE     Convert sucess
**                      FALSE    Convert ffailure
**        WORD    --    the array simision(size)
**
*****************************************************************************/

BOOL
CPicLoader :: GetBitfieldType( WORD& wSymTypeIndex )
{
   TYPE_INDEX  typeIndex;
   TYPE_HEADER_TYPE typeHdrInfo;
   char typeName[256];
   RETCODE  retCode;
   TYPE_BITFIELD_STRUCT bit;
   TYPE_S_U_STRUCT typeOfStruct;
   int i;   

   typeHdrInfo.typeChoice = (TYPE_CLASS) COMPLEX_TYPE_CLASS;
   
   typeIndex = 286+IndexDelta;    // 286 --> skip the head 30 
   for ( i = 0; i < 8; i ++ ) {
      memset(typeName, 0, sizeof(typeName));   
      typeHdrInfo.typeName = typeName;                    
      typeHdrInfo.sizeCalculated = FALSE;
      typeHdrInfo.t.complexType = TY_BITFIELD;
      retCode = SymAddTypeHeader(typeIndex+i , &typeHdrInfo);
      if ( retCode != GOOD ) {
         m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
         return( FAILURE );
      }
      bit.bitfieldSigned = 1; // unsigned
      bit.size = 1;
      bit.offset = (U8)i;         // offset
      bit.baseTypeIndex = 5 ; // BI_U16_UINT ;
      retCode = SymAddTypeBitfield(typeIndex+i, &bit);
      if ( retCode != GOOD ) {
         m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
         return( FAILURE );
      }
   }      

   IndexDelta += 8;
   typeIndex = 286+IndexDelta;    // 286 --> skip the head 30 
   //      
   // Add the struct as the bits type
   // Treat the bits type in PIC as a struct type in symbol server
   //      
   memset(typeName, 0, sizeof(typeName));   
   typeHdrInfo.typeChoice = (TYPE_CLASS) COMPLEX_TYPE_CLASS;
   typeHdrInfo.typeName = typeName;                    
   typeHdrInfo.sizeCalculated = TRUE;
   typeHdrInfo.sizeInMAUs = 1;
   typeHdrInfo.t.complexType = TY_STRUCT;
   strcpy(typeName, "bits");
   retCode = SymAddTypeHeader(typeIndex , &typeHdrInfo);
   if ( retCode != GOOD ) {
      m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
      return( FALSE );
   }
   
   for ( i = 0; i < 8; i ++ ) { 
      typeOfStruct.offset = 0;
      typeOfStruct.name = new char [3];
      wsprintf(typeOfStruct.name, "B%d", i);
      typeOfStruct.name[2] = '\0';      
      typeOfStruct.typeIndex = typeIndex-(8-i);
      retCode = SymAddTypeStructUnion(typeIndex, 
                                      &typeOfStruct);
      if ( retCode != GOOD ) {
          m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
          return( FALSE );
      }
      if ( typeOfStruct.name ) delete []typeOfStruct.name ;
   }      

   wSymTypeIndex = (WORD)typeIndex;   
   IndexDelta++;                  // Globle index_delta increase
   
   return TRUE;
}


/****************************************************************************
**
**  ConvertType
**
**  Description:
**     Convert the types from PIC file information to the types in symbol
**    server. (Define in SYMBLVR.H)
**
**  Parameters:
**     input:
**        int nWhich                -- the variable no.
**        int nType                 -- the variable type in PIC file
**        TYPE_INDEX & typeIndex    -- the type index in symbol server
**
**     output:
**        BOOL    --    TRUE     may add to symbol server
**                      FALSE    may lost.
**
*****************************************************************************/

BOOL
CPicLoader :: ConvertType(int nWhich, int nType, TYPE_INDEX& typeIndex)
{  
   WORD wType;
   
   switch( nType ) {
///////
//
// Register
//
///////
      case A_REG              : //0 register ???
      case ADDRESS            : // 46        address lable 
           // 
           // Address lable
           // 
           wType = BI_UNKNOWN;
           break;
                            
      case X_REG              : //1 register ???
           // 
           // Data register
           //
           wType = BI_UNKNOWN;
           break;
            
      //case PORT_W             : //56 port_w   register
      //case PORT_R             : //67 port_r   register
      //case PORT_RW            : //58 port_rw  register
      //case PORT_RMW           : //59 port_rmw register

////////
// 
// Building type
//
////////
      case C_LONG             : //3 long variable
           wType = BI_S32_LONG;
           break;

      case C_SHORT            : //2 int variable
           wType = BI_S16_SHORT;
           break;

/////////
//
// Building type or pointer
//
/////////
      case C_ULONG            : //5 unsigned long variable
           if ( IsPointer(nWhich, nType) ) {
              ////////
              //
              // Convert pointer
              //
              ////////            
              if ( FALSE == GetPointerType(nType, wType) ) {
                  wType = BI_UNKNOWN;
              }    
              else {
              
              }
           }
           else
              wType = BI_S32_LONG;
              
           break;

      case C_USHORT           : //4 char, unsigned char/int variable
           if ( IsPointer(nWhich, nType) ) {
              ////////
              //
              // Convert pointer
              //
              ////////            
              
              if ( FALSE == GetPointerType(nType, wType) ) {
                  wType = BI_UNKNOWN;
              }    
              else {
              
              }
           }
           else
             wType = BI_S16_USHORT;          
           break;
           
///////
//
// Struct and union process
//
///////
      //case C_STRUCT           : //76 struct/union typedef
      case I_STRUCT           : //77 variable of struct/union
      //case S_SHORT            : //79 int element in struct/union
      //case S_USHORT           : //80 char, unsigned char/int elment
      //case S_LONG             : //81 long element in struct/union
      //case S_ULONG            : //82 unsigned long in struct/union
           // 
           // In this function, the type has already add to symbol server
           // 
           if ( FALSE == GetStructType(nWhich, nType, wType) ) {
               wType = BI_UNKNOWN;
           }    
           else {
           
           }
           break;        

///////
// 
// Array
//
///////
      case BYTE_ARRAY         : //12 char/int array. eg. int iArray[10]
      case U_BYTE_ARRAY       : //13 char, unsigned char/int array
      case WORD_ARRAY         : //14 long array
      case U_WORD_ARRAY       : //15 usigned long array
           if ( FALSE == GetArrayType(nWhich, nType, wType) ) {
               wType = BI_UNKNOWN;
           }    
           else {
           
           }
           break;               
////////
//
// Function type
//
////////           
      case FUNC_VOID_NONE     : //16 void func(void) or void func()
      case FUNC_VOID_BYTE     : //17 void func(int) or void func(char)
      case FUNC_VOID_TWOBYTE  : //18 two parameter: void func(int, int)

      case FUNC_INT_NONE      : //21 int func(void) or int func()
      case FUNC_INT_BYTE      : //22 int func(int) or int func(char)
      case FUNC_INT_TWOBYTE   : //23 two parameter: int func(int, int)
      
      case FUNC_LONG_NONE     : //26 long func(void) or int func()
      case FUNC_LONG_BYTE     : //27 long func(int) or int func(char)
      case FUNC_LONG_TWOBYTE  : //28 two parameter: long func(int, int)
           wType = WORD(256+nType-16);
           break;
           
      case FUNC_VOID_LONG     : //19 void func(long):not support
      case FUNC_VOID_UNDEF    : //20 ????
      case FUNC_INT_LONG      : //24 int func(long):not support
      case FUNC_INT_UNDEF     : //25 ????
      case FUNC_LONG_LONG     : //29 long func(long):not support
      case FUNC_LONG_UNDEF    : //30
           wType = BI_UNKNOWN;
           break;

             
      //case CONSTANT           : //47 eg. #define; const int; enum element

             
///////
//
// Can not supprot
//
///////
      //case C_POINTER          : //6 int/long pointer
      //case C_UPOINTER         : //7 char, usigned char/int pointer
      //case TABLE              : //8
      //case M_BYTE             : //9
      //case M_INDEX            : //11
      //case PFUN_VOID_NONE     : //31
      //case PFUN_VOID_BYTE     : //32
      //case PFUN_VOID_TWOBYTE  : //33
      //case PFUN_VOID_LONG     : //34
      //case PFUN_VOID_UNDEF    : //35
      //case PFUN_INT_NONE      : //36
      //case PFUN_INT_BYTE      : //37
      //case PFUN_INT_TWOBYTE   : //38
      //case PFUN_INT_LONG      : //39
      //case PFUN_INT_UNDEF     : //40
      //case PFUN_LONG_NONE     : //41
      //case PFUN_LONG_BYTE     : //42
      //case PFUN_LONG_TWOBYTE  : //43
      //case PFUN_LONG_LONG     : //44
      //case PFUN_LONG_UNDEF    : //45
      //case BAD_UND            : //48
      //case BR_UND             : //49
      //case UPPER_UND          : //50
      //case BYTE_UND           : //51
      //case ADD_UND            : //52
      //case M_KEYWORD          : //53
      //case ADD_MI_UND         : //54
      //case VECTOR             : //55
      //case ENDIF              : //60
      //case EXUNDEF            : //61
      //case MACRO_S            : //62
      //case MACRO_A            : //63
      //case MACRO_C            : //64
      //case C_KEYWORD          : //65
      //case uVOID              : //66
      //case C_ENUM             : //67 typedef of enum. eg. enum ENUM,
      //case C_TYPEDEF1         : //68
      //case C_UTYPEDEF1        : //69
      //case C_TYPEDEF2         : //70
      //case C_UTYPEDEF2        : //71
      //case CP_TYPEDEF1        : //72
      //case CP_UTYPEDEF1       : //73
      //case CP_TYPEDEF2        : //74
      //case CP_UTYPEDEF2       : //75
      //case L_CONST            : //78
      //case SA_SHORT           : //83
      //case SA_USHORT          : //84
      //case SA_LONG            : //85
      //case SA_ULONG           : //86
      //case SP_SHORT           : //87
      //case SP_USHORT          : //88
      //case SP_LONG            : //89
      //case SP_ULONG           : //90
      //case FIXEDPOINTER       : //91
      //case POINTERFUNCTION    : //92
      //case CC_REG             : //93
      //case PTRF_VOID_NONE     : //94
      //case PTRF_VOID_BYTE     : //95
      //case PTRF_VOID_TWOBYTE  : //96
      //case PTRF_VOID_LONG     : //97
      //case PTRF_VOID_UNDEF    : //98
      //case PTRF_INT_NONE      : //99
      //case PTRF_INT_BYTE      : //100
      //case PTRF_INT_TWOBYTE   : //101
      //case PTRF_INT_LONG      : //102
      //case PTRF_INT_UNDEF     : //103
      //case PTRF_LONG_NONE     : //104
      //case PTRF_LONG_BYTE     : //105
      //case PTRF_LONG_TWOBYTE  : //106
      //case PTRF_LONG_LONG     : //107
      //case PTRF_LONG_UNDEF    : //108
      //case PFAR_VOID_NONE     : //109
      //case PFAR_VOID_BYTE     : //110
      //case PFAR_VOID_TWOBYTE  : //111
      //case PFAR_VOID_LONG     : //112
      //case PFAR_VOID_UNDEF    : //113
      //case PFAR_INT_NONE      : //114
      //case PFAR_INT_BYTE      : //115
      //case PFAR_INT_TWOBYTE   : //116
      //case PFAR_INT_LONG      : //117
      //case PFAR_INT_UNDEF     : //118
      //case PFAR_LONG_NONE     : //119
      //case PFAR_LONG_BYTE     : //120
      //case PFAR_LONG_TWOBYTE  : //121
      //case PFAR_LONG_LONG     : //122
      //case PFAR_LONG_UNDEF    : //123
      //case FWDLIT             : //124
      //case PFUNC              : //125
      //case MGOTO              : //126
      //case MCGOTO             : //127
      //case MCGOTO2            : //128
      //case MCGOTO3            : //129
      //case MCGOTO4            : //130
      //case MCGOTO74           : //131
      //case MCGOTO17           : //132
      //case MCCALL17           : //133
      //case MCALL              : //134
      //case MC_CALL            : //135
      //case RES_WORD           : //136
      //case LOCAL              : //137
      //case PICUNKNOWN         : //138
      //case VARLABEL           : //139
      //case EXTERN             : //140
      //case GLOBAL             : //141
      //case SEGMENT            : //142
      //case BANKADDR           : //143
      //case BIT_0              : //145
      //case BIT_1              : //146
      //case BIT_2              : //147
      //case BIT_3              : //148
      //case BIT_4              : //149
      //case BIT_5              : //150
      //case BIT_6              : //151
      //case BIT_7              : //152
      
      case M_BOOLEAN          : //10
           //////
           //
           // bit field
           //
           //////
           // Add bit field type
           //////
           
           if ( FALSE == GetBitfieldType(wType) ) {
               wType = BI_UNKNOWN;
           }    
           else {
           
           }
                       
           break;
                  
      default:
         wType = BI_UNKNOWN;
         typeIndex = (TYPE_INDEX)wType;
         return FALSE;
   }

   typeIndex = (TYPE_INDEX)wType;
   
   return TRUE;
}

/****************************************************************************
**
**  ConvertGlobleType
**
**  Description:
**     Convert the types from PIC file information to the types in symbol
**    server. (Define in SYMBLVR.H)
**
**  Parameters:
**     input:
**        int nWhich                -- the variable no.
**        int nType                 -- the variable type in PIC file
**        TYPE_INDEX & typeIndex    -- the type index in symbol server
**
**     output:
**        BOOL    --    TRUE     may add to symbol server
**                      FALSE    may lost.
**
*****************************************************************************/

BOOL
CPicLoader :: ConvertGlobleType(int nWhich, int nType, TYPE_INDEX& typeIndex)
{  
   WORD wType;
   
   switch( nType ) {
///////
//
// Register
//
///////
      case A_REG              : //0 register ???
      case ADDRESS            : // 46        address lable 
           // 
           // Address lable
           // 
           wType = BI_UNKNOWN;
           break;
                            
      case X_REG              : //1 register ???
           // 
           // Data register
           //
           wType = BI_UNKNOWN;
           break;
            
      //case PORT_W             : //56 port_w   register
      //case PORT_R             : //67 port_r   register
      //case PORT_RW            : //58 port_rw  register
      //case PORT_RMW           : //59 port_rmw register

////////
// 
// Building type
//
////////
      case C_LONG             : //3 long variable
           wType = BI_S32_LONG;
           break;

      case C_SHORT            : //2 int variable
           wType = BI_S16_SHORT;
           break;

/////////
//
// Building type or pointer
//
/////////
      case C_ULONG            : //5 unsigned long variable
           if ( IsGloblePointer(nWhich, nType) ) {
              ////////
              //
              // Convert pointer
              //
              ////////            
              if ( FALSE == GetPointerType(nType, wType) ) {
                  wType = BI_UNKNOWN;
              }    
              else {
              
              }
           }
           else
              wType = BI_S32_LONG;
              
           break;

      case C_USHORT           : //4 char, unsigned char/int variable
           if ( IsGloblePointer(nWhich, nType) ) {
              ////////
              //
              // Convert pointer
              //
              ////////            
              
              if ( FALSE == GetPointerType(nType, wType) ) {
                  wType = BI_UNKNOWN;
              }    
              else {
              
              }
           }
           else
             wType = BI_S16_USHORT;          
           break;
           
///////
//
// Struct and union process
//
///////
      //case C_STRUCT           : //76 struct/union typedef
      case I_STRUCT           : //77 variable of struct/union
      //case S_SHORT            : //79 int element in struct/union
      //case S_USHORT           : //80 char, unsigned char/int elment
      //case S_LONG             : //81 long element in struct/union
      //case S_ULONG            : //82 unsigned long in struct/union
           // 
           // In this function, the type has already add to symbol server
           // 
           if ( FALSE == GetGlobleStructType(nWhich, nType, wType) ) {
               wType = BI_UNKNOWN;
           }    
           else {
           
           }
           break;        

///////
// 
// Array
//
///////
      case BYTE_ARRAY         : //12 char/int array. eg. int iArray[10]
      case U_BYTE_ARRAY       : //13 char, unsigned char/int array
      case WORD_ARRAY         : //14 long array
      case U_WORD_ARRAY       : //15 usigned long array
           if ( FALSE == GetGlobleArrayType(nWhich, nType, wType) ) {
               wType = BI_UNKNOWN;
           }    
           else {
           
           }
           break;               
////////
//
// Function type
//
////////           
      case FUNC_VOID_NONE     : //16 void func(void) or void func()
      case FUNC_VOID_BYTE     : //17 void func(int) or void func(char)
      case FUNC_VOID_TWOBYTE  : //18 two parameter: void func(int, int)

      case FUNC_INT_NONE      : //21 int func(void) or int func()
      case FUNC_INT_BYTE      : //22 int func(int) or int func(char)
      case FUNC_INT_TWOBYTE   : //23 two parameter: int func(int, int)
      
      case FUNC_LONG_NONE     : //26 long func(void) or int func()
      case FUNC_LONG_BYTE     : //27 long func(int) or int func(char)
      case FUNC_LONG_TWOBYTE  : //28 two parameter: long func(int, int)
           wType = WORD(256+nType-16);
           break;
           
      case FUNC_VOID_LONG     : //19 void func(long):not support
      case FUNC_VOID_UNDEF    : //20 ????
      case FUNC_INT_LONG      : //24 int func(long):not support
      case FUNC_INT_UNDEF     : //25 ????
      case FUNC_LONG_LONG     : //29 long func(long):not support
      case FUNC_LONG_UNDEF    : //30
           wType = BI_UNKNOWN;
           break;

      case M_BOOLEAN          : //10
           //////
           //
           // bit field
           //
           //////
           // Add bit field type
           //////
           
           if ( FALSE == GetBitfieldType(wType) ) {
               wType = BI_UNKNOWN;
           }    
           else {
           
           }
                       
           break;
                  
      default:
         wType = BI_UNKNOWN;
         typeIndex = (TYPE_INDEX)wType;
         return FALSE;
   }

   typeIndex = (TYPE_INDEX)wType;
   
   return TRUE;
}

/****************************************************************************
**
**  StartAddSymbol & EndAddSymbol
**
**  Description:
**     Do the first routin in link with symbol that is SymAddLoadStart();
**     Do the last action in link with symbol that is SymAddLoadClose();
**
**  Parameters:
**     input:
**        none
**     output:
**        RETCODE
**
*****************************************************************************/

RETCODE
CPicLoader :: StartAddSymbol()
{  
   RETCODE retCode;
   m_time.year    = U16(m_nStatus.m_ctime.GetYear());
   m_time.month   = U8(m_nStatus.m_ctime.GetMonth());
   m_time.day     = U8(m_nStatus.m_ctime.GetDay());
   m_time.hour    = U8(m_nStatus.m_ctime.GetHour());
   m_time.minute  = U8(m_nStatus.m_ctime.GetMinute());
   m_time.second  = U8(m_nStatus.m_ctime.GetSecond());
   
   CString filename = m_strCodFileName;   
   retCode = SymAddLoadStart(filename.GetBuffer(filename.GetLength()) ,
                             FALSE,
                             &m_time );

   return retCode;   
}

void
CPicLoader :: EndAddSymbol()
{  
   SymAddLoadEnd();
}

/****************************************************************************
**
**  SymIsFunc
**
**  Description:
**    Distinguish the symbol is function or common variable
**    For load global symbol.
**
**  Parameters:
**     input:
**        PICBYTE    nSymbolType    --    the symbol type
**
**     output:
**        BOOL    TRUE        --    symbol type is function
**                FALSE       --    symbol type is not function
**
*****************************************************************************/

BOOL
CPicLoader :: SymIsFunc(PICBYTE  nSymbolType)
{
   tagSymbolTypes type = (tagSymbolTypes)nSymbolType;
   switch (type) {
      case  FUNC_VOID_NONE     :
      case  FUNC_VOID_BYTE     :
      case  FUNC_VOID_TWOBYTE  :
      case  FUNC_VOID_LONG     :
      case  FUNC_VOID_UNDEF    :
      case  FUNC_INT_NONE      :
      case  FUNC_INT_BYTE      :
      case  FUNC_INT_TWOBYTE   :
      case  FUNC_INT_LONG      :
      case  FUNC_INT_UNDEF     :
      case  FUNC_LONG_NONE     :
      case  FUNC_LONG_BYTE     :
      case  FUNC_LONG_TWOBYTE  :
      case  FUNC_LONG_LONG     :
      case  FUNC_LONG_UNDEF    :
      case  PFUN_VOID_NONE     :         //31
      case  PFUN_VOID_BYTE     :         //32
      case  PFUN_VOID_TWOBYTE  :         //33
      case  PFUN_VOID_LONG     :         //34
      case  PFUN_VOID_UNDEF    :         //35
      case  PFUN_INT_NONE      :         //36
      case  PFUN_INT_BYTE      :         //37
      case  PFUN_INT_TWOBYTE   :         //38
      case  PFUN_INT_LONG      :         //39
      case  PFUN_INT_UNDEF     :         //40
      case  PFUN_LONG_NONE     :         //41
      case  PFUN_LONG_BYTE     :         //42
      case  PFUN_LONG_TWOBYTE  :         //43
      case  PFUN_LONG_LONG     :         //44
      case  PFUN_LONG_UNDEF    :         //45
            return TRUE;
            
      case  CONSTANT:
      case  uVOID:
      case  VECTOR:
      //case  ADDRESS:                      // Add for label
            return TRUE;
            
      default:
            return FALSE;
   }
   
   return FALSE;
}

/****************************************************************************
**
**  LoadGlobleVariable
**
**  Description:
**      Store the globle variable to symbol server.
**    Because I can not know the variable is belong to which module or it 
**    is a globle variable in all modules, I treat all variables as globle
**    variable for all modules.   
**
**  Parameters:
**     input:
**        none
**     output:
**        RETCODE
**
*****************************************************************************/

BOOL
CPicLoader :: LoadGlobleVariable()
{
   char varName[MAX_SYMNAME_LENGTH];
   TYPE_INDEX  typeIndex;
   ADDRESS_TYPE   varAddr;
   int iCount = 0;
   RETCODE retCode;
   BOOL  bConvOk = FALSE;
   int   nGVarNumber = m_nSSymBlockCount * 32;
         
   do {
      nGLoaded++;
      if ( nGLoaded > 60 ) nGLoaded = 60;
      
      if ( (TestKey(VK_ESCAPE)) == 1 ) { 
          m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
          return( FALSE );
      }                  
      if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
          if ( IsLoadCanceled() ) {
              m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
              return( FALSE );
          }                  
          TestMessage();
      }
      if ( SymIsFunc(m_symBlock[iCount]->SymbolType) ) {
         //
         // Not add to symbol server 
         //
      }      
      else {   
         bConvOk = ConvertGlobleType(iCount, m_symBlock[iCount]->SymbolType, typeIndex);
         if ( TRUE == bConvOk ) {
            if ( BI_UNKNOWN == typeIndex ) {
               if  ( (ADDRESS == m_symBlock[iCount]->SymbolType) ||
                     (A_REG == m_symBlock[iCount]->SymbolType) ) {
                  ////////
                  //
                  // Add lable
                  //
                  ////////                     
                  varAddr.addr = OFFSET_ADDR_TYPE(m_symBlock[iCount]->SymbolValue);
                  strcpy(varName, m_symBlock[iCount]->SymbolName);
                  retCode = SymAddLabelPublic(varName, varAddr.addr);
                  if (GOOD != retCode)
                     return FALSE;
               }
               else 
               if ( X_REG == m_symBlock[iCount]->SymbolType ) {
                  varAddr.segType = SEG_DATA;
                  varAddr.addr = OFFSET_ADDR_TYPE(m_symBlock[iCount]->SymbolValue);
                  strcpy(varName, m_symBlock[iCount]->SymbolName);
                  //if ( 0 != varAddr.addr ) {
                     retCode = SymAddVarPublic(LPSTR(varName), 
                                               typeIndex, 
                                               varAddr);
                     if (GOOD != retCode)
                        return FALSE;
                  //}               
               }
            }
            else {
               varAddr.segType = SEG_DATA;
               varAddr.addr = OFFSET_ADDR_TYPE(m_symBlock[iCount]->SymbolValue);
               strcpy(varName, m_symBlock[iCount]->SymbolName);
               //if ( 0 != varAddr.addr ) {
                  retCode = SymAddVarPublic(LPSTR(varName), 
                                            typeIndex, 
                                            varAddr);
                  if (GOOD != retCode)
                     return FALSE;
               //}               
            }               
         }            
      }            
      iCount ++;                
   } while ( (iCount < nGVarNumber) && 
             (m_symBlock[iCount]->NameLen != 0) );
   
   return TRUE;
}

/****************************************************************************
**
**  StartAddModule & EndAddModule
**
**  Description:
**     Add module to symbol server. First do the action of 
**    SymAddModuleCreate();
**     Close module. After the module have linked to symbol server, do the 
**    action of SymAddModuleClose()
**
**  Parameters:
**     input:
**        none
**     output:
**        RETCODE
**
*****************************************************************************/

RETCODE
CPicLoader :: StartAddModule(int nModule)
{
   char strModuleName[63]; 
   RETCODE  retCode;
   SYM_DESCRIPTOR moduleDesc;
      
   ModuleNodeInit();                       
   m_modNode.offset = 0 ;
   m_modNode.time.day = U8(m_nStatus.m_ctime.GetDay());
   m_modNode.time.hour = U8(m_nStatus.m_ctime.GetHour());
   
   CString strName1 = m_moduleBlock[nModule]->modulename;
   CString strName2;
   int pos = strName1.ReverseFind('\\');
   if (pos != -1) {     // fine '.', filename have extend
      strName2 = strName1.Right(strName1.GetLength()-pos-1);
      strName2.MakeUpper();
   }
   else {     // not find '\'
      strName2 = strName1;
   }

   strcpy( strModuleName, strName2.GetBuffer(strName2.GetLength()) );
   for ( UINT i = 0; i < strlen(strModuleName); i ++ ) {
      if (strModuleName[i] == '.')
         strModuleName[i] = '\0';
   }
   
   m_modNode.codeaddr.segType = SEG_CODE;
   m_modNode.codeaddr.startAddr = 0;
   U32 t = (0xff*m_nCodeBlock)||0xF;
   m_modNode.codeaddr.endAddr = dwpMax;
   //(0xff*m_nCodeBlock)||0xF;   
   
   retCode = SymAddModuleCreate( (LPSTR)strModuleName,       
                                 &m_modNode.time ,
                                 &m_modNode.codeaddr ,
                                 m_modNode.offset ,
                                 (BOOLEAN) m_nOnDemand ,
                                 0,       // type delta     ????
                                 &moduleDesc );
   if ( GOOD == retCode )
      curModDesc = moduleDesc;
                                 
   return retCode;                                 
}

RETCODE
CPicLoader :: EndAddModule()
{
   RETCODE  retCode;
   retCode = SymAddModuleClose(0);
   return retCode;
}

/****************************************************************************
**
**  IsStatement
**
**  Description:
**    Distinguish the current line is statement or not
**
**  Parameters:
**     input:
**        const int flag      the line information flag
**
**     output:
**        BOOL       --    TRUE     is statememt
**                         FALSE    is not
**
*****************************************************************************/

BOOL
CPicLoader::IsStatement(const int flag)
{
   if (flag == 0x00)          // One source line, the other b_code
      return FALSE;
   if (flag == 0x90)          // Function head
      return FALSE;
      
   if (flag == 0x20)          // Interrupt head
      return TRUE;
   if (flag == 0x80)          // Source line
      return TRUE;      
   if (flag == 0x40)          // Function start
      return TRUE;
   if (flag == 0xc0)          // main() start
      return TRUE;      
   
   return FALSE;
}

/****************************************************************************
**
**  GetLineInfor
**
**  Description:
**    Link line information to symbol server.
**     The second parameter(col) in SymAddLinenum() must set to '1' because
**    PIC loader can not get line coloumn information.
**
**  Parameters:
**     input:
**        none
**     output:
**        BOOL       --    TRUE     success
**                         FALSE    failure
**
*****************************************************************************/

BOOL
CPicLoader :: SetLineInfor()
{
   RETCODE        retCode;
   LINENUM_TYPE   srcState;
   ADDRESS_TYPE   addrState;    
   BOOL           bool = FALSE;
   int            linenum = 0;
   int            iCount = 0;
   
   do {
      // 
      // This action filter the lib moudle, header file moudle.
      // Only the *.c source
      // Not support the case of '#include *.c' 
      //
      bool = FALSE;      
      for ( int xi = 0; xi < 20; xi ++ ) {
         if ( ( m_lineInfor[iCount]->SourceNum ) == m_nIndex[xi] ) {
            bool = TRUE;
            goto OUT;
         }
      }
            
      OUT:   
      if ( bool ) {
         if (IsStatement(m_lineInfor[iCount]->Flag)){
            if ( m_modNode.linecnt == 0 ) {
               retCode = SymAddLinenumStart(curModDesc);
               if ( retCode != GOOD ) {
                  m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                  return( FALSE );
               }
            }
         
            TRACE("Line number is %d\r\n", m_lineInfor[iCount]->SourceLine);
            TRACE("Address is 0x%X\r\n", m_lineInfor[iCount]->CodeAddress);
            
            srcState = LINENUM_TYPE(m_lineInfor[iCount]->SourceLine);
            addrState.segType = ( SEGMENTTYPE ) SEG_CODE;
            addrState.addr = OFFSET_ADDR_TYPE( m_lineInfor[iCount]->CodeAddress );
            retCode = SymAddLinenum( srcState, 1, addrState.addr );
            if ( retCode != GOOD ) {
               m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
               return( FALSE );
            }
            
            linenum ++;
            m_modNode.linecnt = linenum;
            bool = FALSE;
         }            
      }           
      iCount ++;                
   } while (!(m_lineInfor[iCount]-> SourceLine == 0 &&
              m_lineInfor[iCount]-> SourceNum == 0 &&
              m_lineInfor[iCount]-> CodeAddress == 0) );
   
   m_modNode.linecnt = linenum;
         
   if ( m_modNode.linecnt > 0 ) {
      retCode = SymAddLinenumEnd();
      if ( retCode != GOOD ) {
          m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
          return( FALSE );
      }
   }
   
   return TRUE;
}

/****************************************************************************
**
**  GetBlockInfor
**
**  Description:
**    Link block, function and local variable information to symbol server.
**
**  Parameters:
**     input:
**        none
**     output:
**        BOOL       --    TRUE     success
**                         FALSE    failure
**
*****************************************************************************/

BOOL
CPicLoader :: GetBlockInfor()
{
   char funcName[MAX_SYMNAME_LENGTH];
   char varName[MAX_SYMNAME_LENGTH];
   
   FUNC_CLASS funcClass;
   U32 stacksize = 0;          
   ADDR_RANGE_TYPE codeaddr; // function or block code range                
   TYPE_INDEX typeIndex = 0;   // function return type
   RETCODE  retCode;
   
   VAR_STORAGE_CLASS varStorage;
   VAR_REGISTER_CLASS registerClass;
   BOOLEAN isConst = 0, isValid = 1;
   ADD_VAR_ADDR_UNION addr;
   SYM_DESCRIPTOR symDesc;
   CSymStack   blockStack;
   
   int  nCloseIndex = 0;
      
   int nLocalMember = -1;
   int jCount = 0;
   int bTypeConv = FALSE;

   blockStack.DeleteStack();
      
   int nOld = 0;
   int nOldMember = 0;

   struct tagAddrRange {
         LONG  lStartAddr;
         LONG  lEndAddr;
   } *curBlock, *lastBlock;
   void *pVoid;
   
   //
   // Calculate the total local variable count
   //
   do {
      nLocalMember ++;
   } while(strcmp(m_localVars[nLocalMember]->VarSymbol.SymbolName, "main"));

   // 
   // If main function have parameter, add parameter number to nLoacalMember
   //
   if ((FUNC_VOID_BYTE == m_localVars[nLocalMember]->VarSymbol.SymbolType) ||
       (FUNC_INT_BYTE == m_localVars[nLocalMember]->VarSymbol.SymbolType) ||    
       (FUNC_LONG_BYTE == m_localVars[nLocalMember]->VarSymbol.SymbolType) )
       nLocalMember ++;      // main have One parameter
   if ((FUNC_VOID_TWOBYTE == m_localVars[nLocalMember]->VarSymbol.SymbolType) ||
       (FUNC_INT_TWOBYTE == m_localVars[nLocalMember]->VarSymbol.SymbolType) ||    
       (FUNC_LONG_TWOBYTE == m_localVars[nLocalMember]->VarSymbol.SymbolType) )
       nLocalMember += 2;    // main have two parameter
   
   //
   // goto to the first block, always is 'main'
   //
   if ( nLocalMember <= 0 )
      return FALSE;
   else {
      jCount = nLocalMember;
      while( strcmp( m_localVars[jCount]->VarSymbol.SymbolName,
                     "$$BLOCK" ) )
         jCount --;
   }
   
   //
   // Get all block & function information
   //
   do {
      int xCnt = 0;
         
      codeaddr.segType = (SEGMENTTYPE)SEG_CODE;
      codeaddr.startAddr = OFFSET_ADDR_TYPE(m_localVars[jCount]->lBlockStartAddress);
      codeaddr.startAddr /= 2;
      codeaddr.endAddr = OFFSET_ADDR_TYPE(m_localVars[jCount]->lBlockEndAddress);
      codeaddr.endAddr /= 2;
      
      if (LocalVarIsFunction(m_localVars[jCount+1]->VarSymbol.SymbolType)) {
         //
         // The block is Function
         //
         strcpy(funcName,        // function name   
                m_localVars[jCount+1]->VarSymbol.SymbolName);   
         funcClass = FUNC_GLOBAL;// function
         bTypeConv = ConvertType(jCount+1,
                                 m_localVars[jCount+1]->VarSymbol.SymbolType,
                                 typeIndex);      //@@@@@@
         if ( bTypeConv == TRUE ) {
            retCode = SymAddFuncCreate(     
                              funcName,      // Func name, NULL if it is a block
                              funcClass ,    // FUNC_GLOBAL -- Function
                                             // FUNC_LOCAL  -- Block
                              stacksize ,    // Stack size, in pic, it always 0
                              &codeaddr ,    // Code range   
                              typeIndex );   // the index of the function return 
                                             // type. It is always 0 if it is a 
                                             // block
         }
                                                      
         if (GOOD != retCode)
            return FALSE;
         //////
         //
         // Add symbol in this func(parameters)
         //
         /////            
         for ( xCnt = jCount+2; xCnt <= nLocalMember; xCnt ++ ) {
             strcpy(varName, m_localVars[xCnt]->VarSymbol.SymbolName);
             varStorage = STATIC_VAR_CLASS ;
             registerClass = NOT_REG;
             addr.addr.addr = OFFSET_ADDR_TYPE(m_localVars[xCnt]->VarSymbol.SymbolValue);
             addr.addr.segType = SEG_DATA;
             bTypeConv = ConvertType(xCnt,
                                     m_localVars[xCnt]->VarSymbol.SymbolType, 
                                     typeIndex);
             if ( TRUE == bTypeConv ) {
                retCode = SymAddVar((LPSTR)varName,
                                    typeIndex,
                                    varStorage,
                                    registerClass,
                                    &addr,
                                    isConst,
                                    isValid,
                                    &symDesc);
             }                                    
                                    
             if ( retCode != GOOD )
                return FALSE;
         }
         
         ///////////
         //
         // Add block
         //
         ///////////
         nLocalMember = jCount-1;         
         jCount = nLocalMember;
         if ( jCount <= 0 ) {
         
         }
         else {
            while( strcmp( m_localVars[jCount]->VarSymbol.SymbolName,
                           "$$BLOCK" ) )
               jCount --;
            
            //
            // Add all block infor
            //
            // while--y
            while (FALSE == LocalVarIsFunction(m_localVars[jCount+1]->VarSymbol.SymbolType)) {
               codeaddr.segType = (SEGMENTTYPE)SEG_CODE;
               codeaddr.startAddr = OFFSET_ADDR_TYPE(m_localVars[jCount]->lBlockStartAddress);
               codeaddr.startAddr /= 2;
               codeaddr.endAddr = OFFSET_ADDR_TYPE(m_localVars[jCount]->lBlockEndAddress);
               codeaddr.endAddr /= 2;
            
               if ( codeaddr.startAddr < codeaddr.endAddr ) {
                  curBlock = new tagAddrRange;
               
                  curBlock->lStartAddr = m_localVars[jCount]->lBlockStartAddress;
                  curBlock->lStartAddr /= 2;
                  curBlock->lEndAddr = m_localVars[jCount]->lBlockEndAddress;
                  curBlock->lEndAddr /= 2;
                  //
                  // Push current block
                  blockStack.Push(curBlock);
                              
                  //
                  // The block is Block
                  //
                  strcpy( funcName, "" ); // block name is ""   
                  funcClass = FUNC_LOCAL; // block
                  typeIndex = 0;          // block type always 0         
                  retCode = SymAddFuncCreate(     
                                    funcName,      // Func name, NULL if it is a block
                                    funcClass ,    // FUNC_GLOBAL -- Function
                                                   // FUNC_LOCAL  -- Block
                                    stacksize ,    // Stack size, in pic, it always 0
                                    &codeaddr ,    // Code range   
                                    typeIndex );   // the index of the function return 
                                                   // type. It is always 0 if it is a 
                                                   // block
                  if (GOOD != retCode)
                     return FALSE;
                        
                  //////
                  //
                  // Add symbol in this block
                  //
                  /////            
                  for ( xCnt = jCount+1; xCnt <= nLocalMember; xCnt ++ ) {
                      bTypeConv = ConvertType(xCnt,
                                              m_localVars[xCnt]->VarSymbol.SymbolType, 
                                              typeIndex);
                      if ( TRUE == bTypeConv ) {
                        if ( BI_UNKNOWN == typeIndex ) {
                           if ( (ADDRESS == m_localVars[xCnt]->VarSymbol.SymbolType) ||
                                (A_REG == m_localVars[xCnt]->VarSymbol.SymbolType) ) {
                              ////////
                              //
                              // Add lable
                              //
                              ////////                     
                              addr.addr.addr = OFFSET_ADDR_TYPE(m_localVars[xCnt]->VarSymbol.SymbolValue);
                              strcpy(varName, m_localVars[xCnt]->VarSymbol.SymbolName);
                              retCode = SymAddLabelPublic(varName, addr.addr.addr);
                              if (GOOD != retCode)
                                 return FALSE;
                           }
                           else 
                           if ( X_REG == m_localVars[xCnt]->VarSymbol.SymbolType ) {
                              //////////////
                              //
                              // Add register data
                              //
                              //////////////
                              varStorage = STATIC_VAR_CLASS ;
                              registerClass = NOT_REG;
                              addr.addr.addr = OFFSET_ADDR_TYPE(m_localVars[xCnt]->VarSymbol.SymbolValue);
                              addr.addr.segType = SEG_DATA;
                              strcpy(varName, m_localVars[xCnt]->VarSymbol.SymbolName);
                              retCode = SymAddVar((LPSTR)varName,
                                                  typeIndex,
                                                  varStorage,
                                                  registerClass,
                                                  &addr,
                                                  isConst,
                                                  isValid,
                                                  &symDesc);
                              if (GOOD != retCode)
                                 return FALSE;
                           }
                        }
                        else {
                            strcpy(varName, m_localVars[xCnt]->VarSymbol.SymbolName);
                            varStorage = STATIC_VAR_CLASS ;
                            registerClass = NOT_REG;
                            addr.addr.addr = OFFSET_ADDR_TYPE(m_localVars[xCnt]->VarSymbol.SymbolValue);
                            addr.addr.segType = SEG_DATA;
                            retCode = SymAddVar((LPSTR)varName,
                                                typeIndex,
                                                varStorage,
                                                registerClass,
                                                &addr,
                                                isConst,
                                                isValid,
                                                &symDesc);
                        }                                              
                      }                                    
                                             
                      if ( retCode != GOOD )
                         return FALSE;
                  }
               }     // dustinguish the start addr less then the end addr   
                  
               nLocalMember = jCount-1;         
               jCount = nLocalMember;
               if (jCount <= 0) {
                  break;      
               }
               else {   // else--xx
                  while( strcmp( m_localVars[jCount]->VarSymbol.SymbolName,
                                 "$$BLOCK" ) )
                     jCount --;
                     
                  curBlock->lStartAddr = m_localVars[jCount]->lBlockStartAddress;
                  curBlock->lStartAddr /= 2;
                  curBlock->lEndAddr = m_localVars[jCount]->lBlockEndAddress;
                  curBlock->lEndAddr /= 2;
                  while( FAILURE == blockStack.IsEmpty() ) {   // while--x
                     blockStack.Pop(pVoid);
                     lastBlock = (tagAddrRange *)pVoid;
                                 
                     if ( (curBlock->lStartAddr >= lastBlock->lStartAddr) &&
                          (curBlock->lEndAddr <= lastBlock->lEndAddr) ) {
                        //  
                        // the new block is in the last block
                        //
                        blockStack.Push(lastBlock);
                        break;                     
                     }
                     else {
                        retCode = SymAddFuncClose();        // close block
                        if (lastBlock) delete lastBlock;
                        if (GOOD != retCode)
                           return FALSE;
                     }
                  }         // end of while--x
               }     // end of else--xx
            }     // end of while--y
            
            while( FAILURE == blockStack.IsEmpty() ) {
                blockStack.Pop(pVoid);
                lastBlock = (tagAddrRange *)pVoid;
                retCode = SymAddFuncClose();        // close block
                if (lastBlock) delete lastBlock;
                if (GOOD != retCode)
                    return FALSE;
            }
         }
                              
         retCode = SymAddFuncClose();        // Close function
         if (GOOD != retCode)
            return FALSE;
      }      
   } while ( nLocalMember > 0 );
   
   return TRUE;      
}

/****************************************************************************
**
**  LocalVarIsFunction
**
**  Description:
**    Distinguish which type will not add to symbol server.
**
**  Parameters:
**     input:
**        int        --    nType    type index;
**     output:
**        BOOL       --    TRUE     should not add
**                         FALSE    may add
**
*****************************************************************************/

BOOL
CPicLoader :: LocalVarIsFunction(const int nType)
{
   switch ( nType ) {
      case  FUNC_VOID_NONE     :         //16 void func(void) or void func()
      case  FUNC_VOID_BYTE     :         //17 void func(int) or void func(char)
      case  FUNC_VOID_TWOBYTE  :         //18 two parameter: void func(int, int)
      case  FUNC_VOID_LONG     :         //19 void func(long):not support
      case  FUNC_VOID_UNDEF    :         //20 ????
      case  FUNC_INT_NONE      :         //21 int func(void) or int func()
      case  FUNC_INT_BYTE      :         //22 int func(int) or int func(char)
      case  FUNC_INT_TWOBYTE   :         //23 two parameter: int func(int, int)
      case  FUNC_INT_LONG      :         //24 int func(long):not support
      case  FUNC_INT_UNDEF     :         //25 ????
      case  FUNC_LONG_NONE     :         //26 long func(void) or int func()
      case  FUNC_LONG_BYTE     :         //27 long func(int) or int func(char)
      case  FUNC_LONG_TWOBYTE  :         //28 two parameter: long func(int, int)
      case  FUNC_LONG_LONG     :         //29 long func(long):not support
      case  FUNC_LONG_UNDEF    :         //30
            return TRUE;
            
      default:
            return FALSE;
   }

   return FALSE;
}

/****************************************************************************
**
**  FillCode
**
**  Description:
**    Fill binary code to ICE program area
**    Call AbiFill(...);
**    Set the PC address value.
**
**  Parameters:
**     input:
**          none
**     output:
**          none
*****************************************************************************/

void
CPicLoader :: FillCode()
{
   ADDR  startAddr, endAddr;
   char  buffer[512];
   int err = 0;

   startAddr.addrType = 1;
   endAddr.addrType = 1;
   //uLoadBytes = 0;
   
   for ( int iCount = 0; iCount < 127; iCount ++ ) {
      if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
          m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
          return;
      }                  
      if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
          if ( IsLoadCanceled() ) {
              m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
              return;
          }                  
          TestMessage();
      }
   
      if ( m_dirBlock.Index[iCount] != 0 ) {
         memcpy(buffer, 
               m_chBuffer+(m_dirBlock.Index[iCount]-1)*512, 
               512);
         startAddr.addr = WORD(iCount*256);
         endAddr.addr = startAddr.addr+127;
         AbiFill(startAddr, endAddr, (WORD*)buffer, 128);
         uLoadBytes += 128; 
         startAddr.addr += 128;
         endAddr.addr = startAddr.addr+127;
         AbiFill(startAddr, endAddr, (WORD*)(buffer+256), 128);
         uLoadBytes += 128; 
      }
   } 

   //m_lPCAddr = (m_nCodeBlock*512-2)/2;        // Set pc address
   //m_startaddress = (U32)m_lPCAddr;
}

/****************************************************************************
**
**  DeleteContent
**
**  Description:
**      Delete the pointer alloced before, free the memory
**
**  Parameters:
**     input:
**          none
**     output:
**          none
**
*****************************************************************************/

void
CPicLoader :: DeleteContent()
{
   if (m_chBuffer != NULL) {
      delete []m_chBuffer;
      m_chBuffer = NULL;
   }
   
   if ( NULL != m_strFileName ) {
        delete []m_strFileName;
        m_strFileName = NULL;
   }    
        
   PICWORD iCount = 0;
   
   for ( iCount = 0; iCount < m_nSSymBlockCount; iCount ++ )
      if ( NULL != m_symbolPointer[iCount] ) {
         delete m_symbolPointer[iCount]; // Delete every symbol block pointer
         m_symbolPointer[iCount] = NULL;
      }        
   if ( m_symbolPointer != NULL ) {
      delete []m_symbolPointer;
      m_symbolPointer = NULL;
   }
   if ( m_symBlock != NULL ) {
      delete []m_symBlock;    
      m_symBlock = NULL;
   }    

   for ( iCount = 0; iCount < m_nNameBlockCount; iCount ++ )
      if ( NULL != m_namePointer[iCount] ) {
         delete m_namePointer[iCount];   // Delete every name block pointer
         m_namePointer[iCount] = NULL;
      }
   if ( m_namePointer != NULL ) {
      delete []m_namePointer;
      m_namePointer = NULL;
   }        
   if ( m_nameTab != NULL ) {
      delete []m_nameTab; 
      m_nameTab = NULL;
   }         

   for ( iCount = 0; iCount < m_nLineBlockCount; iCount ++ )
      if ( NULL != m_linePointer[iCount] ) {
         delete m_linePointer[iCount];   // Delete every name block pointer
         m_linePointer[iCount] = NULL;
      }         
   if ( m_linePointer != NULL ) {
      delete []m_linePointer;
      m_linePointer = NULL;
   }   
   if ( m_lineInfor != NULL ) {
      delete []m_lineInfor; 
      m_lineInfor = NULL;
   }
   
   for ( iCount = 0; iCount < (PICWORD)m_nVarsCount; iCount ++ )
      if ( NULL != m_localVars[iCount] ) {
         delete [](m_localVars[iCount]);
         m_localVars[iCount] = NULL;
      }            
   if ( m_localVars != NULL) {
      delete []m_localVars; 
      m_localVars = NULL;
   }
   
   if ( m_nModuleCount != 0 ) {
        if ( NULL != m_moduleBlock ) {
         delete []m_moduleBlock;
         m_moduleBlock = NULL;
        }
   }
      
   return;
}

/****************************************************************************
**
**  SetLoadFileInfo
**
**  Description:
**      Set the loaded file infor such as recent file
**
**  Parameters:
**     input:
**          char * str
**
**     output:
**          none
**
*****************************************************************************/

BOOL
CPicLoader :: SetLoadFileInfo(char * str)
{
   GetFileName((LPSTR)str, 0);

   CString cstrName;
    
   cstrName = m_lpFileRef;
   cstrName += m_lpFileName;   
   if ( m_lpFileRef ) delete m_lpFileRef;
   m_lpFileRef = new char [ cstrName.GetLength()+2 ];
   if ( m_lpFileRef == 0 ) return FALSE;
   strcpy(m_lpFileRef , cstrName);
   
   return TRUE;
}

void 
CPicLoader :: TestCancel()
{
   int err = 0;

   if ( (err = TestKey(VK_ESCAPE)) == 1 ) { 
       m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
       return;
   }                  
   if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
       if ( IsLoadCanceled() ) {
           m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
           return;
       }                  
       TestMessage();
   }
}

///////////////////////////(EOF of PLOADER.CPP)//////////////////////////

