/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/LDRSRV.CPP   1.13   13 Dec 1996 11:18:46   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/LDRSRV.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:46   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:46   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:04   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:00   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:48   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:12   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:00   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:14   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:48   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:16   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:32   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:40   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:18   ZJRD
** PIC/SLD Version 0.20
**
****************************************************************************/

/****************************************************************************
**
**  Name:  LDRSRV.CPP
**
**  Description:
**      Some foundamental function for Loader Server.
**
**  Status:  CODED
**
**    Rev 1.0   1 Sept. 1995 8:30:00am   Gates Hua, Jamoon Zhou
** Initial revision.
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"
//#include <ctype.h>
#include <io.h>
//#include <sys\timeb.h>

#include "symblsvr.h"
#include "ldr.h"                      
#include "abibase.h"
#include "uicom.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
unsigned char asc__h(unsigned char a);
unsigned char asc2hex(unsigned char a,unsigned char b);
                        

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern SYM_DESCRIPTOR curModDesc;
extern U32 uLoadBytes;
extern void ShlReshowLine(char * pch, int nLen);
extern STATUS AbiFill(ADDR addr1, ADDR addr2,WORD* pchBuff,UINT uPatternLen);

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
/***************************************************************************
*                                                                          *
*  asc__h - convert a ascii char to hex value                              *
*  parameter :                                                             *
*       a     ----     ascii char '0'-'F'                                  *
*  return value :                                                          *
*       value of a                                                         *
*                                                                          *
***************************************************************************/
unsigned char asc__h(unsigned char a)
{
    if ( (a>='0')&&(a<='9') ) a = (unsigned char)(a-'0');
    else if ( (a>='A')&&(a<='F') ) a = (unsigned char)(a-'A'+10);
    else if ( (a>='a')&&(a<='f') ) a = (unsigned char)(a-'a'+10);
    else a = 0;
    return( a );
}

/***************************************************************************
*                                                                          *
*  asc2hex - convert two ascii char to hex value                           *
*  parameter :                                                             *
*       a     ----     high half-byte char '0'-'F'                         *
*       b     ----     low  half-byte char '0'-'F'                         *
*  return value :                                                          *
*       value of ab                                                        *
*                                                                          *
***************************************************************************/
unsigned char asc2hex(unsigned char a,unsigned char b)
{
   unsigned char r;
   r = asc__h(a);
   r = (unsigned char) ((r << 4) | asc__h(b));
   return(r);
}
                        
/***************************************************************************
*                                                                          *
*  GetLpFileRef - Get load file reference string                           *
*  parameter :                                                             *
*       str  --  load file reference string ( output )                     *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::GetLpFileRef( CString& str )
{                                   
    if ( IsSymbolLoaded() != TRUE ) return -1;
    str = m_lpFileRef ;
    return GOOD;
}


/***************************************************************************
*                                                                          *
*  UngetOneByte - Get one byte from load buffer                            *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::UngetOneByte()
{                                        
    if ( GOOD != SeekLoadFile(-1L,1) ) return FAILURE;
    return GOOD;
}
    
/***************************************************************************
*                                                                          *
*  GetOneByte - Get one byte from load buffer                              *
*  parameter :                                                             *
*       ch  --  byte pointer ( output )                                    *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::GetOneByte(U8 *ch)
{                                   
    if (m_uBufPos < m_uBufSize) {
        *ch = m_lpBuffer[m_uBufPos];
        m_uBufPos++;
    }
    else {              
        m_uBufInFilePos += m_uBufSize;
        m_uBufSize = (U16)_lread(m_loaderFile , m_lpBuffer , LDR_BUFSIZE);
        if ( m_uBufSize == 0 ) return( FAILURE );
        *ch = *m_lpBuffer;
        m_uBufPos = 1;
    }   
    return GOOD;
}

/***************************************************************************
*                                                                          *
*  PeekByte - Peek one byte from load buffer                              *
*  parameter :                                                             *
*       ch  --  byte pointer ( output )                                    *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::PeekByte(U8 *ch)
{                                   
    if (m_uBufPos < m_uBufSize) {
        *ch = m_lpBuffer[m_uBufPos];
    }
    else {              
        m_uBufInFilePos += m_uBufSize;
        m_uBufSize = (U16)_lread(m_loaderFile , m_lpBuffer , LDR_BUFSIZE);
        if ( m_uBufSize == 0 ) return( FAILURE );
        *ch = *m_lpBuffer;
        m_uBufPos = 0;
    }   
    return GOOD;
}
    
    
/***************************************************************************
*                                                                          *
*  GetBytes - Get n byte from load buffer                                  *
*  parameter :                                                             *
*       ch  --  byte pointer ( output )                                    *
*       num  --  byte number ( input )                                     *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::GetBytes(U8 *ch , int num)
{                                   
    int i , j;
    U8 *temp;
    
    temp = ch;
    i = 0;

    while ( i < num ) {
        if (m_uBufPos >= m_uBufSize) {
            m_uBufInFilePos += m_uBufSize;
            m_uBufSize = (U16)_lread(m_loaderFile , 
                            m_lpBuffer , LDR_BUFSIZE);
            if ( m_uBufSize == 0 ) return( FAILURE );
            m_uBufPos = 0;
        }
        j = m_uBufSize - m_uBufPos;
        j = ( j > (num - i) ) ? (num - i) : j;
        memcpy( &ch[i] , &m_lpBuffer[m_uBufPos] , j);
        i += j;
        m_uBufPos += (U16) j;
    }        
    return GOOD;
}
    
/***************************************************************************
*                                                                          *
*  GetName - Get one name from load buffer                                 *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
unsigned char *LoaderServer::GetName(void)
{                                   
    U8 ch;
    unsigned char *str;
    
    if ( GetOneByte(&ch) == FAILURE ) {
        return 0;
    }
    str = new unsigned char[ch+1];
//    ASSERT (str);
    if ( str == 0 ) {
        return 0;
    }
    if ( GetBytes(str , ch) == -1 ) {
        delete str;
        return 0;
    }
    str[ch] = '\0';
    if ( ch > MAX_SYMNAME_LENGTH ) {
        str[MAX_SYMNAME_LENGTH] = '\0';
    }
    
    return str;
}
    
/***************************************************************************
*                                                                          *
*  GetFileName - split a string to a file name and path                    *
*  parameter :                                                             *
*       lpFileRef  --  string include name and path .                      *
*       mode       --  0  split to m_lpFileName and m_lpFileRef            *
*                      1  split to m_lpModuleName and m_lpModuleRef        *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::GetFileName(LPSTR lpFileRef, int mode) {
    int found = 0;
    int i;
    int pathLength;
    LPSTR tmpPtr = lpFileRef;
             
        
    if ( (mode != 0)&&(mode != 1) ) 
        return(FAILURE);
                     
    if ((pathLength = lstrlen(lpFileRef)) == 0)
        return(GOOD);

//  Algorithm:
//      Search from right to left for the last slash or a colon,
//      if found
//          copy name and path
//      else only name is specified
//          copy name and set reference to empty tring.
//      return results

    for (i = pathLength; i > 0 && !found; i--) {
        if ((i < pathLength) && (((char)*(tmpPtr+i) == '\\') ||
            ((char)*(tmpPtr+i) == '/') || ((char)*(tmpPtr+i) == ':')) ) {
            if ( mode == 0 ) {
                m_lpFileName = new char[pathLength - i];
//              ASSERT( m_lpFileName );
                if ( m_lpFileName == 0 ) {
                    return( FAILURE );
                }
                lstrcpy(m_lpFileName , (LPSTR)(tmpPtr+i+1) );
                m_lpFileRef = new char[i+2];
//              ASSERT( m_lpFileRef );
                if ( m_lpFileRef  == 0 ) {
                    return( FAILURE );
                }
                *(tmpPtr+i+1) = '\0';
                lstrcpy(m_lpFileRef, (LPSTR)tmpPtr); 
                found = 1;
            }
            else if ( mode == 1 ) {
                m_lpModuleName = new char[pathLength - i];
//              ASSERT( m_lpModuleName );
                if ( m_lpModuleName == 0 ) return( FAILURE );
                lstrcpy(m_lpModuleName , (LPSTR)(tmpPtr+i+1) );
                m_lpModuleRef = new char[i+2];
//              ASSERT( m_lpModuleRef );
                if ( m_lpModuleRef == 0 ) return( FAILURE );
                *(tmpPtr+i+1) = '\0';
                lstrcpy(m_lpModuleRef, (LPSTR)tmpPtr); 
                found = 1;
            }                     
        }
    }

/* There is no path reference in lpFileRef */

    if (!found) {
        if ( mode == 0 ) {
            m_lpFileName = new char[pathLength + 1];
//              ASSERT( m_lpFileName );
            if ( m_lpFileName == 0 ) return( FAILURE );
            lstrcpy(m_lpFileName , lpFileRef);
            m_lpFileRef = 0;
        }
        else if ( mode == 1 ) {              
            m_lpModuleName = new char[pathLength + 1];
//          ASSERT( m_lpModuleName );
            if ( m_lpModuleName == 0 ) return( FAILURE );
            lstrcpy(m_lpModuleName , lpFileRef);
            m_lpModuleRef = 0;
        }
    }
    return(GOOD);
} /* GetFileName */
    
/***************************************************************************
*                                                                          *
*  OpenLoadFile - Open load file                                           *
*  parameter :                                                             *
*       None (Information all in class LoaderServer)                       *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::OpenLoadFile(void)
{                       
    OFSTRUCT pof;
    int len;        
    CString filename;
                     
    filename = m_lpFileRef;
    filename += m_lpFileName;                         
//    if ((m_loaderFile=_lopen(filename.GetBuffer(filename.GetLength()), READ))
//         == HFILE_ERROR)
    if ((m_loaderFile=_lopen(filename.GetBuffer(filename.GetLength()), 
        READ | OF_SHARE_DENY_WRITE)) == HFILE_ERROR)
        return ( FAILURE );
    OpenFile(filename.GetBuffer(filename.GetLength()), &pof, OF_PARSE);
    len = lstrlen(pof.szPathName); 
    if (m_lpFileRef) delete m_lpFileRef;
    m_lpFileRef = new char[len+2];      
//    ASSERT( m_lpFileRef );
    if ( m_lpFileRef == 0 ) return ( FAILURE );
    lstrcpy((LPSTR)m_lpFileRef, (LPSTR)&pof.szPathName);
    m_fileLen = _filelength(m_loaderFile);
    
    if (m_lpBuffer) delete m_lpBuffer;
    m_lpBuffer = new U8[LDR_BUFSIZE];
//  ASSERT( m_lpBuffer );
    if ( m_lpBuffer == 0 ) return( FAILURE );
    m_uBufInFilePos = 0;
    m_uBufPos = 0;
    m_uBufSize = 0;
    return(GOOD);
}

/***************************************************************************
*                                                                          *
*  CloseLoadFile - Close load file                                         *
*  parameter :                                                             *
*       None (Information all in class LoaderServer)                       *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::CloseLoadFile(void)
{           
    if (_lclose(m_loaderFile) != 0)
        return ( FAILURE );
    m_loaderFile = -1;
    if (m_lpBuffer) delete m_lpBuffer;
    m_lpBuffer = 0;
    m_uBufInFilePos = 0;
    m_uBufPos = 0;
    m_uBufSize = 0;
    return(GOOD);
}

/***************************************************************************
*                                                                          *
*  SeekLoadFile - lseek load file                                          *
*  parameter :                                                             *
*       off -- file pointer offset                                         *
*       nOrg -- Specifies the start position and direction of the pointer  *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::SeekLoadFile(long off , int nOrg)
{                                               
    if ( nOrg == 1 ) {
        long i;
        i = off + (long)m_uBufPos;
        if ( (i>=0L) && (i<(long)m_uBufSize) ) {
            m_uBufPos = (U16) i;
            return GOOD;
        }
        nOrg = 0;
        off = (long) (m_uBufInFilePos+m_uBufPos) + off;
    }
    if ((m_uBufInFilePos=_llseek(m_loaderFile,off,nOrg))==HFILE_ERROR)
        return ( FAILURE );
    m_uBufSize = (U16) _lread(m_loaderFile , m_lpBuffer , LDR_BUFSIZE);
    if ( m_uBufSize == 0 ) return( FAILURE );
    m_uBufPos = 0;
    return( GOOD );
}            

/***************************************************************************
*                                                                          *
*  BinToU16 - convert 2 byte to U16 value                                  *
*  parameter :                                                             *
*       s  --  byte pointer ( input )                                      *
*  return value :                                                          *
*       U16 value                                                          *
*                                                                          *
***************************************************************************/
U16 LoaderServer::BinToU16(U8 *s)
{
    U16 ui ;
       
    if ( m_absflag ) {
        ui = (U16) s[1] ;
        ui = (ui<<8) + (U8)s[0];
    }
    else {   
        ui = (U16) s[0];
        ui = (ui<<8) + (U8)s[1];
    }
    return (ui);
}

/***************************************************************************
*                                                                          *
*  BinToU32 - convert 4 byte to U32 value                                  *
*  parameter :                                                             *
*       s  --  byte pointer ( input )                                      *
*  return value :                                                          *
*       U32 value                                                          *
*                                                                          *
***************************************************************************/
U32 LoaderServer::BinToU32(U8 *s)
{
    U32 ul;

    if ( m_absflag ) {
        ul = (U32) s[3];
        ul = (ul<<8) + (U8) s[2];
        ul = (ul<<8) + (U8) s[1];
        ul = (ul<<8) + (U8) s[0];
    }
    else {
        ul = (U32) s[0];
        ul = (ul<<8) + (U8) s[1];
        ul = (ul<<8) + (U8) s[2];
        ul = (ul<<8) + (U8) s[3];
    }
    return (ul);
}


/***************************************************************************
*                                                                          *
*  VALToU32 - convert OMF251 5 bytes VALUE to U32 value                    *
*  parameter :                                                             *
*       s  --  byte pointer ( input )                                      *
*             s[0] = 0 value in unit bytes                                 *
*                  = 1 value in unit bits                                  *
*  return value :                                                          *
*       U32 value                                                          *
*                                                                          *
***************************************************************************/
/*
U32 LoaderServer::VALToU32(U8 *s)
{
    U32 ul;

    if ( m_absflag ) {
        ul = (U32) s[4];
        ul = (ul<<8) + (U8) s[3];
        ul = (ul<<8) + (U8) s[2];
        ul = (ul<<8) + (U8) s[1];
    }
    else {
        ul = (U32) s[1];
        ul = (ul<<8) + (U8) s[2];
        ul = (ul<<8) + (U8) s[3];
        ul = (ul<<8) + (U8) s[4];
    }
    return (ul);
}
*/
    
/***************************************************************************
*                                                                          *
*  ModuleNodeInit - initial a moduleBlock                                  *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::ModuleNodeInit(void)
{
    m_modNode.codeaddr.segType = (SEGMENTTYPE) SEG_CODE;
    m_modNode.codeaddr.startAddr = DEFAULT_START_ADDR;
    m_modNode.codeaddr.endAddr = DEFAULT_END_ADDR;
    m_modNode.time.year = -1;
    m_modNode.time.hour = -1;
    m_modNode.offset = 0;
    m_modNode.symno = 0;
    m_modNode.blkcnt = 0;
    m_modNode.linecnt = 0;
    m_modNode.scope = 0;
    m_modNode.tfileoffset = 0;
    return GOOD;
}   

/***************************************************************************
*                                                                          *
*  LdrIntelHexDownload - Intel hex format main process routine             *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrIntelHexDownload(void)
{
    unsigned int old_pc;
    int dw_byte , err;
    unsigned char *ptr;
    unsigned int next_pc;
    unsigned char dw_buf[512];
    unsigned char dw_buf2[512];
    int i,j;    
    CString sss;
    int nLin = 0;

    memset(dw_buf2, 0, 512);
    dw_byte = 0;
    next_pc = 0;
    ptr = dw_buf2;                              
    if ( m_window == LOAD_FROM_SHELL) 
        ShowLine("Download file : ");
    for (;;) {
        if ( (err = TestKey(VK_ESCAPE)) == 1 ) {
            m_dwErrorNum = ER_LDR_ABORT;        // 0x4010;
            return( -1 );
        } 
        if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
            if ( IsLoadCanceled() ) {
                m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
                return( -1 );
            }                  
            TestMessage();
        }
        if ( GetBytes(dw_buf , 9) == -1 ) {
            m_dwErrorNum = ER_LDR_FILE_FORMAT;      // 0x4014;
            return(-1);                        
        }                            
        switch (dw_buf[8]) {
        case '2':
            if ( GetBytes(dw_buf , 8) == -1 ) {
                m_dwErrorNum = ER_LDR_FILE_FORMAT;  // 0x4014;
                return(-1);                        
            }    
            break;                        
        case '0':
            old_pc = 0;
            for (i=0;i<4;i++) old_pc = (old_pc << 4) + asc__h(dw_buf[3+i]);
            old_pc /= 2;
            if (dw_byte && (old_pc != next_pc)) {
                ADDR stAddr , endAddr;

                //if ( LOAD_TODATA( m_ldrFlags ) )
                //    stAddr.addrType = endAddr.addrType = 2;
                //else
                    stAddr.addrType = endAddr.addrType = 1;
                stAddr.addr=(unsigned short)(next_pc-(unsigned int) dw_byte);
                endAddr.addr=(unsigned short)(next_pc - 1);

#ifdef _ZLR_                
                err=AbiFill(stAddr , endAddr , (WORD *)dw_buf2 , dw_byte);
                if ( err != ICE_OK ) {
                    m_dwErrorNum = ER_ICE_FAIL_MEM_WRITE; // 0x4002;
                    return(-1);
                }
                displayPC( stAddr.addr );
#endif              
                ptr = dw_buf2;

                uLoadBytes += (U32)dw_byte;

                dw_byte = 0;
            }
            j = (int) asc2hex(dw_buf[1],dw_buf[2]);
            
            dw_byte += j/2;
            next_pc = old_pc + (unsigned int) j/2;
            j = j*2;
            if ( GetBytes(&dw_buf[9] , j+4) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400f;//0x4014;
                return(-1);                        
            }
#ifndef _ZLR_           
            else {            
                dw_buf[j+11] = '\0';
                if ( m_window == LOAD_FROM_SHELL) 
                    ShowLine( (char *) dw_buf );
            }
#endif          
            
            for (i=0; i < j; i += 2) {
                *ptr++ = asc2hex(dw_buf[9+i], dw_buf[i+10]);
            }                
            
            if (dw_byte >= 128) {
                ADDR stAddr , endAddr;

                //if ( LOAD_TODATA( m_ldrFlags ) )
                //    stAddr.addrType = endAddr.addrType = 2;
                //else
                    stAddr.addrType = endAddr.addrType = 1;
                stAddr.addr=(unsigned short)(next_pc-(unsigned int) dw_byte);
                endAddr.addr=(unsigned short)(stAddr.addr + 127);

#ifdef _ZLR_                                
                err=AbiFill(stAddr , endAddr , (WORD *)dw_buf2 , 128);
                if ( err != ICE_OK ) {
                    m_dwErrorNum = ER_ICE_FAIL_MEM_WRITE; // 0x4002;
                    return(-1);
                }
#endif
                uLoadBytes += 128L;
                
                dw_byte -= 128;
                ptr = &dw_buf2[dw_byte];
                if ( dw_byte ) {
                    memcpy( dw_buf2 , &dw_buf2[256] , dw_byte );
                }   

#ifdef _ZLR_                
                displayPC( stAddr.addr );
#endif
            }
            break;
            
        case '1':
            if (dw_byte) {
                ADDR stAddr , endAddr;

                //if ( LOAD_TODATA( m_ldrFlags ) )
                //    stAddr.addrType = endAddr.addrType = 2;
                //else
                    stAddr.addrType = endAddr.addrType = 1;
                stAddr.addr=(unsigned short)(next_pc-(unsigned int) dw_byte);
                endAddr.addr=(unsigned short)(next_pc - 1);

#ifdef _ZLR_                                
                err=AbiFill(stAddr , endAddr , (WORD *)dw_buf2 , dw_byte);
                if ( err != ICE_OK ) {
                    m_dwErrorNum = ER_ICE_FAIL_MEM_WRITE; // 0x4002;
                    return(-1);
                }
                displayPC( stAddr.addr );
#endif
                
                ptr = dw_buf2;

                uLoadBytes += (U32)dw_byte;
                nLin = dw_byte*2;
                dw_byte = 0;
            }
            
            //m_lPCAddr = dw_buf2[nLin-2];
            m_lPCAddr = old_pc;
            return (0);
            
        case '3':
            j = (int) asc2hex(dw_buf[1],dw_buf[2]);
            j *= 2;
            if ( GetBytes(dw_buf , j+4) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                return(-1);                        
            }    
            old_pc = 0;
            for (i=0;i<4;i++) old_pc = (old_pc << 4) + asc__h(dw_buf[i]);
            m_startaddress = (U32) old_pc;
            break;          
        default:
#ifdef _DUMP_
            Message("\r\n???Unknown hex tag at file %lx",
                            GetFileCurPos()-9);
#endif
            m_dwErrorNum = ER_LDR_FILE_FORMAT;      // 0x4014;
            return(-1);
            break;                             
        }
    }
    
    m_lPCAddr = old_pc/2;    
    return (0);     // unreachable code
}        /* end of downrecord() */


/***************************************************************************
*                                                                          *
*  displayPC - display pc value string                                     *
*  parameter :                                                             *
*       addr  ----     pc value                                            *
*  return value :                                                          *
*       NONE                                                               *
*                                                                          *
***************************************************************************/
void LoaderServer::displayPC(U16 addr)
{
    char tempStr[100];
    int l , i , j;

    sprintf(tempStr , "Download file : ");
    l = strlen(tempStr);
    for( i=0; i < 4;i++) {
        j = addr & 0x000F;
        if ( j < 10 ) tempStr[3-i+l] = (char) ('0' + j);
        else tempStr[3-i+l] = (char) ('A' + j - 10);
        addr = addr >> 4;
    }
    tempStr[4+l] = '\0';                         

    if ( m_window == LOAD_FROM_SHELL ) {
        if ( LOAD_WARNING(m_ldrFlags) ) {
            ShlReshowLine(tempStr , 4+l);
        }
    }
}        /* end of displayCSIP() */

/******************************** E O F ***********************************/
