
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/LOADDLG.CPP   1.13   13 Dec 1996 11:18:48   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/LOADDLG.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:48   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:46   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:04   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:00   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:48   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:10   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:58   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:12   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:48   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:16   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:30   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:38   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:16   ZJRD
** PIC/SLD Version 0.20
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  LOADDLG.CPP
//
//  Description:The implement file for the class: CLoadDialog
//
//  Author:     Roger Zhang
//
//  Date:       07/12/95
//
//  Modification:
//
//      1. 07/12/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"
                    
#include "uicom.h"                    
#include "srcgrp.h"
#include "loaddlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLoadDialog dialog


static char BASED_CODE szFilter[] = 
 "Binary Code File(*.cod)|*.cod|Hex File(*.hex)|*.hex|All files(*.*)|*.*||";
    
static char * ExtName[] = { 
    "*.cod", "*.hex", "*.*"
} ;
                                    
// return 1 -- 6 indicates the initial file extension                                    
static int GetFilterIndex(const char * pszExt)
{
    for(int i = 0; i < 3; i ++) {
        if(_stricmp(pszExt, ExtName[i]) == 0)   return  i + 1;
    }                                                         
    return  1;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CLoadDialog::CLoadDialog()
: CFileDialog(TRUE, NULL, 
    AfxGetApp()->GetProfileString("LoadOption","LoadExt", "*.cod"),
  OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, ::szFilter, NULL)
{
    m_ofn.lpstrTitle = "Load"; 
    m_ofn.nFilterIndex = ::GetFilterIndex(
        AfxGetApp()->GetProfileString("LoadOption","LoadExt", "*.cod"));
    
    m_nIDHelp = IDD_LOAD;
    //{{AFX_DATA_INIT(CLoadDialog)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLoadDialog::DoDataExchange(CDataExchange* pDX)
{
    CFileDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CLoadDialog)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLoadDialog, CFileDialog)
    //{{AFX_MSG_MAP(CLoadDialog)
    ON_BN_CLICKED(IDC_LOAD_OPTION, OnLoadOption)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLoadDialog message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CLoadDialog::OnInitDialog()
{
    CFileDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    CenterWindow();
                          
    // Add "Options..." button
    CRect rect;

    GetDlgItem(IDCANCEL)->GetWindowRect(rect);
    ScreenToClient(&rect);
    rect.OffsetRect(0, rect.Height() + 50);
    
    m_btnOption.Create("&Options...",WS_VISIBLE|WS_TABSTOP|WS_CHILD|WS_GROUP
        |BS_PUSHBUTTON, rect, this, IDC_LOAD_OPTION);
    m_btnOption.SetFont(GetFont(), TRUE);
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}
                                               
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLoadDialog::OnLoadOption()
{
    CSrcGrpDlg    dlg(0, this);
    dlg.DoModal();
}                 

void CLoadDialog::OnOK()
{
    // TODO: Add extra cleanup here
    CFileDialog::OnOK();    
    
    if(m_ofn.nFilterIndex > 0) {
        AfxGetApp()->WriteProfileString("LoadOption", "LoadExt", 
            ::ExtName[m_ofn.nFilterIndex - 1]);
    } else {
        AfxGetApp()->WriteProfileString("LoadOption", "LoadExt", 
            ::ExtName[0]);
    }       
}

/////////////////////////////////(EOF)///////////////////////////////////////
                              
