
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMADDR.CPP   1.13   13 Dec 1996 11:18:50   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMADDR.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:50   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:50   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:08   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:04   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:06   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:28   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:16   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:32   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:06   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:48   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:16   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:22   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:44   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:44   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMADDR.CPP
//
//  Description: The implementation file for the class: CMemoryAddr.
//
//  Author: Chen Jun
//
//  Date: 04/17/95
//
//  Modification:
//      1. 04/17/95, Initial version of the class: CMemoryAddr.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memaddr.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.



/////////////////////////////////////////////////////////////////////////////
// Executable codes.


/////////////////////////////////////////////////////////////////////////////
// Public functions.


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryAddr.

// Construction.
CMemoryAddr::CMemoryAddr()
{
    m_uchType = 1;
}   // End of CMemoryAddr().

// Copy construction.
CMemoryAddr::CMemoryAddr(unsigned short uAddr, unsigned char uchType)
{
    // Assertion of the input parameters.
    ASSERT( uchType >= 0 && uchType <= 5 );
    
    // Copy construction.
    m_uAddr = uAddr;
    m_uchType = uchType;

}   // End of CMemoryAddr().

// Destruction.
CMemoryAddr::~CMemoryAddr()
{

}   // End of ~CMemoryAddr().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryAddr::operator*().
//
//  Description: The operator function of CMemoryAddr class.
//               Operator(+, -, =, ==, >, <, >=, <=).
//
//  Input:  CMemoryAddr.
//
//  Output: CMemoryAddr.
//
//  Return: CMemoryAddr.
//
/////////////////////////////////////////////////////////////////////////////

// CMemoryAddr1 + CMemoryAddr2.
CMemoryAddr CMemoryAddr::operator+(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
    // ASSERT( m_uchType == Addr.m_uchType );

    // Convert.
    CMemoryAddr TmpAddr;
    TmpAddr.m_uAddr = m_uAddr + Addr.m_uAddr;
    TmpAddr.m_uchType = m_uchType;

    if ( 3 == m_uchType || 4 == m_uchType || 5 == m_uchType ) {
        TmpAddr.m_uAddr %= 0x0100;
    }

    return (TmpAddr);
    
}   // End of CMemoryAddr::operator+().

// CMemoryAddr1 + uSize.
CMemoryAddr CMemoryAddr::operator+(const unsigned short& uSize)
{
    // Assertion of the input parameters.
    
    // Convert.
    CMemoryAddr TmpAddr;
    TmpAddr.m_uAddr = m_uAddr + uSize;
    TmpAddr.m_uchType = m_uchType;

    if ( 3 == m_uchType || 4 == m_uchType || 5 == m_uchType ) {
        TmpAddr.m_uAddr %= 0x0100;
    }
    
    return (TmpAddr);

}   // End of CMemoryAddr::operator+().


// CMemoryAddr1 - CMemoryAddr2.
CMemoryAddr CMemoryAddr::operator-(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
    // ASSERT( m_uchType == Addr.m_uchType );

    // Convert.
    CMemoryAddr TmpAddr;
    TmpAddr.m_uAddr = m_uAddr - Addr.m_uAddr;
    TmpAddr.m_uchType = m_uchType;

    if ( 3 == m_uchType || 4 == m_uchType || 5 == m_uchType ) {
        TmpAddr.m_uAddr %= 0x0100;
    }

    return (TmpAddr);
    
}   // End of CMemoryAddr::operator-().

// CMemoryAddr1 - uSize.
CMemoryAddr CMemoryAddr::operator-(const unsigned short& uSize)
{
    // Assertion of the input parameters.
    
    // Convert.
    CMemoryAddr TmpAddr;
    TmpAddr.m_uAddr = m_uAddr - uSize;
    TmpAddr.m_uchType = m_uchType;
    
    if ( 3 == m_uchType || 4 == m_uchType || 5 == m_uchType ) {
        TmpAddr.m_uAddr %= 0x0100;
    }

    return (TmpAddr);

}   // End of CMemoryAddr::operator-().


// CMemoryAddr1 = CMemoryAddr2.
void CMemoryAddr::operator=(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
    // ASSERT( m_uchType == Addr.m_uchType );

    // Convert.
    m_uAddr = Addr.m_uAddr;
    m_uchType = Addr.m_uchType;

}   // End of CMemoryAddr::operator=().

// CMemoryAddr1 = uNewAddr.
void CMemoryAddr::operator=(const unsigned short& uNewAddr)
{
    // Assertion of the input parameters.

    // Convert.
    m_uAddr = uNewAddr;

}   // End of CMemoryAddr::operator=().


// CMemoryAddr1 == CMemoryAddr2.
BOOL CMemoryAddr::operator==(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
    ASSERT( m_uchType == Addr.m_uchType );

    // Convert.
    return ( m_uAddr == Addr.m_uAddr );

}   // End of CMemoryAddr::operator==().


// CMemoryAddr1 == uNewAddr.
BOOL CMemoryAddr::operator==(const unsigned short& uNewAddr)
{
    // Assertion of the input parameters.

    // Convert.
    return ( m_uAddr == uNewAddr );

}   // End of CMemoryAddr::operator==().


// CMemoryAddr1 != CMemoryAddr2.
BOOL CMemoryAddr::operator!=(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
    ASSERT( m_uchType == Addr.m_uchType );

    // Convert.
    return ( m_uAddr != Addr.m_uAddr );

}   // End of CMemoryAddr::operator!=().


// CMemoryAddr1 != m_uAddr.
BOOL CMemoryAddr::operator!=(const unsigned short& uNewAddr)
{
    // Assertion of the input parameters.

    // Convert.
    return ( m_uAddr != uNewAddr );

}   // End of CMemoryAddr::operator!=().


// CMemoryAddr1 > CMemoryAddr2.
BOOL CMemoryAddr::operator>(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
    ASSERT( m_uchType == Addr.m_uchType );

    // Convert.
    return ( m_uAddr > Addr.m_uAddr );

}   // End of CMemoryAddr::operator>().
                
// CMemoryAddr1 > uNewAddr.
BOOL CMemoryAddr::operator>(const unsigned short& uNewAddr)
{
    // Assertion of the input parameters.

    // Convert.
    return ( m_uAddr > uNewAddr );

}   // End of CMemoryAddr::operator>().


// CMemoryAddr1 < CMemoryAddr2.
BOOL CMemoryAddr::operator<(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
    ASSERT( m_uchType == Addr.m_uchType );

    // Convert.
    return ( m_uAddr < Addr.m_uAddr );

}   // End of CMemoryAddr::operator<().

// CMemoryAddr1 < uNewAddr.
BOOL CMemoryAddr::operator<(const unsigned short& uNewAddr)
{
    // Assertion of the input parameters.

    // Convert.
    return ( m_uAddr < uNewAddr );

}   // End of CMemoryAddr::operator<().


// CMemoryAddr1 >= CMemoryAddr2.
BOOL CMemoryAddr::operator>=(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
    ASSERT( m_uchType == Addr.m_uchType );

    // Convert.
    return ( m_uAddr >= Addr.m_uAddr );

}   // End of CMemoryAddr::operator>=().

// CMemoryAddr1 >= uNewAddr.
BOOL CMemoryAddr::operator>=(const unsigned short& uNewAddr)
{
    // Assertion of the input parameters.

    // Convert.
    return ( m_uAddr >= uNewAddr );

}   // End of CMemoryAddr::operator>=().


// CMemoryAddr1 <= CMemoryAddr2.
BOOL CMemoryAddr::operator<=(const CMemoryAddr& Addr)
{
    // Assertion of the input parameters.
    ASSERT( m_uchType == Addr.m_uchType );

    // Convert.
    return ( m_uAddr <= Addr.m_uAddr );

}   // End of CMemoryAddr::operator<=().

// CMemoryAddr1 <= uNewAddr.
BOOL CMemoryAddr::operator<=(const unsigned short& uNewAddr)
{
    // Assertion of the input parameters.

    // Convert.
    return ( m_uAddr <= uNewAddr );

}   // End of CMemoryAddr::operator<=().


//////////////////////////////// End of File ////////////////////////////////
