
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMADDR.H__   1.13   13 Dec 1996 11:18:52   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMADDR.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:52   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:50   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:08   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:04   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:08   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:32   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:20   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:34   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:08   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:54   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:24   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:30   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:48   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:46   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMADDR.H
//
//  Description: The header file for the class: CMemoryAddr.
//
//  Author: Chen Jun
//
//  Date: 04/21/95
//
//  Modification:
//      1. 04/21/95, Initial version of the class: CMemoryAddr.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _MEMADDR_
#define _MEMADDR_


/////////////////////////////////////////////////////////////////////////////
// CMemoryAddr class.
class CMemoryAddr
{
// Contruction & Destruction.
public:
    CMemoryAddr();
    CMemoryAddr(unsigned short uAddr, unsigned char uchType);
    ~CMemoryAddr();
        
// Member variables.
public:
    unsigned char m_uchType;
    unsigned short m_uAddr;
    
// Operator member functions.
public:
    CMemoryAddr operator+(const CMemoryAddr& Addr);
    CMemoryAddr operator+(const unsigned short& uSize);
    
    CMemoryAddr operator-(const CMemoryAddr& Addr);
    CMemoryAddr operator-(const unsigned short& uSize);
    
    void operator=(const CMemoryAddr& Addr);
    void operator=(const unsigned short& uNewAddr);
    
    BOOL operator==(const CMemoryAddr& Addr);
    BOOL operator==(const unsigned short& uNewAddr);

    BOOL operator!=(const CMemoryAddr& Addr);
    BOOL operator!=(const unsigned short& uNewAddr);
    
    BOOL operator>(const CMemoryAddr& Addr);
    BOOL operator>(const unsigned short& uNewAddr);
    
    BOOL operator<(const CMemoryAddr& Addr);
    BOOL operator<(const unsigned short& uNewAddr);

    BOOL operator>=(const CMemoryAddr& Addr);
    BOOL operator>=(const unsigned short& uNewAddr);

    BOOL operator<=(const CMemoryAddr& Addr);
    BOOL operator<=(const unsigned short& uNewAddr);

};  // End of class: CMemoryAddr.

#endif
//////////////////////////////// End of File ////////////////////////////////
