
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMBASE.CPP   1.13   13 Dec 1996 11:18:52   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMBASE.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:52   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:52   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:08   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:04   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:08   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:26   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:18   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:34   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:10   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:33:50   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:47:52   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:29:04   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:07:02   ZJRD
** PIC/SLD Version 0.20
** 
**    Rev 1.0   13 Aug 1996 09:18:50   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMBASE.CPP
//
//  Description: The implementation file for the class: CMemoryBase.
//
//  Author: Chen Jun
//
//  Date: 04/17/95
//
//  Modification:
//      1. 04/17/95, Initial version of the class: CMemoryBase.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "basictyp.h"
#include "membase.h"
#include "hosterrs.h"

/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
extern int TestKey(WORD wKey);  // Defined in UICOM.CPP
//extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, LPSTR lpszError ...);
//extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, CString& strError ...);



/////////////////////////////////////////////////////////////////////////////
// Executable codes.


/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryBase.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemory::CMemoryBase().
//
//  Description: The construction of the class: CMemoryBase.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryBase::CMemoryBase()
{
    // Allocate a space.
    m_pszVar = new char[MAX_DIGIT];
    if ( !m_pszVar ) {
        ErrDisplayError(ER_OUT_OF_MEMORY);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        memset(m_pszVar, 0, sizeof(m_pszVar));
    }
    
    m_pszResult = new char[LINE_LENGTH];
    if ( !m_pszResult ) {
        ErrDisplayError(ER_OUT_OF_MEMORY);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        memset(m_pszResult, 0, sizeof(m_pszResult));
    }
    
    // Initialization.
    m_nErrorID = 0;

}   // End of CMemoryBase::CMemoryBase().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemory::~CMemoryBase().
//
//  Description: The destruction of the class: CMemoryBase.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryBase::~CMemoryBase()
{
    // Free the allocated space.
    if ( m_pszVar ) {
        delete []m_pszVar;
    }
    
    if ( m_pszResult ) {
        delete []m_pszResult;
    }

}   // End of CMemoryBase::~CMemoryBase().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBase::StrToVar().
//
//  Description: Convert the string to an unsigned long value.
//
//  Input:  pszConvStr - The string to be converted.
//
//  Output: m_ulVar - An unsigned long value.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryBase::StrToVar(char* pszConvStr)
{
    // Assertion of the input parameters.
    ASSERT( pszConvStr );
    
    // Convertion.
    char* pszStopStr;
    m_ulVar = strtoul(pszConvStr, &pszStopStr, 16);

}   // End of CMemoryBase::StrToVar().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBase::VarToStr().
//
//  Description: Convert an unsigned long value to a string.
//
//  Input:  ulConvVar - The converted value.
//
//  Output: m_pszVarString - The ASCII digital string.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryBase::VarToStr(unsigned long ulConvVar)
{
    // Assertion of the input parameters.

    // Convert an unsigned long value to the string.
    _ultoa(ulConvVar, m_pszVar, 16);
    
}   // End of CMemoryBase::VarToStr().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBase::SetAddrVar().
//
//  Description: Set the address with the memory space.
//
//  Input:  pszArgv - Input address with memory attribute.
//
//  Output: addr - Structure "CMemoryAddr" variable.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryBase::SetAddrVar(char* pszAddr, CMemoryAddr& addr)
{
    // Assertion of the input parameters.
    ASSERT( pszAddr );
    
    unsigned char uch;
    
    if ( ':' == pszAddr[1] ) {
        // Convert the "X:xxxx" form.
        ASSERT( 'P' == toupper(*pszAddr) ||
                'X' == toupper(*pszAddr) ||
                'I' == toupper(*pszAddr) ||
                'R' == toupper(*pszAddr) ||
                'B' == toupper(*pszAddr) );

        switch ( toupper(*pszAddr) ) {
            case 'P':
                uch = MEM_PROGRAM;
                break;
            case 'X':
                uch = MEM_EXTERNAL;
                break;
            case 'R':
            case 'I':
                uch = MEM_INTERNAL;
                break;
//            case 'R':
//                uch = MEM_SFR;
//                break;
            case 'B':
                uch = MEM_BIT;
                break;
            default:
                uch = MEM_UNDEFINE;
                ASSERT( FALSE );
                break;
        }
    
        StrToVar(pszAddr+2);
    }
    else {
        // Convert the "xxxx" form.
        StrToVar(pszAddr);
        uch = MEM_PROGRAM;
    }

    unsigned short uAddr = (unsigned short) m_ulVar;
    
    // Set the ADDR structure.
    addr.m_uchType = uch;
    addr.m_uAddr = uAddr;

}   // End of CMemoryBase::SetAddrVar().

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBase::SetAddrVar().
//
//  Description: Set the address with the memory space.
//
//  Input:  pszArgv - Input address with memory attribute.
//          pszLength - Length between Start address & End address.
//
//  Output: addr - Structure "CMemoryAddr" variable.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryBase::SetAddrVar(char* pszAddr, char* pszLength, CMemoryAddr& addr)
{
    // Assertion of the input parameters.
    ASSERT( pszAddr );
    ASSERT( pszLength );
    
    unsigned char uch;
    if ( ':' == pszAddr[1] ) {
        // Convert the "X:xxxx" form.
        ASSERT( 'P' == toupper(*pszAddr) ||
                'X' == toupper(*pszAddr) ||
                'I' == toupper(*pszAddr) ||
                'R' == toupper(*pszAddr) ||
                'B' == toupper(*pszAddr) );
        ASSERT( ':' == *(pszAddr+1) );
        
        char ch = (char) toupper(*pszAddr);
        switch ( ch ) {
            case 'P':
                uch = MEM_PROGRAM;
                break;
            case 'X':
                uch = MEM_EXTERNAL;
                break;
            case 'R':
            case 'I':
                uch = MEM_INTERNAL;
                break;
//            case 'R':
//                uch = MEM_SFR;
//                break;
            case 'B':
                uch = MEM_BIT;
                break;
            default:
                uch = MEM_UNDEFINE;
                ASSERT( FALSE );
                break;
        }
        StrToVar(pszAddr+2);    
    }
    else {
        // Convert the "xxxx" form.
        StrToVar(pszAddr);
        uch = MEM_PROGRAM;
    }

    unsigned short uAddr = (unsigned short) m_ulVar;
    StrToVar(pszLength);
    uAddr += (unsigned short) (m_ulVar - 1);
    
    // Set the ADDR structure.
    addr.m_uchType = uch;
    addr.m_uAddr = uAddr;

}   // End of CMemoryBase::SetAddrVar().

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBase::SetAddrVar().
//
//  Description: Set the address with the memory space.
//
//  Input:  nType - P, X, I, R, B.
//          ulAddr - address value.
//
//  Output: addr - Structure "CMemoryAddr" variable.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryBase::SetAddrVar(int nType, unsigned long ulAddr, CMemoryAddr& addr)
{
    // Assertion of the input parameters.
    ASSERT( nType >= MEM_UNDEFINE && nType <= MEM_BIT );
    
    // Set the ADDR structure.
    addr.m_uchType = (unsigned char) nType;
    addr.m_uAddr = (unsigned short) ulAddr;

}   // End of CMemoryBase::SetAddrVar().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBase::EscapeAbort().
//
//  Description: Test if abort by pressing ESC key.
//
//  Input:  None.
//
//  Output: nErrorID - The ID of the ABI error.
//
//  Return: TRUE - abort; FALSE - no abort.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CMemoryBase::EscapeAbort(void)
{
    // Assertion of the input parameters.
    
    // Test the key value.
    if ( 1 == ::TestKey(VK_ESCAPE) ) {
        char chErr[E_ERRSIZE];
        ErrGetErrorText(ER_TST_INNER_ESC, chErr);
        ShowLine(chErr);
//        ShowLine("Abort by user.");
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CMemoryBase::EscapeAbort().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBase::DisplayErrorMessage().
//
//  Description: Display the ABI error messages of the Memory server.
//
//  Input:  nErrorID - The ID of the ABI error.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryBase::DisplayErrorMessage(void) const
{
    // Assertion of the input parameters.
//    ASSERT(m_nErrorID >= ICE_FAIL_STEP && m_nErrorID <= ICE_FLASH_REC_ERROR);
    ASSERT(m_nErrorID >= ICE_FAIL_STEP && m_nErrorID <= ICE_NO_RESPONSE);

    // Dispatch ABI error message.
    char* pszAbiError;
    pszAbiError = new char [256];
/*    
    switch ( m_nErrorID ) {
        case ICE_FAIL_STEP:
            //pszAbiError = "Target cannot step.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_FAIL_MEM_WRITE:
            //pszAbiError = "Memory write failure.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_FAIL_MAP_INCLUDE:
            //pszAbiError = "Map status not included.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_FAIL_MAP_BOUNDARY:
            //pszAbiError = "Map address boundary error.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_NOT_FOUND:
            //pszAbiError = "Not found.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_FOUND:
            //pszAbiError = "Found.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_TIME_OUT:
            //pszAbiError = "Communication failure.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_PARA_ERROR:
            //pszAbiError = "Parameter error.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_EP_RUNNING:
            //pszAbiError = "EP running.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_TRACE_RUNNING:
            pszAbiError = "Trace running.";
            break;
        case ICE_TRACE_READ_OVER:
            pszAbiError = "Trace read over.";
            break;
        case ICE_COMMAND_INVALID:
            pszAbiError = "Invalid command.";
            break;
        case ICE_FLASH_SW_ERROR:
            pszAbiError = "Flash EPROM switching error.";
            break;
        case ICE_FLASH_EC_ERROR:
            pszAbiError = "Flash EPROM earsing error.";
            break;
        case ICE_FLASH_PRG_ERROR:
            pszAbiError = "Flash EPROM programming error.";
            break;
        case ICE_FLASH_REC_ERROR:
            pszAbiError = "Flash EPROM recording error.";
            break;
        default:
            ASSERT( FALSE );
            pszAbiError = "Parameter error.";
            break;
    }
*/  
    //Add by Daniel Lin on 5/30/1996
    //
    ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);    
    
    // Display the ABI error message.
    if ( !m_isServer ) {
        ShowLine(pszAbiError);
    }
    else {
        AfxMessageBox(pszAbiError);
    }
    
    delete [] pszAbiError;
    
}   // End of CMemoryBase::DisplayErrorMessage().

//////////////////////////////// End of File ////////////////////////////////
