
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMBYTE.CPP   1.12   13 Dec 1996 11:18:52   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMBYTE.CPP  $
** 
**    Rev 1.12   13 Dec 1996 11:18:52   ZJRD
** No change.
** 
**    Rev 1.11   22 Nov 1996 10:59:52   ZJRD
** No change.
** 
**    Rev 1.10   11 Nov 1996 12:47:10   ZJRD
** No change.
** 
**    Rev 1.9   06 Nov 1996 12:59:04   ZJRD
** No change.
** 
**    Rev 1.8   02 Nov 1996 09:45:30   ZJRD
** No change.
** 
**    Rev 1.7   30 Oct 1996 12:47:42   ZJRD
** No change.
** 
**    Rev 1.6   28 Oct 1996 09:40:42   ZJRD
** No change.
** 
**    Rev 1.5   21 Oct 1996 09:15:18   ZJRD
** No change.
** 
**    Rev 1.4   09 Oct 1996 13:44:52   ZJRD
** No change.
** 
**    Rev 1.3   23 Sep 1996 10:30:26   ZJRD
** No change.
** 
**    Rev 1.2   06 Sep 1996 13:44:12   ZJRD
** No change.
** 
**    Rev 1.1   02 Sep 1996 11:25:34   ZJRD
** No change.
** 
**    Rev 1.0   15 Aug 1996 10:04:18   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "membyte.h"
#include "hosterrs.h"
#include "abiextfn.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void ByteCmd(int nArgc, char* pszArgv[]);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.

void SrcUpdate(void);
extern BOOL GetCpuStatus(unsigned char&);
extern void ShowLine(char *);


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   ByteCmd().
//
//  Description: The main control routine of Byte command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void ByteCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Byte to EMM.
    char error[128];
    CMemoryByte* pMemoryByte = new CMemoryByte;
    if ( !pMemoryByte ) {
        ErrDisplayError(ER_OUT_OF_MEMORY, 0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
            pMemoryByte->ByteAction(nArgc, pszArgv);
            delete pMemoryByte;
          }           
       }   
    }

//    CMemoryByte objByte;
//    objByte.SetByte(nArgc, pszArgv);

}   // End of ByteCmd().



/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryByte.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryByte::CMemoryByte().
//
//  Description: The construction of the class: CMemoryByte.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryByte::CMemoryByte()
{

}   // End of CMemoryByte::CMemoryByte().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryByte::~CMemoryByte().
//
//  Description: The destruction of the class: CMemoryByte.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryByte::~CMemoryByte()
{

}   // End of CMemoryByte::~CMemoryByte().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryByte::ByteAction().
//
//  Description: Set Byte value to EMM.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryByte::ByteAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set address & pattern.
    if ( 3 == nArgc ) {
        // Byte adr data.
        SetAddrVar(pszArgv[1], m_Addr);
        SetPattern(pszArgv[2]);
    }
    else {
        ASSERT( FALSE );
        return;
    }
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] ) {
        m_Addr.m_uchType = MEM_PROGRAM;
    }
    
    // Memory Byte kernel routine.
    MemoryByteKernel();
        
}   // End of CMemoryByte::ByteAction().


void CMemoryByte::SetPattern(char* pszPattern)
{
    // Assertion of the input parameters.
    ASSERT( pszPattern );
    
    // Set the pattern buffer.
    m_uPatternLen = 0;
    while ( *pszPattern ) {
        char pszData[3];
        memset(pszData, 0, sizeof(pszData));
        for ( int i = 0; i <= 2; i++ ) {
            if ( ' ' != *pszPattern ) {
                pszData[i] = *pszPattern++;
            }
            else {
                pszPattern++;
                break;
            }
        }
        StrToVar(pszData);
        m_pchByte[m_uPatternLen/1] = (BYTE) m_ulVar;
        m_uPatternLen += 1;
    }

}   // End of CMemoryByte::SetPattern().


void CMemoryByte::MemoryByteKernel(void)
{
    // Assertion of the input parameters.
    
    // Call Abi routine.
    m_nErrorID = AbiSetMemN((ADDR&) m_Addr, m_pchByte, m_uPatternLen);

    // Update Source window.
    if ( MEM_PROGRAM == m_Addr.m_uchType ) {
        ::SrcUpdate();
    }
    
    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
    }
        
}   // End of CMemoryByte::MemoryDumpKernel().


//////////////////////////////// End of File ////////////////////////////////
