
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMBYTE.H__   1.12   13 Dec 1996 11:18:52   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMBYTE.H__  $
** 
**    Rev 1.12   13 Dec 1996 11:18:52   ZJRD
** No change.
** 
**    Rev 1.11   22 Nov 1996 10:59:52   ZJRD
** No change.
** 
**    Rev 1.10   11 Nov 1996 12:47:10   ZJRD
** No change.
** 
**    Rev 1.9   06 Nov 1996 12:59:06   ZJRD
** No change.
** 
**    Rev 1.8   02 Nov 1996 09:48:44   ZJRD
** No change.
** 
**    Rev 1.7   30 Oct 1996 12:51:10   ZJRD
** No change.
** 
**    Rev 1.6   28 Oct 1996 09:43:58   ZJRD
** No change.
** 
**    Rev 1.5   21 Oct 1996 09:18:08   ZJRD
** No change.
** 
**    Rev 1.4   09 Oct 1996 13:47:42   ZJRD
** No change.
** 
**    Rev 1.3   23 Sep 1996 10:37:10   ZJRD
** No change.
** 
**    Rev 1.2   06 Sep 1996 13:51:56   ZJRD
** No change.
** 
**    Rev 1.1   02 Sep 1996 11:33:04   ZJRD
** No change.
** 
**    Rev 1.0   15 Aug 1996 10:10:12   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMBYTE.H
//
//  Description: The header file for the class: CMemoryByte.
//
//  Author: Chen Jun
//
//  Date: 04/26/95
//
//  Modification:
//      1. 04/26/95, Initial version of the class: CMemoryByte.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _MEMBYTE_
#define _MEMBYTE_

#include "membase.h"


/////////////////////////////////////////////////////////////////////////////
// CMemoryByte class.
class CMemoryByte : public CMemoryBase
{
// Construction & Destruction.
public:
    CMemoryByte();
    ~CMemoryByte();
    
// Member variables.
private:
    CMemoryAddr m_Addr;
    
    enum { MAX_BYTE_SIZE = 32 };
    WORD m_pchByte[MAX_BYTE_SIZE+1];
    
    unsigned int m_uPatternLen;
    
// Implementations.
private:
    void SetPattern(char* pszPattern);
    void MemoryByteKernel(void);

public:
    void ByteAction(int nArgc, char* pszArgv[]);

};  // End of class: CMemoryByte.

#endif
//////////////////////////////// End of File ////////////////////////////////
