
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMCHK.CPP   1.13   13 Dec 1996 11:18:52   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMCHK.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:52   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:52   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:10   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:06   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:50   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:08   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:00   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:18   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:54   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:33:08   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:47:04   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:28:08   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:06:26   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:32   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMCHK.CPP
//
//  Description: The implementation file for the class: CMemoryChecksum.
//
//  Author: Chen Jun
//
//  Date: 04/29/95
//
//  Modification:
//      1. 04/29/95, Initial version of the class: CMemoryChecksum.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memchk.h"
#include "hosterrs.h" 
#include "abiextfn.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void ChecksumCmd(int nArgc, char* pszArgv[]);
long MemServerChecksum(const unsigned short uStart,
    const unsigned short uEnd, unsigned char uchType);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.

//#ifndef _SERVER_NO_ABI
//    extern STATUS AbiChecksum(ADDR addr1, ADDR addr2, UINT* uChecksum);
//#endif  // _SERVER_NO_ABI
extern BOOL GetCpuStatus(unsigned char &);
extern void ShowLine(char *);


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   ChecksumCmd().
//
//  Description: The main control routine of Checksum command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void ChecksumCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc || 4 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Get Checksum.
    char error[128];
    
    CMemoryChecksum* pMemoryChecksum = new CMemoryChecksum;
    if ( !pMemoryChecksum ) {
        ErrDisplayError(ER_OUT_OF_MEMORY, 0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
            pMemoryChecksum->ChecksumAction(nArgc, pszArgv);
            delete pMemoryChecksum;
          }           
       }   
    }

//    CMemoryChecksum objChecksum;
//    objChecksum.GetChecksum(nArgc, pszArgv);

}   // End of ChecksumCmd().


// Memory server: checksum.
long MemServerChecksum(const unsigned short uStart,
    const unsigned short uEnd, unsigned char uchType)
{
    // Assertion of the input parameters.

    // Get Checksum.
    CMemoryChecksum* pMemoryChecksum = new CMemoryChecksum;
    if ( !pMemoryChecksum ) {
        ErrDisplayError(ER_OUT_OF_MEMORY, 0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return 0;
    }
    else {
        long lChecksum = 
            pMemoryChecksum->MemServerChecksum(uStart, uEnd, uchType);
        delete pMemoryChecksum;
        return (lChecksum);
    }

}   // End of MemServerChecksum().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryChecksum.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryChecksum::CMemoryChecksum().
//
//  Description: The construction of the class: CMemoryChecksum.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryChecksum::CMemoryChecksum()
{

}   // End of CMemoryChecksum::CMemoryChecksum().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryChecksum::~CMemoryChecksum().
//
//  Description: The destruction of the class: CMemoryChecksum.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryChecksum::~CMemoryChecksum()
{

}   // End of CMemoryChecksum::~CMemoryChecksum().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryChecksum::ChecksumAction().
//
//  Description: Checksum of EMM.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryChecksum::ChecksumAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc || 4 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set Start address & End address.
    if ( 3 == nArgc ) {
        // Checksum adr1 adr2.
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[2], m_EndAddr);
    }
    else if ( 4 == nArgc ) {
        // Checksum adr1 Length length.
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[1], pszArgv[3], m_EndAddr);
    }
    else {
        ASSERT( FALSE );
        return;
    }
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] ) {
//        m_StartAddr.m_uchType = MEM_EXTERNAL;
        m_StartAddr.m_uchType = MEM_PROGRAM;
    }
    m_EndAddr.m_uchType = m_StartAddr.m_uchType;
    
    // Memory Checksum kernel routine.
    MemoryChecksumKernel();
        
}   // End of CMemoryChecksum::ChecksumAction().


void CMemoryChecksum::MemoryChecksumKernel(void)
{
    // Assertion of the input parameters.
    
    // Call Abi routine.
    m_nErrorID = 
        AbiChecksum((ADDR&) m_StartAddr, (ADDR&) m_EndAddr, &m_uChecksum);

    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
    }
    else {
        DisplayChecksum(m_uChecksum);
    }
        
}   // End of CMemoryChecksum::MemoryDumpKernel().


void CMemoryChecksum::DisplayChecksum(UINT uChecksum)
{
    // Assertion of the input parameters.
    
    // Display the Checksum of the special EMM range.
    char pszChecksum[255];
    memset(pszChecksum, 0, sizeof(pszChecksum));
    wsprintf(pszChecksum, "Checksum is: %X.", uChecksum);
    ShowLine(pszChecksum);

}   // End of CMemoryChecksum::DisplayChecksum().


// Memory server: checksum.
long CMemoryChecksum::MemServerChecksum(const unsigned short uStart,
    const unsigned short uEnd, unsigned char uchType)
{
    // Assertion of the input parameters.
    
    // Set the server flag.
    m_isServer = TRUE;
    
    // Set the parameter.
    m_StartAddr = CMemoryAddr(uStart, uchType);
    m_EndAddr = CMemoryAddr(uEnd, uchType);
    
    // Memory Checksum kernel routine.
    MemoryChecksumKernel();
    
    if ( ICE_OK != m_nErrorID ) {
        return (-1);
    }
    else {
        return (m_uChecksum);
    }

}   // End of CMemoryChecksum::MemServerChecksum().

//////////////////////////////// End of File ////////////////////////////////
