
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMCHK.H__   1.13   13 Dec 1996 11:18:52   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMCHK.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:52   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:52   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:10   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:06   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:26   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:46   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:36   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:52   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:28   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:34:28   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:48:38   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:29:48   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:07:36   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:08   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMCHK.H
//
//  Description: The header file for the class: CMemoryChecksum.
//
//  Author: Chen Jun
//
//  Date: 04/29/95
//
//  Modification:
//      1. 04/29/95, Initial version of the class: CMemoryChecksum.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _MEMCHK_
#define _MEMCHK_

#include "membase.h"


/////////////////////////////////////////////////////////////////////////////
// CMemoryChecksum class.
class CMemoryChecksum : public CMemoryBase
{
// Construction & Destruction.
public:
    CMemoryChecksum();
    ~CMemoryChecksum();
    
// Member variables.
private:
    CMemoryAddr m_StartAddr, m_EndAddr;
    
    UINT m_uChecksum;

// Implementations.
private:
    void MemoryChecksumKernel(void);
    void DisplayChecksum(UINT uChecksum);

public:
    void ChecksumAction(int nArgc, char* pszArgv[]);
    long MemServerChecksum(const unsigned short uStart,
        const unsigned short uEnd, unsigned char uchType);

};  // End of class: CMemoryChecksum.

#endif
//////////////////////////////// End of File ////////////////////////////////
