
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMCOMP.CPP   1.13   13 Dec 1996 11:18:52   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMCOMP.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:52   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:52   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:10   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:06   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:14   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:28   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:26   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:46   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:20   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:31:50   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:45:36   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:26:42   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:05:16   ZJRD
** PIC/SLD Version 0.20
** 
**    Rev 1.0   13 Aug 1996 09:18:00   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMCOMP.CPP
//
//  Description: The implementation file for the class: CMemoryCompare.
//
//  Author: Chen Jun
//
//  Date: 04/29/95
//
//  Modification:
//      1. 04/29/95, Initial version of the class: CMemoryCompare.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memcomp.h"
#include "hosterrs.h"
#include "abiextfn.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void CompareCmd(int nArgc, char* pszArgv[]);
BOOL MemServerCompare(unsigned short uStart, unsigned short uEnd,
    unsigned short uTarget, 
    unsigned char uchSourceType, unsigned char uchTargetType,
    unsigned short& uSource, char* pszResult);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
//#ifndef _SERVER_NO_ABI
//    extern STATUS AbiCompare(ADDR addr1, ADDR addr2, ADDR destAddr,
//                             ADDR* retAddr);
//    extern STATUS AbiGetMemN(ADDR addr1, ADDR addr2, char* pchBuff);
//#endif  // _SERVER_NO_ABI
extern BOOL GetCpuStatus(unsigned char &);
extern void ShowLine(char *);


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CompareCmd().
//
//  Description: The main control routine of Compare command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CompareCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 4 == nArgc || 5 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    char error[128];
    // Compare EMM contents.
    CMemoryCompare* pMemoryCompare = new CMemoryCompare;
    if ( !pMemoryCompare ) {
        ErrDisplayError(ER_OUT_OF_MEMORY, 0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
            pMemoryCompare->CompareAction(nArgc, pszArgv);
            delete pMemoryCompare;
          }           
       }   
    }

//    CMemoryCompare objCompare;
//    objCompare.MemoryCompare(nArgc, pszArgv);

}   // End of CompareCmd().


// Memory Compare server.
BOOL MemServerCompare(unsigned short uStart, unsigned short uEnd,
    unsigned short uTarget, 
    unsigned char uchSourceType, unsigned char uchTargetType,
    unsigned short& uSource, char* pszResult)
{
    // Assertion of the input parameters.
    ASSERT( pszResult );

    // Compare EMM contents.
    CMemoryCompare* pMemoryCompare = new CMemoryCompare;
    if ( !pMemoryCompare ) {
        ErrDisplayError(ER_OUT_OF_MEMORY, 0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return (FALSE);
    }
    else {
        BOOL isMismatch =
            pMemoryCompare->MemServerCompare(uStart, uEnd, uTarget, 
                uchSourceType, uchTargetType, uSource, pszResult);
        delete pMemoryCompare;
        return (isMismatch);
    }

}   // End of MemServerCompare().



/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryCompare.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryCompare::CMemoryCompare().
//
//  Description: The construction of the class: CMemoryCompare.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryCompare::CMemoryCompare()
{

}   // End of CMemoryCompare::CMemoryCompare().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryCompare::~CMemoryCompare().
//
//  Description: The destruction of the class: CMemoryCompare.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryCompare::~CMemoryCompare()
{

}   // End of CMemoryCompare::~CMemoryCompare().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryCompare::CompareAction().
//
//  Description: Compare EMM.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryCompare::CompareAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 4 == nArgc || 5 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set Start address & End address.
    if ( 4 == nArgc ) {
        // Compare adr1 adr2 adr3.
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[2], m_EndAddr);
        SetAddrVar(pszArgv[3], m_TargetAddr);
        if ( ':' != pszArgv[3][1] ) {
            if ( ':' != pszArgv[1][1] ) {
//                m_TargetAddr.m_uchType = MEM_EXTERNAL;
                m_TargetAddr.m_uchType = MEM_PROGRAM;
            }
            else {
                m_TargetAddr.m_uchType = m_StartAddr.m_uchType;
            }
        }
    }
    else if ( 5 == nArgc ) {
        // Compare adr1 Length length adr3.
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[1], pszArgv[3], m_EndAddr);
        SetAddrVar(pszArgv[4], m_TargetAddr);
        if ( ':' != pszArgv[4][1] ) {
            if ( ':' != pszArgv[1][1] ) {
//                m_TargetAddr.m_uchType = MEM_EXTERNAL;
                m_TargetAddr.m_uchType = MEM_PROGRAM;
            }
            else {
                m_TargetAddr.m_uchType = m_StartAddr.m_uchType;
            }
        }
    }
    else {
        ASSERT( FALSE );
        return;
    }
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] ) {
//        m_StartAddr.m_uchType = MEM_EXTERNAL;
        m_StartAddr.m_uchType = MEM_PROGRAM;
    }
    m_EndAddr.m_uchType = m_StartAddr.m_uchType;
    
    // Memory Compare kernel routine.
    MemoryCompareKernel();
        
}   // End of CMemoryCompare::CompareAction().


void CMemoryCompare::MemoryCompareKernel(void)
{
    // Assertion of the input parameters.
    
    // Call Abi routine.
    m_nErrorID = AbiCompare((ADDR&) m_StartAddr, (ADDR&) m_EndAddr,
                            (ADDR&) m_TargetAddr, &(ADDR&) m_SrcAddr);
    
    if ( 5 == m_nErrorID ) {
        // No difference.
        ShowLine("No different data.");
        m_bServerRet = FALSE;
    }
    else if ( 6 == m_nErrorID ) {
        // Display difference.
        DisplayDifferent();
        m_bServerRet = TRUE;
    }
    else if ( 0 != m_nErrorID ) {
        // Display error message.
        DisplayErrorMessage();
        m_bServerRet = FALSE;
    }
    else {
        m_bServerRet = FALSE;
        ASSERT( FALSE );
    }
        
}   // End of CMemoryCompare::MemoryCompareKernel().


void CMemoryCompare::DisplayDifferent(void)
{
    // Assertion of the input parameters.
    
    // Format result string.
    m_DestAddr = m_TargetAddr + (m_SrcAddr - m_StartAddr);
    char pszData[20];
    WORD wData[1];
    strcpy(m_pszResult, "Different data at: ");
    if ( !GetDiffCell(m_SrcAddr, wData) ) {
        DisplayErrorMessage();
        return;
    }
    else {
        char chType;
        switch ( m_SrcAddr.m_uchType ) {
            case MEM_PROGRAM:
                chType = 'P';
                break;
            case MEM_EXTERNAL:
                chType = 'X';
                break;
            case MEM_INTERNAL:
                chType = 'R';
//                chType = 'I';
                break;
            case MEM_SFR:
                chType = 'R';
                break;
            case MEM_BIT:
                chType = 'B';
                break;
            default:
                ASSERT( FALSE );
                break;
        }
//        wsprintf(pszData, "( %c:%04X ) = %02X,  ", 
//                    chType, m_SrcAddr.m_uAddr, (unsigned char)pszData[0]);
        wsprintf(pszData, "( %c:%04X ) = %04X,  ", 
                    chType, m_SrcAddr.m_uAddr, wData[0]);
        strcat(m_pszResult, pszData);
    }
        
    if ( !GetDiffCell(m_DestAddr, wData) ) {
        DisplayErrorMessage();
        return;
    }
    else {
        char chType;
        switch ( m_DestAddr.m_uchType ) {
            case MEM_PROGRAM:
                chType = 'P';
                break;
            case MEM_EXTERNAL:
                chType = 'X';
                break;
            case MEM_INTERNAL:
                chType = 'R';
//                chType = 'I';
                break;
            case MEM_SFR:
                chType = 'R';
                break;
            case MEM_BIT:
                chType = 'B';
                break;
            default:
                ASSERT( FALSE );
                break;
        }
//        wsprintf(pszData, "( %c:%04X ) = %02X", 
//                    chType, m_DestAddr.m_uAddr, (unsigned char)pszData[0]);
        wsprintf(pszData, "( %c:%04X ) = %04X", 
                    chType, m_DestAddr.m_uAddr, wData[0]);
        strcat(m_pszResult, pszData);
    }
    
    // Display the Compare result.
    ShowLine(m_pszResult);

}   // End of CMemoryCompare::DisplayDifferent().


BOOL CMemoryCompare::GetDiffCell(CMemoryAddr DiffAddr, WORD* pszData)
{
    // Assertion of the input parameters.
    ASSERT( pszData );
    
    // Call Abi routine.
    m_nErrorID = AbiGetMemN((ADDR&) DiffAddr, (ADDR&) DiffAddr, pszData);
    if ( 0 != m_nErrorID ) {
        return (FALSE);
    }
        
    return (TRUE);

}   // End of CMemoryCompare::GetDiffCell().


BOOL CMemoryCompare::MemServerCompare(unsigned short uStart, 
    unsigned short uEnd, unsigned short uTarget, 
    unsigned char uchSourceType, unsigned char uchTargetType,
    unsigned short& uSource, char* pszResult)
{
    // Assertion of the input parameters.
    ASSERT( uchSourceType >= MEM_PROGRAM && uchSourceType <= MEM_BIT );
    ASSERT( uchTargetType >= MEM_PROGRAM && uchTargetType <= MEM_BIT );

    // Set the server flag.
    m_isServer = TRUE;
        
    // Set the parameters.
    m_StartAddr = CMemoryAddr(uStart, uchSourceType);
    m_EndAddr = CMemoryAddr(uEnd, uchSourceType);
    m_TargetAddr = CMemoryAddr(uTarget, uchTargetType);
    
    // Memory Compare kernel routine.
    MemoryCompareKernel();
    if ( m_bServerRet ) {
        strcpy(pszResult, m_pszResult);
        uSource = m_SrcAddr.m_uAddr;
    }
    return (m_bServerRet);

}   // End of CMemoryCompare::MemServerCompare().

//////////////////////////////// End of File ////////////////////////////////
