
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMCOMP.H__   1.13   13 Dec 1996 11:18:54   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMCOMP.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:54   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:52   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:10   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:06   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:32   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:48   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:44   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:04   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:38   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:32:32   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:46:22   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:27:28   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:05:52   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:18   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMCOMP.H
//
//  Description: The header file for the class: CMemoryCompare.
//
//  Author: Chen Jun
//
//  Date: 04/29/95
//
//  Modification:
//      1. 04/29/95, Initial version of the class: CMemoryCompare.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _MEMCOMP_
#define _MEMCOMP_

#include "membase.h"


/////////////////////////////////////////////////////////////////////////////
// CMemoryCompare class.
class CMemoryCompare : public CMemoryBase
{
// Construction & Destruction.
public:
    CMemoryCompare();
    ~CMemoryCompare();
    
// Member variables.
private:
    CMemoryAddr m_StartAddr, m_EndAddr, m_TargetAddr, m_SrcAddr, m_DestAddr;
    BOOL m_bServerRet;
    
// Implementations.
private:
    void MemoryCompareKernel(void);
    void DisplayDifferent(void);
//    BOOL GetDiffCell(CMemoryAddr DiffAddr, char* pszData);
    BOOL GetDiffCell(CMemoryAddr DiffAddr, WORD* pszData);

public:
    void CompareAction(int nArgc, char* pszArgv[]);
    BOOL MemServerCompare(unsigned short uStart, unsigned short uEnd,
        unsigned short uTarget, 
        unsigned char uchSourceType, unsigned char uchTargetType,
        unsigned short& uSource, char* pszResult);

};  // End of class: CMemoryCompare.

#endif
//////////////////////////////// End of File ////////////////////////////////
