
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMCOPY.CPP   1.13   13 Dec 1996 11:18:54   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMCOPY.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:54   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:52   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:10   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:06   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:00   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:22   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:10   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:24   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:00   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:36   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:00   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:06   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:34   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:38   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMCOPY.CPP
//
//  Description: The implementation file for the class: CMemoryCopy.
//
//  Author: Chen Jun
//
//  Date: 05/04/95
//
//  Modification:
//      1. 05/04/95, Initial version of the class: CMemoryCopy.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memcopy.h"
#include "hosterrs.h"
#include "abiextfn.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void CopyCmd(int nArgc, char* pszArgv[]);
void MemServerCopy(unsigned short uStart, unsigned short uEnd,
    unsigned short uTarget, 
    unsigned char uchSourceType, unsigned char uchTargetType);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
//#ifndef _SERVER_NO_ABI
//    extern STATUS AbiCopy(ADDR addr1, ADDR addr2, ADDR destAddr);
//#endif  // _SERVER_NO_ABI

void SrcUpdate(void);
extern BOOL GetCpuStatus(unsigned char &);
extern void ShowLine(char *);


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CopyCmd().
//
//  Description: The main control routine of Copy command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CopyCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 4 == nArgc || 5 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Copy EMM contents.
    char error[128];
    CMemoryCopy* pMemoryCopy = new CMemoryCopy;
    if ( !pMemoryCopy ) {
        ErrDisplayError(ER_OUT_OF_MEMORY, 0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
            pMemoryCopy->CopyAction(nArgc, pszArgv);
            delete pMemoryCopy;
          }           
       }   
    }

//    CMemoryCopy objCopy;
//    objCopy.MemoryCopy(nArgc, pszArgv);

}   // End of CopyCmd().


// Memory Copy server.
void MemServerCopy(unsigned short uStart, unsigned short uEnd,
    unsigned short uTarget, 
    unsigned char uchSourceType, unsigned char uchTargetType)
{
    // Assertion of the input parameters.

    // Copy EMM contents.
    CMemoryCopy* pMemoryCopy = new CMemoryCopy;
    if ( !pMemoryCopy ) {
        ErrDisplayError(ER_OUT_OF_MEMORY, 0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pMemoryCopy->MemServerCopy(uStart, uEnd, uTarget, 
            uchSourceType, uchTargetType);
        delete pMemoryCopy;
    }

}   // End of MemServerCopy().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryCopy.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryCopy::CMemoryCopy().
//
//  Description: The construction of the class: CMemoryCopy.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryCopy::CMemoryCopy()
{

}   // End of CMemoryCopy::CMemoryCopy().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryCopy::~CMemoryCopy().
//
//  Description: The destruction of the class: CMemoryCopy.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryCopy::~CMemoryCopy()
{

}   // End of CMemoryCopy::~CMemoryCopy().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryCopy::CopyAction().
//
//  Description: Copy to EMM.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryCopy::CopyAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 4 == nArgc || 5 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set Start address & End address.
    if ( 4 == nArgc ) {
        // Copy adr1 adr2 adr3.
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[2], m_EndAddr);
        SetAddrVar(pszArgv[3], m_TargetAddr);
        if ( ':' != pszArgv[3][1] ) {
            if ( ':' != pszArgv[1][1] ) {
//                m_TargetAddr.m_uchType = MEM_EXTERNAL;
                m_TargetAddr.m_uchType = MEM_PROGRAM;
            }
            else {
                m_TargetAddr.m_uchType = m_StartAddr.m_uchType;
            }
        }
    }
    else if ( 5 == nArgc ) {
        // Copy adr1 Length length adr3.
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[1], pszArgv[3], m_EndAddr);
        SetAddrVar(pszArgv[4], m_TargetAddr);
        if ( ':' != pszArgv[4][1] ) {
            if ( ':' != pszArgv[1][1] ) {
//                m_TargetAddr.m_uchType = MEM_EXTERNAL;
                m_TargetAddr.m_uchType = MEM_PROGRAM;
            }
            else {
                m_TargetAddr.m_uchType = m_StartAddr.m_uchType;
            }
        }
    }
    else {
        ASSERT( FALSE );
        return;
    }
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] ) {
//        m_StartAddr.m_uchType = MEM_EXTERNAL;
        m_StartAddr.m_uchType = MEM_PROGRAM;
    }
    m_EndAddr.m_uchType = m_StartAddr.m_uchType;

    // Memory Copy kernel routine.
    MemoryCopyKernel();
        
}   // End of CMemoryCopy::CopyAction().


void CMemoryCopy::MemoryCopyKernel(void)
{
    // Assertion of the input parameters.
    
    // Call Abi routine.
    m_nErrorID = 
        AbiCopy((ADDR&)m_StartAddr, (ADDR&)m_EndAddr, (ADDR&)m_TargetAddr);
        
    // Update Source window.
    if ( MEM_PROGRAM == m_TargetAddr.m_uchType ) {
        ::SrcUpdate();
    }
    
    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
    }
        
}   // End of CMemoryCopy::MemoryCopyKernel().


// Memory Copy server.
void CMemoryCopy::MemServerCopy(unsigned short uStart, unsigned short uEnd,
        unsigned short uTarget, 
        unsigned char uchSourceType, unsigned char uchTargetType)
{
    // Assertion of the input parameters.
    ASSERT( uchSourceType >= MEM_PROGRAM && uchSourceType <= MEM_BIT );
    ASSERT( uchTargetType >= MEM_PROGRAM && uchTargetType <= MEM_BIT );
    
    // Set the server flag.
    m_isServer = TRUE;
        
    // Set the parameters.
    m_StartAddr = CMemoryAddr(uStart, uchSourceType);
    m_EndAddr = CMemoryAddr(uEnd, uchSourceType);
    m_TargetAddr = CMemoryAddr(uTarget, uchTargetType);
    
    // Memory Copy kernel routine.
    MemoryCopyKernel();

}   // End of CMemoryCopy::MemServerCopy().

//////////////////////////////// End of File ////////////////////////////////
