
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMDSM.CPP   1.13   13 Dec 1996 11:18:54   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMDSM.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:54   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:54   ZJRD
** PIC/SLD Version 0.97
** 
**    Rev 1.11   11 Nov 1996 12:47:12   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:08   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:48   ZJRD
** PIC/SLD Version 0.94
** 
**    Rev 1.8   30 Oct 1996 12:50:12   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:00   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.6   21 Oct 1996 09:17:14   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.5   09 Oct 1996 13:46:50   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.4   23 Sep 1996 10:35:18   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:34   ZJRD
** PIC/SLD Version 0.60
** 
**    Rev 1.2   02 Sep 1996 11:30:42   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:08:18   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:28   ZJRD
** Initial revision.
** 
****************************************************************************/

//#include "dad.h"
#include "stdafx.h"
#include "memdsm.h" 
#include "dsmedit1.h"
#include "dsmedit2.h" 

extern BOOL GetCpuStatus(unsigned char & uchStatus);
                   
CMemDsm::CMemDsm(int f,int nWords)
{
    m_dsm=(DADMEMSTRU*)new DADMEMSTRU[51];
    m_szScroll=CSize(160,nWords);   
    m_nWords=nWords;
    m_ptFirst=CPoint(0,f);
}  
CMemDsm::~CMemDsm()
{         
    if(m_dsm!=NULL)
    {
    	delete []m_dsm;
    	m_dsm=NULL;
    }	
}
extern int GetDsm (WORD, int, DADMEMSTRU*, int);  
BOOL CMemDsm::GetInstruction(int address,int line,DADMEMSTRU* m_dsm)
{
  GetDsm(address, line, (DADMEMSTRU*)m_dsm, 0);
 ASSERT(line<=50);    
// GetDsm(address, line, m_dsm,1);
/*for(int i=0;i<line;i++)
 {
    m_dsm->address=address+i;
    sprintf(m_dsm->code,"abcd");
    sprintf(m_dsm->instruction,"kdjfjkflkldsa");
    m_dsm++;
 }
*/     
 return 1;
}                 
 

void CMemDsm::DrawGrid(CDC*pDC,CRect rectClient)
{
    int nWidth=rectClient.right;
    CPen *pGrayPen,* pOldPen;
    pGrayPen=new CPen;
    pGrayPen->CreatePen(PS_SOLID,1,PALETTEINDEX(11));
    pOldPen=pDC->SelectObject(pGrayPen);
    CRect  rect(0,0,nWidth,17);
    ::FillRect(pDC->m_hDC,&rect,(HBRUSH)::GetStockObject(LTGRAY_BRUSH) );
    rect.right=ADDR_WIDTH;
    rect.bottom=rectClient.bottom;
    ::FillRect(pDC->m_hDC,&rect,(HBRUSH)::GetStockObject(LTGRAY_BRUSH) );
    pDC->MoveTo(ADDR_WIDTH,0);
    pDC->LineTo(ADDR_WIDTH,rectClient.bottom);
    
    pDC->MoveTo(ADDR_WIDTH+CODE_WIDTH-m_ptFirst.x,0);
    pDC->LineTo(ADDR_WIDTH+CODE_WIDTH-m_ptFirst.x,rectClient.bottom);
    
    pDC->MoveTo(0,17);
    pDC->LineTo(rectClient.right,17);
    
    int nHeight=17;
    while(rectClient.bottom>nHeight+17)
    {   
        nHeight+=17;        
        pDC->MoveTo(0,nHeight);
        pDC->LineTo(rectClient.right,nHeight);//-m_ptFirst.y*m_nLineHeight);
    }               
    pDC->SelectObject(pOldPen);
    pGrayPen->DeleteObject();
    delete pGrayPen;  
    pOldPen=(CPen*)pDC->SelectStockObject(WHITE_PEN);
//3D Style White                                         
    pDC->MoveTo(rectClient.right,0);
    pDC->LineTo(0,0);
    pDC->LineTo(0,rectClient.bottom);

    nHeight=17+1;
    while(rectClient.bottom>nHeight+17)
    {   
        nHeight+=17;        
        pDC->MoveTo(0,nHeight);
        pDC->LineTo(ADDR_WIDTH,nHeight);//-m_ptFirst.y*m_nLineHeight);
    }                   
    
    pDC->MoveTo(ADDR_WIDTH+1,0);
    pDC->LineTo(ADDR_WIDTH+1,17);
    pDC->MoveTo(ADDR_WIDTH+1+CODE_WIDTH-m_ptFirst.x,0);
    pDC->LineTo(ADDR_WIDTH+1+CODE_WIDTH-m_ptFirst.x,17);
   
    pDC->SelectObject(pOldPen);

//3D Style Black 
    pDC->MoveTo(0,17);
    pDC->LineTo(rectClient.right,17);
    pDC->MoveTo(ADDR_WIDTH,0);
    pDC->LineTo(ADDR_WIDTH,rectClient.bottom);

    pDC->MoveTo(ADDR_WIDTH,0);
    pDC->LineTo(ADDR_WIDTH,17);
    pDC->MoveTo(ADDR_WIDTH+CODE_WIDTH-m_ptFirst.x,0);
    pDC->LineTo(ADDR_WIDTH+CODE_WIDTH-m_ptFirst.x,17);

    nHeight=17;
    while(rectClient.bottom>nHeight+17)
    {   
        nHeight+=17;        
        pDC->MoveTo(0,nHeight);
        pDC->LineTo(ADDR_WIDTH,nHeight);//-m_ptFirst.y*m_nLineHeight);
    }               
}

void CMemDsm::DrawDsm(CDC*pDC,DADMEMSTRU dsm,int line,CRect rectClient)
{
    CRect rect(0,0,0,0),rectClip;
   
    if(dsm.address>m_nWords) return ;
    char szAddr[8]="";
    rect.top=(line+1)*17;
    rect.bottom=rect.top+17;
    rect.right=ADDR_WIDTH;   
    sprintf(szAddr,"%03X",dsm.address);
    pDC->DrawText(szAddr,3,&rect,DT_CENTER);
    
    rect.left=rect.right;
    rect.right=rect.left+CODE_WIDTH; 
    rectClip=rect;
    rect.OffsetRect(-m_ptFirst.x,0);              
    pDC->ExtTextOut(rect.left+3,rect.top+1,ETO_CLIPPED,&rectClip,
            dsm.code,4,NULL);

    rect.left=ADDR_WIDTH+CODE_WIDTH;  
    rect.right=3000;
    rectClip=rect;
    rectClip.left=ADDR_WIDTH;
    rect.OffsetRect(-m_ptFirst.x,0);                              
    pDC->ExtTextOut(rect.left+3,rect.top+1,ETO_CLIPPED,&rectClip,
            dsm.instruction,strlen(dsm.instruction),NULL);   

}

void CMemDsm::Draw(CDC*pDC,CRect rectClient)
{
    pDC->SetBkMode(TRANSPARENT);
    DrawGrid(pDC,rectClient);     

    CRect rect(0,0,0,0),rectClip;
    rect.bottom=rect.top+17;
    rect.right=ADDR_WIDTH;   
    pDC->DrawText("Addr",4,&rect,DT_CENTER);
    

    rect.left=rect.right;
    rect.right=rect.left+CODE_WIDTH; 
    rectClip=rect;
    rect.OffsetRect(-m_ptFirst.x,0);              
    pDC->ExtTextOut(rect.left+5,rect.top+1,ETO_CLIPPED,&rectClip,
            "Code",4,NULL);

    rect.left=ADDR_WIDTH+CODE_WIDTH;  
    rect.right=3000;
    rectClip=rect;
    rectClip.left=ADDR_WIDTH;
    rect.OffsetRect(-m_ptFirst.x,0);                              
    pDC->ExtTextOut(rect.left+5,rect.top+1,ETO_CLIPPED,&rectClip,
            "Instruction",11,NULL);
                    
    int lines=rectClient.bottom/17;
    for(int j=0;j<lines;j++)
    {
        if(m_dsm[j].address==0xffff) break;
        DrawDsm(pDC,m_dsm[j],j,rectClient); 
    }    
        
}

void CMemDsm::VScroll(CWnd*pWnd,UINT nSBCode, UINT nPos, CScrollBar*,CRect rectClient)
{
    // TODO: Add your message handler code here and/or call default
    CRect rect; 
    rect=rectClient;
    int i;
    rect.left=0;
    rect.top=17+1;
    int nPageRange=rectClient.bottom/17-1;
    switch(nSBCode) {
        case SB_LINEUP:
            if(m_ptFirst.y <= 0)  return;
              i = 1;
            m_ptFirst.y --;      
            m_nFirstViewableWord--;                          
            GetInstruction(m_nFirstViewableWord,50,m_dsm);
            pWnd->ScrollWindow(0, i*17,&rect, &rect);
            pWnd->SetScrollPos(SB_VERT, m_ptFirst.y); 
//          m_ptCaretPos.y++;
//          SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_LINEDOWN:    
            if(m_ptFirst.y>= m_szScroll.cy)    return;
            i =1     ;
            m_ptFirst.y ++;;
            m_nFirstViewableWord++;
            GetInstruction(m_nFirstViewableWord,50,m_dsm);
            pWnd->ScrollWindow(0,-i*17,&rect,&rect);
            pWnd->SetScrollPos(SB_VERT, m_ptFirst.y);
//          m_ptCaretPos.y--;
//          SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_PAGEUP: 
            if(m_ptFirst.y == 0)    return;
            i=nPageRange;
            if(m_ptFirst.y<nPageRange)
            {
				i=m_ptFirst.y;            	
            	m_ptFirst.y=0;
            	m_nFirstViewableWord=0; 
            }
            else
            {	
            	m_ptFirst.y -=nPageRange ;
            	m_nFirstViewableWord-=nPageRange;
            }	
            GetInstruction(m_nFirstViewableWord,50,m_dsm);
            pWnd->ScrollWindow(0,i*17 ,&rect,&rect);
//            m_ptCaretPos.y-=m_nPageRange;
            pWnd->SetScrollPos(SB_VERT, m_ptFirst.y);
//            SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_PAGEDOWN:
            if(m_ptFirst.y >= m_szScroll.cy)    return;
            i=nPageRange; 
            if(m_ptFirst.y+i>m_szScroll.cy)
            {
            	m_ptFirst.y=m_szScroll.cy;   
            	m_nFirstViewableWord=m_szScroll.cy; 
            }
            else
            {	
            	m_ptFirst.y +=nPageRange;
            	m_nFirstViewableWord+=nPageRange;
            }	
            GetInstruction(m_nFirstViewableWord,50,m_dsm);
            pWnd->InvalidateRect(&rect);
            pWnd->ScrollWindow(0, -i*17,&rect,&rect);
 
            //m_ptCaretPos.y+=m_nPageRange;
            pWnd->SetScrollPos(SB_VERT, m_ptFirst.y);
//            SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_THUMBTRACK:  
                                                     
        case SB_THUMBPOSITION:           
            if(nPos==m_ptFirst.y) return ;
            i=m_ptFirst.y-nPos;
            m_ptFirst.y=nPos;
            m_nFirstViewableWord=nPos; 
            
            GetInstruction(m_nFirstViewableWord,50,m_dsm);
            pWnd->InvalidateRect(&rect);
            pWnd->ScrollWindow(0, -i*17,&rect,&rect);
 
            //m_ptCaretPos.y+=m_nPageRange;
            pWnd->SetScrollPos(SB_VERT, m_ptFirst.y);
            break;
    }  
}

void CMemDsm::HScroll(CWnd*pWnd,UINT nSBCode, UINT nPos, CScrollBar* ,CRect rectClient)
{
    CRect rect;
    rect=rectClient;
    rect.top=0;
    rect.left=ADDR_WIDTH+2;
    int i;                                
    switch(nSBCode) {
        
        case SB_LINELEFT:                 
            if(m_ptFirst.x <= 0)  return;  
            i =5;
            m_ptFirst.x -= i;;   
            pWnd->ScrollWindow(i, 0,&rect,&rect);
            pWnd->SetScrollPos(SB_HORZ, m_ptFirst.x);

//            SetMemCaretPos(m_ptCaretPos);
            break;
        case SB_LINERIGHT:
            if(m_ptFirst.x >= m_szScroll.cx)    return;
               i =5;
            m_ptFirst.x += i;
            pWnd->ScrollWindow(-i,0,&rect,&rect);
            pWnd->SetScrollPos(SB_HORZ, m_ptFirst.x);
//           SetMemCaretPos(m_ptCaretPos);
            break;     
        case SB_PAGELEFT: 
            if(m_ptFirst.x == 0)    return;
            i = m_ptFirst.x;
            m_ptFirst.x =0;   
            pWnd->ScrollWindow(i, 0,&rect,&rect);
            pWnd->SetScrollPos(SB_HORZ, m_ptFirst.x);
            break;
        case SB_PAGERIGHT:
            if(m_ptFirst.x >= m_szScroll.cx)    return;
            i =m_szScroll.cx-m_ptFirst.x;
            m_ptFirst.x =m_szScroll.cx;
            pWnd->ScrollWindow(-i, 0,&rect,&rect);
            pWnd->SetScrollPos(SB_HORZ, m_ptFirst.x);
            break;
        case SB_THUMBTRACK:
            
        case SB_THUMBPOSITION:           
            break;
        default: break;
       }     
}


BOOL CMemDsm::SetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
    if( message==WM_RBUTTONDOWN)       
        return FALSE; 
    return 1;    
}   


void CMemDsm::LButtonDblClk(CWnd* pWnd,UINT nFlags, CPoint point)
{
    unsigned char  uchStatus;
    GetCpuStatus(uchStatus);
    if(uchStatus==1){
        AfxMessageBox("Please Halt the CPU first !" ,MB_OK);
        return ;
    }     
        
    if(point.x>ADDR_WIDTH&&
       point.x<ADDR_WIDTH+CODE_WIDTH-m_ptFirst.x&&
       point.y/17-1+m_ptFirst.y<m_nWords)
    {   
    	CDsmEdit1 *pDsmEdit1;
        pDsmEdit1= new CDsmEdit1(pWnd);  
        pDsmEdit1->m_lAddress=point.y/17-1+m_ptFirst.y;
        pDsmEdit1->m_nSpaceType=1;
// Modified by Gates Hua -- start
//        if(1==pDsmEdit1->DoModal() )
//        {
//            GetInstruction(m_nFirstViewableWord,50,m_dsm);
//            pWnd->Invalidate();
//            pWnd->UpdateWindow();
//        }
		pDsmEdit1->DoModal();    
// --- end		
				
        delete pDsmEdit1;
    }
    else
      if(point.x>ADDR_WIDTH&&
         point.x>ADDR_WIDTH+CODE_WIDTH-m_ptFirst.x&&
         point.y/17-1+m_ptFirst.y<m_nWords)
      { 
        CDsmEdit2 *pDsmEdit2;
        pDsmEdit2= new CDsmEdit2(pWnd);
        pDsmEdit2->m_lAddress=point.y/17-1+m_ptFirst.y;
        pDsmEdit2->m_nSpaceType=1;
// Modified by Gates Hua , -- start        
//        if(1==pDsmEdit2->DoModal() )
//        {
//            GetInstruction(m_nFirstViewableWord,50,m_dsm);
//            pWnd->Invalidate();
//            pWnd->UpdateWindow();
//        }     
		pDsmEdit2->DoModal();
// -- end                    

        delete pDsmEdit2;
      }      
                
}


void CMemDsm::Size(CWnd *pWnd,UINT nType, int cx, int cy)
{
	m_szScroll.cy=m_nWords-cy/17+1;
	pWnd->SetScrollRange(SB_VERT,0,m_szScroll.cy);   
}

