
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMDUMP.H__   1.13   13 Dec 1996 11:18:56   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMDUMP.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:18:56   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:56   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:12   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:08   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:52   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:16   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:02   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:18   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:52   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:24   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:44   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:50   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:24   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:32   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMDUMP.H
//
//  Description: The header file for the class: CMemoryDump.
//
//  Author: Chen Jun
//
//  Date: 04/21/95
//
//  Modification:
//      1. 04/21/95, Initial version of the class: CMemoryDump.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _MEMDUMP_
#define _MEMDUMP_

#include "membase.h"


/////////////////////////////////////////////////////////////////////////////
// CMemoryDump class.
class CMemoryDump : public CMemoryBase
{
// Construction & Destruction.
public:
    CMemoryDump();
    ~CMemoryDump();
    
// Member variables.
private:
    CMemoryAddr m_StartAddr, m_EndAddr;
    
    enum { MAX_DUMP_SIZE = 256 };
//    char m_pchDump[MAX_DUMP_SIZE];
    WORD m_pchDump[MAX_DUMP_SIZE];
    
    unsigned short m_uSize;
    
    char m_pszAddr[2+4+1];
    char m_pszData[16*3+1];
    char m_pszASCII[16+1];
    
// Implementations.
private:
    void MemoryDumpKernel(void);
    void DisplayDumpHead(void);
    void FormatDumpInfo(const CMemoryAddr& StartAddr);

public:
    void DumpAction(int nArgc, char* pszArgv[]);
    long MemServerDump(WORD* pchDump, WORD uAddr, int nSize, int nType);

};  // End of class: CMemoryDump.

#endif
//////////////////////////////// End of File ////////////////////////////////
