
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMFILL.CPP   1.13   13 Dec 1996 11:18:56   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMFILL.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:56   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:56   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:14   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:08   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:18   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:38   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:30   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:48   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:24   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.4   23 Sep 1996 10:34:14   ZJRD
** PIC/SLD Version 0.70
** 
**    Rev 1.3   06 Sep 1996 13:48:24   ZJRD
** PIC/SLD Version 0.60
** 
**    Rev 1.2   02 Sep 1996 11:29:34   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:07:24   ZJRD
** PIC/SLD Version 0.20
** 
**    Rev 1.0   13 Aug 1996 09:19:02   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMFILL.CPP
//
//  Description: The implementation file for the class: CMemoryFill.
//
//  Author: Chen Jun
//
//  Date: 04/26/95
//
//  Modification:
//      1. 04/26/95, Initial version of the class: CMemoryFill.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memfill.h"
#include "hosterrs.h"
#include "abiextfn.h"

/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void FillCmd(int nArgc, char* pszArgv[]);
int MemServerFill(long lAddr, WORD wValue, int nType);
void MemServerFill(const unsigned short uStart, const unsigned short uEnd,
                   const unsigned char uchType, char* szPattern);
void MemServerFill(const unsigned short uStart, const unsigned short uEnd,
                   const unsigned char uchType, WORD* pwData);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
//#ifndef _SERVER_NO_ABI
//    extern STATUS AbiFill(ADDR addr1, ADDR addr2, char* pchBuff, 
//                          UINT uPatternLen);
//    extern ADDR AbiGetErrorAddr();
//#endif  // _SERVER_NO_ABI

void SrcUpdate(void);
extern BOOL GetCpuStatus(unsigned char &);
extern void ShowLine(char *);




/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   FillCmd().
//
//  Description: The main control routine of Fill command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void FillCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 4 == nArgc || 5 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Fill to EMM.
    char error[128];
    CMemoryFill* pMemoryFill = new CMemoryFill;
    if ( !pMemoryFill ) {
//        AfxMessageBox("Insufficient Memory !");
        ErrDisplayError(ER_OUT_OF_MEMORY,0);
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
            pMemoryFill->FillAction(nArgc, pszArgv);
            delete pMemoryFill;
          }           
       }   
    }

//    CMemoryFill objFill;
//    objFill.FillMemory(nArgc, pszArgv);

}   // End of FillCmd().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   MemServerFill().
//
//  Description: The main control routine of Fill Server.
//
//  Input:  lAddr - Start address.
//          bValue - Value which will be filled.    
//          nType - Memory space type.
//
//  Output: None.
//
//  Return: Error ID.
//
/////////////////////////////////////////////////////////////////////////////
int MemServerFill(long lAddr, WORD wValue, int nType)
{
    // Assertion of the input parameters.
    ASSERT( nType >= 1 && nType <= 5 );
//    ASSERT( nType == 1 );
    
    // Fill to EMM.
    CMemoryFill* pMemoryFill = new CMemoryFill;
    if ( !pMemoryFill ) {
        ErrDisplayError(ER_OUT_OF_MEMORY,0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return (0);
    }
    else {
        int nRetError = 
            pMemoryFill->MemServerFill((WORD) lAddr, wValue, nType);
        delete pMemoryFill;
        return (nRetError);
    }

//    CMemoryFill objFill;
//    int nRetError = objFill.MemServerFill((WORD) lAddr, bValue, nType);
//    return (nRetError);

}   // End of MemServerFill().

// Fill server for Fill dialog.
void MemServerFill(const unsigned short uStart, const unsigned short uEnd,
                   const unsigned char uchType, WORD* pwData)
{
    // Assertion of the input parameters.
    ASSERT( uchType >= 1 && uchType <= 5 );
//    ASSERT( uchType == 1 );

    // Fill to EMM.
    CMemoryFill* pMemoryFill = new CMemoryFill;
    if ( !pMemoryFill ) {
        ErrDisplayError(ER_OUT_OF_MEMORY,0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
    }
    else {
        pMemoryFill->MemServerFill(uStart, uEnd, uchType, pwData);
        delete pMemoryFill;
    }
}

// Fill server for Fill dialog.
void MemServerFill(const unsigned short uStart, const unsigned short uEnd,
                   const unsigned char uchType, char* pszPattern)
{
    // Assertion of the input parameters.
    ASSERT( uchType >= 1 && uchType <= 5 );
//    ASSERT( uchType == 1 );

    // Fill to EMM.
    CMemoryFill* pMemoryFill = new CMemoryFill;
    if ( !pMemoryFill ) {
        ErrDisplayError(ER_OUT_OF_MEMORY,0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
    }
    else {
        pMemoryFill->MemServerFill(uStart, uEnd, uchType, pszPattern);
        delete pMemoryFill;
    }
}


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryFill.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryFill::CMemoryFill().
//
//  Description: The construction of the class: CMemoryFill.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryFill::CMemoryFill()
{

}   // End of CMemoryFill::CMemoryFill().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryFill::~CMemoryFill().
//
//  Description: The destruction of the class: CMemoryFill.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryFill::~CMemoryFill()
{

}   // End of CMemoryFill::~CMemoryFill().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryFill::FillAction().
//
//  Description: Fill to EMM.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryFill::FillAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 4 == nArgc || 5 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set Start address & End address.
    if ( 4 == nArgc ) {
        // Fill adr1 adr2 "string"|data.
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[2], m_EndAddr);
        SetPattern(pszArgv[3]);
    }
    else if ( 5 == nArgc ) {
        // Fill adr1 Length length "string"|data.
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[1], pszArgv[3], m_EndAddr);
        SetPattern(pszArgv[4]);
    }
    else {
        ASSERT( FALSE );
        return;
    }
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] ) {
//        m_StartAddr.m_uchType = MEM_EXTERNAL;
        m_StartAddr.m_uchType = MEM_PROGRAM;
    }
    m_EndAddr.m_uchType = m_StartAddr.m_uchType;
    
    // Memory Fill kernel routine.
    MemoryFillKernel();
        
}   // End of CMemoryFill::FillAction().


void CMemoryFill::SetPattern(char* pszPattern)
{
    // Assertion of the input parameters.
    ASSERT( pszPattern );
    
    // Set the pattern buffer.
    if ( '\"' == *pszPattern ) {
        // Set "string".
        m_uPatternLen = strlen(pszPattern) - 2;
        pszPattern++;
        for (unsigned int i = 0; i < m_uPatternLen; i++, pszPattern++)
        	m_pchFill[i] = *pszPattern;
    }
    else {
        // Set Data: "12 34 ".
        int nNum = 4;
        if (m_StartAddr.m_uchType == MEM_PROGRAM) nNum = 4;
        
        m_uPatternLen = 0;
        while ( *pszPattern ) {
            char pszData[20];
            memset(pszData, 0, sizeof(pszData));
            for ( int i = 0;/* i <= nNum*/; i++ ) {
                if ( ' ' != *pszPattern ) {
                    pszData[i] = *pszPattern++;
                }
                else {
                    pszPattern++;
                    break;
                }
            }
            StrToVar(pszData);
            m_pchFill[m_uPatternLen++] = (WORD) m_ulVar;
        }
    }

}   // End of CMemoryFill::SetPattern().


void CMemoryFill::MemoryFillKernel(void)
{
    // Assertion of the input parameters.
    
    // Call Abi routine.
    m_nErrorID = AbiFill((ADDR&) m_StartAddr, (ADDR&) m_EndAddr,
                         m_pchFill, m_uPatternLen);

    // Update Source window.
    if ( MEM_PROGRAM == m_StartAddr.m_uchType ) {
        ::SrcUpdate();
    }

    // Get the error address.
    if ( ICE_FAIL_MEM_WRITE == m_nErrorID ) {
        m_FailAddr = (CMemoryAddr&) AbiGetErrorAddr();
        char chType;
        switch ( m_FailAddr.m_uchType ) {
            case MEM_UNDEFINE:
                switch ( m_StartAddr.m_uchType ) {
                    case MEM_PROGRAM:
                        chType = 'P';
                        break;
                    case MEM_EXTERNAL:
                        chType = 'X';
                        break;
                    case MEM_INTERNAL:
                        chType = 'R';
//                        chType = 'I';
                        break;
                    case MEM_SFR:
                        chType = 'R';
                        break;
                    case MEM_BIT:
                        chType = 'B';
                        break;
                    default:
                        ASSERT( FALSE );
                        break;
                }
                break;
            case MEM_PROGRAM:
                chType = 'P';
                break;
            case MEM_EXTERNAL:
                chType = 'X';
                break;
            case MEM_INTERNAL:
                chType = 'R';
//                chType = 'I';
                break;
            case MEM_SFR:
                chType = 'R';
                break;
            case MEM_BIT:
                chType = 'B';
                break;
            default:
                ASSERT( FALSE );
                break;
        }
        ErrGetErrorText(ER_ABI_MEM_WRITE1,m_pszResult,
                    chType, m_FailAddr.m_uAddr);
//        wsprintf(m_pszResult, "Memory write failure at: %c:%04X.",
//                    chType, m_FailAddr.m_uAddr);
        if ( !m_isServer ) {
            ShowLine(m_pszResult);
        }
        else {
            AfxMessageBox(m_pszResult);
        }
    }
    else if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
    }
        
}   // End of CMemoryFill::MemoryDumpKernel().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryFill::MemServerFill().
//
//  Description: Fill EMM for UI.
//
//  Input:  wAddr - Start address.
//          bValue - Value which will be filled.    
//          nType - Memory space type.
//
//  Output: None.
//
//  Return: Error ID.
//
/////////////////////////////////////////////////////////////////////////////
int CMemoryFill::MemServerFill(WORD wAddr, WORD wValue, int nType)
{
    // Assertion of the input parameters.
    ASSERT( nType >= 1 && nType <= 5 );

    // Set the parameters.
    CMemoryAddr StartAddr(wAddr, (unsigned char) nType);
    CMemoryAddr EndAddr = StartAddr;
    
    WORD pszBuffer[1];
    pszBuffer[0] = wValue;
        
    // Call ABI routine.
    m_nErrorID = AbiFill((ADDR&)StartAddr, (ADDR&)EndAddr, pszBuffer, 1);
    m_isServer = TRUE;

    // Update Source window.
    if ( MEM_PROGRAM == nType ) {
        ::SrcUpdate();
    }

    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
    }

    return (m_nErrorID);

}   // End of CMemoryFill::MemServerFill().

// Fill server for Fill dialog.
void CMemoryFill::MemServerFill(const unsigned short uStart, 
    const unsigned short uEnd, const unsigned char uchType, WORD* pwData)
{
    // Assertion of the input parameters.
    ASSERT( uchType >= MEM_PROGRAM && uchType <= MEM_BIT );
    
    // Set server flag.
    m_isServer = TRUE;

    // Set address.
    m_StartAddr = CMemoryAddr(uStart, uchType);
    m_EndAddr = CMemoryAddr(uEnd, uchType);

    // Set pattern.
	m_uPatternLen = m_EndAddr.m_uAddr - m_StartAddr.m_uAddr +1;
    memcpy(m_pchFill, pwData, m_uPatternLen);
//    SetPattern(pszPattern);
    
    // Memory Fill kernel routine.
    MemoryFillKernel();
    
}   // End of CMemoryFill::MemServerFill().

// Fill server for Fill dialog.
void CMemoryFill::MemServerFill(const unsigned short uStart, 
    const unsigned short uEnd, const unsigned char uchType, char* pszPattern)
{
    // Assertion of the input parameters.
    ASSERT( uchType >= MEM_PROGRAM && uchType <= MEM_BIT );
    
    // Set server flag.
    m_isServer = TRUE;

    // Set address.
    m_StartAddr = CMemoryAddr(uStart, uchType);
    m_EndAddr = CMemoryAddr(uEnd, uchType);

    // Set pattern.
    SetPattern(pszPattern);
    
    // Memory Fill kernel routine.
    MemoryFillKernel();
    
}   // End of CMemoryFill::MemServerFill().

//////////////////////////////// End of File ////////////////////////////////
