
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMLAY.CPP   1.13   13 Dec 1996 11:18:56   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMLAY.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:18:56   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:59:56   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:14   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:10   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:38   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:51:02   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:52   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.6   21 Oct 1996 09:18:00   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:34   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:36:56   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:51:38   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:32:46   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:09:56   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:20:14   ZJRD
** Initial revision.
** 
****************************************************************************/

#include "stdafx.h"
#include "memlay.h"
#include "cpucom.h"                         
#include "cpuserve.h"
    
extern long MemServerDump(WORD* pbDump, long lAddr, long lSize, int nType);    
extern int  GetMemoryRange(CPUMEMORYRANGE* stRange);
extern int MemServerFill(long lAddr, WORD wValue, int nType);
extern unsigned char gEPModule;

unsigned char Char2Value(UINT nChar)
{
    unsigned char ch;
    if(nChar>='0'&&nChar<='9')
    {   ch=nChar-'0';return ch;  }
    else if(nChar>='a'&&nChar<='f')
    {   ch=nChar-'a'+10;return ch;}
    else if(nChar>='A'&&nChar<='F')
    {   ch=nChar-'A'+10;return ch;}
    else ch=0xff;                          
    return ch;
}

BOOL CheckLegal(UINT u,BOOL bSign)
{                      
	  switch (gEPModule){
	  case 0: 
	  	if(bSign)
	  		{ if(u<=0x8ff)  return 1;}
	  	else if(u<=0x0fff)  return 1;
	    break;
	  case 1: 
	  	if(bSign) 
	  		{if(u<=0x1fff) return 1;}
	  	else	
	  		if(u<=0x3fff)  return 1;
	     break;
	  case 2: 
	  	if(bSign) 
	  		{if(u<=0x7fff) return 1;}
	  	else	
	  		if(u<=0xffff)  return 1;
	     break; 
	  }
	  return 0;
}                             

BOOL IsNegative(UINT u)
{                      
	  switch (gEPModule){
	  case 0: if(u&0x800)  return 1;
	     break;
	  case 1: if(u&0x2000)  return 1;
	     break;
	  case 2: if(u&0x8000)  return 1;
	     break; 
	  }
	  return 0;
}                     

void UnsignToSign(char* text, int u)
{
	  int ntemp;
	  switch (gEPModule){
	  case 0: 
	      if(u&0x800)        
	  	  {		
	  	  	 ntemp=((~u)&0x0fff)+1;
	  	  	 sprintf(text,"-%05u",ntemp);
	  	  }
	  	  else 	                         
	  	  	sprintf(text,"+%05u",u);
	     break;
	  case 1:
	  	 if(u&0x2000)
   	     {		
	  	  	 ntemp=((~u)&0x3fff)+1;
	  	  	 sprintf(text,"-%05u",ntemp);
	  	  }
	  	 else 	                         
	  	  	sprintf(text,"+%05u",u);

	     break;
	  case 2: 
	  	  if(u&0x8000)  
  	  	  {		
	  	  	 ntemp=((~u)&0xffff)+1;
	  	  	 sprintf(text,"-%05u",ntemp);
	  	  }
	  	  else 	                         
	  	  	sprintf(text,"+%05u",u);
	     break; 
	  }
}                                 

int UnsignToSign( int u)
{
	  int des;
	  switch (gEPModule){
	  case 0: 
	  	  	 des=((~u)&0x0fff)+1;
	     break;
	  case 1:
	  	  	 des=((~u)&0x3fff)+1;
	     break;
	  case 2: 
	  	  	 des=((~u)&0xffff)+1;
	     break; 
	  }      
	  return des;
}                                 


int gStartLine=0;      
int gCurrentCaretLine=0;
int gCurrentCaretCol=0;
int gFirstViewableLine=0;  



CMemLayout::CMemLayout()
{
    CPUMEMORYRANGE stRange;
    GetMemoryRange(&stRange);
    m_nMemRangeMin=stRange.pMin;
    m_nMemRangeMax=stRange.pMax;
    
    m_nLines=(m_nMemRangeMax-m_nMemRangeMin+1)/8;
    m_nStartLine=gStartLine;
    m_nEndLine=m_nStartLine+31;
    m_nCurrentCaretLine=gCurrentCaretLine;
    m_nCurrentCaretCol=gCurrentCaretCol;
    m_nFirstViewableLine=gFirstViewableLine;  
    m_nLastViewableLine=gFirstViewableLine; 
    m_bWriteDone=1; 
}


CMemLayout::~CMemLayout()
{                       
    gStartLine=m_nStartLine;      
	gCurrentCaretLine=m_nCurrentCaretLine;
	gCurrentCaretCol=m_nCurrentCaretCol;
	gFirstViewableLine=m_nFirstViewableLine;  
    delete m_pMemByte;
    m_arrayNewData.RemoveAll();
} 

BOOL CMemLayout::WriteMemory()
{
     long addr_start,addr_end;
     if(m_bWriteDone) return 0;
     addr_start=m_nStartLine*8*2;
     addr_end=addr_start+511;
//     MemServerFill(addr_start,addr_end,1,(char*)m_pMemByte); 
     m_bWriteDone=1;
     return 1;
}


BOOL CMemLayout::GetMemory(UINT uFlag)
{   
    if(!m_bWriteDone) 
    {  if(IDOK==AfxMessageBox("Do you confirm your modification !",MB_OKCANCEL))
          WriteMemory();
       m_arrayNewData.RemoveAll();
       m_bWriteDone=1;      
    }   
    if(uFlag)
    {
        m_nStartLine=m_nLastViewableLine-24;
        if(m_nStartLine<0)  m_nStartLine=0; 
        m_nEndLine=m_nStartLine+31; 
        if(m_nEndLine>m_nLines-1 )
        {
            m_nEndLine=m_nLines-1;
            m_nStartLine=m_nEndLine-31;  
        }         
    }
    else
    {
        m_nEndLine=m_nFirstViewableLine+24;
        if(m_nEndLine>m_nLines-1) m_nEndLine=m_nLines-1;
        m_nStartLine=m_nEndLine-31;
        if(m_nStartLine<0)
        {
            m_nStartLine=0;
            m_nEndLine=31;
        }
    }
    MemServerDump(m_pMemByte, m_nStartLine*8,128,1);
    MemServerDump(m_pMemByte+128, m_nStartLine*8+128,128,1);
    //  memset(m_pMemByte,m_nStartLine+5,1024);     
     return 1;
}

BOOL CMemLayout::AllocMemory()
{
    m_pMemByte=new WORD[256];
    if(m_pMemByte==NULL) return 0;
    else return 1;
}



BOOL CMemLayout::CheckInput(UINT nChar, int pos,int N, BOOL bSign,BOOL isByte)   
{
     ASSERT(N==10||N==16);           
     UINT uCheck;
	int power=1;
     if(bSign)      //signed value
     {                                        
        ASSERT(N==10);
        int *pMemInt=(int*)m_pMemByte;
        int nTemp; 
        BOOL isNegative;
        nTemp=pMemInt[(m_nCurrentCaretLine-m_nStartLine)*8+m_nCurrentCaretCol];
        int n,m=0;
        
        isNegative=IsNegative((UINT)nTemp );
        ASSERT(!isByte);
        if(pos==0) 
        {   if(nChar=='+')
               nTemp=isNegative?UnsignToSign(nTemp):nTemp;     
            else if(nChar=='-')
               nTemp=isNegative?nTemp:UnsignToSign(nTemp);
            else return 0;      
            pMemInt[(m_nCurrentCaretLine-m_nStartLine)*8+m_nCurrentCaretCol]=nTemp;
//            return 1;
        }
        else
        {
        	if(nChar>'9'||nChar<'0') return 0;
  		    if(isNegative) 
        	    nTemp=UnsignToSign(nTemp);
	        n=nTemp;
    	    for(int i=5;i>pos;i--)
        	{
            	m=n%N;n/=N;
            	power*=10;
        	} 
        	m=n%N;           
	        nTemp=nTemp-m*power+(nChar-'0')*power; 
    	    if(!CheckLegal((UINT)nTemp,bSign) ) return 0;
            else if(isNegative) nTemp=UnsignToSign(nTemp);
        }   
//for fill the memory
        long lAddr;
//        lAddr=m_nStartLine*8+m_nCurrentCaretCol;               
        lAddr=m_nCurrentCaretLine*8+m_nCurrentCaretCol;               
        MemServerFill(lAddr,nTemp,1);
        MemServerDump((WORD*)&nTemp,lAddr,1,1);
        pMemInt[(m_nCurrentCaretLine-m_nStartLine)*8+m_nCurrentCaretCol]=nTemp;
        return 1;
     }
     else  //unsigned   value
     {
//      ASSERT(N==10);
        unsigned char ch;
        if((ch=Char2Value(nChar))==255)  return 0;
        if(isByte)
        {   
            unsigned char chTemp,ch;
            chTemp=(unsigned char)m_pMemByte[(m_nCurrentCaretLine-m_nStartLine)*16+m_nCurrentCaretCol];
            
            switch(pos){
            case 0: chTemp=(chTemp&0x0f)|(ch<<4);break;
            case 1: chTemp=(chTemp&0xf0)|(ch);break;
            default:return 0;
            }
            m_pMemByte[(m_nCurrentCaretLine-m_nStartLine)*16+m_nCurrentCaretCol]=chTemp;
            
        }
        else    
        {
            UINT uTemp;        
            UINT* pMemUInt=(UINT*)m_pMemByte;
            uTemp=(UINT)pMemUInt[(m_nCurrentCaretLine-m_nStartLine)*8+m_nCurrentCaretCol]; 
            if(N==16)
            {
            	switch(pos){
            	case 0: uTemp=(uTemp&0x0fff)|(ch<<12);break;
            	case 1: uTemp=(uTemp&0xf0ff)|(ch<<8);break;
            	case 2: uTemp=(uTemp&0xff0f)|(ch<<4);break;
            	case 3: uTemp=(uTemp&0xfff0)|(ch);break;
            	default:return 0;
                }
            }   
            else
            {
            	if(nChar>'9'||nChar<'0') return 0;
                UINT u,q=0;
        		u=uTemp;
        		for(int j=5;j>pos+1;j--)
        		{
     		       q=u%N;u/=N;
            	   power*=10;
        		} 
        		q=u%N;           
        		uTemp=uTemp-q*power+(nChar-'0')*power;
            }                                          
            if(!CheckLegal((UINT)uTemp,bSign) ) return 0;
//for fill the memory
     		long lAddr=m_nCurrentCaretLine*8+m_nCurrentCaretCol;
     		MemServerFill(lAddr,uTemp,1);
            MemServerDump((WORD*)&uTemp,lAddr,1,1);
            pMemUInt[(m_nCurrentCaretLine-m_nStartLine)*8+m_nCurrentCaretCol]=uTemp;
            uTemp=0;
         }
         m_bWriteDone=0;    
        return 1;                       
     }
}             


BOOL CMemLayout::CaretInWnd()
{
    if(m_nCurrentCaretLine>m_nFirstViewableLine&&
       m_nCurrentCaretLine<m_nLastViewableLine)
       return 1;
    else return 0;         
}       


BOOL CNewDataArray::IsExsit(WORD w)
{
    for(int i=0;i<GetSize();i++)
    {
        if( GetAt(i)==w) return 1;  
    }                             
    return 0;
}
                   
                   
int CNewDataArray::Add(WORD w)
{
    if(!IsExsit(w))     
        return CWordArray::Add(w);
    else return 0;  
}    
    
    