 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/MEMTEST.CPP   1.13   13 Dec 1996 11:19:00   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/MEMTEST.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:19:00   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:00:00   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:47:18   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:59:14   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:06   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:28   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:16   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:30   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:04   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:46   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:14   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:20   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:08:42   ZJRD
** PIC/SLD Version 0.20
** 
**    Rev 1.0   13 Aug 1996 09:19:42   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMTEST.CPP
//
//  Description: The implementation file for the class: CMemoryTest.
//
//  Author: Chen Jun
//
//  Date: 04/29/95
//
//  Modification:
//      1. 04/29/95, Initial version of the class: CMemoryTest.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memtest.h"
#include "hosterrs.h"
#include "abiextfn.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void TestCmd(int nArgc, char* pszArgv[]);
BOOL MemServerTest(unsigned short uStartAddr, unsigned short uEndAddr, 
                   unsigned char uchType, unsigned short& uFailAddr);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
//#ifndef _SERVER_NO_ABI
//    extern STATUS AbiTest(ADDR addr1, ADDR addr2);
//    extern ADDR AbiGetErrorAddr();
//#endif  // _SERVER_NO_ABI

void SrcUpdate(void);
extern BOOL GetCpuStatus(unsigned char &);
extern void ShowLine(char *);


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   TestCmd().
//
//  Description: The main control routine of Test command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void TestCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc || 4 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Test EMM.
    char error[128];
    CMemoryTest* pMemoryTest = new CMemoryTest;
    if ( !pMemoryTest ) {
        ErrDisplayError(ER_OUT_OF_MEMORY,0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
           pMemoryTest->TestAction(nArgc, pszArgv);
           delete pMemoryTest;
          }           
       }   
    }

//    CMemoryTest objTest;
//    objTest.MemoryTest(nArgc, pszArgv);

}   // End of TestCmd().


BOOL MemServerTest(unsigned short uStartAddr, unsigned short uEndAddr, 
                   unsigned char uchType, unsigned short& uFailAddr)
{
    // Assertion of the input parameters.
    
    // Test EMM.
    CMemoryTest* pMemoryTest = new CMemoryTest;
    if ( !pMemoryTest ) {
        ErrDisplayError(ER_OUT_OF_MEMORY,0);
//        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return (TRUE);
    }
    else {
        BOOL isOK = 
           pMemoryTest->MemServerTest(uStartAddr,uEndAddr,uchType,uFailAddr);
        delete pMemoryTest;
        return (isOK);
    }

}   // End of MemServerTest().
                   

/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryTest.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryTest::CMemoryTest().
//
//  Description: The construction of the class: CMemoryTest.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryTest::CMemoryTest()
{

}   // End of CMemoryTest::CMemoryTest().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryTest::~CMemoryTest().
//
//  Description: The destruction of the class: CMemoryTest.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryTest::~CMemoryTest()
{

}   // End of CMemoryTest::~CMemoryTest().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryTest::TestAction().
//
//  Description: Test EMM.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryTest::TestAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc || 4 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set Start address & End address.
    if ( 3 == nArgc ) {
        // Test adr1 adr2.
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[2], m_EndAddr);
    }
    else if ( 4 == nArgc ) {
        // Test adr1 Length length.
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[1], pszArgv[3], m_EndAddr);
    }
    else {
        ASSERT( FALSE );
        return;
    }
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] ) {
//        m_StartAddr.m_uchType = MEM_EXTERNAL;
        m_StartAddr.m_uchType = MEM_PROGRAM;
    }
    m_EndAddr.m_uchType = m_StartAddr.m_uchType;
    
    // Memory Test kernel routine.
    MemoryTestKernel();
        
}   // End of CMemoryTest::TestAction().


void CMemoryTest::MemoryTestKernel(void)
{
    // Assertion of the input parameters.
    
    // Call Abi routine.
    m_nErrorID = AbiTest((ADDR&) m_StartAddr, (ADDR&) m_EndAddr);

    // Update Source window.
    if ( MEM_PROGRAM == m_StartAddr.m_uchType ) {
        ::SrcUpdate();
    }
    
    if ( ICE_OK_MEM_WRITE == m_nErrorID ) {
        m_bServerRet = TRUE;
        ErrGetErrorText(ER_MEM_TEST_OK, m_pszResult);
        ShowLine( m_pszResult);
//        ShowLine("Memory test completed - no failure found.");
    }
    else if ( ICE_FAIL_MEM_WRITE == m_nErrorID ) {
        m_FailAddr = (CMemoryAddr&) AbiGetErrorAddr();
        m_bServerRet = FALSE;
        char chType;
        switch ( m_FailAddr.m_uchType ) {
            case MEM_UNDEFINE:
                switch ( m_StartAddr.m_uchType ) {
                    case MEM_PROGRAM:
                        chType = 'P';
                        break;
                    case MEM_EXTERNAL:
                        chType = 'X';
                        break;
                    case MEM_INTERNAL:
                        chType = 'R';
//                        chType = 'I';
                        break;
                    default:
                        ASSERT( FALSE );
                        break;
                }
                break;
            case MEM_PROGRAM:
                chType = 'P';
                break;
            case MEM_EXTERNAL:
                chType = 'X';
                break;
            case MEM_INTERNAL:
                chType = 'R';
//                chType = 'I';
                break;
/*            
            case MEM_SFR:
                chType = 'R';
                break;
            case MEM_BIT:
                chType = 'B';
                break;
*/                
            default:
                ASSERT( FALSE );
                break;
        }
        
        ErrGetErrorText(ER_MEM_TEST_ERROR, m_pszResult,
                    chType, m_FailAddr.m_uAddr);
//        wsprintf(m_pszResult, "Memory test terminated - failure at %c:%04X.",
//                    chType, m_FailAddr.m_uAddr);
        ShowLine(m_pszResult);
    }
    else {
        DisplayErrorMessage();
        m_bServerRet = TRUE;
    }
        
}   // End of CMemoryTest::MemoryTestKernel().


// Memory Test server.
BOOL CMemoryTest::MemServerTest(unsigned short uStartAddr,
    unsigned short uEndAddr,unsigned char uchType,unsigned short& uFailAddr)
{
    // Assertion of the input parameters.
    ASSERT( uchType >= MEM_PROGRAM && uchType <= MEM_BIT );

    // Set the server flag.
    m_isServer = TRUE;
        
    // Set the parameters.
    m_StartAddr = CMemoryAddr(uStartAddr, uchType);
    m_EndAddr = CMemoryAddr(uEndAddr, uchType);
    
    // Memory Test kernel routine.
    MemoryTestKernel();
    uFailAddr = m_FailAddr.m_uAddr;
    return (m_bServerRet);

}   // End of CMemoryTest::MemServerTest().

//////////////////////////////// End of File ////////////////////////////////
